/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Collectors;
import kong.unirest.Util;

public class Cookie {
    private String name;
    private String value;
    private String domain;
    private String path;
    private boolean httpOnly;
    private Integer maxAge;
    private ZonedDateTime expires;
    private boolean secure;
    private SameSite sameSite;

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Cookie(String v) {
        this(v.split(";"));
    }

    private Cookie(String[] split) {
        int pos = 0;
        for (String s : split) {
            String[] sub;
            if (pos == 0) {
                sub = s.split("=", 2);
                this.name = sub[0];
                this.value = sub.length == 2 ? this.stripQuoteWrapper(sub[1]) : "";
            } else {
                sub = s.split("=");
                this.parseSection(sub);
            }
            ++pos;
        }
    }

    private String getDecode(String sub) {
        try {
            return URLDecoder.decode(sub, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return sub;
        }
    }

    private String stripQuoteWrapper(String sub) {
        if (sub.startsWith("\"") && sub.endsWith("\"") && sub.length() > 1) {
            return sub.substring(1, sub.length() - 1);
        }
        return sub;
    }

    private void parseSection(String[] sub) {
        switch (sub[0].toLowerCase().trim()) {
            case "path": {
                this.path = sub[1];
                break;
            }
            case "domain": {
                this.domain = sub[1];
                break;
            }
            case "expires": {
                this.parseExpires(sub[1]);
                break;
            }
            case "max-age": {
                this.maxAge = Integer.parseInt(sub[1]);
                break;
            }
            case "httponly": {
                this.httpOnly = true;
                break;
            }
            case "secure": {
                this.secure = true;
                break;
            }
            case "samesite": {
                this.sameSite = SameSite.parse(sub[1]);
            }
        }
    }

    private void parseExpires(String text) {
        this.expires = Util.tryParseToDate(text);
    }

    public String toString() {
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        pairs.add(new Pair(this.name, this.value));
        if (this.path != null) {
            pairs.add(new Pair("Path", this.path));
        }
        if (this.domain != null) {
            pairs.add(new Pair("Domain", this.domain));
        }
        if (this.expires != null) {
            pairs.add(new Pair("Expires", this.expires.format(Util.DEFAULT_PATTERN)));
        }
        if (this.maxAge != null) {
            pairs.add(new Pair("Max-Age", String.valueOf(this.maxAge)));
        }
        if (this.httpOnly) {
            pairs.add(new Pair("HttpOnly", null));
        }
        if (this.secure) {
            pairs.add(new Pair("Secure", null));
        }
        return pairs.stream().map(Pair::toString).collect(Collectors.joining(";"));
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getUrlDecodedValue() {
        return this.getDecode(this.value);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public ZonedDateTime getExpiration() {
        return this.expires;
    }

    public SameSite getSameSite() {
        return this.sameSite;
    }

    public static enum SameSite {
        None,
        Strict,
        Lax;

        private static EnumSet<SameSite> all;

        public static SameSite parse(String value) {
            return all.stream().filter(e -> e.name().equalsIgnoreCase(value)).findFirst().orElse(null);
        }

        static {
            all = EnumSet.allOf(SameSite.class);
        }
    }

    private static class Pair {
        final String key;
        final String value;

        public Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            if (this.value == null) {
                return this.key;
            }
            return this.key + "=" + this.value;
        }
    }
}

