/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.NullDataCallback;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.callback.ContinuationCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.Continuation;
import com.koushikdutta.async.future.SimpleCancellable;
import com.koushikdutta.async.future.TransformFuture;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.SimpleMiddleware;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashSet;
import java.util.Hashtable;

public class AsyncSocketMiddleware
extends SimpleMiddleware {
    String scheme;
    int port;
    AsyncHttpClient mClient;
    private Hashtable<String, HashSet<AsyncSocket>> mSockets = new Hashtable();
    boolean connectAllAddresses;
    String proxyHost;
    int proxyPort;
    InetSocketAddress proxyAddress;

    public AsyncSocketMiddleware(AsyncHttpClient client, String scheme, int port) {
        this.mClient = client;
        this.scheme = scheme;
        this.port = port;
    }

    public int getSchemePort(URI uri) {
        if (!uri.getScheme().equals(this.scheme)) {
            return -1;
        }
        if (uri.getPort() == -1) {
            return this.port;
        }
        return uri.getPort();
    }

    public AsyncSocketMiddleware(AsyncHttpClient client) {
        this(client, "http", 80);
    }

    protected ConnectCallback wrapCallback(ConnectCallback callback, URI uri, int port) {
        return callback;
    }

    public boolean getConnectAllAddresses() {
        return this.connectAllAddresses;
    }

    public void setConnectAllAddresses(boolean connectAllAddresses) {
        this.connectAllAddresses = connectAllAddresses;
    }

    public void disableProxy() {
        this.proxyPort = -1;
        this.proxyHost = null;
        this.proxyAddress = null;
    }

    public void enableProxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyAddress = null;
    }

    String computeLookup(URI uri, int port, AsyncHttpRequest request) {
        String proxy = this.proxyHost != null ? this.proxyHost + ":" + this.proxyPort : "";
        if (request.proxyHost != null) {
            proxy = request.getProxyHost() + ":" + request.proxyPort;
        }
        return uri.getScheme() + "//" + uri.getHost() + ":" + port + "?proxy=" + proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cancellable getSocket(final AsyncHttpClientMiddleware.GetSocketData data) {
        final URI uri = data.request.getUri();
        final int port = this.getSchemePort(data.request.getUri());
        if (port == -1) {
            return null;
        }
        String lookup = this.computeLookup(uri, port, data.request);
        data.state.putBoolean(this.getClass().getCanonicalName() + ".owned", true);
        AsyncSocketMiddleware asyncSocketMiddleware = this;
        synchronized (asyncSocketMiddleware) {
            HashSet<AsyncSocket> sockets = this.mSockets.get(lookup);
            if (sockets != null) {
                for (final AsyncSocket socket : sockets) {
                    if (!socket.isOpen()) continue;
                    sockets.remove(socket);
                    socket.setClosedCallback(null);
                    this.mClient.getServer().post(new Runnable(){

                        @Override
                        public void run() {
                            data.request.logd("Reusing keep-alive socket");
                            data.connectCallback.onConnectCompleted(null, socket);
                        }
                    });
                    return new SimpleCancellable();
                }
            }
        }
        if (!this.connectAllAddresses || this.proxyHost != null || data.request.getProxyHost() != null) {
            int unresolvedPort;
            String unresolvedHost;
            data.request.logd("Connecting socket");
            if (data.request.getProxyHost() != null) {
                unresolvedHost = data.request.getProxyHost();
                unresolvedPort = data.request.getProxyPort();
                data.request.getHeaders().getHeaders().setStatusLine(data.request.getProxyRequestLine().toString());
            } else if (this.proxyHost != null) {
                unresolvedHost = this.proxyHost;
                unresolvedPort = this.proxyPort;
                data.request.getHeaders().getHeaders().setStatusLine(data.request.getProxyRequestLine().toString());
            } else {
                unresolvedHost = uri.getHost();
                unresolvedPort = port;
            }
            return this.mClient.getServer().connectSocket(unresolvedHost, unresolvedPort, this.wrapCallback(data.connectCallback, uri, port));
        }
        data.request.logv("Resolving domain and connecting to all available addresses");
        return new TransformFuture<AsyncSocket, InetAddress[]>(){
            Exception lastException;

            @Override
            protected void transform(InetAddress[] result) throws Exception {
                Continuation keepTrying = new Continuation(new CompletedCallback(){

                    @Override
                    public void onCompleted(Exception ex) {
                        if (lastException == null) {
                            lastException = new Exception("Unable to connect to remote address");
                        }
                        this.setComplete(lastException);
                    }
                });
                for (final InetAddress address : result) {
                    keepTrying.add(new ContinuationCallback(){

                        @Override
                        public void onContinue(Continuation continuation, final CompletedCallback next) throws Exception {
                            AsyncSocketMiddleware.this.mClient.getServer().connectSocket(new InetSocketAddress(address, port), AsyncSocketMiddleware.this.wrapCallback(new ConnectCallback(){

                                @Override
                                public void onConnectCompleted(Exception ex, AsyncSocket socket) {
                                    assert (!this.isDone());
                                    if (ex != null) {
                                        lastException = ex;
                                        next.onCompleted(null);
                                        return;
                                    }
                                    if (this.isDone() || this.isCancelled()) {
                                        data.request.logd("Recycling extra socket leftover from cancelled operation");
                                        AsyncSocketMiddleware.this.idleSocket(socket);
                                        AsyncSocketMiddleware.this.recycleSocket(socket, data.request);
                                        return;
                                    }
                                    if (this.setComplete(null, socket)) {
                                        data.connectCallback.onConnectCompleted(ex, socket);
                                    }
                                }
                            }, uri, port));
                        }
                    });
                }
                keepTrying.start();
            }
        }.from(this.mClient.getServer().getAllByName(uri.getHost()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionPoolCount() {
        int ret = 0;
        AsyncSocketMiddleware asyncSocketMiddleware = this;
        synchronized (asyncSocketMiddleware) {
            for (HashSet<AsyncSocket> sockets : this.mSockets.values()) {
                ret += sockets.size();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleSocket(final AsyncSocket socket, AsyncHttpRequest request) {
        if (socket == null) {
            return;
        }
        URI uri = request.getUri();
        int port = this.getSchemePort(uri);
        String lookup = this.computeLookup(uri, port, request);
        AsyncSocketMiddleware asyncSocketMiddleware = this;
        synchronized (asyncSocketMiddleware) {
            HashSet<AsyncSocket> sockets = this.mSockets.get(lookup);
            if (sockets == null) {
                sockets = new HashSet();
                this.mSockets.put(lookup, sockets);
            }
            final HashSet<AsyncSocket> ss = sockets;
            sockets.add(socket);
            socket.setClosedCallback(new CompletedCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompleted(Exception ex) {
                    3 var2_2 = this;
                    synchronized (var2_2) {
                        ss.remove(socket);
                    }
                    socket.setClosedCallback(null);
                }
            });
        }
    }

    private void idleSocket(final AsyncSocket socket) {
        socket.setEndCallback(null);
        socket.setWriteableCallback(null);
        socket.setDataCallback(new NullDataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                super.onDataAvailable(emitter, bb);
                bb.recycle();
                socket.close();
            }
        });
    }

    @Override
    public void onRequestComplete(AsyncHttpClientMiddleware.OnRequestCompleteData data) {
        if (!data.state.getBoolean(this.getClass().getCanonicalName() + ".owned", false)) {
            return;
        }
        this.idleSocket(data.socket);
        if (data.exception != null || !data.socket.isOpen()) {
            data.socket.close();
            return;
        }
        String kas = data.headers.getConnection();
        if (kas == null || !"keep-alive".toLowerCase().equals(kas.toLowerCase())) {
            data.socket.close();
            return;
        }
        data.request.logd("Recycling keep-alive socket");
        this.recycleSocket(data.socket, data.request);
    }
}

