/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.NullDataCallback;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpPost;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.WebSocket;
import java.util.Arrays;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class SocketIOClient {
    CompletedCallback closedCallback;
    JSONCallback jsonCallback;
    StringCallback stringCallback;
    EventCallback eventCallback;
    String sessionUrl;
    WebSocket webSocket;
    AsyncHttpClient httpClient;
    boolean connected;
    boolean disconnected;
    int heartbeat;
    Handler handler;

    private static void reportError(FutureImpl future, Handler handler, final SocketIOConnectCallback callback, final Exception e) {
        if (!future.setComplete(e)) {
            return;
        }
        if (handler != null) {
            AsyncServer.post(handler, new Runnable(){

                @Override
                public void run() {
                    callback.onConnectCompleted(e, null);
                }
            });
        } else {
            callback.onConnectCompleted(e, null);
        }
    }

    private void emitRaw(int type, String message) {
        this.webSocket.send(String.format("%d:::%s", type, message));
    }

    public void emit(String name, JSONArray args) {
        JSONObject event = new JSONObject();
        try {
            event.put("name", (Object)name);
            event.put("args", (Object)args);
            this.emitRaw(5, event.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void emit(String message) {
        this.emitRaw(3, message);
    }

    public void emit(JSONObject jsonMessage) {
        this.emitRaw(4, jsonMessage.toString());
    }

    public static Future<SocketIOClient> connect(AsyncHttpClient client, String uri, SocketIOConnectCallback callback) {
        return SocketIOClient.connect(client, new SocketIORequest(uri), callback);
    }

    public static Future<SocketIOClient> connect(final AsyncHttpClient client, final SocketIORequest request, final SocketIOConnectCallback callback) {
        final Handler handler = Looper.myLooper() == null ? null : new Handler();
        final FutureImpl ret = new FutureImpl();
        request.setHandler(null);
        Future<String> cancel = client.executeString(request, new AsyncHttpClient.StringCallback(){

            @Override
            public void onCompleted(Exception e, AsyncHttpResponse response, String result) {
                if (e != null) {
                    SocketIOClient.reportError(ret, handler, callback, e);
                    return;
                }
                try {
                    String[] parts = result.split(":");
                    String session = parts[0];
                    int heartbeat = !"".equals(parts[1]) ? Integer.parseInt(parts[1]) / 2 * 1000 : 0;
                    String transportsLine = parts[3];
                    String[] transports = transportsLine.split(",");
                    HashSet<String> set = new HashSet<String>(Arrays.asList(transports));
                    if (!set.contains("websocket")) {
                        throw new Exception("websocket not supported");
                    }
                    String sessionUrl = request.getUri().toString() + "websocket/" + session + "/";
                    SocketIOClient socketio = new SocketIOClient(handler, heartbeat, sessionUrl, client);
                    socketio.reconnect(callback, ret);
                }
                catch (Exception ex) {
                    SocketIOClient.reportError(ret, handler, callback, ex);
                }
            }
        });
        ret.setParent(cancel);
        return ret;
    }

    public CompletedCallback getClosedCallback() {
        return this.closedCallback;
    }

    public void setClosedCallback(CompletedCallback callback) {
        this.closedCallback = callback;
    }

    public JSONCallback getJSONCallback() {
        return this.jsonCallback;
    }

    public void setJSONCallback(JSONCallback callback) {
        this.jsonCallback = callback;
    }

    public StringCallback getStringCallback() {
        return this.stringCallback;
    }

    public void setStringCallback(StringCallback callback) {
        this.stringCallback = callback;
    }

    public EventCallback getEventCallback() {
        return this.eventCallback;
    }

    public void setEventCallback(EventCallback callback) {
        this.eventCallback = callback;
    }

    private SocketIOClient(Handler handler, int heartbeat, String sessionUrl, AsyncHttpClient httpCliet) {
        this.handler = handler;
        this.heartbeat = heartbeat;
        this.sessionUrl = sessionUrl;
        this.httpClient = httpCliet;
    }

    public boolean isConnected() {
        return this.connected && !this.disconnected && this.webSocket != null && this.webSocket.isOpen();
    }

    public void disconnect() {
        this.webSocket.setStringCallback(null);
        this.webSocket.setDataCallback(null);
        this.webSocket.setClosedCallback(null);
        this.webSocket.close();
        this.webSocket = null;
        if (this.closedCallback != null) {
            this.closedCallback.onCompleted(null);
        }
    }

    private void reconnect(final SocketIOConnectCallback callback, final FutureImpl ret) {
        if (this.isConnected()) {
            this.httpClient.getServer().post(new Runnable(){

                @Override
                public void run() {
                    ret.setComplete(new Exception("already connected"));
                }
            });
            return;
        }
        this.connected = false;
        this.disconnected = false;
        Future<WebSocket> cancel = this.httpClient.websocket(this.sessionUrl, null, new AsyncHttpClient.WebSocketConnectCallback(){

            @Override
            public void onCompleted(Exception ex, WebSocket webSocket) {
                if (ex != null) {
                    SocketIOClient.reportError(ret, SocketIOClient.this.handler, callback, ex);
                    return;
                }
                SocketIOClient.this.webSocket = webSocket;
                SocketIOClient.this.attach(callback, ret);
            }
        });
        ret.setParent(cancel);
    }

    private Future<SocketIOClient> reconnect(SocketIOConnectCallback callback) {
        FutureImpl ret = new FutureImpl();
        this.reconnect(callback, ret);
        return ret;
    }

    void setupHeartbeat() {
        final WebSocket ws = this.webSocket;
        Runnable heartbeatRunner = new Runnable(){

            @Override
            public void run() {
                if (SocketIOClient.this.heartbeat <= 0 || SocketIOClient.this.disconnected || !SocketIOClient.this.connected || ws != SocketIOClient.this.webSocket || ws == null || !ws.isOpen()) {
                    return;
                }
                SocketIOClient.this.webSocket.send("2:::");
                SocketIOClient.this.webSocket.getServer().postDelayed(this, SocketIOClient.this.heartbeat);
            }
        };
        heartbeatRunner.run();
    }

    private void attach(final SocketIOConnectCallback callback, final FutureImpl future) {
        this.webSocket.setDataCallback(new NullDataCallback());
        this.webSocket.setClosedCallback(new CompletedCallback(){

            @Override
            public void onCompleted(final Exception ex) {
                final boolean wasDiconnected = SocketIOClient.this.disconnected;
                SocketIOClient.this.disconnected = true;
                SocketIOClient.this.webSocket = null;
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        if (!SocketIOClient.this.connected) {
                            callback.onConnectCompleted(ex == null ? new Exception("connection failed") : ex, null);
                        } else if (!wasDiconnected && SocketIOClient.this.closedCallback != null) {
                            SocketIOClient.this.closedCallback.onCompleted(ex == null ? new Exception("connection failed") : ex);
                        }
                    }
                };
                if (SocketIOClient.this.handler != null) {
                    AsyncServer.post(SocketIOClient.this.handler, runner);
                } else {
                    runner.run();
                }
            }
        });
        this.webSocket.setStringCallback(new WebSocket.StringCallback(){

            @Override
            public void onStringAvailable(String message) {
                block31: {
                    try {
                        String[] parts = message.split(":", 4);
                        int code = Integer.parseInt(parts[0]);
                        switch (code) {
                            case 0: {
                                if (!SocketIOClient.this.connected) {
                                    throw new Exception("received disconnect before client connect");
                                }
                                SocketIOClient.this.disconnected = true;
                                SocketIOClient.this.webSocket.close();
                                if (SocketIOClient.this.closedCallback != null) {
                                    if (SocketIOClient.this.handler != null) {
                                        AsyncServer.post(SocketIOClient.this.handler, new Runnable(){

                                            @Override
                                            public void run() {
                                                SocketIOClient.this.closedCallback.onCompleted(null);
                                            }
                                        });
                                        break;
                                    }
                                    SocketIOClient.this.closedCallback.onCompleted(null);
                                }
                                break;
                            }
                            case 1: {
                                if (SocketIOClient.this.connected) {
                                    throw new Exception("received duplicate connect event");
                                }
                                if (!future.setComplete(SocketIOClient.this)) {
                                    throw new Exception("request canceled");
                                }
                                SocketIOClient.this.connected = true;
                                SocketIOClient.this.setupHeartbeat();
                                callback.onConnectCompleted(null, SocketIOClient.this);
                                break;
                            }
                            case 2: {
                                SocketIOClient.this.webSocket.send("2::");
                                break;
                            }
                            case 3: {
                                if (!SocketIOClient.this.connected) {
                                    throw new Exception("received message before client connect");
                                }
                                String messageId = parts[1];
                                final String dataString = parts[3];
                                if (!"".equals(messageId)) {
                                    SocketIOClient.this.webSocket.send(String.format("6:::%s", messageId));
                                }
                                if (SocketIOClient.this.stringCallback != null) {
                                    if (SocketIOClient.this.handler != null) {
                                        AsyncServer.post(SocketIOClient.this.handler, new Runnable(){

                                            @Override
                                            public void run() {
                                                SocketIOClient.this.stringCallback.onString(dataString);
                                            }
                                        });
                                        break;
                                    }
                                    SocketIOClient.this.stringCallback.onString(dataString);
                                }
                                break;
                            }
                            case 4: {
                                if (!SocketIOClient.this.connected) {
                                    throw new Exception("received message before client connect");
                                }
                                String messageId = parts[1];
                                String dataString = parts[3];
                                final JSONObject jsonMessage = new JSONObject(dataString);
                                if (!"".equals(messageId)) {
                                    SocketIOClient.this.webSocket.send(String.format("6:::%s", messageId));
                                }
                                if (SocketIOClient.this.jsonCallback != null) {
                                    if (SocketIOClient.this.handler != null) {
                                        AsyncServer.post(SocketIOClient.this.handler, new Runnable(){

                                            @Override
                                            public void run() {
                                                SocketIOClient.this.jsonCallback.onJSON(jsonMessage);
                                            }
                                        });
                                        break;
                                    }
                                    SocketIOClient.this.jsonCallback.onJSON(jsonMessage);
                                }
                                break;
                            }
                            case 5: {
                                if (!SocketIOClient.this.connected) {
                                    throw new Exception("received message before client connect");
                                }
                                String messageId = parts[1];
                                String dataString = parts[3];
                                JSONObject data = new JSONObject(dataString);
                                final String event = data.getString("name");
                                final JSONArray args = data.optJSONArray("args");
                                if (!"".equals(messageId)) {
                                    SocketIOClient.this.webSocket.send(String.format("6:::%s", messageId));
                                }
                                if (SocketIOClient.this.eventCallback != null) {
                                    if (SocketIOClient.this.handler != null) {
                                        AsyncServer.post(SocketIOClient.this.handler, new Runnable(){

                                            @Override
                                            public void run() {
                                                SocketIOClient.this.eventCallback.onEvent(event, args);
                                            }
                                        });
                                        break;
                                    }
                                    SocketIOClient.this.eventCallback.onEvent(event, args);
                                }
                                break;
                            }
                            case 6: {
                                break;
                            }
                            case 7: {
                                throw new Exception(message);
                            }
                            case 8: {
                                break;
                            }
                            default: {
                                throw new Exception("unknown code");
                            }
                        }
                    }
                    catch (Exception ex) {
                        SocketIOClient.this.webSocket.close();
                        if (!SocketIOClient.this.connected) {
                            SocketIOClient.reportError(future, SocketIOClient.this.handler, callback, ex);
                        }
                        SocketIOClient.this.disconnected = true;
                        if (SocketIOClient.this.closedCallback == null) break block31;
                        SocketIOClient.this.closedCallback.onCompleted(ex);
                    }
                }
            }
        });
    }

    public static class SocketIORequest
    extends AsyncHttpPost {
        String channel;

        public String getChannel() {
            return this.channel;
        }

        public SocketIORequest(String uri) {
            super(Uri.parse((String)uri).buildUpon().encodedPath("/socket.io/1/").build().toString());
            this.channel = Uri.parse((String)uri).getPath();
            if (TextUtils.isEmpty((CharSequence)this.channel)) {
                this.channel = null;
            }
        }
    }

    private static class FutureImpl
    extends SimpleFuture<SocketIOClient> {
        private FutureImpl() {
        }
    }

    public static interface EventCallback {
        public void onEvent(String var1, JSONArray var2);
    }

    public static interface StringCallback {
        public void onString(String var1);
    }

    public static interface JSONCallback {
        public void onJSON(JSONObject var1);
    }

    public static interface SocketIOConnectCallback {
        public void onConnectCompleted(Exception var1, SocketIOClient var2);
    }
}

