/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.FilteredDataSink;
import com.koushikdutta.async.callback.CompletedCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipDataSink
extends FilteredDataSink {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    ZipOutputStream zop = new ZipOutputStream(this.bout);
    boolean first = true;

    public ZipDataSink(DataSink sink) {
        super(sink);
    }

    public void putNextEntry(ZipEntry ze) throws IOException {
        this.zop.putNextEntry(ze);
    }

    public void closeEntry() throws IOException {
        this.zop.closeEntry();
    }

    protected void report(Exception e) {
        CompletedCallback closed = this.getClosedCallback();
        if (closed != null) {
            closed.onCompleted(e);
        }
    }

    @Override
    public void close() {
        try {
            this.zop.close();
        }
        catch (IOException e) {
            this.report(e);
            return;
        }
        this.setMaxBuffer(Integer.MAX_VALUE);
        this.write(new ByteBufferList());
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBufferList filter(ByteBufferList bb) {
        try {
            if (bb != null) {
                while (bb.size() > 0) {
                    ByteBuffer b = bb.remove();
                    this.zop.write(b.array(), b.arrayOffset() + b.position(), b.remaining());
                    ByteBufferList.reclaim(b);
                }
            }
            ByteBufferList ret = new ByteBufferList(this.bout.toByteArray());
            this.bout.reset();
            ByteBufferList byteBufferList = ret;
            return byteBufferList;
        }
        catch (IOException e) {
            this.report(e);
            ByteBufferList byteBufferList = null;
            return byteBufferList;
        }
        finally {
            if (bb != null) {
                bb.recycle();
            }
        }
    }
}

