/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.socketio;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.socketio.Acknowledge;
import com.koushikdutta.async.http.socketio.ConnectCallback;
import com.koushikdutta.async.http.socketio.DisconnectCallback;
import com.koushikdutta.async.http.socketio.ErrorCallback;
import com.koushikdutta.async.http.socketio.EventEmitter;
import com.koushikdutta.async.http.socketio.ExceptionCallback;
import com.koushikdutta.async.http.socketio.JSONCallback;
import com.koushikdutta.async.http.socketio.ReconnectCallback;
import com.koushikdutta.async.http.socketio.SocketIOConnection;
import com.koushikdutta.async.http.socketio.SocketIORequest;
import com.koushikdutta.async.http.socketio.StringCallback;
import org.json.JSONArray;
import org.json.JSONObject;

public class SocketIOClient
extends EventEmitter {
    boolean connected;
    boolean disconnected;
    ConnectCallback connectCallback;
    ExceptionCallback exceptionCallback;
    ErrorCallback errorCallback;
    DisconnectCallback disconnectCallback;
    ReconnectCallback reconnectCallback;
    JSONCallback jsonCallback;
    StringCallback stringCallback;
    SocketIOConnection connection;
    String endpoint;

    private static void reportError(SimpleFuture<SocketIOClient> future, Handler handler, final ConnectCallback callback, final Exception e) {
        if (!future.setComplete(e)) {
            return;
        }
        if (handler != null) {
            AsyncServer.post(handler, new Runnable(){

                @Override
                public void run() {
                    callback.onConnectCompleted(e, null);
                }
            });
        } else {
            callback.onConnectCompleted(e, null);
        }
    }

    private void emitRaw(int type, String message, Acknowledge acknowledge) {
        this.connection.emitRaw(type, this, message, acknowledge);
    }

    public void emit(String name, JSONArray args) {
        this.emit(name, args, null);
    }

    public void emit(String message) {
        this.emit(message, (Acknowledge)null);
    }

    public void emit(JSONObject jsonMessage) {
        this.emit(jsonMessage, null);
    }

    public void emit(String name, JSONArray args, Acknowledge acknowledge) {
        JSONObject event = new JSONObject();
        try {
            event.put("name", (Object)name);
            event.put("args", (Object)args);
            this.emitRaw(5, event.toString(), acknowledge);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void emit(String message, Acknowledge acknowledge) {
        this.emitRaw(3, message, acknowledge);
    }

    public void emit(JSONObject jsonMessage, Acknowledge acknowledge) {
        this.emitRaw(4, jsonMessage.toString(), acknowledge);
    }

    public void emitEvent(String name) {
        this.emitEvent(name, null);
    }

    public void emitEvent(String name, Acknowledge acknowledge) {
        JSONObject event = new JSONObject();
        try {
            event.put("name", (Object)name);
            this.emitRaw(5, event.toString(), acknowledge);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static Future<SocketIOClient> connect(AsyncHttpClient client, String uri, ConnectCallback callback) {
        return SocketIOClient.connect(client, new SocketIORequest(uri), callback);
    }

    public static Future<SocketIOClient> connect(AsyncHttpClient client, final SocketIORequest request, final ConnectCallback callback) {
        Handler handler = Looper.myLooper() == null ? null : request.getHandler();
        final SimpleFuture<SocketIOClient> ret = new SimpleFuture<SocketIOClient>();
        final SocketIOConnection connection = new SocketIOConnection(handler, client, request);
        ConnectCallback wrappedCallback = new ConnectCallback(){

            @Override
            public void onConnectCompleted(Exception ex, SocketIOClient client) {
                if (ex != null || TextUtils.isEmpty((CharSequence)request.getEndpoint())) {
                    if (callback != null) {
                        callback.onConnectCompleted(ex, client);
                    }
                    ret.setComplete(ex, client);
                    return;
                }
                connection.clients.remove(client);
                client.of(request.getEndpoint(), new ConnectCallback(){

                    @Override
                    public void onConnectCompleted(Exception ex, SocketIOClient client) {
                        if (callback != null) {
                            callback.onConnectCompleted(ex, client);
                        }
                        ret.setComplete(ex, client);
                    }
                });
            }
        };
        connection.clients.add(new SocketIOClient(connection, "", wrappedCallback));
        connection.reconnect(ret);
        return ret;
    }

    public void setExceptionCallback(ExceptionCallback exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
    }

    public ExceptionCallback getExceptionCallback() {
        return this.exceptionCallback;
    }

    public ErrorCallback getErrorCallback() {
        return this.errorCallback;
    }

    public void setErrorCallback(ErrorCallback callback) {
        this.errorCallback = callback;
    }

    public DisconnectCallback getDisconnectCallback() {
        return this.disconnectCallback;
    }

    public void setDisconnectCallback(DisconnectCallback callback) {
        this.disconnectCallback = callback;
    }

    public ReconnectCallback getReconnectCallback() {
        return this.reconnectCallback;
    }

    public void setReconnectCallback(ReconnectCallback callback) {
        this.reconnectCallback = callback;
    }

    public JSONCallback getJSONCallback() {
        return this.jsonCallback;
    }

    public void setJSONCallback(JSONCallback callback) {
        this.jsonCallback = callback;
    }

    public StringCallback getStringCallback() {
        return this.stringCallback;
    }

    public void setStringCallback(StringCallback callback) {
        this.stringCallback = callback;
    }

    private SocketIOClient(SocketIOConnection connection, String endpoint, ConnectCallback callback) {
        this.endpoint = endpoint;
        this.connection = connection;
        this.connectCallback = callback;
    }

    public boolean isConnected() {
        return this.connected && !this.disconnected && this.connection.isConnected();
    }

    public void disconnect() {
        this.connection.disconnect(this);
        DisconnectCallback disconnectCallback = this.disconnectCallback;
        if (disconnectCallback != null) {
            disconnectCallback.onDisconnect(null);
        }
    }

    public void of(String endpoint, ConnectCallback connectCallback) {
        this.connection.connect(new SocketIOClient(this.connection, endpoint, connectCallback));
    }

    public void reconnect() {
        this.connection.reconnect(null);
    }

    public WebSocket getWebSocket() {
        return this.connection.webSocket;
    }
}

