/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.filter;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.http.filter.DataRemainingException;
import java.nio.ByteBuffer;
import java.util.zip.Inflater;

public class InflaterInputFilter
extends FilteredDataEmitter {
    private Inflater mInflater;
    ByteBufferList transformed = new ByteBufferList();

    @Override
    protected void report(Exception e) {
        this.mInflater.end();
        if (e != null && this.mInflater.getRemaining() > 0) {
            e = new DataRemainingException("data still remaining in inflater", e);
        }
        super.report(e);
    }

    @Override
    public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
        try {
            ByteBuffer output = ByteBufferList.obtain(bb.remaining() * 2);
            int totalRead = 0;
            while (bb.size() > 0) {
                ByteBuffer b = bb.remove();
                if (b.hasRemaining()) {
                    totalRead = b.remaining();
                    this.mInflater.setInput(b.array(), b.arrayOffset() + b.position(), b.remaining());
                    do {
                        int inflated = this.mInflater.inflate(output.array(), output.arrayOffset() + output.position(), output.remaining());
                        output.position(output.position() + inflated);
                        if (output.hasRemaining()) continue;
                        output.limit(output.position());
                        output.position(0);
                        this.transformed.add(output);
                        assert (totalRead != 0);
                        int newSize = output.capacity() * 2;
                        output = ByteBufferList.obtain(newSize);
                    } while (!this.mInflater.needsInput() && !this.mInflater.finished());
                }
                ByteBufferList.reclaim(b);
            }
            output.limit(output.position());
            output.position(0);
            this.transformed.add(output);
            Util.emitAllData(this, this.transformed);
        }
        catch (Exception ex) {
            this.report(ex);
        }
    }

    public InflaterInputFilter() {
        this(new Inflater());
    }

    public InflaterInputFilter(Inflater inflater) {
        this.mInflater = inflater;
    }
}

