/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.ConnectionClosedException;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import java.nio.charset.Charset;

abstract class AsyncHttpResponseImpl
extends FilteredDataEmitter
implements AsyncSocket,
AsyncHttpResponse,
AsyncHttpClientMiddleware.ResponseHead {
    private CompletedCallback mReporter = new CompletedCallback(){

        @Override
        public void onCompleted(Exception error) {
            if (error != null && !AsyncHttpResponseImpl.this.mCompleted) {
                AsyncHttpResponseImpl.this.report(new ConnectionClosedException("connection closed before response completed.", error));
            } else {
                AsyncHttpResponseImpl.this.report(error);
            }
        }
    };
    private AsyncHttpRequest mRequest;
    private AsyncSocket mSocket;
    protected Headers mHeaders;
    boolean mCompleted = false;
    int code;
    String protocol;
    String message;
    private boolean mFirstWrite = true;
    DataSink mSink;

    @Override
    public AsyncSocket socket() {
        return this.mSocket;
    }

    @Override
    public AsyncHttpRequest getRequest() {
        return this.mRequest;
    }

    void setSocket(AsyncSocket exchange) {
        this.mSocket = exchange;
        if (this.mSocket == null) {
            return;
        }
        this.mSocket.setEndCallback(this.mReporter);
    }

    protected void onHeadersSent() {
        AsyncHttpRequestBody requestBody = this.mRequest.getBody();
        if (requestBody != null) {
            requestBody.write(this.mRequest, this, new CompletedCallback(){

                @Override
                public void onCompleted(Exception ex) {
                    AsyncHttpResponseImpl.this.onRequestCompleted(ex);
                }
            });
        } else {
            this.onRequestCompleted(null);
        }
    }

    protected void onRequestCompleted(Exception ex) {
    }

    protected void onHeadersReceived() {
    }

    @Override
    public DataEmitter emitter() {
        return this.getDataEmitter();
    }

    @Override
    public AsyncHttpClientMiddleware.ResponseHead emitter(DataEmitter emitter) {
        this.setDataEmitter(emitter);
        return this;
    }

    @Override
    protected void report(Exception e) {
        super.report(e);
        this.mSocket.setDataCallback(new DataCallback.NullDataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                super.onDataAvailable(emitter, bb);
                AsyncHttpResponseImpl.this.mSocket.close();
            }
        });
        this.mSocket.setWriteableCallback(null);
        this.mSocket.setClosedCallback(null);
        this.mSocket.setEndCallback(null);
        this.mCompleted = true;
    }

    public AsyncHttpResponseImpl(AsyncHttpRequest request) {
        this.mRequest = request;
    }

    @Override
    public Headers headers() {
        return this.mHeaders;
    }

    @Override
    public AsyncHttpClientMiddleware.ResponseHead headers(Headers headers) {
        this.mHeaders = headers;
        return this;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public AsyncHttpClientMiddleware.ResponseHead code(int code) {
        this.code = code;
        return this;
    }

    @Override
    public AsyncHttpClientMiddleware.ResponseHead protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Override
    public AsyncHttpClientMiddleware.ResponseHead message(String message) {
        this.message = message;
        return this;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String message() {
        return this.message;
    }

    public String toString() {
        if (this.mHeaders == null) {
            return super.toString();
        }
        return this.mHeaders.toPrefixString(this.protocol + " " + this.code + " " + this.message);
    }

    private void assertContent() {
        if (!this.mFirstWrite) {
            return;
        }
        this.mFirstWrite = false;
        assert (null != this.mRequest.getHeaders().get("Content-Type"));
        assert (this.mRequest.getHeaders().get("Transfer-Encoding") != null || HttpUtil.contentLength(this.mRequest.getHeaders()) != -1);
    }

    @Override
    public DataSink sink() {
        return this.mSink;
    }

    @Override
    public AsyncHttpClientMiddleware.ResponseHead sink(DataSink sink) {
        this.mSink = sink;
        return this;
    }

    @Override
    public void write(ByteBufferList bb) {
        this.assertContent();
        this.mSink.write(bb);
    }

    @Override
    public void end() {
        throw new AssertionError((Object)"end called?");
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mSink.setWriteableCallback(handler);
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mSink.getWriteableCallback();
    }

    @Override
    public boolean isOpen() {
        return this.mSink.isOpen();
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mSink.setClosedCallback(handler);
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mSink.getClosedCallback();
    }

    @Override
    public AsyncServer getServer() {
        return this.mSocket.getServer();
    }

    @Override
    public String charset() {
        String cs;
        Multimap mm = Multimap.parseSemicolonDelimited(this.headers().get("Content-Type"));
        if (mm != null && null != (cs = mm.getString("charset")) && Charset.isSupported(cs)) {
            return cs;
        }
        return null;
    }
}

