/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.ChannelWrapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

class DatagramChannelWrapper
extends ChannelWrapper {
    DatagramChannel mChannel;
    InetSocketAddress address;

    @Override
    public int getLocalPort() {
        return this.mChannel.socket().getLocalPort();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.address;
    }

    public void disconnect() throws IOException {
        this.mChannel.disconnect();
    }

    DatagramChannelWrapper(DatagramChannel channel) throws IOException {
        super(channel);
        this.mChannel = channel;
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        if (!this.isConnected()) {
            int position = buffer.position();
            this.address = (InetSocketAddress)this.mChannel.receive(buffer);
            if (this.address == null) {
                return -1;
            }
            return buffer.position() - position;
        }
        this.address = null;
        return this.mChannel.read(buffer);
    }

    @Override
    public boolean isConnected() {
        return this.mChannel.isConnected();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.mChannel.write(src);
    }

    @Override
    public int write(ByteBuffer[] src) throws IOException {
        return (int)this.mChannel.write(src);
    }

    @Override
    public SelectionKey register(Selector sel, int ops) throws ClosedChannelException {
        return this.mChannel.register(sel, ops);
    }

    @Override
    public boolean isChunked() {
        return true;
    }

    @Override
    public SelectionKey register(Selector sel) throws ClosedChannelException {
        return this.register(sel, 1);
    }

    @Override
    public void shutdownOutput() {
    }

    @Override
    public void shutdownInput() {
    }

    @Override
    public long read(ByteBuffer[] byteBuffers) throws IOException {
        return this.mChannel.read(byteBuffers);
    }

    @Override
    public long read(ByteBuffer[] byteBuffers, int i, int i2) throws IOException {
        return this.mChannel.read(byteBuffers, i, i2);
    }

    @Override
    public Object getSocket() {
        return this.mChannel.socket();
    }
}

