/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.net.Uri;
import android.util.Log;
import com.koushikdutta.async.AsyncSSLException;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;

public class AsyncHttpRequest {
    private String mMethod;
    Uri uri;
    private Headers mRawHeaders = new Headers();
    private boolean mFollowRedirect = true;
    private AsyncHttpRequestBody mBody;
    public static final int DEFAULT_TIMEOUT = 30000;
    int mTimeout = 30000;
    String proxyHost;
    int proxyPort = -1;
    String LOGTAG;
    int logLevel;
    long executionTime;

    public RequestLine getRequestLine() {
        return new RequestLine(){

            public String getUri() {
                return AsyncHttpRequest.this.getUri().toString();
            }

            public ProtocolVersion getProtocolVersion() {
                return new ProtocolVersion("HTTP", 1, 1);
            }

            public String getMethod() {
                return AsyncHttpRequest.this.mMethod;
            }

            public String toString() {
                String query;
                String path = AsyncHttpRequest.this.getUri().getEncodedPath();
                if (path == null || path.length() == 0) {
                    path = "/";
                }
                if ((query = AsyncHttpRequest.this.getUri().getEncodedQuery()) != null && query.length() != 0) {
                    path = path + "?" + query;
                }
                return String.format("%s %s HTTP/1.1", AsyncHttpRequest.this.mMethod, path);
            }
        };
    }

    public RequestLine getProxyRequestLine() {
        return new RequestLine(){

            public String getUri() {
                return AsyncHttpRequest.this.getUri().toString();
            }

            public ProtocolVersion getProtocolVersion() {
                return new ProtocolVersion("HTTP", 1, 1);
            }

            public String getMethod() {
                return AsyncHttpRequest.this.mMethod;
            }

            public String toString() {
                return String.format("%s %s HTTP/1.1", AsyncHttpRequest.this.mMethod, AsyncHttpRequest.this.getUri());
            }
        };
    }

    protected static String getDefaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? agent : "Java" + System.getProperty("java.version");
    }

    public String getMethod() {
        return this.mMethod;
    }

    public AsyncHttpRequest setMethod(String method) {
        if (this.getClass() != AsyncHttpRequest.class) {
            throw new UnsupportedOperationException("can't change method on a subclass of AsyncHttpRequest");
        }
        this.mMethod = method;
        return this;
    }

    public AsyncHttpRequest(Uri uri, String method) {
        this(uri, method, null);
    }

    public static void setDefaultHeaders(Headers ret, Uri uri) {
        if (uri != null) {
            String host = uri.getHost();
            if (uri.getPort() != -1) {
                host = host + ":" + uri.getPort();
            }
            if (host != null) {
                ret.set("Host", host);
            }
        }
        ret.set("User-Agent", AsyncHttpRequest.getDefaultUserAgent());
        ret.set("Accept-Encoding", "gzip, deflate");
        ret.set("Connection", "keep-alive");
        ret.set("Accept", "*/*");
    }

    public AsyncHttpRequest(Uri uri, String method, Headers headers) {
        assert (uri != null);
        this.mMethod = method;
        this.uri = uri;
        this.mRawHeaders = headers == null ? new Headers() : headers;
        if (headers == null) {
            AsyncHttpRequest.setDefaultHeaders(this.mRawHeaders, uri);
        }
    }

    public Uri getUri() {
        return this.uri;
    }

    public Headers getHeaders() {
        return this.mRawHeaders;
    }

    public boolean getFollowRedirect() {
        return this.mFollowRedirect;
    }

    public AsyncHttpRequest setFollowRedirect(boolean follow) {
        this.mFollowRedirect = follow;
        return this;
    }

    public void setBody(AsyncHttpRequestBody body) {
        this.mBody = body;
    }

    public AsyncHttpRequestBody getBody() {
        return this.mBody;
    }

    public void onHandshakeException(AsyncSSLException e) {
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public AsyncHttpRequest setTimeout(int timeout) {
        this.mTimeout = timeout;
        return this;
    }

    public static AsyncHttpRequest create(HttpRequest request) {
        AsyncHttpRequest ret = new AsyncHttpRequest(Uri.parse((String)request.getRequestLine().getUri()), request.getRequestLine().getMethod());
        for (Header header : request.getAllHeaders()) {
            ret.getHeaders().add(header.getName(), header.getValue());
        }
        return ret;
    }

    public HttpRequest asHttpRequest() {
        return new HttpRequestWrapper(this);
    }

    public AsyncHttpRequest setHeader(String name, String value) {
        this.getHeaders().set(name, value);
        return this;
    }

    public AsyncHttpRequest addHeader(String name, String value) {
        this.getHeaders().add(name, value);
        return this;
    }

    public void enableProxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
    }

    public void disableProxy() {
        this.proxyHost = null;
        this.proxyPort = -1;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String toString() {
        if (this.mRawHeaders == null) {
            return super.toString();
        }
        return this.mRawHeaders.toPrefixString(this.uri.toString());
    }

    public void setLogging(String tag, int level) {
        this.LOGTAG = tag;
        this.logLevel = level;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public String getLogTag() {
        return this.LOGTAG;
    }

    private String getLogMessage(String message) {
        long elapsed = this.executionTime != 0L ? System.currentTimeMillis() - this.executionTime : 0L;
        return String.format("(%d ms) %s: %s", elapsed, this.getUri(), message);
    }

    public void logi(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 4) {
            return;
        }
        Log.i((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logv(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 2) {
            return;
        }
        Log.v((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logw(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 5) {
            return;
        }
        Log.w((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logd(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 3) {
            return;
        }
        Log.d((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logd(String message, Exception e) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 3) {
            return;
        }
        Log.d((String)this.LOGTAG, (String)this.getLogMessage(message));
        Log.d((String)this.LOGTAG, (String)e.getMessage(), (Throwable)e);
    }

    public void loge(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 6) {
            return;
        }
        Log.e((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void loge(String message, Exception e) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 6) {
            return;
        }
        Log.e((String)this.LOGTAG, (String)this.getLogMessage(message));
        Log.e((String)this.LOGTAG, (String)e.getMessage(), (Throwable)e);
    }

    private static class HttpRequestWrapper
    implements HttpRequest {
        AsyncHttpRequest request;
        HttpParams params;

        public RequestLine getRequestLine() {
            return this.request.getRequestLine();
        }

        public HttpRequestWrapper(AsyncHttpRequest request) {
            this.request = request;
        }

        public void addHeader(Header header) {
            this.request.getHeaders().add(header.getName(), header.getValue());
        }

        public void addHeader(String name, String value) {
            this.request.getHeaders().add(name, value);
        }

        public boolean containsHeader(String name) {
            return this.request.getHeaders().get(name) != null;
        }

        public Header[] getAllHeaders() {
            return this.request.getHeaders().toHeaderArray();
        }

        public Header getFirstHeader(String name) {
            String value = this.request.getHeaders().get(name);
            if (value == null) {
                return null;
            }
            return new BasicHeader(name, value);
        }

        public Header[] getHeaders(String name) {
            Multimap map = this.request.getHeaders().getMultiMap();
            List vals = (List)map.get(name);
            if (vals == null) {
                return new Header[0];
            }
            Header[] ret = new Header[vals.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new BasicHeader(name, (String)vals.get(i));
            }
            return ret;
        }

        public Header getLastHeader(String name) {
            Header[] vals = this.getHeaders(name);
            if (vals.length == 0) {
                return null;
            }
            return vals[vals.length - 1];
        }

        public HttpParams getParams() {
            return this.params;
        }

        public ProtocolVersion getProtocolVersion() {
            return new ProtocolVersion("HTTP", 1, 1);
        }

        public HeaderIterator headerIterator() {
            assert (false);
            return null;
        }

        public HeaderIterator headerIterator(String name) {
            assert (false);
            return null;
        }

        public void removeHeader(Header header) {
            this.request.getHeaders().remove(header.getName());
        }

        public void removeHeaders(String name) {
            this.request.getHeaders().remove(name);
        }

        public void setHeader(Header header) {
            this.setHeader(header.getName(), header.getValue());
        }

        public void setHeader(String name, String value) {
            this.request.getHeaders().set(name, value);
        }

        public void setHeaders(Header[] headers) {
            for (Header header : headers) {
                this.setHeader(header);
            }
        }

        public void setParams(HttpParams params) {
            this.params = params;
        }
    }
}

