/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.text.TextUtils;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.BufferedDataSink;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.LineEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.SimpleMiddleware;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.filter.ChunkedOutputFilter;
import java.io.IOException;

public class HttpTransportMiddleware
extends SimpleMiddleware {
    @Override
    public boolean exchangeHeaders(final AsyncHttpClientMiddleware.OnExchangeHeaderData data) {
        DataSink headerSink;
        BufferedDataSink bsink;
        boolean waitForBody;
        Protocol p = Protocol.get(data.protocol);
        if (p != null && p != Protocol.HTTP_1_0 && p != Protocol.HTTP_1_1) {
            return super.exchangeHeaders(data);
        }
        AsyncHttpRequest request = data.request;
        AsyncHttpRequestBody requestBody = data.request.getBody();
        if (requestBody != null) {
            if (requestBody.length() >= 0) {
                request.getHeaders().set("Content-Length", String.valueOf(requestBody.length()));
                data.response.sink(data.socket);
            } else if ("close".equals(request.getHeaders().get("Connection"))) {
                data.response.sink(data.socket);
            } else {
                request.getHeaders().set("Transfer-Encoding", "Chunked");
                data.response.sink(new ChunkedOutputFilter(data.socket));
            }
        }
        boolean bl = waitForBody = requestBody != null && requestBody.length() >= 0 && requestBody.length() < 1024;
        if (waitForBody) {
            bsink = new BufferedDataSink(data.response.sink());
            bsink.forceBuffering(true);
            data.response.sink(bsink);
            headerSink = bsink;
        } else {
            bsink = null;
            headerSink = data.socket;
        }
        String rl = request.getRequestLine().toString();
        String rs = request.getHeaders().toPrefixString(rl);
        request.logv("\n" + rs);
        if (bsink != null) {
            bsink.setMaxBuffer(1024);
        }
        final CompletedCallback sentCallback = data.sendHeadersCallback;
        Util.writeAll(headerSink, rs.getBytes(), new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                Util.end(sentCallback, ex);
                if (bsink != null) {
                    bsink.forceBuffering(false);
                    bsink.setMaxBuffer(0);
                }
            }
        });
        LineEmitter.StringCallback headerCallback = new LineEmitter.StringCallback(){
            Headers mRawHeaders = new Headers();
            String statusLine;

            @Override
            public void onStringAvailable(String s) {
                try {
                    s = s.trim();
                    if (this.statusLine == null) {
                        this.statusLine = s;
                    } else if (!TextUtils.isEmpty((CharSequence)s)) {
                        this.mRawHeaders.addLine(s);
                    } else {
                        String[] parts = this.statusLine.split(" ", 3);
                        if (parts.length < 2) {
                            throw new Exception(new IOException("Not HTTP"));
                        }
                        data.response.headers(this.mRawHeaders);
                        String protocol = parts[0];
                        data.response.protocol(protocol);
                        data.response.code(Integer.parseInt(parts[1]));
                        data.response.message(parts.length == 3 ? parts[2] : "");
                        data.receiveHeadersCallback.onCompleted(null);
                        AsyncSocket socket = data.response.socket();
                        if (socket == null) {
                            return;
                        }
                        DataEmitter emitter = "HEAD".equalsIgnoreCase(data.request.getMethod()) ? HttpUtil.EndEmitter.create(socket.getServer(), null) : HttpUtil.getBodyDecoder(socket, Protocol.get(protocol), this.mRawHeaders, false);
                        data.response.emitter(emitter);
                    }
                }
                catch (Exception ex) {
                    data.receiveHeadersCallback.onCompleted(ex);
                }
            }
        };
        LineEmitter liner = new LineEmitter();
        data.socket.setDataCallback(liner);
        liner.setLineCallback(headerCallback);
        return true;
    }

    @Override
    public void onRequestSent(AsyncHttpClientMiddleware.OnRequestSentData data) {
        Protocol p = Protocol.get(data.protocol);
        if (p != null && p != Protocol.HTTP_1_0 && p != Protocol.HTTP_1_1) {
            return;
        }
        if (data.response.sink() instanceof ChunkedOutputFilter) {
            data.response.sink().end();
        }
    }
}

