/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import android.annotation.TargetApi;
import android.os.Looper;
import com.koushikdutta.async.ArrayDeque;
import com.koushikdutta.async.util.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.PriorityQueue;

@TargetApi(value=9)
public class ByteBufferList {
    ArrayDeque<ByteBuffer> mBuffers = new ArrayDeque();
    ByteOrder order = ByteOrder.BIG_ENDIAN;
    private int remaining = 0;
    static PriorityQueue<ByteBuffer> reclaimed = new PriorityQueue<ByteBuffer>(8, new Reclaimer());
    private static int MAX_SIZE = 0x100000;
    public static int MAX_ITEM_SIZE = 262144;
    static int currentSize = 0;
    static int maxItem = 0;
    private static final Object LOCK = new Object();
    public static final ByteBuffer EMPTY_BYTEBUFFER = ByteBuffer.allocate(0);

    public ByteOrder order() {
        return this.order;
    }

    public ByteBufferList order(ByteOrder order) {
        this.order = order;
        return this;
    }

    public ByteBufferList() {
    }

    public ByteBufferList(ByteBuffer ... b) {
        this.addAll(b);
    }

    public ByteBufferList(byte[] buf) {
        ByteBuffer b = ByteBuffer.wrap(buf);
        this.add(b);
    }

    public ByteBufferList addAll(ByteBuffer ... bb) {
        for (ByteBuffer b : bb) {
            this.add(b);
        }
        return this;
    }

    public ByteBufferList addAll(ByteBufferList ... bb) {
        for (ByteBufferList b : bb) {
            b.get(this);
        }
        return this;
    }

    public byte[] getBytes(int length) {
        byte[] ret = new byte[length];
        this.get(ret);
        return ret;
    }

    public byte[] getAllByteArray() {
        ByteBuffer peek;
        if (this.mBuffers.size() == 1 && (peek = this.mBuffers.peek()).capacity() == this.remaining() && peek.isDirect()) {
            this.remaining = 0;
            return this.mBuffers.remove().array();
        }
        byte[] ret = new byte[this.remaining()];
        this.get(ret);
        return ret;
    }

    public ByteBuffer[] getAllArray() {
        ByteBuffer[] ret = new ByteBuffer[this.mBuffers.size()];
        ret = this.mBuffers.toArray(ret);
        this.mBuffers.clear();
        this.remaining = 0;
        return ret;
    }

    public boolean isEmpty() {
        return this.remaining == 0;
    }

    public int remaining() {
        return this.remaining;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public short peekShort() {
        return this.read(2).duplicate().getShort();
    }

    public int peekInt() {
        return this.read(4).duplicate().getInt();
    }

    public long peekLong() {
        return this.read(8).duplicate().getLong();
    }

    public byte[] peekBytes(int size) {
        byte[] ret = new byte[size];
        this.read(size).duplicate().get(ret);
        return ret;
    }

    public ByteBufferList skip(int length) {
        this.get(null, 0, length);
        return this;
    }

    public int getInt() {
        int ret = this.read(4).getInt();
        this.remaining -= 4;
        return ret;
    }

    public char getByteChar() {
        char ret = (char)this.read(1).get();
        --this.remaining;
        return ret;
    }

    public short getShort() {
        short ret = this.read(2).getShort();
        this.remaining -= 2;
        return ret;
    }

    public byte get() {
        byte ret = this.read(1).get();
        --this.remaining;
        return ret;
    }

    public long getLong() {
        long ret = this.read(8).getLong();
        this.remaining -= 8;
        return ret;
    }

    public void get(byte[] bytes) {
        this.get(bytes, 0, bytes.length);
    }

    public void get(byte[] bytes, int offset, int length) {
        if (this.remaining() < length) {
            throw new IllegalArgumentException("length");
        }
        int need = length;
        while (need > 0) {
            ByteBuffer b = this.mBuffers.peek();
            int read = Math.min(b.remaining(), need);
            if (bytes != null) {
                b.get(bytes, offset, read);
            } else {
                b.position(b.position() + read);
            }
            need -= read;
            offset += read;
            if (b.remaining() != 0) continue;
            ByteBuffer removed = this.mBuffers.remove();
            assert (b == removed);
            ByteBufferList.reclaim(b);
        }
        this.remaining -= length;
    }

    public void get(ByteBufferList into, int length) {
        if (this.remaining() < length) {
            throw new IllegalArgumentException("length");
        }
        int offset = 0;
        while (offset < length) {
            ByteBuffer b = this.mBuffers.remove();
            int remaining = b.remaining();
            if (remaining == 0) {
                ByteBufferList.reclaim(b);
                continue;
            }
            if (offset + remaining > length) {
                int need = length - offset;
                ByteBuffer subset = ByteBufferList.obtain(need);
                subset.limit(need);
                b.get(subset.array(), 0, need);
                into.add(subset);
                this.mBuffers.addFirst(b);
                assert (subset.capacity() >= need);
                assert (subset.position() == 0);
                break;
            }
            into.add(b);
            offset += remaining;
        }
        this.remaining -= length;
    }

    public void get(ByteBufferList into) {
        this.get(into, this.remaining());
    }

    public ByteBufferList get(int length) {
        ByteBufferList ret = new ByteBufferList();
        this.get(ret, length);
        return ret.order(this.order);
    }

    public ByteBuffer getAll() {
        if (this.remaining() == 0) {
            return EMPTY_BYTEBUFFER;
        }
        this.read(this.remaining());
        return this.remove();
    }

    private ByteBuffer read(int count) {
        int toRead;
        if (this.remaining() < count) {
            throw new IllegalArgumentException("count : " + this.remaining() + "/" + count);
        }
        ByteBuffer first = this.mBuffers.peek();
        while (first != null && !first.hasRemaining()) {
            ByteBufferList.reclaim(this.mBuffers.remove());
            first = this.mBuffers.peek();
        }
        if (first == null) {
            return EMPTY_BYTEBUFFER;
        }
        if (first.remaining() >= count) {
            return first.order(this.order);
        }
        ByteBuffer ret = ByteBufferList.obtain(count);
        ret.limit(count);
        byte[] bytes = ret.array();
        Buffer bb = null;
        for (int offset = 0; offset < count; offset += toRead) {
            bb = this.mBuffers.remove();
            toRead = Math.min(count - offset, bb.remaining());
            ((ByteBuffer)bb).get(bytes, offset, toRead);
            if (bb.remaining() != 0) continue;
            ByteBufferList.reclaim((ByteBuffer)bb);
            bb = null;
        }
        if (bb != null && bb.remaining() > 0) {
            this.mBuffers.addFirst((ByteBuffer)bb);
        }
        this.mBuffers.addFirst(ret);
        return ret.order(this.order);
    }

    public void trim() {
        this.read(0);
    }

    public ByteBufferList add(ByteBufferList b) {
        b.get(this);
        return this;
    }

    public ByteBufferList add(ByteBuffer b) {
        ByteBuffer last;
        if (b.remaining() <= 0) {
            ByteBufferList.reclaim(b);
            return this;
        }
        this.addRemaining(b.remaining());
        if (this.mBuffers.size() > 0 && (last = this.mBuffers.getLast()).capacity() - last.limit() >= b.remaining()) {
            last.mark();
            last.position(last.limit());
            last.limit(last.capacity());
            last.put(b);
            last.limit(last.position());
            last.reset();
            ByteBufferList.reclaim(b);
            this.trim();
            return this;
        }
        this.mBuffers.add(b);
        this.trim();
        return this;
    }

    public void addFirst(ByteBuffer b) {
        ByteBuffer first;
        if (b.remaining() <= 0) {
            ByteBufferList.reclaim(b);
            return;
        }
        this.addRemaining(b.remaining());
        if (this.mBuffers.size() > 0 && (first = this.mBuffers.getFirst()).position() >= b.remaining()) {
            first.position(first.position() - b.remaining());
            first.mark();
            first.put(b);
            first.reset();
            ByteBufferList.reclaim(b);
            return;
        }
        this.mBuffers.addFirst(b);
    }

    private void addRemaining(int remaining) {
        if (this.remaining() >= 0) {
            this.remaining += remaining;
        }
    }

    public void recycle() {
        while (this.mBuffers.size() > 0) {
            ByteBufferList.reclaim(this.mBuffers.remove());
        }
        assert (this.mBuffers.size() == 0);
        this.remaining = 0;
    }

    public ByteBuffer remove() {
        ByteBuffer ret = this.mBuffers.remove();
        this.remaining -= ret.remaining();
        return ret;
    }

    public int size() {
        return this.mBuffers.size();
    }

    public void spewString() {
        System.out.println(this.peekString());
    }

    public String peekString() {
        return this.peekString(null);
    }

    public String peekString(Charset charset) {
        if (charset == null) {
            charset = Charsets.US_ASCII;
        }
        StringBuilder builder = new StringBuilder();
        for (ByteBuffer bb : this.mBuffers) {
            int length;
            int offset;
            byte[] bytes;
            if (bb.isDirect()) {
                bytes = new byte[bb.remaining()];
                offset = 0;
                length = bb.remaining();
                bb.get(bytes);
            } else {
                bytes = bb.array();
                offset = bb.arrayOffset() + bb.position();
                length = bb.remaining();
            }
            builder.append(new String(bytes, offset, length, charset));
        }
        return builder.toString();
    }

    public String readString() {
        return this.readString(null);
    }

    public String readString(Charset charset) {
        String ret = this.peekString(charset);
        this.recycle();
        return ret;
    }

    private static PriorityQueue<ByteBuffer> getReclaimed() {
        Looper mainLooper = Looper.getMainLooper();
        if (mainLooper != null && Thread.currentThread() == mainLooper.getThread()) {
            return null;
        }
        return reclaimed;
    }

    public static void setMaxPoolSize(int size) {
        MAX_SIZE = size;
    }

    public static void setMaxItemSize(int size) {
        MAX_ITEM_SIZE = size;
    }

    private static boolean reclaimedContains(ByteBuffer b) {
        for (ByteBuffer other : reclaimed) {
            if (other != b) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reclaim(ByteBuffer b) {
        if (b == null || b.isDirect()) {
            return;
        }
        if (b.arrayOffset() != 0 || b.array().length != b.capacity()) {
            return;
        }
        if (b.capacity() < 8192) {
            return;
        }
        if (b.capacity() > MAX_ITEM_SIZE) {
            return;
        }
        PriorityQueue<ByteBuffer> r = ByteBufferList.getReclaimed();
        if (r == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            while (currentSize > MAX_SIZE && r.size() > 0 && r.peek().capacity() < b.capacity()) {
                ByteBuffer head = (ByteBuffer)r.remove();
                currentSize -= head.capacity();
            }
            if (currentSize > MAX_SIZE) {
                return;
            }
            assert (!ByteBufferList.reclaimedContains(b));
            b.position(0);
            b.limit(b.capacity());
            r.add(b);
            assert (r.size() != 0 ^ (currentSize += b.capacity()) == 0);
            maxItem = Math.max(maxItem, b.capacity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer obtain(int size) {
        PriorityQueue<ByteBuffer> r;
        if (size <= maxItem && (r = ByteBufferList.getReclaimed()) != null) {
            Object object = LOCK;
            synchronized (object) {
                while (r.size() > 0) {
                    ByteBuffer ret = (ByteBuffer)r.remove();
                    if (r.size() == 0) {
                        maxItem = 0;
                    }
                    assert (r.size() != 0 ^ (currentSize -= ret.capacity()) == 0);
                    if (ret.capacity() < size) continue;
                    return ret;
                }
            }
        }
        ByteBuffer ret = ByteBuffer.allocate(Math.max(8192, size));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obtainArray(ByteBuffer[] arr, int size) {
        int total;
        PriorityQueue<ByteBuffer> r = ByteBufferList.getReclaimed();
        int index = 0;
        if (r != null) {
            Object object = LOCK;
            synchronized (object) {
                int needed;
                for (total = 0; r.size() > 0 && total < size && index < arr.length - 1; total += needed) {
                    ByteBuffer b = (ByteBuffer)r.remove();
                    assert (r.size() != 0 ^ (currentSize -= b.capacity()) == 0);
                    needed = Math.min(size - total, b.capacity());
                    arr[index++] = b;
                }
            }
        }
        if (total < size) {
            ByteBuffer b = ByteBuffer.allocate(Math.max(8192, size - total));
            arr[index++] = b;
        }
        for (int i = index; i < arr.length; ++i) {
            arr[i] = EMPTY_BYTEBUFFER;
        }
    }

    public static void writeOutputStream(OutputStream out, ByteBuffer b) throws IOException {
        int length;
        int offset;
        byte[] bytes;
        if (b.isDirect()) {
            bytes = new byte[b.remaining()];
            offset = 0;
            length = b.remaining();
            b.get(bytes);
        } else {
            bytes = b.array();
            offset = b.arrayOffset() + b.position();
            length = b.remaining();
        }
        out.write(bytes, offset, length);
    }

    static class Reclaimer
    implements Comparator<ByteBuffer> {
        Reclaimer() {
        }

        @Override
        public int compare(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            if (byteBuffer.capacity() == byteBuffer2.capacity()) {
                return 0;
            }
            if (byteBuffer.capacity() > byteBuffer2.capacity()) {
                return 1;
            }
            return -1;
        }
    }
}

