/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.callback.DataCallback;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class LineEmitter
implements DataCallback {
    Charset charset;
    ByteBufferList data = new ByteBufferList();
    StringCallback mLineCallback;

    public LineEmitter() {
        this(null);
    }

    public LineEmitter(Charset charset) {
        this.charset = charset;
    }

    public void setLineCallback(StringCallback callback) {
        this.mLineCallback = callback;
    }

    public StringCallback getLineCallback() {
        return this.mLineCallback;
    }

    @Override
    public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
        ByteBuffer buffer = ByteBuffer.allocate(bb.remaining());
        while (bb.remaining() > 0) {
            byte b = bb.get();
            if (b == 10) {
                assert (this.mLineCallback != null);
                buffer.flip();
                this.data.add(buffer);
                this.mLineCallback.onStringAvailable(this.data.readString(this.charset));
                this.data = new ByteBufferList();
                return;
            }
            buffer.put(b);
        }
        buffer.flip();
        this.data.add(buffer);
    }

    public static interface StringCallback {
        public void onStringAvailable(String var1);
    }
}

