/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.spdy;

import android.os.Build;
import com.koushikdutta.async.BufferedDataSink;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataEmitterReader;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.spdy.ByteString;
import com.koushikdutta.async.http.spdy.ErrorCode;
import com.koushikdutta.async.http.spdy.FrameReader;
import com.koushikdutta.async.http.spdy.FrameWriter;
import com.koushikdutta.async.http.spdy.Header;
import com.koushikdutta.async.http.spdy.HeaderReader;
import com.koushikdutta.async.http.spdy.HeadersMode;
import com.koushikdutta.async.http.spdy.Settings;
import com.koushikdutta.async.http.spdy.Variant;
import com.koushikdutta.async.util.Charsets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Locale;
import java.util.zip.Deflater;

final class Spdy3
implements Variant {
    static final int TYPE_DATA = 0;
    static final int TYPE_SYN_STREAM = 1;
    static final int TYPE_SYN_REPLY = 2;
    static final int TYPE_RST_STREAM = 3;
    static final int TYPE_SETTINGS = 4;
    static final int TYPE_PING = 6;
    static final int TYPE_GOAWAY = 7;
    static final int TYPE_HEADERS = 8;
    static final int TYPE_WINDOW_UPDATE = 9;
    static final int FLAG_FIN = 1;
    static final int FLAG_UNIDIRECTIONAL = 2;
    static final int VERSION = 3;
    static final byte[] DICTIONARY;

    Spdy3() {
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.SPDY_3;
    }

    @Override
    public FrameReader newReader(DataEmitter source, FrameReader.Handler handler, boolean client) {
        return new Reader(source, handler, client);
    }

    @Override
    public FrameWriter newWriter(BufferedDataSink sink, boolean client) {
        return new Writer(sink, client);
    }

    @Override
    public int maxFrameSize() {
        return 16383;
    }

    static {
        try {
            DICTIONARY = "\u0000\u0000\u0000\u0007options\u0000\u0000\u0000\u0004head\u0000\u0000\u0000\u0004post\u0000\u0000\u0000\u0003put\u0000\u0000\u0000\u0006delete\u0000\u0000\u0000\u0005trace\u0000\u0000\u0000\u0006accept\u0000\u0000\u0000\u000eaccept-charset\u0000\u0000\u0000\u000faccept-encoding\u0000\u0000\u0000\u000faccept-language\u0000\u0000\u0000\raccept-ranges\u0000\u0000\u0000\u0003age\u0000\u0000\u0000\u0005allow\u0000\u0000\u0000\rauthorization\u0000\u0000\u0000\rcache-control\u0000\u0000\u0000\nconnection\u0000\u0000\u0000\fcontent-base\u0000\u0000\u0000\u0010content-encoding\u0000\u0000\u0000\u0010content-language\u0000\u0000\u0000\u000econtent-length\u0000\u0000\u0000\u0010content-location\u0000\u0000\u0000\u000bcontent-md5\u0000\u0000\u0000\rcontent-range\u0000\u0000\u0000\fcontent-type\u0000\u0000\u0000\u0004date\u0000\u0000\u0000\u0004etag\u0000\u0000\u0000\u0006expect\u0000\u0000\u0000\u0007expires\u0000\u0000\u0000\u0004from\u0000\u0000\u0000\u0004host\u0000\u0000\u0000\bif-match\u0000\u0000\u0000\u0011if-modified-since\u0000\u0000\u0000\rif-none-match\u0000\u0000\u0000\bif-range\u0000\u0000\u0000\u0013if-unmodified-since\u0000\u0000\u0000\rlast-modified\u0000\u0000\u0000\blocation\u0000\u0000\u0000\fmax-forwards\u0000\u0000\u0000\u0006pragma\u0000\u0000\u0000\u0012proxy-authenticate\u0000\u0000\u0000\u0013proxy-authorization\u0000\u0000\u0000\u0005range\u0000\u0000\u0000\u0007referer\u0000\u0000\u0000\u000bretry-after\u0000\u0000\u0000\u0006server\u0000\u0000\u0000\u0002te\u0000\u0000\u0000\u0007trailer\u0000\u0000\u0000\u0011transfer-encoding\u0000\u0000\u0000\u0007upgrade\u0000\u0000\u0000\nuser-agent\u0000\u0000\u0000\u0004vary\u0000\u0000\u0000\u0003via\u0000\u0000\u0000\u0007warning\u0000\u0000\u0000\u0010www-authenticate\u0000\u0000\u0000\u0006method\u0000\u0000\u0000\u0003get\u0000\u0000\u0000\u0006status\u0000\u0000\u0000\u0006200 OK\u0000\u0000\u0000\u0007version\u0000\u0000\u0000\bHTTP/1.1\u0000\u0000\u0000\u0003url\u0000\u0000\u0000\u0006public\u0000\u0000\u0000\nset-cookie\u0000\u0000\u0000\nkeep-alive\u0000\u0000\u0000\u0006origin100101201202205206300302303304305306307402405406407408409410411412413414415416417502504505203 Non-Authoritative Information204 No Content301 Moved Permanently400 Bad Request401 Unauthorized403 Forbidden404 Not Found500 Internal Server Error501 Not Implemented503 Service UnavailableJan Feb Mar Apr May Jun Jul Aug Sept Oct Nov Dec 00:00:00 Mon, Tue, Wed, Thu, Fri, Sat, Sun, GMTchunked,text/html,image/png,image/jpg,image/gif,application/xml,application/xhtml+xml,text/plain,text/javascript,publicprivatemax-age=gzip,deflate,sdchcharset=utf-8charset=iso-8859-1,utf-,*,enq=0.".getBytes(Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    static final class Writer
    implements FrameWriter {
        private final BufferedDataSink sink;
        private final boolean client;
        private boolean closed;
        private ByteBufferList frameHeader = new ByteBufferList();
        private final Deflater deflater = new Deflater();
        ByteBufferList dataList = new ByteBufferList();
        ByteBufferList headerBlockList = new ByteBufferList();

        Writer(BufferedDataSink sink, boolean client) {
            this.sink = sink;
            this.client = client;
            this.deflater.setDictionary(DICTIONARY);
        }

        @Override
        public void ackSettings() {
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) throws IOException {
        }

        @Override
        public synchronized void connectionPreface() {
        }

        @Override
        public synchronized void synStream(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            ByteBufferList headerBlockBuffer = this.writeNameValueBlockToBuffer(headerBlock);
            int length = 10 + headerBlockBuffer.remaining();
            int type = 1;
            int flags = (outFinished ? 1 : 0) | (inFinished ? 2 : 0);
            int unused = 0;
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(0x80030000 | type & 0xFFFF);
            sink.putInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            sink.putInt(streamId & Integer.MAX_VALUE);
            sink.putInt(associatedStreamId & Integer.MAX_VALUE);
            sink.putShort((short)((unused & 7) << 13 | (unused & 0x1F) << 8 | unused & 0xFF));
            sink.flip();
            this.sink.write(this.frameHeader.add(sink).add(headerBlockBuffer));
        }

        @Override
        public synchronized void synReply(boolean outFinished, int streamId, List<Header> headerBlock) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            ByteBufferList headerBlockBuffer = this.writeNameValueBlockToBuffer(headerBlock);
            int type = 2;
            int flags = outFinished ? 1 : 0;
            int length = headerBlockBuffer.remaining() + 4;
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(0x80030000 | type & 0xFFFF);
            sink.putInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            sink.putInt(streamId & Integer.MAX_VALUE);
            sink.flip();
            this.sink.write(this.frameHeader.add(sink).add(headerBlockBuffer));
        }

        @Override
        public synchronized void headers(int streamId, List<Header> headerBlock) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            ByteBufferList headerBlockBuffer = this.writeNameValueBlockToBuffer(headerBlock);
            int flags = 0;
            int type = 8;
            int length = headerBlockBuffer.remaining() + 4;
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(0x80030000 | type & 0xFFFF);
            sink.putInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            sink.putInt(streamId & Integer.MAX_VALUE);
            sink.flip();
            this.sink.write(this.frameHeader.add(sink).add(headerBlockBuffer));
        }

        @Override
        public synchronized void rstStream(int streamId, ErrorCode errorCode) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (errorCode.spdyRstCode == -1) {
                throw new IllegalArgumentException();
            }
            int flags = 0;
            int type = 3;
            int length = 8;
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(0x80030000 | type & 0xFFFF);
            sink.putInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            sink.putInt(streamId & Integer.MAX_VALUE);
            sink.putInt(errorCode.spdyRstCode);
            sink.flip();
            this.sink.write(this.frameHeader.addAll(sink));
        }

        @Override
        public synchronized void data(boolean outFinished, int streamId, ByteBufferList source) throws IOException {
            int flags = outFinished ? 1 : 0;
            this.sendDataFrame(streamId, flags, source);
        }

        void sendDataFrame(int streamId, int flags, ByteBufferList buffer) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            int byteCount = buffer.remaining();
            if ((long)byteCount > 0xFFFFFFL) {
                throw new IllegalArgumentException("FRAME_TOO_LARGE max size is 16Mib: " + byteCount);
            }
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(streamId & Integer.MAX_VALUE);
            sink.putInt((flags & 0xFF) << 24 | byteCount & 0xFFFFFF);
            sink.flip();
            this.dataList.add(sink).add(buffer);
            this.sink.write(this.dataList);
        }

        private ByteBufferList writeNameValueBlockToBuffer(List<Header> headerBlock) throws IOException {
            if (this.headerBlockList.hasRemaining()) {
                throw new IllegalStateException();
            }
            ByteBuffer headerBlockOut = ByteBufferList.obtain(8192).order(ByteOrder.BIG_ENDIAN);
            headerBlockOut.putInt(headerBlock.size());
            int size = headerBlock.size();
            for (int i = 0; i < size; ++i) {
                ByteString name = headerBlock.get((int)i).name;
                headerBlockOut.putInt(name.size());
                headerBlockOut.put(name.toByteArray());
                ByteString value = headerBlock.get((int)i).value;
                headerBlockOut.putInt(value.size());
                headerBlockOut.put(value.toByteArray());
                if (headerBlockOut.remaining() >= headerBlockOut.capacity() / 2) continue;
                ByteBuffer newOut = ByteBufferList.obtain(headerBlockOut.capacity() * 2).order(ByteOrder.BIG_ENDIAN);
                headerBlockOut.flip();
                newOut.put(headerBlockOut);
                ByteBufferList.reclaim(headerBlockOut);
                headerBlockOut = newOut;
            }
            headerBlockOut.flip();
            this.deflater.setInput(headerBlockOut.array(), 0, headerBlockOut.remaining());
            while (!this.deflater.needsInput()) {
                ByteBuffer deflated = ByteBufferList.obtain(headerBlockOut.capacity()).order(ByteOrder.BIG_ENDIAN);
                int read = Build.VERSION.SDK_INT >= 19 ? this.deflater.deflate(deflated.array(), 0, deflated.capacity(), 2) : this.deflater.deflate(deflated.array(), 0, deflated.capacity());
                deflated.limit(read);
                this.headerBlockList.add(deflated);
            }
            ByteBufferList.reclaim(headerBlockOut);
            return this.headerBlockList;
        }

        @Override
        public synchronized void settings(Settings settings) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            int type = 4;
            int flags = 0;
            int size = settings.size();
            int length = 4 + size * 8;
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(0x80030000 | type & 0xFFFF);
            sink.putInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            sink.putInt(size);
            for (int i = 0; i <= 10; ++i) {
                if (!settings.isSet(i)) continue;
                int settingsFlags = settings.flags(i);
                sink.putInt((settingsFlags & 0xFF) << 24 | i & 0xFFFFFF);
                sink.putInt(settings.get(i));
            }
            sink.flip();
            this.sink.write(this.frameHeader.addAll(sink));
        }

        @Override
        public synchronized void ping(boolean reply, int payload1, int payload2) throws IOException {
            boolean payloadIsReply;
            if (this.closed) {
                throw new IOException("closed");
            }
            boolean bl = payloadIsReply = this.client != ((payload1 & 1) == 1);
            if (reply != payloadIsReply) {
                throw new IllegalArgumentException("payload != reply");
            }
            int type = 6;
            int flags = 0;
            int length = 4;
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(0x80030000 | type & 0xFFFF);
            sink.putInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            sink.putInt(payload1);
            sink.flip();
            this.sink.write(this.frameHeader.addAll(sink));
        }

        @Override
        public synchronized void goAway(int lastGoodStreamId, ErrorCode errorCode, byte[] ignored) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (errorCode.spdyGoAwayCode == -1) {
                throw new IllegalArgumentException("errorCode.spdyGoAwayCode == -1");
            }
            int type = 7;
            int flags = 0;
            int length = 8;
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(0x80030000 | type & 0xFFFF);
            sink.putInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            sink.putInt(lastGoodStreamId);
            sink.putInt(errorCode.spdyGoAwayCode);
            sink.flip();
            this.sink.write(this.frameHeader.addAll(sink));
        }

        @Override
        public synchronized void windowUpdate(int streamId, long increment) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (increment == 0L || increment > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("windowSizeIncrement must be between 1 and 0x7fffffff: " + increment);
            }
            int type = 9;
            int flags = 0;
            int length = 8;
            ByteBuffer sink = ByteBufferList.obtain(256).order(ByteOrder.BIG_ENDIAN);
            sink.putInt(0x80030000 | type & 0xFFFF);
            sink.putInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            sink.putInt(streamId);
            sink.putInt((int)increment);
            sink.flip();
            this.sink.write(this.frameHeader.addAll(sink));
        }

        @Override
        public synchronized void close() throws IOException {
            this.closed = true;
        }
    }

    static final class Reader
    implements FrameReader {
        private final HeaderReader headerReader = new HeaderReader();
        private final DataEmitter emitter;
        private final boolean client;
        private final FrameReader.Handler handler;
        private final DataEmitterReader reader;
        int w1;
        int w2;
        int flags;
        int length;
        int streamId;
        boolean inFinished;
        private final ByteBufferList emptyList = new ByteBufferList();
        private final DataCallback onFrame = new DataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                bb.order(ByteOrder.BIG_ENDIAN);
                Reader.this.w1 = bb.getInt();
                Reader.this.w2 = bb.getInt();
                boolean control = (Reader.this.w1 & Integer.MIN_VALUE) != 0;
                Reader.this.flags = (Reader.this.w2 & 0xFF000000) >>> 24;
                Reader.this.length = Reader.this.w2 & 0xFFFFFF;
                if (!control) {
                    Reader.this.streamId = Reader.this.w1 & Integer.MAX_VALUE;
                    Reader.this.inFinished = (Reader.this.flags & 1) != 0;
                    emitter.setDataCallback(Reader.this.onDataFrame);
                    if (Reader.this.length == 0) {
                        Reader.this.onDataFrame.onDataAvailable(emitter, Reader.this.emptyList);
                    }
                } else {
                    Reader.this.reader.read(Reader.this.length, Reader.this.onFullFrame);
                }
            }
        };
        ByteBufferList partial = new ByteBufferList();
        private final DataCallback onDataFrame = new DataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                int toRead = Math.min(bb.remaining(), Reader.this.length);
                if (toRead < bb.remaining()) {
                    bb.get(Reader.this.partial, toRead);
                    bb = Reader.this.partial;
                }
                Reader.this.length -= toRead;
                Reader.this.handler.data(Reader.this.length == 0 && Reader.this.inFinished, Reader.this.streamId, bb);
                if (Reader.this.length == 0) {
                    Reader.this.parseFrameHeader();
                }
            }
        };
        private final DataCallback onFullFrame = new DataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                bb.order(ByteOrder.BIG_ENDIAN);
                int version = (Reader.this.w1 & 0x7FFF0000) >>> 16;
                int type = Reader.this.w1 & 0xFFFF;
                try {
                    if (version != 3) {
                        throw new ProtocolException("version != 3: " + version);
                    }
                    switch (type) {
                        case 1: {
                            Reader.this.readSynStream(bb, Reader.this.flags, Reader.this.length);
                            break;
                        }
                        case 2: {
                            Reader.this.readSynReply(bb, Reader.this.flags, Reader.this.length);
                            break;
                        }
                        case 3: {
                            Reader.this.readRstStream(bb, Reader.this.flags, Reader.this.length);
                            break;
                        }
                        case 4: {
                            Reader.this.readSettings(bb, Reader.this.flags, Reader.this.length);
                            break;
                        }
                        case 6: {
                            Reader.this.readPing(bb, Reader.this.flags, Reader.this.length);
                            break;
                        }
                        case 7: {
                            Reader.this.readGoAway(bb, Reader.this.flags, Reader.this.length);
                            break;
                        }
                        case 8: {
                            Reader.this.readHeaders(bb, Reader.this.flags, Reader.this.length);
                            break;
                        }
                        case 9: {
                            Reader.this.readWindowUpdate(bb, Reader.this.flags, Reader.this.length);
                            break;
                        }
                        default: {
                            bb.recycle();
                        }
                    }
                    Reader.this.parseFrameHeader();
                }
                catch (IOException e) {
                    Reader.this.handler.error(e);
                }
            }
        };

        Reader(DataEmitter emitter, FrameReader.Handler handler, boolean client) {
            this.emitter = emitter;
            this.handler = handler;
            this.client = client;
            emitter.setEndCallback(new CompletedCallback(){

                @Override
                public void onCompleted(Exception ex) {
                }
            });
            this.reader = new DataEmitterReader();
            this.parseFrameHeader();
        }

        private void parseFrameHeader() {
            this.emitter.setDataCallback(this.reader);
            this.reader.read(8, this.onFrame);
        }

        private void readSynStream(ByteBufferList source, int flags, int length) throws IOException {
            int w1 = source.getInt();
            int w2 = source.getInt();
            int streamId = w1 & Integer.MAX_VALUE;
            int associatedStreamId = w2 & Integer.MAX_VALUE;
            source.getShort();
            List<Header> headerBlock = this.headerReader.readHeader(source, length - 10);
            boolean inFinished = (flags & 1) != 0;
            boolean outFinished = (flags & 2) != 0;
            this.handler.headers(outFinished, inFinished, streamId, associatedStreamId, headerBlock, HeadersMode.SPDY_SYN_STREAM);
        }

        private void readSynReply(ByteBufferList source, int flags, int length) throws IOException {
            int w1 = source.getInt();
            int streamId = w1 & Integer.MAX_VALUE;
            List<Header> headerBlock = this.headerReader.readHeader(source, length - 4);
            boolean inFinished = (flags & 1) != 0;
            this.handler.headers(false, inFinished, streamId, -1, headerBlock, HeadersMode.SPDY_REPLY);
        }

        private void readRstStream(ByteBufferList source, int flags, int length) throws IOException {
            if (length != 8) {
                throw Reader.ioException("TYPE_RST_STREAM length: %d != 8", length);
            }
            int streamId = source.getInt() & Integer.MAX_VALUE;
            int errorCodeInt = source.getInt();
            ErrorCode errorCode = ErrorCode.fromSpdy3Rst(errorCodeInt);
            if (errorCode == null) {
                throw Reader.ioException("TYPE_RST_STREAM unexpected error code: %d", errorCodeInt);
            }
            this.handler.rstStream(streamId, errorCode);
        }

        private void readHeaders(ByteBufferList source, int flags, int length) throws IOException {
            int w1 = source.getInt();
            int streamId = w1 & Integer.MAX_VALUE;
            List<Header> headerBlock = this.headerReader.readHeader(source, length - 4);
            this.handler.headers(false, false, streamId, -1, headerBlock, HeadersMode.SPDY_HEADERS);
        }

        private void readWindowUpdate(ByteBufferList source, int flags, int length) throws IOException {
            if (length != 8) {
                throw Reader.ioException("TYPE_WINDOW_UPDATE length: %d != 8", length);
            }
            int w1 = source.getInt();
            int w2 = source.getInt();
            int streamId = w1 & Integer.MAX_VALUE;
            long increment = w2 & Integer.MAX_VALUE;
            if (increment == 0L) {
                throw Reader.ioException("windowSizeIncrement was 0", increment);
            }
            this.handler.windowUpdate(streamId, increment);
        }

        private void readPing(ByteBufferList source, int flags, int length) throws IOException {
            if (length != 4) {
                throw Reader.ioException("TYPE_PING length: %d != 4", length);
            }
            int id = source.getInt();
            boolean ack = this.client == ((id & 1) == 1);
            this.handler.ping(ack, id, 0);
        }

        private void readGoAway(ByteBufferList source, int flags, int length) throws IOException {
            if (length != 8) {
                throw Reader.ioException("TYPE_GOAWAY length: %d != 8", length);
            }
            int lastGoodStreamId = source.getInt() & Integer.MAX_VALUE;
            int errorCodeInt = source.getInt();
            ErrorCode errorCode = ErrorCode.fromSpdyGoAway(errorCodeInt);
            if (errorCode == null) {
                throw Reader.ioException("TYPE_GOAWAY unexpected error code: %d", errorCodeInt);
            }
            this.handler.goAway(lastGoodStreamId, errorCode, ByteString.EMPTY);
        }

        private void readSettings(ByteBufferList source, int flags, int length) throws IOException {
            int numberOfEntries = source.getInt();
            if (length != 4 + 8 * numberOfEntries) {
                throw Reader.ioException("TYPE_SETTINGS length: %d != 4 + 8 * %d", length, numberOfEntries);
            }
            Settings settings = new Settings();
            for (int i = 0; i < numberOfEntries; ++i) {
                int w1 = source.getInt();
                int value = source.getInt();
                int idFlags = (w1 & 0xFF000000) >>> 24;
                int id = w1 & 0xFFFFFF;
                settings.set(id, idFlags, value);
            }
            boolean clearPrevious = (flags & 1) != 0;
            this.handler.settings(clearPrevious, settings);
        }

        private static IOException ioException(String message, Object ... args) throws IOException {
            throw new IOException(String.format(Locale.ENGLISH, message, args));
        }
    }
}

