/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.util;

import com.koushikdutta.async.util.LruCache;
import com.koushikdutta.async.util.StreamUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class FileCache {
    private static String hashAlgorithm;
    static MessageDigest messageDigest;
    boolean loadAsync;
    Random random = new Random();
    long blockSize = 4096L;
    InternalCache cache;
    File directory;
    long size;
    Comparator<File> dateCompare = new Comparator<File>(){

        @Override
        public int compare(File lhs, File rhs) {
            long r;
            long l = lhs.lastModified();
            if (l < (r = rhs.lastModified())) {
                return -1;
            }
            if (r > l) {
                return 1;
            }
            return 0;
        }
    };
    boolean loading;

    private static MessageDigest findAlternativeMessageDigest() {
        if ("MD5".equals(hashAlgorithm)) {
            for (Provider provider : Security.getProviders()) {
                for (Provider.Service service : provider.getServices()) {
                    hashAlgorithm = service.getAlgorithm();
                    try {
                        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm);
                        if (messageDigest == null) continue;
                        return messageDigest;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    }
                }
            }
        }
        return null;
    }

    public static synchronized String toKeyString(Object ... parts) {
        messageDigest.reset();
        for (Object part : parts) {
            messageDigest.update(part.toString().getBytes());
        }
        byte[] md5bytes = messageDigest.digest();
        return new BigInteger(1, md5bytes).toString(16);
    }

    public File getTempFile() {
        File f;
        while ((f = new File(this.directory, new BigInteger(128, this.random).toString(16))).exists()) {
        }
        return f;
    }

    public File[] getTempFiles(int count) {
        File[] ret = new File[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = this.getTempFile();
        }
        return ret;
    }

    public static void removeFiles(File ... files) {
        if (files == null) {
            return;
        }
        for (File file : files) {
            file.delete();
        }
    }

    public void remove(String key) {
        int i = 0;
        while (this.cache.remove(this.getPartName(key, i)) != null) {
            ++i;
        }
        this.removePartFiles(key);
    }

    public boolean exists(String key, int part) {
        return this.getPartFile(key, part).exists();
    }

    public boolean exists(String key) {
        return this.getPartFile(key, 0).exists();
    }

    public File touch(File file) {
        this.cache.get(file.getName());
        file.setLastModified(System.currentTimeMillis());
        return file;
    }

    public FileInputStream get(String key) throws IOException {
        return new FileInputStream(this.touch(this.getPartFile(key, 0)));
    }

    public File getFile(String key) {
        return this.touch(this.getPartFile(key, 0));
    }

    public FileInputStream[] get(String key, int count) throws IOException {
        FileInputStream[] ret = new FileInputStream[count];
        try {
            for (int i = 0; i < count; ++i) {
                ret[i] = new FileInputStream(this.touch(this.getPartFile(key, i)));
            }
        }
        catch (IOException e) {
            for (FileInputStream fin : ret) {
                StreamUtility.closeQuietly(fin);
            }
            this.remove(key);
            throw e;
        }
        return ret;
    }

    String getPartName(String key, int part) {
        return key + "." + part;
    }

    public void commitTempFiles(String key, File ... tempFiles) {
        this.removePartFiles(key);
        for (int i = 0; i < tempFiles.length; ++i) {
            File tmp = tempFiles[i];
            File partFile = this.getPartFile(key, i);
            if (!tmp.renameTo(partFile)) {
                FileCache.removeFiles(tempFiles);
                this.remove(key);
                return;
            }
            this.remove(tmp.getName());
            this.cache.put(this.getPartName(key, i), new CacheEntry(partFile));
        }
    }

    void removePartFiles(String key) {
        File f;
        int i = 0;
        while ((f = this.getPartFile(key, i)).exists()) {
            f.delete();
            ++i;
        }
    }

    File getPartFile(String key, int part) {
        return new File(this.directory, this.getPartName(key, part));
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() {
        this.loading = true;
        try {
            File[] files = this.directory.listFiles();
            if (files == null) {
                return;
            }
            ArrayList list = new ArrayList();
            Collections.addAll(list, files);
            Collections.sort(list, this.dateCompare);
            for (File file : list) {
                String name = file.getName();
                CacheEntry entry = new CacheEntry(file);
                this.cache.put(name, entry);
                this.cache.get(name);
            }
        }
        finally {
            this.loading = false;
        }
    }

    private void doLoad() {
        if (this.loadAsync) {
            new Thread(){

                @Override
                public void run() {
                    FileCache.this.load();
                }
            }.start();
        } else {
            this.load();
        }
    }

    public FileCache(File directory, long size, boolean loadAsync) {
        this.directory = directory;
        this.size = size;
        this.loadAsync = loadAsync;
        this.cache = new InternalCache();
        directory.mkdirs();
        this.doLoad();
    }

    public long size() {
        return this.cache.size();
    }

    public void clear() {
        FileCache.removeFiles(this.directory.listFiles());
        this.cache.evictAll();
    }

    public Set<String> keySet() {
        HashSet<String> ret = new HashSet<String>();
        File[] files = this.directory.listFiles();
        if (files == null) {
            return ret;
        }
        for (File file : files) {
            String name = file.getName();
            int last = name.lastIndexOf(46);
            if (last == -1) continue;
            ret.add(name.substring(0, last));
        }
        return ret;
    }

    public void setMaxSize(long maxSize) {
        this.cache.setMaxSize(maxSize);
        this.doLoad();
    }

    static {
        block4: {
            hashAlgorithm = "MD5";
            try {
                messageDigest = MessageDigest.getInstance(hashAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                messageDigest = FileCache.findAlternativeMessageDigest();
                if (null != messageDigest) break block4;
                throw new RuntimeException(e);
            }
        }
        try {
            messageDigest = (MessageDigest)messageDigest.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    class InternalCache
    extends LruCache<String, CacheEntry> {
        public InternalCache() {
            super(FileCache.this.size);
        }

        @Override
        protected long sizeOf(String key, CacheEntry value) {
            return Math.max(FileCache.this.blockSize, value.size);
        }

        @Override
        protected void entryRemoved(boolean evicted, String key, CacheEntry oldValue, CacheEntry newValue) {
            super.entryRemoved(evicted, key, oldValue, newValue);
            if (newValue != null) {
                return;
            }
            if (FileCache.this.loading) {
                return;
            }
            new File(FileCache.this.directory, key).delete();
        }
    }

    public static class Snapshot {
        FileInputStream[] fins;
        long[] lens;

        Snapshot(FileInputStream[] fins, long[] lens) {
            this.fins = fins;
            this.lens = lens;
        }

        public long getLength(int index) {
            return this.lens[index];
        }

        public void close() {
            StreamUtility.closeQuietly(this.fins);
        }
    }

    class CacheEntry {
        final long size;

        public CacheEntry(File file) {
            this.size = file.length();
        }
    }
}

