/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import android.annotation.TargetApi;
import android.util.Log;
import com.koushikdutta.async.AsyncSSLSocket;
import com.koushikdutta.async.AsyncSSLSocketWrapper;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncServerSocket;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.ListenCallback;
import com.koushikdutta.async.callback.ValueCallback;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.koushikdutta.async.http.server.AsyncHttpServerResponse;
import com.koushikdutta.async.http.server.AsyncHttpServerResponseImpl;
import com.koushikdutta.async.http.server.AsyncHttpServerRouter;
import com.koushikdutta.async.http.server.HttpServerRequestCallback;
import com.koushikdutta.async.http.server.UnknownRequestBody;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.SSLContext;

@TargetApi(value=5)
public class AsyncHttpServer
extends AsyncHttpServerRouter {
    ArrayList<AsyncServerSocket> mListeners = new ArrayList();
    ListenCallback mListenCallback = new ListenCallback(){

        @Override
        public void onAccepted(final AsyncSocket socket) {
            AsyncHttpServerRouter.AsyncHttpServerRequestImpl req = new AsyncHttpServerRouter.AsyncHttpServerRequestImpl(){
                AsyncHttpServerRouter.AsyncHttpServerRequestImpl self;
                HttpServerRequestCallback requestCallback;
                String fullPath;
                String path;
                boolean responseComplete;
                boolean requestComplete;
                AsyncHttpServerResponseImpl res;
                boolean hasContinued;
                boolean handled;
                final Runnable onFinally;
                final ValueCallback<Exception> onException;
                {
                    super(AsyncHttpServer.this);
                    this.self = this;
                    this.onFinally = new Runnable(){

                        @Override
                        public void run() {
                            Log.i((String)"HTTP", (String)"Done");
                        }
                    };
                    this.onException = new ValueCallback<Exception>(){

                        @Override
                        public void onResult(Exception value) {
                            Log.e((String)"HTTP", (String)"exception", (Throwable)value);
                        }
                    };
                }

                void onRequest() {
                    AsyncHttpServer.this.onRequest(this.requestCallback, this, this.res);
                }

                @Override
                protected AsyncHttpRequestBody onBody(Headers headers) {
                    String statusLine = this.getStatusLine();
                    String[] parts = statusLine.split(" ");
                    this.fullPath = parts[1];
                    this.path = URLDecoder.decode(this.fullPath.split("\\?")[0]);
                    this.method = parts[0];
                    AsyncHttpServerRouter.RouteMatch route = AsyncHttpServer.this.route(this.method, this.path);
                    if (route == null) {
                        return null;
                    }
                    this.matcher = route.matcher;
                    this.requestCallback = route.callback;
                    if (route.bodyCallback == null) {
                        return null;
                    }
                    return route.bodyCallback.getBody(headers);
                }

                @Override
                protected AsyncHttpRequestBody onUnknownBody(Headers headers) {
                    return AsyncHttpServer.this.onUnknownBody(headers);
                }

                @Override
                protected void onHeadersReceived() {
                    Headers headers = this.getHeaders();
                    if (!this.hasContinued && "100-continue".equals(headers.get("Expect"))) {
                        this.pause();
                        Util.writeAll((DataSink)this.mSocket, "HTTP/1.1 100 Continue\r\n\r\n".getBytes(), new CompletedCallback(){

                            @Override
                            public void onCompleted(Exception ex) {
                                this.resume();
                                if (ex != null) {
                                    this.report(ex);
                                    return;
                                }
                                hasContinued = true;
                                this.onHeadersReceived();
                            }
                        });
                        return;
                    }
                    this.res = new AsyncHttpServerResponseImpl(socket, this){

                        @Override
                        protected void report(Exception e) {
                            super.report(e);
                            if (e != null) {
                                socket.setDataCallback(new DataCallback.NullDataCallback());
                                socket.setEndCallback(new CompletedCallback.NullCompletedCallback());
                                socket.close();
                            }
                        }

                        @Override
                        protected void onEnd() {
                            responseComplete = true;
                            super.onEnd();
                            this.mSocket.setEndCallback(null);
                            AsyncHttpServer.this.onResponseCompleted(this.getRequest(), res);
                            this.handleOnCompleted();
                        }
                    };
                    this.handled = AsyncHttpServer.this.onRequest(this, this.res);
                    if (this.handled) {
                        return;
                    }
                    if (this.requestCallback == null) {
                        this.res.code(404);
                        this.res.end();
                        return;
                    }
                    if (!this.getBody().readFullyOnRequest() || this.requestComplete) {
                        this.onRequest();
                    }
                }

                @Override
                public void onCompleted(Exception e) {
                    this.requestComplete = true;
                    super.onCompleted(e);
                    this.mSocket.setDataCallback(new DataCallback.NullDataCallback(){

                        @Override
                        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                            super.onDataAvailable(emitter, bb);
                            mSocket.close();
                        }
                    });
                    if (e != null) {
                        this.mSocket.close();
                        return;
                    }
                    this.handleOnCompleted();
                    if (this.getBody().readFullyOnRequest() && !this.handled) {
                        this.onRequest();
                    }
                }

                private void handleOnCompleted() {
                    if (this.requestComplete && this.responseComplete && !AsyncHttpServer.this.isSwitchingProtocols(this.res)) {
                        if (AsyncHttpServer.this.isKeepAlive(this.self, this.res)) {
                            this.onAccepted(socket);
                        } else {
                            socket.close();
                        }
                    }
                }

                @Override
                public String getPath() {
                    return this.path;
                }

                @Override
                public Multimap getQuery() {
                    String[] parts = this.fullPath.split("\\?", 2);
                    if (parts.length < 2) {
                        return new Multimap();
                    }
                    return Multimap.parseQuery(parts[1]);
                }

                @Override
                public String getUrl() {
                    return this.fullPath;
                }
            };
            req.setSocket(socket);
            socket.resume();
        }

        @Override
        public void onCompleted(Exception error) {
            AsyncHttpServer.this.report(error);
        }

        @Override
        public void onListening(AsyncServerSocket socket) {
            AsyncHttpServer.this.mListeners.add(socket);
        }
    };
    CompletedCallback mCompletedCallback;
    private static Hashtable<Integer, String> mCodes = new Hashtable();

    public void stop() {
        if (this.mListeners != null) {
            for (AsyncServerSocket listener : this.mListeners) {
                listener.stop();
            }
        }
    }

    protected boolean onRequest(AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
        return false;
    }

    protected void onResponseCompleted(AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
    }

    protected void onRequest(HttpServerRequestCallback callback, AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
        if (callback != null) {
            try {
                callback.onRequest(request, response);
            }
            catch (Exception e) {
                Log.e((String)"AsyncHttpServer", (String)"request callback raised uncaught exception. Catching versus crashing process", (Throwable)e);
                response.code(500);
                response.end();
            }
        }
    }

    protected boolean isKeepAlive(AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
        return HttpUtil.isKeepAlive(response.getHttpVersion(), request.getHeaders());
    }

    protected AsyncHttpRequestBody onUnknownBody(Headers headers) {
        return new UnknownRequestBody(headers.get("Content-Type"));
    }

    protected boolean isSwitchingProtocols(AsyncHttpServerResponse res) {
        return res.code() == 101;
    }

    public AsyncServerSocket listen(AsyncServer server, int port) {
        return server.listen(null, port, this.mListenCallback);
    }

    private void report(Exception ex) {
        if (this.mCompletedCallback != null) {
            this.mCompletedCallback.onCompleted(ex);
        }
    }

    public AsyncServerSocket listen(int port) {
        return this.listen(AsyncServer.getDefault(), port);
    }

    public void listenSecure(final int port, final SSLContext sslContext) {
        AsyncServer.getDefault().listen(null, port, new ListenCallback(){

            @Override
            public void onAccepted(AsyncSocket socket) {
                AsyncSSLSocketWrapper.handshake(socket, null, port, sslContext.createSSLEngine(), null, null, false, new AsyncSSLSocketWrapper.HandshakeCallback(){

                    @Override
                    public void onHandshakeCompleted(Exception e, AsyncSSLSocket socket) {
                        if (socket != null) {
                            AsyncHttpServer.this.mListenCallback.onAccepted(socket);
                        }
                    }
                });
            }

            @Override
            public void onListening(AsyncServerSocket socket) {
                AsyncHttpServer.this.mListenCallback.onListening(socket);
            }

            @Override
            public void onCompleted(Exception ex) {
                AsyncHttpServer.this.mListenCallback.onCompleted(ex);
            }
        });
    }

    public ListenCallback getListenCallback() {
        return this.mListenCallback;
    }

    public void setErrorCallback(CompletedCallback callback) {
        this.mCompletedCallback = callback;
    }

    public CompletedCallback getErrorCallback() {
        return this.mCompletedCallback;
    }

    public static String getResponseCodeDescription(int code) {
        String d = mCodes.get(code);
        if (d == null) {
            return "Unknown";
        }
        return d;
    }

    static {
        mCodes.put(200, "OK");
        mCodes.put(202, "Accepted");
        mCodes.put(206, "Partial Content");
        mCodes.put(101, "Switching Protocols");
        mCodes.put(301, "Moved Permanently");
        mCodes.put(302, "Found");
        mCodes.put(304, "Not Modified");
        mCodes.put(400, "Bad Request");
        mCodes.put(404, "Not Found");
        mCodes.put(500, "Internal Server Error");
    }

    public static interface WebSocketRequestCallback {
        public void onConnected(WebSocket var1, AsyncHttpServerRequest var2);
    }
}

