/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.AsyncNetworkSocket;
import com.koushikdutta.async.DatagramChannelWrapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class AsyncDatagramSocket
extends AsyncNetworkSocket {
    public void disconnect() throws IOException {
        this.socketAddress = null;
        ((DatagramChannelWrapper)this.getChannel()).disconnect();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (this.isOpen()) {
            return super.getRemoteAddress();
        }
        return ((DatagramChannelWrapper)this.getChannel()).getRemoteAddress();
    }

    public void connect(InetSocketAddress address) throws IOException {
        this.socketAddress = address;
        ((DatagramChannelWrapper)this.getChannel()).mChannel.connect(address);
    }

    public void send(final String host, final int port, final ByteBuffer buffer) {
        if (this.getServer().getAffinity() != Thread.currentThread()) {
            this.getServer().run(new Runnable(){

                @Override
                public void run() {
                    AsyncDatagramSocket.this.send(host, port, buffer);
                }
            });
            return;
        }
        try {
            ((DatagramChannelWrapper)this.getChannel()).mChannel.send(buffer, new InetSocketAddress(host, port));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void send(final InetSocketAddress address, final ByteBuffer buffer) {
        if (this.getServer().getAffinity() != Thread.currentThread()) {
            this.getServer().run(new Runnable(){

                @Override
                public void run() {
                    AsyncDatagramSocket.this.send(address, buffer);
                }
            });
            return;
        }
        try {
            int n = ((DatagramChannelWrapper)this.getChannel()).mChannel.send(buffer, new InetSocketAddress(address.getHostName(), address.getPort()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

