/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class SelectorWrapper
implements Closeable {
    private Selector selector;
    public AtomicBoolean isWaking = new AtomicBoolean(false);
    Semaphore semaphore = new Semaphore(0);

    public Selector getSelector() {
        return this.selector;
    }

    public SelectorWrapper(Selector selector) {
        this.selector = selector;
    }

    public int selectNow() throws IOException {
        return this.selector.selectNow();
    }

    public void select() throws IOException {
        this.select(0L);
    }

    public void select(long timeout) throws IOException {
        try {
            this.semaphore.drainPermits();
            this.selector.select(timeout);
        }
        finally {
            this.semaphore.release(Integer.MAX_VALUE);
        }
    }

    public Set<SelectionKey> keys() {
        return this.selector.keys();
    }

    public Set<SelectionKey> selectedKeys() {
        return this.selector.selectedKeys();
    }

    @Override
    public void close() throws IOException {
        this.selector.close();
    }

    public boolean isOpen() {
        return this.selector.isOpen();
    }

    public void wakeupOnce() {
        boolean selecting = !this.semaphore.tryAcquire();
        this.selector.wakeup();
        if (selecting) {
            return;
        }
        if (this.isWaking.getAndSet(true)) {
            this.selector.wakeup();
            return;
        }
        try {
            this.waitForSelect();
            this.selector.wakeup();
        }
        finally {
            this.isWaking.set(false);
        }
    }

    public boolean waitForSelect() {
        for (int i = 0; i < 100; ++i) {
            try {
                if (!this.semaphore.tryAcquire(10L, TimeUnit.MILLISECONDS)) continue;
            }
            catch (InterruptedException e) {
                return true;
            }
        }
        return false;
    }
}

