/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.body;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.NameValuePair;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

public class UrlEncodedFormBody
implements AsyncHttpRequestBody<Multimap> {
    private Multimap mParameters;
    private byte[] mBodyBytes;
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";

    public UrlEncodedFormBody(Multimap parameters) {
        this.mParameters = parameters;
    }

    public UrlEncodedFormBody(List<NameValuePair> parameters) {
        this.mParameters = new Multimap(parameters);
    }

    private void buildData() {
        boolean first = true;
        StringBuilder b = new StringBuilder();
        try {
            for (NameValuePair pair : this.mParameters) {
                if (pair.getValue() == null) continue;
                if (!first) {
                    b.append('&');
                }
                first = false;
                b.append(URLEncoder.encode(pair.getName(), "UTF-8"));
                b.append('=');
                b.append(URLEncoder.encode(pair.getValue(), "UTF-8"));
            }
            this.mBodyBytes = b.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void write(AsyncHttpRequest request, DataSink response, CompletedCallback completed) {
        if (this.mBodyBytes == null) {
            this.buildData();
        }
        Util.writeAll(response, this.mBodyBytes, completed);
    }

    @Override
    public String getContentType() {
        return "application/x-www-form-urlencoded; charset=utf-8";
    }

    @Override
    public void parse(DataEmitter emitter, final CompletedCallback completed) {
        final ByteBufferList data = new ByteBufferList();
        emitter.setDataCallback(new DataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                bb.get(data);
            }
        });
        emitter.setEndCallback(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                try {
                    if (ex != null) {
                        throw ex;
                    }
                    UrlEncodedFormBody.this.mParameters = Multimap.parseUrlEncoded(data.readString());
                }
                catch (Exception e) {
                    completed.onCompleted(e);
                    return;
                }
                completed.onCompleted(null);
            }
        });
    }

    public UrlEncodedFormBody() {
    }

    @Override
    public boolean readFullyOnRequest() {
        return true;
    }

    @Override
    public int length() {
        if (this.mBodyBytes == null) {
            this.buildData();
        }
        return this.mBodyBytes.length;
    }

    @Override
    public Multimap get() {
        return this.mParameters;
    }
}

