/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.LineEmitter;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.koushikdutta.async.http.server.UnknownRequestBody;
import java.io.IOException;
import java.util.HashMap;

public abstract class AsyncHttpServerRequestImpl
extends FilteredDataEmitter
implements AsyncHttpServerRequest,
CompletedCallback {
    private String statusLine;
    private Headers mRawHeaders = new Headers();
    AsyncSocket mSocket;
    private HashMap<String, Object> state = new HashMap();
    private CompletedCallback mReporter = new CompletedCallback(){

        @Override
        public void onCompleted(Exception error) {
            AsyncHttpServerRequestImpl.this.onCompleted(error);
        }
    };
    LineEmitter.StringCallback mHeaderCallback = new LineEmitter.StringCallback(){

        @Override
        public void onStringAvailable(String s) {
            if (AsyncHttpServerRequestImpl.this.statusLine == null) {
                AsyncHttpServerRequestImpl.this.statusLine = s;
                if (!AsyncHttpServerRequestImpl.this.statusLine.contains("HTTP/")) {
                    AsyncHttpServerRequestImpl.this.onNotHttp();
                    AsyncHttpServerRequestImpl.this.mSocket.setDataCallback(new DataCallback.NullDataCallback());
                    AsyncHttpServerRequestImpl.this.report(new IOException("data/header received was not not http"));
                }
                return;
            }
            if (!"\r".equals(s)) {
                AsyncHttpServerRequestImpl.this.mRawHeaders.addLine(s);
                return;
            }
            DataEmitter emitter = HttpUtil.getBodyDecoder(AsyncHttpServerRequestImpl.this.mSocket, Protocol.HTTP_1_1, AsyncHttpServerRequestImpl.this.mRawHeaders, true);
            AsyncHttpServerRequestImpl.this.mBody = AsyncHttpServerRequestImpl.this.onBody(AsyncHttpServerRequestImpl.this.mRawHeaders);
            if (AsyncHttpServerRequestImpl.this.mBody == null) {
                AsyncHttpServerRequestImpl.this.mBody = HttpUtil.getBody(emitter, AsyncHttpServerRequestImpl.this.mReporter, AsyncHttpServerRequestImpl.this.mRawHeaders);
                if (AsyncHttpServerRequestImpl.this.mBody == null) {
                    AsyncHttpServerRequestImpl.this.mBody = AsyncHttpServerRequestImpl.this.onUnknownBody(AsyncHttpServerRequestImpl.this.mRawHeaders);
                    if (AsyncHttpServerRequestImpl.this.mBody == null) {
                        AsyncHttpServerRequestImpl.this.mBody = new UnknownRequestBody(AsyncHttpServerRequestImpl.this.mRawHeaders.get("Content-Type"));
                    }
                }
            }
            AsyncHttpServerRequestImpl.this.mBody.parse(emitter, AsyncHttpServerRequestImpl.this.mReporter);
            AsyncHttpServerRequestImpl.this.onHeadersReceived();
        }
    };
    String method;
    AsyncHttpRequestBody mBody;

    public HashMap<String, Object> getState() {
        return this.state;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    @Override
    public void onCompleted(Exception e) {
        this.report(e);
    }

    protected abstract void onHeadersReceived();

    protected void onNotHttp() {
        System.out.println("not http!");
    }

    protected AsyncHttpRequestBody onUnknownBody(Headers headers) {
        return null;
    }

    protected AsyncHttpRequestBody onBody(Headers headers) {
        return null;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    void setSocket(AsyncSocket socket) {
        this.mSocket = socket;
        LineEmitter liner = new LineEmitter();
        this.mSocket.setDataCallback(liner);
        liner.setLineCallback(this.mHeaderCallback);
        this.mSocket.setEndCallback(new CompletedCallback.NullCompletedCallback());
    }

    @Override
    public AsyncSocket getSocket() {
        return this.mSocket;
    }

    @Override
    public Headers getHeaders() {
        return this.mRawHeaders;
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        this.mSocket.setDataCallback(callback);
    }

    @Override
    public DataCallback getDataCallback() {
        return this.mSocket.getDataCallback();
    }

    @Override
    public boolean isChunked() {
        return this.mSocket.isChunked();
    }

    public AsyncHttpRequestBody getBody() {
        return this.mBody;
    }

    @Override
    public void pause() {
        this.mSocket.pause();
    }

    @Override
    public void resume() {
        this.mSocket.resume();
    }

    @Override
    public boolean isPaused() {
        return this.mSocket.isPaused();
    }

    public String toString() {
        if (this.mRawHeaders == null) {
            return super.toString();
        }
        return this.mRawHeaders.toPrefixString(this.statusLine);
    }

    @Override
    public String get(String name) {
        Multimap query = this.getQuery();
        String ret = query.getString(name);
        if (ret != null) {
            return ret;
        }
        AsyncHttpRequestBody body = this.getBody();
        Object bodyObject = body.get();
        if (bodyObject instanceof Multimap) {
            Multimap map = (Multimap)bodyObject;
            return map.getString(name);
        }
        return null;
    }
}

