/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.WritableCallback;

public class BufferedDataSink
implements DataSink {
    DataSink mDataSink;
    boolean forceBuffering;
    final ByteBufferList mPendingWrites = new ByteBufferList();
    WritableCallback mWritable;
    int mMaxBuffer = Integer.MAX_VALUE;
    boolean endPending;

    public BufferedDataSink(DataSink datasink) {
        this.setDataSink(datasink);
    }

    public boolean isBuffering() {
        return this.mPendingWrites.hasRemaining() || this.forceBuffering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWritable() {
        ByteBufferList byteBufferList = this.mPendingWrites;
        synchronized (byteBufferList) {
            return this.mPendingWrites.remaining() < this.mMaxBuffer;
        }
    }

    public DataSink getDataSink() {
        return this.mDataSink;
    }

    public void forceBuffering(boolean forceBuffering) {
        this.forceBuffering = forceBuffering;
        if (!forceBuffering) {
            this.writePending();
        }
    }

    public void setDataSink(DataSink datasink) {
        this.mDataSink = datasink;
        this.mDataSink.setWriteableCallback(this::writePending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePending() {
        boolean empty;
        if (this.forceBuffering) {
            return;
        }
        ByteBufferList byteBufferList = this.mPendingWrites;
        synchronized (byteBufferList) {
            this.mDataSink.write(this.mPendingWrites);
            empty = this.mPendingWrites.isEmpty();
        }
        if (empty && this.endPending) {
            this.mDataSink.end();
        }
        if (empty && this.mWritable != null) {
            this.mWritable.onWriteable();
        }
    }

    protected void onDataAccepted(ByteBufferList bb) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBufferList bb) {
        if (this.getServer().getAffinity() != Thread.currentThread()) {
            ByteBufferList byteBufferList = this.mPendingWrites;
            synchronized (byteBufferList) {
                if (this.mPendingWrites.remaining() >= this.mMaxBuffer) {
                    return;
                }
                this.onDataAccepted(bb);
                bb.get(this.mPendingWrites);
            }
            this.getServer().post(this::writePending);
            return;
        }
        this.onDataAccepted(bb);
        if (!this.isBuffering()) {
            this.mDataSink.write(bb);
        }
        ByteBufferList byteBufferList = this.mPendingWrites;
        synchronized (byteBufferList) {
            bb.get(this.mPendingWrites);
        }
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mWritable = handler;
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mWritable;
    }

    public int remaining() {
        return this.mPendingWrites.remaining();
    }

    public int getMaxBuffer() {
        return this.mMaxBuffer;
    }

    public void setMaxBuffer(int maxBuffer) {
        this.mMaxBuffer = maxBuffer;
    }

    @Override
    public boolean isOpen() {
        return this.mDataSink.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        if (this.getServer().getAffinity() != Thread.currentThread()) {
            this.getServer().post(this::end);
            return;
        }
        ByteBufferList byteBufferList = this.mPendingWrites;
        synchronized (byteBufferList) {
            if (this.mPendingWrites.hasRemaining()) {
                this.endPending = true;
                return;
            }
        }
        this.mDataSink.end();
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mDataSink.setClosedCallback(handler);
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mDataSink.getClosedCallback();
    }

    @Override
    public AsyncServer getServer() {
        return this.mDataSink.getServer();
    }
}

