/*
 * Decompiled with CFR 0.152.
 */
package org.legstar.stringtemplate.v4;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import org.legstar.stringtemplate.v4.AttributeRenderer;

public class StringRenderer
implements AttributeRenderer {
    public String toString(Object o, String formatString, Locale locale) {
        String s = (String)o;
        if (formatString == null) {
            return s;
        }
        if (formatString.equals("upper")) {
            return s.toUpperCase(locale);
        }
        if (formatString.equals("lower")) {
            return s.toLowerCase(locale);
        }
        if (formatString.equals("cap")) {
            return s.length() > 0 ? Character.toUpperCase(s.charAt(0)) + s.substring(1) : s;
        }
        if (formatString.equals("url-encode")) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        if (formatString.equals("xml-encode")) {
            return StringRenderer.escapeHTML(s);
        }
        return String.format(locale, formatString, s);
    }

    public static String escapeHTML(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(s.length());
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    buf.append(c);
                    continue block6;
                }
                default: {
                    boolean aboveASCII;
                    boolean control = c < ' ';
                    boolean bl = aboveASCII = c > '~';
                    if (control || aboveASCII) {
                        buf.append("&#");
                        buf.append((int)c);
                        buf.append(";");
                        continue block6;
                    }
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

