/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cob2xsd;

import com.legstar.cob2xsd.Cob2XsdConfig;
import com.legstar.cob2xsd.XsdDataItem;
import com.legstar.cob2xsd.XsdEmitter;
import com.legstar.cob2xsd.XsdGenerationException;
import com.legstar.cob2xsd.antlr.CleanerException;
import com.legstar.cob2xsd.antlr.CobolFixedFormatSourceCleaner;
import com.legstar.cob2xsd.antlr.CobolFreeFormatSourceCleaner;
import com.legstar.cob2xsd.antlr.CobolStructureEmitterImpl;
import com.legstar.cob2xsd.antlr.CobolStructureLexerImpl;
import com.legstar.cob2xsd.antlr.CobolStructureParserImpl;
import com.legstar.cob2xsd.antlr.RecognizerErrorHandler;
import com.legstar.cob2xsd.antlr.RecognizerException;
import com.legstar.cobol.CobolStructureParser;
import com.legstar.cobol.model.CobolDataItem;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.legstar.antlr.runtime.ANTLRReaderStream;
import org.legstar.antlr.runtime.CharStream;
import org.legstar.antlr.runtime.CommonTokenStream;
import org.legstar.antlr.runtime.RecognitionException;
import org.legstar.antlr.runtime.TokenStream;
import org.legstar.antlr.runtime.tree.CommonTree;
import org.legstar.antlr.runtime.tree.CommonTreeNodeStream;
import org.legstar.antlr.runtime.tree.TreeNodeStream;
import org.legstar.apache.ws.commons.schema.XmlSchema;
import org.legstar.apache.ws.commons.schema.XmlSchemaCollection;
import org.legstar.apache.ws.commons.schema.XmlSchemaForm;
import org.legstar.apache.ws.commons.schema.utils.NamespaceMap;
import org.legstar.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.legstar.slf4j.Logger;
import org.legstar.slf4j.LoggerFactory;

public class Cob2Xsd {
    private final Cob2XsdConfig _config;
    private static final Logger _log = LoggerFactory.getLogger(Cob2Xsd.class);
    private RecognizerErrorHandler _errorHandler = new RecognizerErrorHandler();

    public Cob2Xsd(Cob2XsdConfig config) {
        this._config = config;
    }

    public String translate(Reader cobolReader, String targetNamespace, String xsltFileName) throws XsdGenerationException {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("Translating with options: {}", (Object)this.getConfig().toString());
                _log.debug("Target namespace: {}", (Object)targetNamespace);
            }
            return this.xsdToString(this.emitXsd(this.toModel(cobolReader), targetNamespace), xsltFileName);
        }
        catch (RecognizerException e) {
            throw new XsdGenerationException(e);
        }
    }

    public List<CobolDataItem> toModel(Reader cobolReader) throws RecognizerException {
        return this.emitModel(this.parse(this.lex(this.clean(cobolReader))));
    }

    public String clean(Reader cobolReader) throws CleanerException {
        if (_log.isDebugEnabled()) {
            _log.debug("1. Cleaning COBOL source code");
        }
        switch (this.getConfig().getCodeFormat()) {
            case FIXED_FORMAT: {
                CobolFixedFormatSourceCleaner fixedCleaner = new CobolFixedFormatSourceCleaner(this.getErrorHandler(), this.getConfig().getStartColumn(), this.getConfig().getEndColumn());
                return fixedCleaner.clean(cobolReader);
            }
            case FREE_FORMAT: {
                CobolFreeFormatSourceCleaner freeCleaner = new CobolFreeFormatSourceCleaner(this.getErrorHandler());
                return freeCleaner.clean(cobolReader);
            }
        }
        throw new CleanerException("Unkown COBOL source format " + (Object)((Object)this.getConfig().getCodeFormat()));
    }

    public CommonTokenStream lex(String cleanedCobolSource) throws RecognizerException {
        if (_log.isDebugEnabled()) {
            _log.debug("2. Lexing COBOL source code: {}", (Object)cleanedCobolSource);
        }
        try {
            CobolStructureLexerImpl lex = new CobolStructureLexerImpl((CharStream)new ANTLRReaderStream(new StringReader(cleanedCobolSource)), this.getErrorHandler());
            CommonTokenStream tokens = new CommonTokenStream(lex);
            if (lex.getNumberOfSyntaxErrors() != 0 || tokens == null) {
                throw new RecognizerException("Lexing failed. " + lex.getNumberOfSyntaxErrors() + " syntax errors. Last error was " + this.getErrorHistory().get(this.getErrorHistory().size() - 1));
            }
            return tokens;
        }
        catch (IOException e) {
            throw new RecognizerException(e);
        }
    }

    public CommonTree parse(CommonTokenStream tokens) throws RecognizerException {
        if (_log.isDebugEnabled()) {
            _log.debug("3. Parsing tokens: {}", (Object)tokens.toString());
        }
        try {
            CobolStructureParserImpl parser = new CobolStructureParserImpl((TokenStream)tokens, this.getErrorHandler());
            CobolStructureParser.cobdata_return parserResult = parser.cobdata();
            if (parser.getNumberOfSyntaxErrors() != 0 || parserResult == null) {
                throw new RecognizerException("Parsing failed. " + parser.getNumberOfSyntaxErrors() + " syntax errors. Last error was " + this.getErrorHistory().get(this.getErrorHistory().size() - 1));
            }
            return (CommonTree)parserResult.getTree();
        }
        catch (RecognitionException e) {
            throw new RecognizerException(e);
        }
    }

    public List<CobolDataItem> emitModel(CommonTree ast) throws RecognizerException {
        ArrayList<CobolDataItem> cobolDataItems = new ArrayList<CobolDataItem>();
        if (_log.isDebugEnabled()) {
            _log.debug("4. Emitting Model from AST: {}", (Object)(ast == null ? "null" : ast.toStringTree()));
        }
        if (ast == null) {
            return cobolDataItems;
        }
        try {
            CommonTreeNodeStream nodes = new CommonTreeNodeStream(ast);
            CobolStructureEmitterImpl emitter = new CobolStructureEmitterImpl((TreeNodeStream)nodes, this.getErrorHandler());
            emitter.cobdata(cobolDataItems);
            return cobolDataItems;
        }
        catch (RecognitionException e) {
            throw new RecognizerException(e);
        }
    }

    public XmlSchema emitXsd(List<CobolDataItem> cobolDataItems, String targetNamespace) {
        if (_log.isDebugEnabled()) {
            _log.debug("5. Emitting XML Schema from model: {}", (Object)cobolDataItems.toString());
        }
        XmlSchema xsd = this.createXmlSchema(this.getConfig().getXsdEncoding(), targetNamespace);
        List<String> nonUniqueCobolNames = Cob2Xsd.getNonUniqueCobolNames(cobolDataItems);
        XsdEmitter emitter = new XsdEmitter(xsd, this.getConfig());
        for (CobolDataItem cobolDataItem : cobolDataItems) {
            if (this.getConfig().ignoreOrphanPrimitiveElements() && cobolDataItem.getChildren().size() == 0) continue;
            XsdDataItem xsdDataItem = new XsdDataItem(cobolDataItem, this.getConfig(), null, 0, nonUniqueCobolNames, this._errorHandler);
            xsd.getItems().add(emitter.createXmlSchemaElement(xsdDataItem));
        }
        return xsd;
    }

    public String xsdToString(XmlSchema xsd, String xsltFileName) throws XsdGenerationException {
        if (_log.isDebugEnabled()) {
            StringWriter writer = new StringWriter();
            xsd.write(writer);
            _log.debug("6. Writing XML Schema: {}", (Object)writer.toString());
        }
        String errorMessage = "Customizing XML Schema failed.";
        try {
            Transformer transformer;
            TransformerFactory tFactory = TransformerFactory.newInstance();
            try {
                tFactory.setAttribute("indent-number", "4");
            }
            catch (IllegalArgumentException e) {
                _log.debug("Unable to set indent-number on transfomer factory", e);
            }
            StringWriter writer = new StringWriter();
            DOMSource source = new DOMSource(xsd.getAllSchemas()[0]);
            StreamResult result = new StreamResult(writer);
            if (xsltFileName == null || xsltFileName.trim().length() == 0) {
                transformer = tFactory.newTransformer();
            } else {
                StreamSource xsltSource = new StreamSource(new File(xsltFileName));
                transformer = tFactory.newTransformer(xsltSource);
            }
            transformer.setOutputProperty("encoding", this.getConfig().getXsdEncoding());
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("standalone", "no");
            transformer.transform(source, result);
            writer.flush();
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            _log.error(errorMessage, e);
            throw new XsdGenerationException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            _log.error(errorMessage, e);
            throw new XsdGenerationException(e);
        }
        catch (TransformerException e) {
            _log.error(errorMessage, e);
            throw new XsdGenerationException(e);
        }
    }

    public static List<String> getNonUniqueCobolNames(List<CobolDataItem> cobolDataItems) {
        ArrayList<String> cobolNames = new ArrayList<String>();
        ArrayList<String> nonUniqueCobolNames = new ArrayList<String>();
        for (CobolDataItem cobolDataItem : cobolDataItems) {
            Cob2Xsd.getNonUniqueCobolNames(cobolDataItem, cobolNames, nonUniqueCobolNames);
        }
        return nonUniqueCobolNames;
    }

    protected static void getNonUniqueCobolNames(CobolDataItem cobolDataItem, List<String> cobolNames, List<String> nonUniqueCobolNames) {
        String cobolName = cobolDataItem.getCobolName();
        if (!cobolName.equalsIgnoreCase("FILLER")) {
            if (cobolNames.contains(cobolName)) {
                if (!nonUniqueCobolNames.contains(cobolName)) {
                    nonUniqueCobolNames.add(cobolName);
                }
            } else {
                cobolNames.add(cobolName);
            }
        }
        for (CobolDataItem child : cobolDataItem.getChildren()) {
            Cob2Xsd.getNonUniqueCobolNames(child, cobolNames, nonUniqueCobolNames);
        }
    }

    protected XmlSchema createXmlSchema(String encoding, String targetNamespace) {
        XmlSchema xsd = new XmlSchema(targetNamespace, new XmlSchemaCollection());
        if (targetNamespace != null) {
            xsd.setElementFormDefault(XmlSchemaForm.QUALIFIED);
        }
        xsd.setAttributeFormDefault(null);
        xsd.setInputEncoding(encoding);
        if (targetNamespace == null) {
            NamespaceMap prefixmap = new NamespaceMap();
            NamespacePrefixList npl = xsd.getNamespaceContext();
            if (npl == null) {
                prefixmap.add("xsd", "http://www.w3.org/2001/XMLSchema");
            } else {
                for (int i = 0; i < npl.getDeclaredPrefixes().length; ++i) {
                    String prefix = npl.getDeclaredPrefixes()[i];
                    String namespace = npl.getNamespaceURI(prefix);
                    if (namespace.equals("http://www.w3.org/2001/XMLSchema") && prefix.equals("")) {
                        prefix = "xsd";
                    }
                    prefixmap.add(prefix, namespace);
                }
            }
            xsd.setNamespaceContext(prefixmap);
        }
        return xsd;
    }

    private RecognizerErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public Cob2XsdConfig getConfig() {
        return this._config;
    }

    public List<String> getErrorHistory() {
        return this.getErrorHandler().getErrorMessages();
    }
}

