/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cob2xsd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Cob2XsdConfig {
    private static final String DEFAULT_CONFIG_RESOURCE = "/cob2xsd.properties";
    public static final String DEFAULT_CODE_FORMAT = "FIXED_FORMAT";
    public static final String DEFAULT_START_COLUMN = "7";
    public static final String DEFAULT_END_COLUMN = "72";
    public static final String DEFAULT_XSD_ENCODING = "UTF-8";
    public static final String DEFAULT_CURRENCY_SIGN = "$";
    public static final String DEFAULT_CURRENCY_SYMBOL = "$";
    public static final String CODE_FORMAT = "codeFormat";
    public static final String START_COLUMN = "startColumn";
    public static final String END_COLUMN = "endColumn";
    public static final String XSD_ENCODING = "xsdEncoding";
    public static final String MAP_CONDITIONS_TO_FACETS = "mapConditionsToFacets";
    public static final String NAME_CONFLICT_PREPEND_PARENT_NAME = "nameConflictPrependParentName";
    public static final String ELEMENT_NAMES_START_WITH_UPPERCASE = "elementNamesStartWithUppercase";
    public static final String IGNORE_ORPHAN_PRIMITIVE_ELEMENTS = "ignoreOrphanPrimitiveElements";
    public static final String ADD_LEGSTAR_ANNOTATIONS = "addLegStarAnnotations";
    public static final String CURRENCY_SIGN = "currencySign";
    public static final String CURRENCY_SYMBOL = "currencySymbol";
    public static final String DECIMAL_POINT_IS_COMMA = "decimalPointIsComma";
    public static final String NSYMBOL_DBCS = "nSymbolDbcs";
    public static final String QUOTE_IS_QUOTE = "quoteIsQuote";
    private final CodeFormat _codeFormat;
    private final int _startColumn;
    private final int _endColumn;
    private final String _xsdEncoding;
    private final boolean _mapConditionsToFacets;
    private final boolean _nameConflictPrependParentName;
    private final boolean _elementNamesStartWithUppercase;
    private final boolean _ignoreOrphanPrimitiveElements;
    private final boolean _addLegStarAnnotations;
    private final String _currencySign;
    private final String _currencySymbol;
    private final boolean _decimalPointIsComma;
    private final boolean _nSymbolDbcs;
    private final boolean _quoteIsQuote;

    public Cob2XsdConfig(Properties configProps) {
        Properties props = configProps == null ? Cob2XsdConfig.getDefaultConfigProps() : configProps;
        this._codeFormat = CodeFormat.valueOf(props.getProperty(CODE_FORMAT, DEFAULT_CODE_FORMAT));
        this._startColumn = Integer.parseInt(props.getProperty(START_COLUMN, DEFAULT_START_COLUMN));
        this._endColumn = Integer.parseInt(props.getProperty(END_COLUMN, DEFAULT_END_COLUMN));
        this._xsdEncoding = props.getProperty(XSD_ENCODING, DEFAULT_XSD_ENCODING);
        this._mapConditionsToFacets = Boolean.parseBoolean(props.getProperty(MAP_CONDITIONS_TO_FACETS, "false"));
        this._nameConflictPrependParentName = Boolean.parseBoolean(props.getProperty(NAME_CONFLICT_PREPEND_PARENT_NAME, "false"));
        this._elementNamesStartWithUppercase = Boolean.parseBoolean(props.getProperty(ELEMENT_NAMES_START_WITH_UPPERCASE, "false"));
        this._ignoreOrphanPrimitiveElements = Boolean.parseBoolean(props.getProperty(IGNORE_ORPHAN_PRIMITIVE_ELEMENTS, "true"));
        this._addLegStarAnnotations = Boolean.parseBoolean(props.getProperty(ADD_LEGSTAR_ANNOTATIONS, "true"));
        this._currencySign = props.getProperty(CURRENCY_SIGN, "$");
        this._currencySymbol = props.getProperty(CURRENCY_SYMBOL, "$");
        this._decimalPointIsComma = Boolean.parseBoolean(props.getProperty(DECIMAL_POINT_IS_COMMA, "false"));
        this._nSymbolDbcs = Boolean.parseBoolean(props.getProperty(NSYMBOL_DBCS, "false"));
        this._quoteIsQuote = Boolean.parseBoolean(props.getProperty(QUOTE_IS_QUOTE, "true"));
    }

    public Cob2XsdConfig(File configFile) throws IOException {
        this(Cob2XsdConfig.getConfigProps(configFile));
    }

    private static Properties getConfigProps(File configFile) throws IOException {
        return configFile == null || !configFile.exists() ? Cob2XsdConfig.getDefaultConfigProps() : Cob2XsdConfig.getConfigProps(new FileInputStream(configFile));
    }

    public static Properties getDefaultConfigProps() {
        try {
            return Cob2XsdConfig.getConfigProps(Cob2XsdConfig.class.getResourceAsStream(DEFAULT_CONFIG_RESOURCE));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Properties getConfigProps(InputStream stream) throws IOException {
        try {
            Properties config = new Properties();
            config.load(stream);
            Properties properties = config;
            return properties;
        }
        finally {
            stream.close();
        }
    }

    public CodeFormat getCodeFormat() {
        return this._codeFormat;
    }

    public int getStartColumn() {
        return this._startColumn;
    }

    public int getEndColumn() {
        return this._endColumn;
    }

    public String getXsdEncoding() {
        return this._xsdEncoding;
    }

    public boolean mapConditionsToFacets() {
        return this._mapConditionsToFacets;
    }

    public boolean nameConflictPrependParentName() {
        return this._nameConflictPrependParentName;
    }

    public boolean elementNamesStartWithUppercase() {
        return this._elementNamesStartWithUppercase;
    }

    public boolean ignoreOrphanPrimitiveElements() {
        return this._ignoreOrphanPrimitiveElements;
    }

    public boolean addLegStarAnnotations() {
        return this._addLegStarAnnotations;
    }

    public String getCurrencySign() {
        return this._currencySign;
    }

    public String getCurrencySymbol() {
        return this._currencySymbol;
    }

    public boolean decimalPointIsComma() {
        return this._decimalPointIsComma;
    }

    public boolean nSymbolDbcs() {
        return this._nSymbolDbcs;
    }

    public boolean quoteIsQuote() {
        return this._quoteIsQuote;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Cob2XsdConfig [_codeFormat=");
        builder.append((Object)this._codeFormat);
        builder.append(", _startColumn=");
        builder.append(this._startColumn);
        builder.append(", _endColumn=");
        builder.append(this._endColumn);
        builder.append(", _xsdEncoding=");
        builder.append(this._xsdEncoding);
        builder.append(", _mapConditionsToFacets=");
        builder.append(this._mapConditionsToFacets);
        builder.append(", _nameConflictPrependParentName=");
        builder.append(this._nameConflictPrependParentName);
        builder.append(", _elementNamesStartWithUppercase=");
        builder.append(this._elementNamesStartWithUppercase);
        builder.append(", _ignoreOrphanPrimitiveElements=");
        builder.append(this._ignoreOrphanPrimitiveElements);
        builder.append(", _addLegStarAnnotations=");
        builder.append(this._addLegStarAnnotations);
        builder.append(", _currencySign=");
        builder.append(this._currencySign);
        builder.append(", _currencySymbol=");
        builder.append(this._currencySymbol);
        builder.append(", _decimalPointIsComma=");
        builder.append(this._decimalPointIsComma);
        builder.append(", _nSymbolDbcs=");
        builder.append(this._nSymbolDbcs);
        builder.append(", _quoteIsQuote=");
        builder.append(this._quoteIsQuote);
        builder.append("]");
        return builder.toString();
    }

    public static enum CodeFormat {
        FIXED_FORMAT,
        FREE_FORMAT;

    }
}

