/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cob2xsd;

import com.legstar.cob2xsd.Cob2XsdConfig;
import com.legstar.cob2xsd.antlr.RecognizerErrorHandler;
import com.legstar.cobol.model.CobolDataItem;
import com.legstar.cobol.model.CobolTypes;
import com.legstar.cobol.model.CobolUsage;
import com.legstar.cobol.utils.PictureUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.legstar.slf4j.Logger;
import org.legstar.slf4j.LoggerFactory;

public class XsdDataItem {
    private CobolDataItem _cobolDataItem;
    private XsdDataItem _parent;
    private List<XsdDataItem> _children = new LinkedList<XsdDataItem>();
    private XsdType _xsdType;
    private String _xsdElementName;
    private String _xsdTypeName;
    private CobolTypes _cobolType;
    private int _length = -1;
    private String _pattern;
    private int _totalDigits = -1;
    private int _fractionDigits = -1;
    private boolean _isSigned;
    private int _minOccurs = 1;
    private int _maxOccurs = 1;
    private boolean _isODOObject;
    private boolean _isRedefined;
    private String _redefines;
    private int _minStorageLength;
    private int _maxStorageLength;
    public static final String SAFE_NAME_PREFIX = "C";
    private RecognizerErrorHandler _errorHandler;
    private static final Logger _log = LoggerFactory.getLogger(XsdDataItem.class);

    public XsdDataItem(CobolDataItem cobolDataItem, Cob2XsdConfig config, XsdDataItem parent, int order, List<String> nonUniqueCobolNames, RecognizerErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
        this._cobolDataItem = cobolDataItem;
        this._parent = parent;
        this._xsdElementName = XsdDataItem.formatElementName(cobolDataItem, nonUniqueCobolNames, config, parent, order);
        this._xsdTypeName = XsdDataItem.formatTypeName(this._xsdElementName, cobolDataItem, nonUniqueCobolNames, config, parent, order);
        switch (cobolDataItem.getDataEntryType()) {
            case DATA_DESCRIPTION: {
                this.setDataDescription(cobolDataItem, config, nonUniqueCobolNames);
                break;
            }
            case RENAMES: {
                this.addMessageToHistory("Unhandled data entry type " + cobolDataItem.toString(), "warn");
                break;
            }
            case CONDITION: {
                this._xsdType = XsdType.ENUM;
                if (!config.mapConditionsToFacets() || this.getConditionRanges().size() <= 1) break;
                this.addMessageToHistory("Condition with multiple ranges cannot be mapped to enumeration facet " + cobolDataItem.toString(), "warn");
                break;
            }
            default: {
                this.addMessageToHistory("Unrecognized data entry type " + cobolDataItem.toString(), "error");
            }
        }
    }

    protected void setDataDescription(CobolDataItem cobolDataItem, Cob2XsdConfig config, List<String> nonUniqueCobolNames) {
        boolean odoObjectMarked;
        if (this.isGroup(cobolDataItem)) {
            this._xsdType = XsdType.COMPLEX;
            this._cobolType = CobolTypes.GROUP_ITEM;
        } else {
            if (cobolDataItem.getUsage() != null) {
                this.setAttributesFromUsage(cobolDataItem.getUsage());
            } else if (this.getParent() != null && this.getParent().getUsage() != null) {
                this.setAttributesFromUsage(this.getParent().getUsage());
            }
            if (cobolDataItem.getPicture() != null) {
                this.setAttributesFromPicture(cobolDataItem.getPicture(), cobolDataItem.isSignSeparate(), cobolDataItem.isBlankWhenZero(), config.getCurrencySign(), config.getCurrencySymbol().charAt(0), config.nSymbolDbcs(), config.decimalPointIsComma());
            }
        }
        this._maxStorageLength = this._minStorageLength;
        if (this._xsdType == null) {
            this.addMessageToHistory("Unable to determine type for " + cobolDataItem.toString() + ". Assuming group item.", "warn");
            this._xsdType = XsdType.COMPLEX;
            this._cobolType = CobolTypes.GROUP_ITEM;
        }
        if (this.getDependingOn() != null && this.getParent() != null && !(odoObjectMarked = this.markODOObjectInAncestor(this.getDependingOn()))) {
            this.addMessageToHistory("Unable to locate ODO object named " + this.getDependingOn() + " for item " + cobolDataItem.toString(), "warn");
        }
        this._redefines = cobolDataItem.getRedefines();
        if (this._redefines != null && this.getParent() != null) {
            this._redefines = this.getParent().updateRedefinition(this._redefines);
        }
        int order = 0;
        for (CobolDataItem child : cobolDataItem.getChildren()) {
            XsdDataItem xsdChild = new XsdDataItem(child, config, this, order, nonUniqueCobolNames, this._errorHandler);
            this._children.add(xsdChild);
            ++order;
        }
        boolean redefines = false;
        int minRedefinesStorageLength = 0;
        int maxRedefinesStorageLength = 0;
        for (XsdDataItem xsdChild : this.getChildren()) {
            if (redefines) {
                if (xsdChild.getRedefines() == null) {
                    redefines = false;
                    this._minStorageLength += minRedefinesStorageLength;
                    this._maxStorageLength += maxRedefinesStorageLength;
                } else {
                    if (xsdChild.getMinStorageLength() > minRedefinesStorageLength) {
                        minRedefinesStorageLength = xsdChild.getMinStorageLength();
                    }
                    if (xsdChild.getMaxStorageLength() > maxRedefinesStorageLength) {
                        maxRedefinesStorageLength = xsdChild.getMaxStorageLength();
                    }
                }
            }
            if (xsdChild.isRedefined()) {
                redefines = true;
                minRedefinesStorageLength = xsdChild.getMinStorageLength();
                maxRedefinesStorageLength = xsdChild.getMaxStorageLength();
                continue;
            }
            if (redefines) continue;
            this._minStorageLength += xsdChild.getMinStorageLength();
            this._maxStorageLength += xsdChild.getMaxStorageLength();
        }
        if (redefines) {
            this._minStorageLength += minRedefinesStorageLength;
            this._maxStorageLength += maxRedefinesStorageLength;
        }
        if (cobolDataItem.getMaxOccurs() > 0) {
            this._maxOccurs = cobolDataItem.getMaxOccurs();
            this._maxStorageLength *= this._maxOccurs;
            this._minOccurs = cobolDataItem.getDependingOn() == null ? (cobolDataItem.getMinOccurs() > -1 ? cobolDataItem.getMinOccurs() : cobolDataItem.getMaxOccurs()) : 0;
            this._minStorageLength *= this._minOccurs;
        }
    }

    protected boolean isGroup(CobolDataItem cobolDataItem) {
        boolean isGroup = false;
        if (cobolDataItem.getChildren() != null) {
            for (CobolDataItem child : cobolDataItem.getChildren()) {
                if (child.getDataEntryType() == CobolDataItem.DataEntryType.CONDITION) continue;
                isGroup = true;
            }
        }
        if (isGroup && cobolDataItem.getPicture() != null) {
            this.addMessageToHistory("Group item with picture clause " + cobolDataItem.toString() + ". Assuming elementary item and children are ignored", "warn");
            isGroup = false;
        }
        return isGroup;
    }

    public boolean markODOObjectInAncestor(String odoObjectCobolName) {
        boolean found = false;
        if (this.getParent() == null) {
            return found;
        }
        found = this.getParent().markODOObjectInChildren(odoObjectCobolName, this.getCobolName());
        if (found) {
            return found;
        }
        return this.getParent().markODOObjectInAncestor(odoObjectCobolName);
    }

    public boolean markODOObjectInChildren(String odoObjectCobolName, String stopChildCobolName) {
        boolean found = false;
        for (XsdDataItem child : this.getChildren()) {
            if (child.getCobolName().equals(stopChildCobolName)) break;
            if (child.getCobolName().equals(odoObjectCobolName)) {
                child.setIsODOObject(true);
                found = true;
                break;
            }
            found = child.markODOObjectInChildren(odoObjectCobolName, stopChildCobolName);
            if (!found) continue;
            break;
        }
        return found;
    }

    public String updateRedefinition(String cobolName) {
        for (XsdDataItem child : this.getChildren()) {
            if (!child.getCobolName().equals(cobolName)) continue;
            if (child.getRedefines() != null) {
                return child.getRedefines();
            }
            child.setIsRedefined(true);
            return cobolName;
        }
        if (this.getParent() != null) {
            return this.getParent().updateRedefinition(cobolName);
        }
        _log.error("Unable to locate redefined item " + cobolName);
        return null;
    }

    private void setAttributesFromUsage(CobolUsage.Usage usage) {
        switch (usage) {
            case BINARY: {
                this._cobolType = CobolTypes.BINARY_ITEM;
                this._xsdType = XsdType.INTEGER;
                break;
            }
            case NATIVEBINARY: {
                this._cobolType = CobolTypes.NATIVE_BINARY_ITEM;
                this._xsdType = XsdType.INTEGER;
                break;
            }
            case SINGLEFLOAT: {
                this._cobolType = CobolTypes.SINGLE_FLOAT_ITEM;
                this._xsdType = XsdType.FLOAT;
                this._minStorageLength = 4;
                break;
            }
            case DOUBLEFLOAT: {
                this._cobolType = CobolTypes.DOUBLE_FLOAT_ITEM;
                this._xsdType = XsdType.DOUBLE;
                this._minStorageLength = 8;
                break;
            }
            case PACKEDDECIMAL: {
                this._cobolType = CobolTypes.PACKED_DECIMAL_ITEM;
                this._xsdType = XsdType.DECIMAL;
                break;
            }
            case INDEX: {
                this._cobolType = CobolTypes.INDEX_ITEM;
                this._xsdType = XsdType.HEXBINARY;
                this._minStorageLength = 4;
                break;
            }
            case POINTER: {
                this._cobolType = CobolTypes.POINTER_ITEM;
                this._xsdType = XsdType.HEXBINARY;
                this._minStorageLength = 4;
                break;
            }
            case PROCEDUREPOINTER: {
                this._cobolType = CobolTypes.PROC_POINTER_ITEM;
                this._xsdType = XsdType.HEXBINARY;
                this._minStorageLength = 8;
                break;
            }
            case FUNCTIONPOINTER: {
                this._cobolType = CobolTypes.FUNC_POINTER_ITEM;
                this._xsdType = XsdType.HEXBINARY;
                this._minStorageLength = 4;
                break;
            }
            case DISPLAY: {
                this._cobolType = CobolTypes.ALPHANUMERIC_ITEM;
                this._xsdType = XsdType.STRING;
                break;
            }
            case DISPLAY1: {
                this._cobolType = CobolTypes.DBCS_ITEM;
                this._xsdType = XsdType.STRING;
                break;
            }
            case NATIONAL: {
                this._cobolType = CobolTypes.NATIONAL_ITEM;
                this._xsdType = XsdType.STRING;
                break;
            }
            default: {
                _log.error("Unrecognized usage clause " + this.toString());
            }
        }
    }

    private void setAttributesFromPicture(String picture, boolean isSignSeparate, boolean isBlankWhenZero, String currencySign, char currencySymbol, boolean nSymbolDbcs, boolean decimalPointIsComma) {
        char comma = decimalPointIsComma ? (char)'.' : ',';
        char decimalPoint = decimalPointIsComma ? (char)',' : '.';
        Map<Character, Integer> charNum = PictureUtil.getPictureCharOccurences(picture, currencySymbol);
        this._length = PictureUtil.calcLengthFromPicture(charNum, isSignSeparate, currencySign, currencySymbol, false);
        this._pattern = PictureUtil.getRegexFromPicture(picture, currencySign, currencySymbol);
        if (charNum.get(Character.valueOf('A')) + charNum.get(Character.valueOf('X')) > 0) {
            this._cobolType = charNum.get(Character.valueOf('9')) + charNum.get(Character.valueOf('B')) + charNum.get(Character.valueOf('0')) + charNum.get(Character.valueOf('/')) > 0 ? CobolTypes.ALPHANUMERIC_EDITED_ITEM : (charNum.get(Character.valueOf('X')) == 0 ? CobolTypes.ALPHABETIC_ITEM : CobolTypes.ALPHANUMERIC_ITEM);
            this._xsdType = XsdType.STRING;
            this._minStorageLength = PictureUtil.calcLengthFromPicture(charNum, isSignSeparate, currencySign, currencySymbol, true);
            return;
        }
        if (charNum.get(Character.valueOf('G')) > 0) {
            this._cobolType = CobolTypes.DBCS_ITEM;
            this._xsdType = XsdType.STRING;
            this._minStorageLength = PictureUtil.calcLengthFromPicture(charNum, isSignSeparate, currencySign, currencySymbol, true);
            return;
        }
        if (charNum.get(Character.valueOf('N')) > 0) {
            this._cobolType = nSymbolDbcs ? CobolTypes.DBCS_ITEM : CobolTypes.NATIONAL_ITEM;
            this._xsdType = XsdType.STRING;
            this._minStorageLength = PictureUtil.calcLengthFromPicture(charNum, isSignSeparate, currencySign, currencySymbol, true);
            return;
        }
        if (charNum.get(Character.valueOf('E')) > 0) {
            this._cobolType = CobolTypes.EXTERNAL_FLOATING_ITEM;
            this._xsdType = XsdType.STRING;
            this._minStorageLength = this._length;
            return;
        }
        if (charNum.get(Character.valueOf('/')) + charNum.get(Character.valueOf('B')) + charNum.get(Character.valueOf('/')) + charNum.get(Character.valueOf('Z')) + charNum.get(Character.valueOf('0')) + charNum.get(Character.valueOf(comma)) + charNum.get(Character.valueOf(decimalPoint)) + charNum.get(Character.valueOf('*')) + charNum.get(Character.valueOf('+')) + charNum.get(Character.valueOf('-')) + charNum.get(Character.valueOf('C')) + charNum.get(Character.valueOf('D')) + charNum.get(Character.valueOf(currencySymbol)) > 0 || isBlankWhenZero) {
            this._cobolType = CobolTypes.NUMERIC_EDITED_ITEM;
            this._xsdType = XsdType.STRING;
            this._minStorageLength = this._length;
            this.setDigitsAndSign(picture, currencySymbol, decimalPointIsComma);
            return;
        }
        if (this._cobolType == null || this._cobolType == CobolTypes.ALPHANUMERIC_ITEM) {
            this._cobolType = CobolTypes.ZONED_DECIMAL_ITEM;
            this._minStorageLength = this._length;
        }
        this.setNumericAttributes(picture, currencySymbol, decimalPointIsComma);
    }

    private void setNumericAttributes(String picture, char currencyChar, boolean decimalPointIsComma) {
        this.setDigitsAndSign(picture, currencyChar, decimalPointIsComma);
        this._xsdType = this._fractionDigits == 0 ? (this._totalDigits < 5 ? (this._isSigned ? XsdType.SHORT : XsdType.USHORT) : (this._totalDigits < 10 ? (this._isSigned ? XsdType.INT : XsdType.UINT) : (this._totalDigits < 20 ? (this._isSigned ? XsdType.LONG : XsdType.ULONG) : XsdType.INTEGER))) : XsdType.DECIMAL;
        switch (this._cobolType) {
            case BINARY_ITEM: 
            case NATIVE_BINARY_ITEM: {
                if (this._totalDigits < 5) {
                    this._minStorageLength = 2;
                    break;
                }
                if (this._totalDigits < 10) {
                    this._minStorageLength = 4;
                    break;
                }
                this._minStorageLength = 8;
                break;
            }
            case PACKED_DECIMAL_ITEM: {
                this._minStorageLength = this._totalDigits / 2 + 1;
                break;
            }
        }
    }

    protected void setDigitsAndSign(String picture, char currencySymbol, boolean decimalPointIsComma) {
        Map<Character, Integer> intCharNum;
        int decimalPoint = decimalPointIsComma ? 44 : 46;
        int iV = picture.indexOf(86);
        if (iV == -1) {
            iV = picture.indexOf(118);
        }
        if (iV == -1) {
            iV = picture.indexOf(decimalPoint);
        }
        if (iV > 0) {
            intCharNum = PictureUtil.getPictureCharOccurences(picture.substring(0, iV), currencySymbol);
            Map<Character, Integer> decCharNum = PictureUtil.getPictureCharOccurences(picture.substring(iV), currencySymbol);
            this._fractionDigits = this.getMaxDigits(decCharNum, currencySymbol);
            this._totalDigits = this.getMaxDigits(intCharNum, currencySymbol) + this._fractionDigits;
        } else {
            intCharNum = PictureUtil.getPictureCharOccurences(picture, currencySymbol);
            this._fractionDigits = 0;
            this._totalDigits = this.getMaxDigits(intCharNum, currencySymbol);
        }
        this._isSigned = intCharNum.get(Character.valueOf('S')) + intCharNum.get(Character.valueOf('+')) + intCharNum.get(Character.valueOf('-')) > 0;
    }

    protected int getMaxDigits(Map<Character, Integer> intCharNum, char currencySymbol) {
        int maxDigits = intCharNum.get(Character.valueOf('9')) + intCharNum.get(Character.valueOf('Z')) + intCharNum.get(Character.valueOf('*'));
        if (intCharNum.get(Character.valueOf('+')) > 0) {
            maxDigits += intCharNum.get(Character.valueOf('+')) - 1;
        }
        if (intCharNum.get(Character.valueOf('-')) > 0) {
            maxDigits += intCharNum.get(Character.valueOf('-')) - 1;
        }
        if (intCharNum.get(Character.valueOf(currencySymbol)) > 0) {
            maxDigits += intCharNum.get(Character.valueOf(currencySymbol)) - 1;
        }
        return maxDigits;
    }

    public static String formatElementName(CobolDataItem cobolDataItem, List<String> nonUniqueCobolNames, Cob2XsdConfig config, XsdDataItem parent, int order) {
        String cobolName = XsdDataItem.getXmlCompatibleCobolName(cobolDataItem.getCobolName());
        if (cobolName.equalsIgnoreCase("FILLER")) {
            String filler = config.elementNamesStartWithUppercase() ? "Filler" : "filler";
            return filler + cobolDataItem.getSrceLine();
        }
        StringBuilder sb = new StringBuilder();
        boolean wordBreaker = config.elementNamesStartWithUppercase();
        for (int i = 0; i < cobolName.length(); ++i) {
            char c = cobolName.charAt(i);
            if (c != '-' && c != '_') {
                if (Character.isDigit(c)) {
                    sb.append(c);
                    wordBreaker = true;
                    continue;
                }
                if (wordBreaker) {
                    sb.append(Character.toUpperCase(c));
                } else {
                    sb.append(Character.toLowerCase(c));
                }
                wordBreaker = false;
                continue;
            }
            wordBreaker = true;
        }
        String elementName = sb.toString();
        if (parent != null) {
            int siblingsWithSameName = 0;
            for (CobolDataItem child : parent.getCobolChildren()) {
                if (!child.getCobolName().equals(cobolDataItem.getCobolName())) continue;
                ++siblingsWithSameName;
            }
            if (siblingsWithSameName > 1) {
                elementName = elementName + order;
            }
        }
        return elementName;
    }

    public static String formatTypeName(String elementName, CobolDataItem cobolDataItem, List<String> nonUniqueCobolNames, Cob2XsdConfig config, XsdDataItem parent, int order) {
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toUpperCase(elementName.charAt(0)));
        sb.append(elementName.substring(1));
        if (nonUniqueCobolNames.contains(cobolDataItem.getCobolName())) {
            if (config.nameConflictPrependParentName()) {
                if (parent != null) {
                    sb.insert(0, parent.getXsdTypeName());
                }
            } else {
                sb.append(cobolDataItem.getSrceLine());
            }
        }
        return sb.toString();
    }

    public static String getXmlCompatibleCobolName(String cobolName) {
        if (cobolName != null && cobolName.length() > 0 && Character.isDigit(cobolName.charAt(0))) {
            return SAFE_NAME_PREFIX + cobolName;
        }
        return cobolName;
    }

    public XsdType getXsdType() {
        return this._xsdType;
    }

    public CobolTypes getCobolType() {
        return this._cobolType;
    }

    public int getLength() {
        return this._length;
    }

    public String getPattern() {
        return this._pattern;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public int getFractionDigits() {
        return this._fractionDigits;
    }

    public String getXsdElementName() {
        return this._xsdElementName;
    }

    public String getXsdTypeName() {
        return this._xsdTypeName;
    }

    public List<XsdDataItem> getChildren() {
        return this._children;
    }

    public int getMinOccurs() {
        return this._minOccurs;
    }

    public int getCobolMinOccurs() {
        return this._cobolDataItem.getMinOccurs();
    }

    public int getMaxOccurs() {
        return this._maxOccurs;
    }

    public int getCobolMaxOccurs() {
        return this._cobolDataItem.getMaxOccurs();
    }

    public int getLevelNumber() {
        return this._cobolDataItem.getLevelNumber();
    }

    public String getCobolName() {
        return this._cobolDataItem.getCobolName();
    }

    public String getPicture() {
        return this._cobolDataItem.getPicture();
    }

    public CobolUsage.Usage getUsage() {
        return this._cobolDataItem.getUsage();
    }

    public String getUsageForCobol() {
        switch (this.getUsage()) {
            case BINARY: {
                return "BINARY";
            }
            case SINGLEFLOAT: {
                return "COMP-1";
            }
            case DOUBLEFLOAT: {
                return "COMP-2";
            }
            case PACKEDDECIMAL: {
                return "PACKED-DECIMAL";
            }
            case NATIVEBINARY: {
                return "COMP-5";
            }
            case DISPLAY: {
                return "DISPLAY";
            }
            case DISPLAY1: {
                return "DISPLAY-1";
            }
            case INDEX: {
                return "INDEX";
            }
            case NATIONAL: {
                return "NATIONAL";
            }
            case POINTER: {
                return "POINTER";
            }
            case PROCEDUREPOINTER: {
                return "PROCEDURE-POINTER";
            }
            case FUNCTIONPOINTER: {
                return "FUNCTION-POINTER";
            }
        }
        return null;
    }

    public boolean isJustifiedRight() {
        return this._cobolDataItem.isJustifiedRight();
    }

    public boolean isSign() {
        return this._cobolDataItem.isSign();
    }

    public boolean isSignLeading() {
        return this._cobolDataItem.isSignLeading();
    }

    public boolean isSignSeparate() {
        return this._cobolDataItem.isSignSeparate();
    }

    public String getDependingOn() {
        return this._cobolDataItem.getDependingOn();
    }

    public boolean isSigned() {
        return this._isSigned;
    }

    public String getRedefines() {
        return this._redefines;
    }

    public String getValue() {
        return this._cobolDataItem.getValue();
    }

    public int getSrceLine() {
        return this._cobolDataItem.getSrceLine();
    }

    public CobolDataItem.DataEntryType getDataEntryType() {
        return this._cobolDataItem.getDataEntryType();
    }

    public List<String> getConditionLiterals() {
        return this._cobolDataItem.getConditionLiterals();
    }

    public List<CobolDataItem.Range> getConditionRanges() {
        return this._cobolDataItem.getConditionRanges();
    }

    public boolean isBlankWhenZero() {
        return this._cobolDataItem.isBlankWhenZero();
    }

    public XsdDataItem getParent() {
        return this._parent;
    }

    public boolean isODOObject() {
        return this._isODOObject;
    }

    public boolean isRedefined() {
        return this._isRedefined;
    }

    public void setIsODOObject(boolean isODOObject) {
        this._isODOObject = isODOObject;
    }

    public void setIsRedefined(boolean isRedefined) {
        this._isRedefined = isRedefined;
    }

    public int getMinStorageLength() {
        return this._minStorageLength;
    }

    public int getMaxStorageLength() {
        return this._maxStorageLength;
    }

    public boolean isNumeric() {
        switch (this.getXsdType()) {
            case SHORT: 
            case USHORT: 
            case INT: 
            case UINT: 
            case LONG: 
            case ULONG: 
            case INTEGER: 
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public List<CobolDataItem> getCobolChildren() {
        return this._cobolDataItem.getChildren();
    }

    private void addMessageToHistory(String msg, String level) {
        if (level.equalsIgnoreCase("warn")) {
            _log.warn(msg);
        } else if (level.equalsIgnoreCase("error")) {
            _log.error(msg);
        } else {
            _log.info(msg);
        }
        this._errorHandler.addMessageToHistory(msg);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("typeName:" + this.getXsdTypeName());
        sb.append(',');
        sb.append("elementName:" + this.getXsdElementName());
        if (this.getXsdType() != null) {
            sb.append(',');
            sb.append("type:" + this.getXsdType().toString());
            if (this.getCobolType() != null) {
                sb.append(',');
                sb.append("cobolType:" + this.getCobolType().toString());
            }
            if (this.getXsdType() == XsdType.STRING || this.getXsdType() == XsdType.HEXBINARY) {
                if (this.getLength() > -1) {
                    sb.append(',');
                    sb.append("length:" + this.getLength());
                }
                if (this.getPattern() != null) {
                    sb.append(',');
                    sb.append("pattern:" + this.getPattern());
                }
            }
            if (this.isNumeric()) {
                if (this.getTotalDigits() > -1) {
                    sb.append(',');
                    sb.append("totalDigits:" + this.getTotalDigits());
                }
                if (this.getFractionDigits() > -1) {
                    sb.append(',');
                    sb.append("fractionDigits:" + this.getFractionDigits());
                }
                sb.append(',');
                sb.append("isSigned:" + this.isSigned());
            }
            sb.append(',');
            sb.append("minOccurs:" + this.getMinOccurs());
            sb.append(',');
            sb.append("maxOccurs:" + this.getMaxOccurs());
            sb.append(',');
            sb.append("isODOObject:" + this.isODOObject());
            sb.append(',');
            sb.append("isRedefined:" + this.isRedefined());
            sb.append(',');
            sb.append("minStorageLength:" + this.getMinStorageLength());
            sb.append(',');
            sb.append("maxStorageLength:" + this.getMaxStorageLength());
        }
        sb.append(',');
        sb.append(this._cobolDataItem.toString());
        return sb.toString();
    }

    public static enum XsdType {
        COMPLEX,
        ENUM,
        STRING,
        HEXBINARY,
        SHORT,
        USHORT,
        INT,
        UINT,
        LONG,
        ULONG,
        INTEGER,
        DECIMAL,
        FLOAT,
        DOUBLE;

    }
}

