/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cobol.model;

import org.legstar.apache.commons.lang3.StringUtils;
import org.legstar.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.legstar.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.legstar.apache.ws.commons.schema.XmlSchemaElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CobolAnnotations {
    private final Element cobolAnnotations;

    public CobolAnnotations(XmlSchemaElement xsdElement) {
        this.cobolAnnotations = CobolAnnotations.getCobolXsdAnnotations(xsdElement);
    }

    private static Element getCobolXsdAnnotations(XmlSchemaElement xsdElement) {
        XmlSchemaAnnotation annotation = xsdElement.getAnnotation();
        if (annotation == null || annotation.getItems().size() == 0) {
            throw new IllegalArgumentException("Xsd element of type " + xsdElement.getSchemaType().getQName() + " at line " + xsdElement.getLineNumber() + " does not have COBOL annotations");
        }
        XmlSchemaAppInfo appinfo = (XmlSchemaAppInfo)annotation.getItems().get(0);
        if (appinfo.getMarkup() == null) {
            throw new IllegalArgumentException("Xsd element of type " + xsdElement.getSchemaType().getQName() + " does not have any markup in its annotations");
        }
        Node node = null;
        boolean found = false;
        for (int i = 0; i < appinfo.getMarkup().getLength(); ++i) {
            node = appinfo.getMarkup().item(i);
            if (!(node instanceof Element) || !node.getLocalName().equals("cobolElement") || !node.getNamespaceURI().equals("http://www.legsem.com/legstar/xml/cobol-binding-1.0.1.xsd")) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Xsd element of type " + xsdElement.getSchemaType().getQName() + " at line " + xsdElement.getLineNumber() + " does not have any COBOL annotations");
        }
        return (Element)node;
    }

    public String getCobolType() {
        return this.cobolAnnotations.getAttribute("type");
    }

    public String getCobolName() {
        return this.cobolAnnotations.getAttribute("cobolName");
    }

    public boolean signed() {
        String val = this.cobolAnnotations.getAttribute("signed");
        if (StringUtils.isBlank(val)) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean signLeading() {
        String val = this.cobolAnnotations.getAttribute("signLeading");
        if (StringUtils.isBlank(val)) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean signSeparate() {
        String val = this.cobolAnnotations.getAttribute("signSeparate");
        if (StringUtils.isBlank(val)) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public int totalDigits() {
        String val = this.cobolAnnotations.getAttribute("totalDigits");
        if (StringUtils.isBlank(val)) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    public int fractionDigits() {
        String val = this.cobolAnnotations.getAttribute("fractionDigits");
        if (StringUtils.isBlank(val)) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    public boolean odoObject() {
        String val = this.cobolAnnotations.getAttribute("isODOObject");
        if (StringUtils.isBlank(val)) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public String getDependingOn() {
        if (this.cobolAnnotations.hasAttribute("dependingOn")) {
            return this.cobolAnnotations.getAttribute("dependingOn");
        }
        return null;
    }
}

