/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cobol.model;

import com.legstar.cobol.model.CobolUsage;
import java.util.LinkedList;
import java.util.List;

public class CobolDataItem {
    private int levelNumber = 1;
    private String cobolName = "FILLER";
    private String redefines;
    private boolean blankWhenZero;
    private boolean isExternal;
    private boolean isGlobal;
    private boolean groupUsageNational;
    private boolean isJustifiedRight;
    private String picture;
    private boolean isSign;
    private boolean isSignLeading;
    private boolean isSignSeparate;
    private boolean isSynchronized;
    private int minOccurs = -1;
    private int maxOccurs = -1;
    private String dependingOn;
    private List<String> indexes = new LinkedList<String>();
    private List<String> ascendingKeys = new LinkedList<String>();
    private List<String> descendingKeys = new LinkedList<String>();
    private CobolUsage.Usage usage = null;
    private String value;
    private String dateFormat;
    private int srceLine;
    private List<CobolDataItem> children = new LinkedList<CobolDataItem>();
    private String renamesSubject;
    private Range renamesSubjectRange;
    private List<String> conditionLiterals = new LinkedList<String>();
    private List<Range> conditionRanges = new LinkedList<Range>();

    public CobolDataItem() {
    }

    public CobolDataItem(String cobolName) {
        this.cobolName = cobolName;
    }

    public CobolDataItem(int levelNumber, String cobolName) {
        this.levelNumber = levelNumber;
        this.cobolName = cobolName;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public void setLevelNumber(int levelNumber) {
        this.levelNumber = levelNumber;
    }

    public String getCobolName() {
        return this.cobolName;
    }

    public void setCobolName(String cobolName) {
        this.cobolName = cobolName;
    }

    public String getRedefines() {
        return this.redefines;
    }

    public void setRedefines(String redefines) {
        this.redefines = redefines;
    }

    public boolean isBlankWhenZero() {
        return this.blankWhenZero;
    }

    public void setBlankWhenZero(boolean blankWhenZero) {
        this.blankWhenZero = blankWhenZero;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean external) {
        this.isExternal = external;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean global) {
        this.isGlobal = global;
    }

    public boolean isGroupUsageNational() {
        return this.groupUsageNational;
    }

    public void setGroupUsageNational(boolean groupUsageNational) {
        this.groupUsageNational = groupUsageNational;
    }

    public boolean isJustifiedRight() {
        return this.isJustifiedRight;
    }

    public void setJustifiedRight(boolean justifiedRight) {
        this.isJustifiedRight = justifiedRight;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public boolean isSign() {
        return this.isSign;
    }

    public void setSign(boolean isSign) {
        this.isSign = isSign;
    }

    public boolean isSignLeading() {
        return this.isSignLeading;
    }

    public void setSignLeading(boolean isSignLeading) {
        this.setSign(true);
        this.isSignLeading = isSignLeading;
    }

    public boolean isSignSeparate() {
        return this.isSignSeparate;
    }

    public void setSignSeparate(boolean isSignSeparate) {
        this.setSign(true);
        this.isSignSeparate = isSignSeparate;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public String getDependingOn() {
        return this.dependingOn;
    }

    public void setDependingOn(String dependingOn) {
        this.dependingOn = dependingOn;
    }

    public List<String> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<String> indexes) {
        this.indexes = indexes;
    }

    public void addIndex(String index) {
        this.indexes.add(index);
    }

    public List<String> getAscendingKeys() {
        return this.ascendingKeys;
    }

    public void setAscendingKeys(List<String> ascendingKeys) {
        this.ascendingKeys = ascendingKeys;
    }

    public void addAscendingKey(String ascendingKey) {
        this.ascendingKeys.add(ascendingKey);
    }

    public List<String> getDescendingKeys() {
        return this.descendingKeys;
    }

    public void setDescendingKeys(List<String> descendingKeys) {
        this.descendingKeys = descendingKeys;
    }

    public void addDescendingKey(String descendingKey) {
        this.descendingKeys.add(descendingKey);
    }

    public CobolUsage.Usage getUsage() {
        return this.usage;
    }

    public void setUsage(CobolUsage.Usage usage) {
        this.usage = usage;
    }

    public String getCobolUsage() {
        return CobolUsage.getCobolUsage(this.usage);
    }

    public void setCobolUsage(String cobolUsage) {
        this.usage = CobolUsage.getUsage(cobolUsage);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public int getSrceLine() {
        return this.srceLine;
    }

    public void setSrceLine(int srceLine) {
        this.srceLine = srceLine;
    }

    public List<CobolDataItem> getChildren() {
        return this.children;
    }

    public void setChildren(List<CobolDataItem> children) {
        this.children = children;
    }

    public boolean isStructure() {
        return this.getChildren().size() > 0;
    }

    public String getRenamesSubject() {
        return this.renamesSubject;
    }

    public void setRenamesSubject(String renamesSubject) {
        this.renamesSubject = renamesSubject;
    }

    public Range getRenamesSubjectRange() {
        return this.renamesSubjectRange;
    }

    public void setRenamesSubjectRange(Range renamesSubjectRange) {
        this.renamesSubjectRange = renamesSubjectRange;
    }

    public List<String> getConditionLiterals() {
        return this.conditionLiterals;
    }

    public void setConditionLiterals(List<String> conditionLiterals) {
        this.conditionLiterals = conditionLiterals;
    }

    public void addConditionLiterals(String conditionLiteral) {
        this.conditionLiterals.add(conditionLiteral);
    }

    public List<Range> getConditionRanges() {
        return this.conditionRanges;
    }

    public void setConditionRanges(List<Range> conditionRanges) {
        this.conditionRanges = conditionRanges;
    }

    public void addConditionRange(Range conditionRange) {
        this.conditionRanges.add(conditionRange);
    }

    public DataEntryType getDataEntryType() {
        return this.levelNumber == 88 ? DataEntryType.CONDITION : (this.levelNumber == 66 ? DataEntryType.RENAMES : DataEntryType.DATA_DESCRIPTION);
    }

    public boolean isCondition() {
        return this.getDataEntryType().equals((Object)DataEntryType.CONDITION);
    }

    public boolean isRenames() {
        return this.getDataEntryType().equals((Object)DataEntryType.RENAMES);
    }

    public boolean isDataDescription() {
        return this.getDataEntryType().equals((Object)DataEntryType.DATA_DESCRIPTION);
    }

    public boolean isArray() {
        return this.getMaxOccurs() > 1 || this.getMaxOccurs() == 1 && this.getMinOccurs() == 0;
    }

    public boolean isVariableSizeArray() {
        return this.isArray() && this.getMinOccurs() != this.getMaxOccurs() && this.getDependingOn() != null && this.getDependingOn().trim().length() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("level:" + this.getLevelNumber());
        sb.append(',');
        sb.append("cobolName:" + this.getCobolName());
        if (this.getDataEntryType() != null) {
            switch (this.getDataEntryType()) {
                case DATA_DESCRIPTION: {
                    this.toStringDataDescription(sb);
                    break;
                }
                case RENAMES: {
                    this.toStringRenames(sb);
                    break;
                }
                case CONDITION: {
                    this.toStringCondition(sb);
                    break;
                }
            }
        }
        sb.append(',');
        sb.append("srceLine:" + this.getSrceLine());
        sb.append('}');
        return sb.toString();
    }

    private void toStringDataDescription(StringBuilder sb) {
        if (this.getRedefines() != null) {
            sb.append(',');
            sb.append("redefines:" + this.getRedefines());
        }
        if (this.isBlankWhenZero()) {
            sb.append(',');
            sb.append("isBlankWhenZero:" + this.isBlankWhenZero());
        }
        if (this.isExternal()) {
            sb.append(',');
            sb.append("isExternal:" + this.isExternal());
        }
        if (this.isGlobal()) {
            sb.append(',');
            sb.append("isGlobal:" + this.isGlobal());
        }
        if (this.isGroupUsageNational()) {
            sb.append(',');
            sb.append("groupUsageNational:" + this.isGroupUsageNational());
        }
        if (this.getMaxOccurs() > 0) {
            if (this.getMinOccurs() > -1) {
                sb.append(',');
                sb.append("minOccurs:" + this.getMinOccurs());
            }
            sb.append(',');
            sb.append("maxOccurs:" + this.getMaxOccurs());
            if (this.getDependingOn() != null) {
                sb.append(',');
                sb.append("dependingOn:" + this.getDependingOn());
            }
            if (this.getIndexes().size() > 0) {
                this.toStringList(sb, this.getIndexes(), "indexes");
            }
            if (this.getAscendingKeys().size() > 0) {
                this.toStringList(sb, this.getAscendingKeys(), "ascendingKeys");
            }
            if (this.getDescendingKeys().size() > 0) {
                this.toStringList(sb, this.getDescendingKeys(), "descendingKeys");
            }
        }
        if (this.isSign()) {
            sb.append(',');
            sb.append("isSign:" + this.isSign());
            sb.append(',');
            sb.append("isSignLeading:" + this.isSignLeading());
            sb.append(',');
            sb.append("isSignSeparate:" + this.isSignSeparate());
        }
        if (this.isSynchronized()) {
            sb.append(',');
            sb.append("isSynchronized:" + this.isSynchronized());
        }
        if (this.getUsage() != null) {
            sb.append(',');
            sb.append("usage:" + (Object)((Object)this.getUsage()));
        }
        if (this.getChildren().size() == 0) {
            if (this.isJustifiedRight()) {
                sb.append(',');
                sb.append("isJustifiedRight:" + this.isJustifiedRight());
            }
            if (this.getPicture() != null) {
                sb.append(',');
                sb.append("picture:\"" + this.getPicture() + '\"');
            }
        }
        if (this.getValue() != null && this.getValue().length() > 0) {
            sb.append(',');
            sb.append("value:" + this.getValue());
        }
        if (this.getDateFormat() != null) {
            sb.append(',');
            sb.append("dateFormat:" + this.getDateFormat());
        }
        if (this.getChildren().size() > 0) {
            this.toStringList(sb, this.getChildren(), "children");
        }
    }

    private void toStringRenames(StringBuilder sb) {
        if (this.getRenamesSubject() != null) {
            sb.append(',');
            sb.append("renamesSubject:" + this.getRenamesSubject());
        }
        if (this.getRenamesSubjectRange() != null) {
            sb.append(',');
            sb.append("renamesSubjectRange:" + this.getRenamesSubjectRange());
        }
    }

    private void toStringCondition(StringBuilder sb) {
        if (this.getConditionLiterals().size() > 0) {
            this.toStringList(sb, this.getConditionLiterals(), "conditionLiterals");
        }
        if (this.getConditionRanges().size() > 0) {
            this.toStringList(sb, this.getConditionRanges(), "conditionRanges");
        }
    }

    private void toStringList(StringBuilder sb, List<?> list, String title) {
        sb.append(',');
        sb.append(title + ":[");
        boolean first = true;
        for (Object child : list) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(child.toString());
        }
        sb.append("]");
    }

    public static class Range {
        private String _from;
        private String _to;

        public Range(String from, String to) {
            this._from = from;
            this._to = to;
        }

        public String getFrom() {
            return this._from;
        }

        public String getTo() {
            return this._to;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            sb.append("from:" + this.getFrom());
            sb.append(',');
            sb.append("to:" + this.getTo());
            sb.append('}');
            return sb.toString();
        }
    }

    public static enum DataEntryType {
        DATA_DESCRIPTION,
        RENAMES,
        CONDITION;

    }
}

