/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cobol.utils;

import com.legstar.cob2xsd.PictureSymbol;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class PictureUtil {
    private PictureUtil() {
    }

    public static Map<Character, Integer> getPictureCharOccurences(String picture, char currencySymbol) {
        HashMap<Character, Integer> charNum = new HashMap<Character, Integer>();
        charNum.put(Character.valueOf('A'), 0);
        charNum.put(Character.valueOf('B'), 0);
        charNum.put(Character.valueOf('G'), 0);
        charNum.put(Character.valueOf('N'), 0);
        charNum.put(Character.valueOf('X'), 0);
        charNum.put(Character.valueOf('P'), 0);
        charNum.put(Character.valueOf('Z'), 0);
        charNum.put(Character.valueOf('0'), 0);
        charNum.put(Character.valueOf('/'), 0);
        charNum.put(Character.valueOf('+'), 0);
        charNum.put(Character.valueOf('-'), 0);
        charNum.put(Character.valueOf('*'), 0);
        charNum.put(Character.valueOf('C'), 0);
        charNum.put(Character.valueOf('D'), 0);
        charNum.put(Character.valueOf('.'), 0);
        charNum.put(Character.valueOf(','), 0);
        charNum.put(Character.valueOf('9'), 0);
        charNum.put(Character.valueOf('E'), 0);
        charNum.put(Character.valueOf('S'), 0);
        charNum.put(Character.valueOf('V'), 0);
        charNum.put(Character.valueOf(currencySymbol), 0);
        List<PictureSymbol> pictureSymbols = PictureUtil.parsePicture(picture, currencySymbol);
        for (PictureSymbol pictureSymbol : pictureSymbols) {
            Integer number = (Integer)charNum.get(Character.valueOf(pictureSymbol.getSymbol()));
            if (number == null) continue;
            number = number + pictureSymbol.getNumber();
            charNum.put(Character.valueOf(pictureSymbol.getSymbol()), number);
        }
        return charNum;
    }

    public static int calcLengthFromPicture(Map<Character, Integer> charNum, boolean isSignSeparate, String currencySign, char currencySymbol, boolean calcStorageLength) {
        int length = 0;
        HashMap<Character, Integer> charLen = new HashMap<Character, Integer>();
        charLen.put(Character.valueOf('A'), 1);
        charLen.put(Character.valueOf('B'), 1);
        charLen.put(Character.valueOf('G'), calcStorageLength ? 2 : 1);
        charLen.put(Character.valueOf('N'), calcStorageLength ? 2 : 1);
        charLen.put(Character.valueOf('X'), 1);
        charLen.put(Character.valueOf('P'), 0);
        charLen.put(Character.valueOf('Z'), 1);
        charLen.put(Character.valueOf('0'), 1);
        charLen.put(Character.valueOf('/'), 1);
        charLen.put(Character.valueOf('+'), 1);
        charLen.put(Character.valueOf('-'), 1);
        charLen.put(Character.valueOf('*'), 1);
        charLen.put(Character.valueOf('C'), 2);
        charLen.put(Character.valueOf('D'), 2);
        charLen.put(Character.valueOf('.'), 1);
        charLen.put(Character.valueOf(','), 1);
        charLen.put(Character.valueOf('9'), 1);
        charLen.put(Character.valueOf('E'), 1);
        charLen.put(Character.valueOf('S'), isSignSeparate ? 1 : 0);
        charLen.put(Character.valueOf('V'), 0);
        charLen.put(Character.valueOf(currencySymbol), 1);
        for (Map.Entry<Character, Integer> entry : charNum.entrySet()) {
            length += entry.getValue() * (Integer)charLen.get(entry.getKey());
        }
        if (currencySign.length() > 1 && charNum.get(Character.valueOf(currencySymbol)) > 1) {
            length += currencySign.length() - 1;
        }
        return length;
    }

    public static String getRegexFromPicture(String picture, String currencySign, char currencySymbol) {
        String symbol;
        StringBuilder result = new StringBuilder();
        HashMap<Character, String> charRegex = new HashMap<Character, String>();
        charRegex.put(Character.valueOf('A'), "[\\p{L}\\s]");
        charRegex.put(Character.valueOf('B'), "\\s");
        charRegex.put(Character.valueOf('G'), ".");
        charRegex.put(Character.valueOf('N'), ".");
        charRegex.put(Character.valueOf('X'), ".");
        charRegex.put(Character.valueOf('P'), "[\\d\\.]");
        charRegex.put(Character.valueOf('Z'), "[1-9\\s]");
        charRegex.put(Character.valueOf('0'), "0");
        charRegex.put(Character.valueOf('/'), "/");
        charRegex.put(Character.valueOf('+'), "[\\+\\-\\d]");
        charRegex.put(Character.valueOf('-'), "[\\+\\-\\d]");
        charRegex.put(Character.valueOf('*'), "[1-9\\*]");
        charRegex.put(Character.valueOf('C'), "(CR|\\s\\s)");
        charRegex.put(Character.valueOf('D'), "(DB|\\s\\s)");
        charRegex.put(Character.valueOf('.'), "\\.");
        charRegex.put(Character.valueOf(','), ",");
        charRegex.put(Character.valueOf('9'), "\\d");
        charRegex.put(Character.valueOf('E'), "E");
        charRegex.put(Character.valueOf('S'), "[\\+\\-]");
        charRegex.put(Character.valueOf('V'), "");
        charRegex.put(Character.valueOf(currencySymbol), "(" + currencySign.replace(" ", "\\s") + "|\\d|\\s)");
        List<PictureSymbol> pictureSymbols = PictureUtil.parsePicture(picture, currencySymbol);
        if (pictureSymbols.size() == 1 && ((symbol = (String)charRegex.get(Character.valueOf(pictureSymbols.get(0).getSymbol()))) == null || symbol.equals("."))) {
            return null;
        }
        for (PictureSymbol pictureSymbol : pictureSymbols) {
            String regex = (String)charRegex.get(Character.valueOf(pictureSymbol.getSymbol()));
            if (charRegex == null) continue;
            result.append(regex);
            int occurs = pictureSymbol.getNumber();
            if (occurs > 1) {
                result.append("{0," + occurs + "}");
                continue;
            }
            result.append("?");
        }
        return result.toString();
    }

    public static List<PictureSymbol> parsePicture(String picture, char currencySymbol) {
        int factoredNumber = 0;
        boolean factorSequence = false;
        char lastChar = '\u0000';
        PictureSymbol pictureSymbol = null;
        LinkedList<PictureSymbol> result = new LinkedList<PictureSymbol>();
        for (int i = 0; i < picture.length(); ++i) {
            char c = picture.charAt(i);
            if (c != currencySymbol) {
                c = Character.toUpperCase(c);
            }
            if (factorSequence) {
                if (c == ')') {
                    pictureSymbol.setNumber(pictureSymbol.getNumber() + factoredNumber - 1);
                    factorSequence = false;
                    continue;
                }
                if (!Character.isDigit(c)) continue;
                factoredNumber = factoredNumber * 10 + Character.getNumericValue(c);
                continue;
            }
            if (c == '(') {
                factoredNumber = 0;
                factorSequence = true;
                continue;
            }
            if (c == 'B' && lastChar == 'D' || c == 'R' && lastChar == 67) continue;
            if (c == lastChar) {
                pictureSymbol.setNumber(pictureSymbol.getNumber() + 1);
                continue;
            }
            pictureSymbol = new PictureSymbol(c, 1);
            result.add(pictureSymbol);
            lastChar = c;
        }
        return result;
    }
}

