/*
 * Decompiled with CFR 0.152.
 */
package org.legstar.stringtemplate.v4.misc;

import org.legstar.antlr.runtime.RecognitionException;
import org.legstar.antlr.runtime.Token;
import org.legstar.stringtemplate.v4.misc.ErrorType;
import org.legstar.stringtemplate.v4.misc.STMessage;

public class STLexerMessage
extends STMessage {
    public String msg;
    public Token templateToken;
    public String srcName;

    public STLexerMessage(String srcName, String msg, Token templateToken, Throwable cause) {
        super(ErrorType.LEXER_ERROR, null, cause, null);
        this.msg = msg;
        this.templateToken = templateToken;
        this.srcName = srcName;
    }

    @Override
    public String toString() {
        RecognitionException re = (RecognitionException)this.cause;
        int line = re.line;
        int charPos = re.charPositionInLine;
        if (this.templateToken != null) {
            int templateDelimiterSize = 1;
            if (this.templateToken.getType() == 5) {
                templateDelimiterSize = 2;
            }
            line += this.templateToken.getLine() - 1;
            charPos += this.templateToken.getCharPositionInLine() + templateDelimiterSize;
        }
        String filepos = line + ":" + charPos;
        if (this.srcName != null) {
            return this.srcName + " " + filepos + ": " + String.format(this.error.message, this.msg);
        }
        return filepos + ": " + String.format(this.error.message, this.msg);
    }
}

