/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cob2xsd.antlr;

import java.util.ArrayList;
import java.util.List;
import org.legstar.antlr.runtime.BaseRecognizer;
import org.legstar.antlr.runtime.EarlyExitException;
import org.legstar.antlr.runtime.FailedPredicateException;
import org.legstar.antlr.runtime.MismatchedTokenException;
import org.legstar.antlr.runtime.NoViableAltException;
import org.legstar.antlr.runtime.RecognitionException;
import org.legstar.antlr.runtime.Token;
import org.legstar.antlr.runtime.UnwantedTokenException;
import org.legstar.slf4j.Logger;

public class RecognizerErrorHandler {
    private List<String> _errorMessages = new ArrayList<String>();

    public static String getErrorMessage(Logger log, BaseRecognizer recognizer, RecognitionException e, String superMessage, String[] tokenNames) {
        if (log.isDebugEnabled()) {
            List<String> stack = BaseRecognizer.getRuleInvocationStack(e, recognizer.getClass().getSuperclass().getName());
            String debugMsg = recognizer.getErrorHeader(e) + " " + e.getClass().getSimpleName() + ": " + superMessage + ":";
            if (e instanceof NoViableAltException) {
                NoViableAltException nvae = (NoViableAltException)e;
                debugMsg = debugMsg + " (decision=" + nvae.decisionNumber + " state=" + nvae.stateNumber + ") decision=<<" + nvae.grammarDecisionDescription + ">>";
            } else if (e instanceof UnwantedTokenException) {
                UnwantedTokenException ute = (UnwantedTokenException)e;
                debugMsg = debugMsg + " (unexpected token=" + RecognizerErrorHandler.toString(ute.getUnexpectedToken(), tokenNames) + ")";
            } else if (e instanceof EarlyExitException) {
                EarlyExitException eea = (EarlyExitException)e;
                debugMsg = debugMsg + " (decision=" + eea.decisionNumber + ")";
            }
            debugMsg = debugMsg + " ruleStack=" + stack.toString();
            log.debug(debugMsg);
        }
        return RecognizerErrorHandler.makeUserMsg(e, superMessage);
    }

    public static String makeUserMsg(RecognitionException e, String msg) {
        if (e instanceof NoViableAltException) {
            return msg.replace("no viable alternative at", "unrecognized");
        }
        if (e instanceof UnwantedTokenException) {
            return msg.replace("extraneous input", "unexpected token");
        }
        if (e instanceof MismatchedTokenException) {
            if (msg.contains("mismatched input '<EOF>'")) {
                return msg.replace("mismatched input '<EOF>' expecting", "reached end of file looking for");
            }
            return msg.replace("mismatched input", "unexpected token");
        }
        if (e instanceof EarlyExitException) {
            return msg.replace("required (...)+ loop did not match anything", "required tokens not found");
        }
        if (e instanceof FailedPredicateException) {
            if (msg.contains("picture_string failed predicate: {Unbalanced parentheses}")) {
                return "Unbalanced parentheses in picture string";
            }
            if (msg.contains("PICTURE_PART failed predicate: {Contains invalid picture symbols}")) {
                return "Picture string contains invalid symbols";
            }
            if (msg.contains("PICTURE_PART failed predicate: {Syntax error in last picture clause}")) {
                return "Syntax error in last picture clause";
            }
            if (msg.contains("DATA_NAME failed predicate: {Syntax error in last clause}")) {
                return "Syntax error in last COBOL clause";
            }
        }
        return msg;
    }

    public void addMessageToHistory(String msg) {
        this.getErrorMessages().add(msg);
    }

    public static String toString(Token token, String[] tokenNames) {
        return token.toString().replace("<" + token.getType() + ">", "<" + (token.getType() > -1 ? tokenNames[token.getType()] : "no type") + ">");
    }

    public List<String> getErrorMessages() {
        return this._errorMessages;
    }
}

