/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cobol.utils;

import java.util.Locale;

public final class ValueUtil {
    private ValueUtil() {
    }

    public static String resolveFigurative(String value, int length, boolean quoteIsQuote) {
        if (value == null || value.length() == 0) {
            return value;
        }
        String ucValue = value.toUpperCase(Locale.getDefault());
        if (ucValue.matches("^ZERO(S|ES)?$")) {
            return "0";
        }
        if (ucValue.matches("^SPACES?$")) {
            return " ";
        }
        if (ucValue.matches("^QUOTES?$")) {
            return quoteIsQuote ? "\"" : "'";
        }
        if (ucValue.matches("^APOST$")) {
            return "'";
        }
        if (ucValue.matches("^HIGH-VALUES?$")) {
            return ValueUtil.fill("0x", "FF", length);
        }
        if (ucValue.matches("^LOW-VALUES?$")) {
            return ValueUtil.fill("0x", "00", length);
        }
        if (ucValue.matches("^NULLS?$")) {
            return ValueUtil.fill("0x", "00", length);
        }
        if (ucValue.startsWith("ALL ")) {
            String literal = value.substring("ALL ".length());
            String resolvedLiteral = ValueUtil.resolveFigurative(literal, length, quoteIsQuote);
            if (resolvedLiteral.length() > 0 && resolvedLiteral.length() < length) {
                String filled = ValueUtil.fill(null, resolvedLiteral, length / resolvedLiteral.length());
                if (filled.length() < length) {
                    return filled + resolvedLiteral.substring(0, length - filled.length());
                }
                return filled;
            }
            return resolvedLiteral;
        }
        return ValueUtil.stripDelimiters(value);
    }

    public static String fill(String prefix, String charSequence, int times) {
        if (times < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        for (int i = 0; i < times; ++i) {
            sb.append(charSequence);
        }
        return sb.toString();
    }

    public static String stripDelimiters(String value) {
        if (value != null && value.length() > 1) {
            if (value.charAt(0) == value.charAt(value.length() - 1) && value.charAt(0) == '\'') {
                return value.substring(1, value.length() - 1);
            }
            if (value.charAt(0) == value.charAt(value.length() - 1) && value.charAt(0) == '\"') {
                return value.substring(1, value.length() - 1);
            }
        }
        return value;
    }
}

