// $ANTLR 3.5.3 com\\legstar\\cobol\\CobolStructureParser.g 2025-09-04 10:54:53

package com.legstar.cobol;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

import org.antlr.runtime.tree.*;


/*******************************************************************************
 * Copyright (c) 2009 LegSem.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     LegSem - initial API and implementation
 ******************************************************************************/
@SuppressWarnings("all")
public class CobolStructureParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ALL_CONSTANT", "ALPHANUM_LITERAL_FRAGMENT", 
		"ALPHANUM_LITERAL_STRING", "APOST", "ARE_KEYWORD", "ASCENDING_KEYWORD", 
		"BINARY_KEYWORD", "BLANK_KEYWORD", "BY_KEYWORD", "CHARACTER_KEYWORD", 
		"CONDITION_LEVEL", "CONTINUATION_CHAR", "CONTINUED_ALPHANUM_LITERAL_FRAGMENT", 
		"DATA_ITEM_LEVEL", "DATA_NAME", "DATE_FORMAT_KEYWORD", "DATE_KEYWORD", 
		"DATE_PATTERN", "DBCS_LITERAL_STRING", "DECIMAL_POINT", "DEPENDING_KEYWORD", 
		"DESCENDING_KEYWORD", "DISPLAY_1_KEYWORD", "DISPLAY_KEYWORD", "DOUBLE_FLOAT_KEYWORD", 
		"EXTERNAL_KEYWORD", "FLOAT_PART2", "FUNCTION_POINTER_KEYWORD", "GLOBAL_KEYWORD", 
		"GROUP_USAGE_KEYWORD", "HEX_LITERAL_STRING", "HIGH_VALUE_CONSTANT", "INDEXED_KEYWORD", 
		"INDEX_KEYWORD", "INT", "IS_KEYWORD", "JUSTIFIED_KEYWORD", "KEY_KEYWORD", 
		"LEFT_KEYWORD", "LETTER", "LOW_VALUE_CONSTANT", "NATIONAL_HEX_LITERAL_STRING", 
		"NATIONAL_KEYWORD", "NATIONAL_LITERAL_STRING", "NATIVE_BINARY_KEYWORD", 
		"NEWLINE", "NULL_CONSTANT", "OCCURS_KEYWORD", "ON_KEYWORD", "PACKED_DECIMAL_KEYWORD", 
		"PERIOD", "PICTURE_CHAR", "PICTURE_KEYWORD", "PICTURE_PART", "POINTER_KEYWORD", 
		"PROCEDURE_POINTER_KEYWORD", "QUOTE", "QUOTE_CONSTANT", "REDEFINES_KEYWORD", 
		"RENAMES_KEYWORD", "RENAMES_LEVEL", "RIGHT_KEYWORD", "SEPARATE_KEYWORD", 
		"SIGNED_INT", "SIGN_KEYWORD", "SIGN_LEADING_KEYWORD", "SIGN_TRAILING_KEYWORD", 
		"SINGLE_FLOAT_KEYWORD", "SPACE", "SPACE_CONSTANT", "SYNCHRONIZED_KEYWORD", 
		"THROUGH_KEYWORD", "TIMES_KEYWORD", "TO_KEYWORD", "USAGE_KEYWORD", "VALUE_KEYWORD", 
		"WHEN_KEYWORD", "WHITESPACE", "ZERO_CONSTANT", "ZERO_LITERAL_STRING", 
		"BINARY", "BLANKWHENZERO", "CONDITION", "DATA_ITEM", "DATEFORMAT", "DECIMAL_LITERAL", 
		"DEPENDINGON", "DISPLAY", "DISPLAY1", "DOUBLEFLOAT", "EXTERNAL", "FIXEDARRAY", 
		"FLOAT_LITERAL", "FUNCTIONPOINTER", "GLOBAL", "GROUPUSAGENATIONAL", "HBOUND", 
		"INDEX", "JUSTIFIEDRIGHT", "KEY", "LBOUND", "LEADING", "LEFT", "LEVEL", 
		"LITERAL", "NAME", "NATIONAL", "NATIVEBINARY", "PACKEDDECIMAL", "PICTURE", 
		"PICTURESTRING", "POINTER", "PROCEDUREPOINTER", "RANGE", "REDEFINES", 
		"RENAME", "RIGHT", "SEPARATE", "SIGN", "SINGLEFLOAT", "SYNCHRONIZED", 
		"TRAILING", "USAGE", "VALUE", "VARARRAY"
	};
	public static final int EOF=-1;
	public static final int ALL_CONSTANT=4;
	public static final int ALPHANUM_LITERAL_FRAGMENT=5;
	public static final int ALPHANUM_LITERAL_STRING=6;
	public static final int APOST=7;
	public static final int ARE_KEYWORD=8;
	public static final int ASCENDING_KEYWORD=9;
	public static final int BINARY_KEYWORD=10;
	public static final int BLANK_KEYWORD=11;
	public static final int BY_KEYWORD=12;
	public static final int CHARACTER_KEYWORD=13;
	public static final int CONDITION_LEVEL=14;
	public static final int CONTINUATION_CHAR=15;
	public static final int CONTINUED_ALPHANUM_LITERAL_FRAGMENT=16;
	public static final int DATA_ITEM_LEVEL=17;
	public static final int DATA_NAME=18;
	public static final int DATE_FORMAT_KEYWORD=19;
	public static final int DATE_KEYWORD=20;
	public static final int DATE_PATTERN=21;
	public static final int DBCS_LITERAL_STRING=22;
	public static final int DECIMAL_POINT=23;
	public static final int DEPENDING_KEYWORD=24;
	public static final int DESCENDING_KEYWORD=25;
	public static final int DISPLAY_1_KEYWORD=26;
	public static final int DISPLAY_KEYWORD=27;
	public static final int DOUBLE_FLOAT_KEYWORD=28;
	public static final int EXTERNAL_KEYWORD=29;
	public static final int FLOAT_PART2=30;
	public static final int FUNCTION_POINTER_KEYWORD=31;
	public static final int GLOBAL_KEYWORD=32;
	public static final int GROUP_USAGE_KEYWORD=33;
	public static final int HEX_LITERAL_STRING=34;
	public static final int HIGH_VALUE_CONSTANT=35;
	public static final int INDEXED_KEYWORD=36;
	public static final int INDEX_KEYWORD=37;
	public static final int INT=38;
	public static final int IS_KEYWORD=39;
	public static final int JUSTIFIED_KEYWORD=40;
	public static final int KEY_KEYWORD=41;
	public static final int LEFT_KEYWORD=42;
	public static final int LETTER=43;
	public static final int LOW_VALUE_CONSTANT=44;
	public static final int NATIONAL_HEX_LITERAL_STRING=45;
	public static final int NATIONAL_KEYWORD=46;
	public static final int NATIONAL_LITERAL_STRING=47;
	public static final int NATIVE_BINARY_KEYWORD=48;
	public static final int NEWLINE=49;
	public static final int NULL_CONSTANT=50;
	public static final int OCCURS_KEYWORD=51;
	public static final int ON_KEYWORD=52;
	public static final int PACKED_DECIMAL_KEYWORD=53;
	public static final int PERIOD=54;
	public static final int PICTURE_CHAR=55;
	public static final int PICTURE_KEYWORD=56;
	public static final int PICTURE_PART=57;
	public static final int POINTER_KEYWORD=58;
	public static final int PROCEDURE_POINTER_KEYWORD=59;
	public static final int QUOTE=60;
	public static final int QUOTE_CONSTANT=61;
	public static final int REDEFINES_KEYWORD=62;
	public static final int RENAMES_KEYWORD=63;
	public static final int RENAMES_LEVEL=64;
	public static final int RIGHT_KEYWORD=65;
	public static final int SEPARATE_KEYWORD=66;
	public static final int SIGNED_INT=67;
	public static final int SIGN_KEYWORD=68;
	public static final int SIGN_LEADING_KEYWORD=69;
	public static final int SIGN_TRAILING_KEYWORD=70;
	public static final int SINGLE_FLOAT_KEYWORD=71;
	public static final int SPACE=72;
	public static final int SPACE_CONSTANT=73;
	public static final int SYNCHRONIZED_KEYWORD=74;
	public static final int THROUGH_KEYWORD=75;
	public static final int TIMES_KEYWORD=76;
	public static final int TO_KEYWORD=77;
	public static final int USAGE_KEYWORD=78;
	public static final int VALUE_KEYWORD=79;
	public static final int WHEN_KEYWORD=80;
	public static final int WHITESPACE=81;
	public static final int ZERO_CONSTANT=82;
	public static final int ZERO_LITERAL_STRING=83;
	public static final int BINARY=84;
	public static final int BLANKWHENZERO=85;
	public static final int CONDITION=86;
	public static final int DATA_ITEM=87;
	public static final int DATEFORMAT=88;
	public static final int DECIMAL_LITERAL=89;
	public static final int DEPENDINGON=90;
	public static final int DISPLAY=91;
	public static final int DISPLAY1=92;
	public static final int DOUBLEFLOAT=93;
	public static final int EXTERNAL=94;
	public static final int FIXEDARRAY=95;
	public static final int FLOAT_LITERAL=96;
	public static final int FUNCTIONPOINTER=97;
	public static final int GLOBAL=98;
	public static final int GROUPUSAGENATIONAL=99;
	public static final int HBOUND=100;
	public static final int INDEX=101;
	public static final int JUSTIFIEDRIGHT=102;
	public static final int KEY=103;
	public static final int LBOUND=104;
	public static final int LEADING=105;
	public static final int LEFT=106;
	public static final int LEVEL=107;
	public static final int LITERAL=108;
	public static final int NAME=109;
	public static final int NATIONAL=110;
	public static final int NATIVEBINARY=111;
	public static final int PACKEDDECIMAL=112;
	public static final int PICTURE=113;
	public static final int PICTURESTRING=114;
	public static final int POINTER=115;
	public static final int PROCEDUREPOINTER=116;
	public static final int RANGE=117;
	public static final int REDEFINES=118;
	public static final int RENAME=119;
	public static final int RIGHT=120;
	public static final int SEPARATE=121;
	public static final int SIGN=122;
	public static final int SINGLEFLOAT=123;
	public static final int SYNCHRONIZED=124;
	public static final int TRAILING=125;
	public static final int USAGE=126;
	public static final int VALUE=127;
	public static final int VARARRAY=128;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public CobolStructureParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public CobolStructureParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	protected TreeAdaptor adaptor = new CommonTreeAdaptor();

	public void setTreeAdaptor(TreeAdaptor adaptor) {
		this.adaptor = adaptor;
	}
	public TreeAdaptor getTreeAdaptor() {
		return adaptor;
	}
	@Override public String[] getTokenNames() { return CobolStructureParser.tokenNames; }
	@Override public String getGrammarFileName() { return "com\\legstar\\cobol\\CobolStructureParser.g"; }


	    
	    /**
	     * Checks if a string contains numerics which fall in a given range.
	     * @param str the string holding a numeric value
	     * @param lower the lower bound
	     * @param higher the upper bound
	     * @return true if the string holds a numeric in the range
	     */
	    public boolean inRange(final String str, final int lower, final int higher) {
	        if (str != null && str.length() > 0) {
	            try {
	                int v = Integer.parseInt(str);
	                if (v >= lower && v <= higher) {
	                    return true;
	                }
	            } catch (NumberFormatException e) {
	                return false;
	            }
	        }
	        return false;
	    }

	    /** This AST, built by custom actions, is a hierarchy of DATA_ITEM based on their LEVEL. */
	    private Object hTree ;
	    
	    /** The last subtree built from a DATA_ITEM. */
	    private Object hLast;
	    
	    /**
	     * Get the LEVEL for a DATA_ITEM subtree.
	     * @param tree the DATA_ITEM subtree
	     * @return the DATA_ITEM level
	     */
	    public int getLevel(final Object tree) {
	        Tree level = ((CommonTree) tree).getFirstChildWithType(LEVEL);
	        if (level == null) {
	            return -1;
	        }
	        return Integer.parseInt(level.getChild(0).getText());
	    }
	    
	    /**
	     * Search the tree hierarchy for the first node with a lower level than the one received.
	     * Level 66 renames are a special case where we look for a level 01 to hook them to.
	     * Level 77 are identical to level 01, they are roots.
	     * @param tree the DATA_ITEM subtree to start from (moving up)
	     * @param level the level for which we are looking for a suitable parent
	     * @return the DATA_ITEM which can be used as a parent or the Nil node
	     */
	    public Object getParent(final Object tree, final int level) {
	        if (getTreeAdaptor().isNil(tree)) {
	            return tree;
	        } else {
	            int targetLevel = level;
	            if (level == 66) {
	                targetLevel = 02;
	            } else if (level == 77) {
	                targetLevel = 01;
	            }
	            if (getLevel(tree) < targetLevel) {
	                return tree;
	            } else {
	                return getParent(getTreeAdaptor().getParent(tree), level);
	            }
	        }
	    }

	    /**
	     * Detect unbalanced parentheses.
	     * @param string the string to look into (must not be null)
	     * @return true if there are unbalanced parentheses
	     */
	    public boolean unbalancedParentheses(final String string) {
	        int cnt = 0;
	        for (int i = 0; i < string.length(); i++) {
	            switch (string.charAt(i)) {
	                case '(': cnt++; break;
	                case ')': cnt--; break;
	            }
	        }
	        return (cnt == 0) ?  false : true;
	    }


	public static class cobdata_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "cobdata"
	// com\\legstar\\cobol\\CobolStructureParser.g:178:1: cobdata : ( data_items )* EOF ->;
	public final CobolStructureParser.cobdata_return cobdata() throws RecognitionException {
		CobolStructureParser.cobdata_return retval = new CobolStructureParser.cobdata_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token EOF2=null;
		ParserRuleReturnScope data_items1 =null;

		Object EOF2_tree=null;
		RewriteRuleTokenStream stream_EOF=new RewriteRuleTokenStream(adaptor,"token EOF");
		RewriteRuleSubtreeStream stream_data_items=new RewriteRuleSubtreeStream(adaptor,"rule data_items");


		    /* Initialize the hierarchical AST which will replace the standard one. */
		    hTree = getTreeAdaptor().nil();
		    hLast = hTree;


		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:185:6: ( ( data_items )* EOF ->)
			// com\\legstar\\cobol\\CobolStructureParser.g:185:9: ( data_items )* EOF
			{
			// com\\legstar\\cobol\\CobolStructureParser.g:185:9: ( data_items )*
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==CONDITION_LEVEL||LA1_0==DATA_ITEM_LEVEL||LA1_0==RENAMES_LEVEL) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:185:10: data_items
					{
					pushFollow(FOLLOW_data_items_in_cobdata401);
					data_items1=data_items();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_data_items.add(data_items1.getTree());
					}
					break;

				default :
					break loop1;
				}
			}

			EOF2=(Token)match(input,EOF,FOLLOW_EOF_in_cobdata405); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_EOF.add(EOF2);


			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 186:6: ->
			{
				adaptor.addChild(root_0, hTree);
			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "cobdata"


	public static class data_items_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "data_items"
	// com\\legstar\\cobol\\CobolStructureParser.g:194:1: data_items : data_entry ->;
	public final CobolStructureParser.data_items_return data_items() throws RecognitionException {
		CobolStructureParser.data_items_return retval = new CobolStructureParser.data_items_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope data_entry3 =null;

		RewriteRuleSubtreeStream stream_data_entry=new RewriteRuleSubtreeStream(adaptor,"rule data_entry");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:195:5: ( data_entry ->)
			// com\\legstar\\cobol\\CobolStructureParser.g:195:9: data_entry
			{
			pushFollow(FOLLOW_data_entry_in_data_items439);
			data_entry3=data_entry();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_data_entry.add(data_entry3.getTree());
			if ( state.backtracking==0 ) {
			            Object parent = getParent(hLast, getLevel((data_entry3!=null?((Object)data_entry3.getTree()):null)));
			            getTreeAdaptor().addChild(parent, (data_entry3!=null?((Object)data_entry3.getTree()):null));
			            hLast = (data_entry3!=null?((Object)data_entry3.getTree()):null);
			        }

			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 201:9: ->
			{
				root_0 = null;
			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "data_items"


	public static class data_entry_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "data_entry"
	// com\\legstar\\cobol\\CobolStructureParser.g:204:1: data_entry : ( data_description_entry | rename_description_entry | condition_description_entry );
	public final CobolStructureParser.data_entry_return data_entry() throws RecognitionException {
		CobolStructureParser.data_entry_return retval = new CobolStructureParser.data_entry_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope data_description_entry4 =null;
		ParserRuleReturnScope rename_description_entry5 =null;
		ParserRuleReturnScope condition_description_entry6 =null;


		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:205:5: ( data_description_entry | rename_description_entry | condition_description_entry )
			int alt2=3;
			switch ( input.LA(1) ) {
			case DATA_ITEM_LEVEL:
				{
				alt2=1;
				}
				break;
			case RENAMES_LEVEL:
				{
				alt2=2;
				}
				break;
			case CONDITION_LEVEL:
				{
				alt2=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:205:9: data_description_entry
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_data_description_entry_in_data_entry478);
					data_description_entry4=data_description_entry();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, data_description_entry4.getTree());

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:206:9: rename_description_entry
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_rename_description_entry_in_data_entry488);
					rename_description_entry5=rename_description_entry();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, rename_description_entry5.getTree());

					}
					break;
				case 3 :
					// com\\legstar\\cobol\\CobolStructureParser.g:207:9: condition_description_entry
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_condition_description_entry_in_data_entry498);
					condition_description_entry6=condition_description_entry();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, condition_description_entry6.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "data_entry"


	public static class data_description_entry_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "data_description_entry"
	// com\\legstar\\cobol\\CobolStructureParser.g:213:1: data_description_entry : data_item_level ( DATA_NAME )? ( clauses )* PERIOD -> ^( DATA_ITEM data_item_level ( ^( NAME DATA_NAME ) )? ( clauses )* ) ;
	public final CobolStructureParser.data_description_entry_return data_description_entry() throws RecognitionException {
		CobolStructureParser.data_description_entry_return retval = new CobolStructureParser.data_description_entry_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token DATA_NAME8=null;
		Token PERIOD10=null;
		ParserRuleReturnScope data_item_level7 =null;
		ParserRuleReturnScope clauses9 =null;

		Object DATA_NAME8_tree=null;
		Object PERIOD10_tree=null;
		RewriteRuleTokenStream stream_PERIOD=new RewriteRuleTokenStream(adaptor,"token PERIOD");
		RewriteRuleTokenStream stream_DATA_NAME=new RewriteRuleTokenStream(adaptor,"token DATA_NAME");
		RewriteRuleSubtreeStream stream_data_item_level=new RewriteRuleSubtreeStream(adaptor,"rule data_item_level");
		RewriteRuleSubtreeStream stream_clauses=new RewriteRuleSubtreeStream(adaptor,"rule clauses");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:214:5: ( data_item_level ( DATA_NAME )? ( clauses )* PERIOD -> ^( DATA_ITEM data_item_level ( ^( NAME DATA_NAME ) )? ( clauses )* ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:214:9: data_item_level ( DATA_NAME )? ( clauses )* PERIOD
			{
			pushFollow(FOLLOW_data_item_level_in_data_description_entry520);
			data_item_level7=data_item_level();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_data_item_level.add(data_item_level7.getTree());
			// com\\legstar\\cobol\\CobolStructureParser.g:214:25: ( DATA_NAME )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==DATA_NAME) ) {
				alt3=1;
			}
			switch (alt3) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:214:25: DATA_NAME
					{
					DATA_NAME8=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_data_description_entry522); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DATA_NAME.add(DATA_NAME8);

					}
					break;

			}

			// com\\legstar\\cobol\\CobolStructureParser.g:214:36: ( clauses )*
			loop4:
			while (true) {
				int alt4=2;
				int LA4_0 = input.LA(1);
				if ( ((LA4_0 >= BINARY_KEYWORD && LA4_0 <= BLANK_KEYWORD)||LA4_0==DATE_FORMAT_KEYWORD||(LA4_0 >= DISPLAY_1_KEYWORD && LA4_0 <= EXTERNAL_KEYWORD)||(LA4_0 >= FUNCTION_POINTER_KEYWORD && LA4_0 <= GROUP_USAGE_KEYWORD)||LA4_0==INDEX_KEYWORD||LA4_0==JUSTIFIED_KEYWORD||LA4_0==NATIONAL_KEYWORD||LA4_0==NATIVE_BINARY_KEYWORD||LA4_0==OCCURS_KEYWORD||LA4_0==PACKED_DECIMAL_KEYWORD||LA4_0==PICTURE_KEYWORD||(LA4_0 >= POINTER_KEYWORD && LA4_0 <= PROCEDURE_POINTER_KEYWORD)||LA4_0==REDEFINES_KEYWORD||(LA4_0 >= SIGN_LEADING_KEYWORD && LA4_0 <= SINGLE_FLOAT_KEYWORD)||LA4_0==SYNCHRONIZED_KEYWORD||(LA4_0 >= USAGE_KEYWORD && LA4_0 <= VALUE_KEYWORD)) ) {
					alt4=1;
				}

				switch (alt4) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:214:36: clauses
					{
					pushFollow(FOLLOW_clauses_in_data_description_entry525);
					clauses9=clauses();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_clauses.add(clauses9.getTree());
					}
					break;

				default :
					break loop4;
				}
			}

			PERIOD10=(Token)match(input,PERIOD,FOLLOW_PERIOD_in_data_description_entry528); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_PERIOD.add(PERIOD10);


			// AST REWRITE
			// elements: data_item_level, DATA_NAME, clauses
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 215:5: -> ^( DATA_ITEM data_item_level ( ^( NAME DATA_NAME ) )? ( clauses )* )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:215:7: ^( DATA_ITEM data_item_level ( ^( NAME DATA_NAME ) )? ( clauses )* )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(DATA_ITEM, "DATA_ITEM"), root_1);
				adaptor.addChild(root_1, stream_data_item_level.nextTree());
				// com\\legstar\\cobol\\CobolStructureParser.g:215:35: ( ^( NAME DATA_NAME ) )?
				if ( stream_DATA_NAME.hasNext() ) {
					// com\\legstar\\cobol\\CobolStructureParser.g:215:35: ^( NAME DATA_NAME )
					{
					Object root_2 = (Object)adaptor.nil();
					root_2 = (Object)adaptor.becomeRoot((Object)adaptor.create(NAME, "NAME"), root_2);
					adaptor.addChild(root_2, stream_DATA_NAME.nextNode());
					adaptor.addChild(root_1, root_2);
					}

				}
				stream_DATA_NAME.reset();

				// com\\legstar\\cobol\\CobolStructureParser.g:215:54: ( clauses )*
				while ( stream_clauses.hasNext() ) {
					adaptor.addChild(root_1, stream_clauses.nextTree());
				}
				stream_clauses.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "data_description_entry"


	public static class data_item_level_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "data_item_level"
	// com\\legstar\\cobol\\CobolStructureParser.g:218:1: data_item_level : DATA_ITEM_LEVEL -> ^( LEVEL DATA_ITEM_LEVEL ) ;
	public final CobolStructureParser.data_item_level_return data_item_level() throws RecognitionException {
		CobolStructureParser.data_item_level_return retval = new CobolStructureParser.data_item_level_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token DATA_ITEM_LEVEL11=null;

		Object DATA_ITEM_LEVEL11_tree=null;
		RewriteRuleTokenStream stream_DATA_ITEM_LEVEL=new RewriteRuleTokenStream(adaptor,"token DATA_ITEM_LEVEL");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:219:5: ( DATA_ITEM_LEVEL -> ^( LEVEL DATA_ITEM_LEVEL ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:219:8: DATA_ITEM_LEVEL
			{
			DATA_ITEM_LEVEL11=(Token)match(input,DATA_ITEM_LEVEL,FOLLOW_DATA_ITEM_LEVEL_in_data_item_level569); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_DATA_ITEM_LEVEL.add(DATA_ITEM_LEVEL11);


			// AST REWRITE
			// elements: DATA_ITEM_LEVEL
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 220:5: -> ^( LEVEL DATA_ITEM_LEVEL )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:220:7: ^( LEVEL DATA_ITEM_LEVEL )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(LEVEL, "LEVEL"), root_1);
				adaptor.addChild(root_1, stream_DATA_ITEM_LEVEL.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "data_item_level"


	public static class rename_description_entry_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "rename_description_entry"
	// com\\legstar\\cobol\\CobolStructureParser.g:226:1: rename_description_entry : ( rename_level v= DATA_NAME RENAMES_KEYWORD w= DATA_NAME THROUGH_KEYWORD x= DATA_NAME PERIOD -> ^( RENAME rename_level ^( NAME $v) ^( RANGE $w $x) ) | rename_level v= DATA_NAME RENAMES_KEYWORD w= DATA_NAME PERIOD -> ^( RENAME rename_level ^( NAME $v) ^( LITERAL $w) ) );
	public final CobolStructureParser.rename_description_entry_return rename_description_entry() throws RecognitionException {
		CobolStructureParser.rename_description_entry_return retval = new CobolStructureParser.rename_description_entry_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token v=null;
		Token w=null;
		Token x=null;
		Token RENAMES_KEYWORD13=null;
		Token THROUGH_KEYWORD14=null;
		Token PERIOD15=null;
		Token RENAMES_KEYWORD17=null;
		Token PERIOD18=null;
		ParserRuleReturnScope rename_level12 =null;
		ParserRuleReturnScope rename_level16 =null;

		Object v_tree=null;
		Object w_tree=null;
		Object x_tree=null;
		Object RENAMES_KEYWORD13_tree=null;
		Object THROUGH_KEYWORD14_tree=null;
		Object PERIOD15_tree=null;
		Object RENAMES_KEYWORD17_tree=null;
		Object PERIOD18_tree=null;
		RewriteRuleTokenStream stream_RENAMES_KEYWORD=new RewriteRuleTokenStream(adaptor,"token RENAMES_KEYWORD");
		RewriteRuleTokenStream stream_PERIOD=new RewriteRuleTokenStream(adaptor,"token PERIOD");
		RewriteRuleTokenStream stream_THROUGH_KEYWORD=new RewriteRuleTokenStream(adaptor,"token THROUGH_KEYWORD");
		RewriteRuleTokenStream stream_DATA_NAME=new RewriteRuleTokenStream(adaptor,"token DATA_NAME");
		RewriteRuleSubtreeStream stream_rename_level=new RewriteRuleSubtreeStream(adaptor,"rule rename_level");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:227:5: ( rename_level v= DATA_NAME RENAMES_KEYWORD w= DATA_NAME THROUGH_KEYWORD x= DATA_NAME PERIOD -> ^( RENAME rename_level ^( NAME $v) ^( RANGE $w $x) ) | rename_level v= DATA_NAME RENAMES_KEYWORD w= DATA_NAME PERIOD -> ^( RENAME rename_level ^( NAME $v) ^( LITERAL $w) ) )
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==RENAMES_LEVEL) ) {
				int LA5_1 = input.LA(2);
				if ( (LA5_1==DATA_NAME) ) {
					int LA5_2 = input.LA(3);
					if ( (LA5_2==RENAMES_KEYWORD) ) {
						int LA5_3 = input.LA(4);
						if ( (LA5_3==DATA_NAME) ) {
							int LA5_4 = input.LA(5);
							if ( (LA5_4==THROUGH_KEYWORD) ) {
								alt5=1;
							}
							else if ( (LA5_4==PERIOD) ) {
								alt5=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return retval;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 5, 4, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 5, 3, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 5, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 5, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}

			switch (alt5) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:227:9: rename_level v= DATA_NAME RENAMES_KEYWORD w= DATA_NAME THROUGH_KEYWORD x= DATA_NAME PERIOD
					{
					pushFollow(FOLLOW_rename_level_in_rename_description_entry601);
					rename_level12=rename_level();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_rename_level.add(rename_level12.getTree());
					v=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_rename_description_entry605); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DATA_NAME.add(v);

					RENAMES_KEYWORD13=(Token)match(input,RENAMES_KEYWORD,FOLLOW_RENAMES_KEYWORD_in_rename_description_entry607); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_RENAMES_KEYWORD.add(RENAMES_KEYWORD13);

					w=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_rename_description_entry611); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DATA_NAME.add(w);

					THROUGH_KEYWORD14=(Token)match(input,THROUGH_KEYWORD,FOLLOW_THROUGH_KEYWORD_in_rename_description_entry613); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_THROUGH_KEYWORD.add(THROUGH_KEYWORD14);

					x=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_rename_description_entry617); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DATA_NAME.add(x);

					PERIOD15=(Token)match(input,PERIOD,FOLLOW_PERIOD_in_rename_description_entry619); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_PERIOD.add(PERIOD15);


					// AST REWRITE
					// elements: rename_level, w, v, x
					// token labels: v, w, x
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleTokenStream stream_v=new RewriteRuleTokenStream(adaptor,"token v",v);
					RewriteRuleTokenStream stream_w=new RewriteRuleTokenStream(adaptor,"token w",w);
					RewriteRuleTokenStream stream_x=new RewriteRuleTokenStream(adaptor,"token x",x);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 228:5: -> ^( RENAME rename_level ^( NAME $v) ^( RANGE $w $x) )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:228:7: ^( RENAME rename_level ^( NAME $v) ^( RANGE $w $x) )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(RENAME, "RENAME"), root_1);
						adaptor.addChild(root_1, stream_rename_level.nextTree());
						// com\\legstar\\cobol\\CobolStructureParser.g:228:29: ^( NAME $v)
						{
						Object root_2 = (Object)adaptor.nil();
						root_2 = (Object)adaptor.becomeRoot((Object)adaptor.create(NAME, "NAME"), root_2);
						adaptor.addChild(root_2, stream_v.nextNode());
						adaptor.addChild(root_1, root_2);
						}

						// com\\legstar\\cobol\\CobolStructureParser.g:228:40: ^( RANGE $w $x)
						{
						Object root_2 = (Object)adaptor.nil();
						root_2 = (Object)adaptor.becomeRoot((Object)adaptor.create(RANGE, "RANGE"), root_2);
						adaptor.addChild(root_2, stream_w.nextNode());
						adaptor.addChild(root_2, stream_x.nextNode());
						adaptor.addChild(root_1, root_2);
						}

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:229:9: rename_level v= DATA_NAME RENAMES_KEYWORD w= DATA_NAME PERIOD
					{
					pushFollow(FOLLOW_rename_level_in_rename_description_entry657);
					rename_level16=rename_level();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_rename_level.add(rename_level16.getTree());
					v=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_rename_description_entry661); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DATA_NAME.add(v);

					RENAMES_KEYWORD17=(Token)match(input,RENAMES_KEYWORD,FOLLOW_RENAMES_KEYWORD_in_rename_description_entry663); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_RENAMES_KEYWORD.add(RENAMES_KEYWORD17);

					w=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_rename_description_entry667); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DATA_NAME.add(w);

					PERIOD18=(Token)match(input,PERIOD,FOLLOW_PERIOD_in_rename_description_entry669); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_PERIOD.add(PERIOD18);


					// AST REWRITE
					// elements: rename_level, v, w
					// token labels: v, w
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleTokenStream stream_v=new RewriteRuleTokenStream(adaptor,"token v",v);
					RewriteRuleTokenStream stream_w=new RewriteRuleTokenStream(adaptor,"token w",w);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 230:5: -> ^( RENAME rename_level ^( NAME $v) ^( LITERAL $w) )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:230:7: ^( RENAME rename_level ^( NAME $v) ^( LITERAL $w) )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(RENAME, "RENAME"), root_1);
						adaptor.addChild(root_1, stream_rename_level.nextTree());
						// com\\legstar\\cobol\\CobolStructureParser.g:230:29: ^( NAME $v)
						{
						Object root_2 = (Object)adaptor.nil();
						root_2 = (Object)adaptor.becomeRoot((Object)adaptor.create(NAME, "NAME"), root_2);
						adaptor.addChild(root_2, stream_v.nextNode());
						adaptor.addChild(root_1, root_2);
						}

						// com\\legstar\\cobol\\CobolStructureParser.g:230:40: ^( LITERAL $w)
						{
						Object root_2 = (Object)adaptor.nil();
						root_2 = (Object)adaptor.becomeRoot((Object)adaptor.create(LITERAL, "LITERAL"), root_2);
						adaptor.addChild(root_2, stream_w.nextNode());
						adaptor.addChild(root_1, root_2);
						}

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rename_description_entry"


	public static class rename_level_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "rename_level"
	// com\\legstar\\cobol\\CobolStructureParser.g:233:1: rename_level : RENAMES_LEVEL -> ^( LEVEL RENAMES_LEVEL ) ;
	public final CobolStructureParser.rename_level_return rename_level() throws RecognitionException {
		CobolStructureParser.rename_level_return retval = new CobolStructureParser.rename_level_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token RENAMES_LEVEL19=null;

		Object RENAMES_LEVEL19_tree=null;
		RewriteRuleTokenStream stream_RENAMES_LEVEL=new RewriteRuleTokenStream(adaptor,"token RENAMES_LEVEL");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:234:5: ( RENAMES_LEVEL -> ^( LEVEL RENAMES_LEVEL ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:234:9: RENAMES_LEVEL
			{
			RENAMES_LEVEL19=(Token)match(input,RENAMES_LEVEL,FOLLOW_RENAMES_LEVEL_in_rename_level714); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_RENAMES_LEVEL.add(RENAMES_LEVEL19);


			// AST REWRITE
			// elements: RENAMES_LEVEL
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 235:5: -> ^( LEVEL RENAMES_LEVEL )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:235:7: ^( LEVEL RENAMES_LEVEL )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(LEVEL, "LEVEL"), root_1);
				adaptor.addChild(root_1, stream_RENAMES_LEVEL.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rename_level"


	public static class condition_description_entry_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "condition_description_entry"
	// com\\legstar\\cobol\\CobolStructureParser.g:241:1: condition_description_entry : condition_level DATA_NAME condition_name_values PERIOD -> ^( CONDITION condition_level ^( NAME DATA_NAME ) condition_name_values ) ;
	public final CobolStructureParser.condition_description_entry_return condition_description_entry() throws RecognitionException {
		CobolStructureParser.condition_description_entry_return retval = new CobolStructureParser.condition_description_entry_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token DATA_NAME21=null;
		Token PERIOD23=null;
		ParserRuleReturnScope condition_level20 =null;
		ParserRuleReturnScope condition_name_values22 =null;

		Object DATA_NAME21_tree=null;
		Object PERIOD23_tree=null;
		RewriteRuleTokenStream stream_PERIOD=new RewriteRuleTokenStream(adaptor,"token PERIOD");
		RewriteRuleTokenStream stream_DATA_NAME=new RewriteRuleTokenStream(adaptor,"token DATA_NAME");
		RewriteRuleSubtreeStream stream_condition_name_values=new RewriteRuleSubtreeStream(adaptor,"rule condition_name_values");
		RewriteRuleSubtreeStream stream_condition_level=new RewriteRuleSubtreeStream(adaptor,"rule condition_level");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:242:5: ( condition_level DATA_NAME condition_name_values PERIOD -> ^( CONDITION condition_level ^( NAME DATA_NAME ) condition_name_values ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:242:9: condition_level DATA_NAME condition_name_values PERIOD
			{
			pushFollow(FOLLOW_condition_level_in_condition_description_entry746);
			condition_level20=condition_level();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_condition_level.add(condition_level20.getTree());
			DATA_NAME21=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_condition_description_entry748); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_DATA_NAME.add(DATA_NAME21);

			pushFollow(FOLLOW_condition_name_values_in_condition_description_entry750);
			condition_name_values22=condition_name_values();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_condition_name_values.add(condition_name_values22.getTree());
			PERIOD23=(Token)match(input,PERIOD,FOLLOW_PERIOD_in_condition_description_entry752); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_PERIOD.add(PERIOD23);


			// AST REWRITE
			// elements: condition_name_values, DATA_NAME, condition_level
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 243:5: -> ^( CONDITION condition_level ^( NAME DATA_NAME ) condition_name_values )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:243:7: ^( CONDITION condition_level ^( NAME DATA_NAME ) condition_name_values )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(CONDITION, "CONDITION"), root_1);
				adaptor.addChild(root_1, stream_condition_level.nextTree());
				// com\\legstar\\cobol\\CobolStructureParser.g:243:35: ^( NAME DATA_NAME )
				{
				Object root_2 = (Object)adaptor.nil();
				root_2 = (Object)adaptor.becomeRoot((Object)adaptor.create(NAME, "NAME"), root_2);
				adaptor.addChild(root_2, stream_DATA_NAME.nextNode());
				adaptor.addChild(root_1, root_2);
				}

				adaptor.addChild(root_1, stream_condition_name_values.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "condition_description_entry"


	public static class condition_level_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "condition_level"
	// com\\legstar\\cobol\\CobolStructureParser.g:246:1: condition_level : CONDITION_LEVEL -> ^( LEVEL CONDITION_LEVEL ) ;
	public final CobolStructureParser.condition_level_return condition_level() throws RecognitionException {
		CobolStructureParser.condition_level_return retval = new CobolStructureParser.condition_level_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token CONDITION_LEVEL24=null;

		Object CONDITION_LEVEL24_tree=null;
		RewriteRuleTokenStream stream_CONDITION_LEVEL=new RewriteRuleTokenStream(adaptor,"token CONDITION_LEVEL");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:247:5: ( CONDITION_LEVEL -> ^( LEVEL CONDITION_LEVEL ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:247:9: CONDITION_LEVEL
			{
			CONDITION_LEVEL24=(Token)match(input,CONDITION_LEVEL,FOLLOW_CONDITION_LEVEL_in_condition_level791); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_CONDITION_LEVEL.add(CONDITION_LEVEL24);


			// AST REWRITE
			// elements: CONDITION_LEVEL
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 248:5: -> ^( LEVEL CONDITION_LEVEL )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:248:7: ^( LEVEL CONDITION_LEVEL )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(LEVEL, "LEVEL"), root_1);
				adaptor.addChild(root_1, stream_CONDITION_LEVEL.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "condition_level"


	public static class condition_name_values_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "condition_name_values"
	// com\\legstar\\cobol\\CobolStructureParser.g:251:1: condition_name_values : VALUE_KEYWORD (v+= condition_name_value )+ -> ( $v)+ ;
	public final CobolStructureParser.condition_name_values_return condition_name_values() throws RecognitionException {
		CobolStructureParser.condition_name_values_return retval = new CobolStructureParser.condition_name_values_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token VALUE_KEYWORD25=null;
		List<Object> list_v=null;
		RuleReturnScope v = null;
		Object VALUE_KEYWORD25_tree=null;
		RewriteRuleTokenStream stream_VALUE_KEYWORD=new RewriteRuleTokenStream(adaptor,"token VALUE_KEYWORD");
		RewriteRuleSubtreeStream stream_condition_name_value=new RewriteRuleSubtreeStream(adaptor,"rule condition_name_value");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:252:5: ( VALUE_KEYWORD (v+= condition_name_value )+ -> ( $v)+ )
			// com\\legstar\\cobol\\CobolStructureParser.g:252:9: VALUE_KEYWORD (v+= condition_name_value )+
			{
			VALUE_KEYWORD25=(Token)match(input,VALUE_KEYWORD,FOLLOW_VALUE_KEYWORD_in_condition_name_values821); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_VALUE_KEYWORD.add(VALUE_KEYWORD25);

			// com\\legstar\\cobol\\CobolStructureParser.g:252:23: (v+= condition_name_value )+
			int cnt6=0;
			loop6:
			while (true) {
				int alt6=2;
				int LA6_0 = input.LA(1);
				if ( (LA6_0==ALL_CONSTANT||LA6_0==ALPHANUM_LITERAL_STRING||LA6_0==DBCS_LITERAL_STRING||(LA6_0 >= HEX_LITERAL_STRING && LA6_0 <= HIGH_VALUE_CONSTANT)||LA6_0==INT||(LA6_0 >= LOW_VALUE_CONSTANT && LA6_0 <= NATIONAL_HEX_LITERAL_STRING)||LA6_0==NATIONAL_LITERAL_STRING||LA6_0==NULL_CONSTANT||LA6_0==QUOTE_CONSTANT||LA6_0==SIGNED_INT||LA6_0==SPACE_CONSTANT||(LA6_0 >= ZERO_CONSTANT && LA6_0 <= ZERO_LITERAL_STRING)) ) {
					alt6=1;
				}

				switch (alt6) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:252:24: v+= condition_name_value
					{
					pushFollow(FOLLOW_condition_name_value_in_condition_name_values826);
					v=condition_name_value();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_condition_name_value.add(v.getTree());
					if (list_v==null) list_v=new ArrayList<Object>();
					list_v.add(v.getTree());
					}
					break;

				default :
					if ( cnt6 >= 1 ) break loop6;
					if (state.backtracking>0) {state.failed=true; return retval;}
					EarlyExitException eee = new EarlyExitException(6, input);
					throw eee;
				}
				cnt6++;
			}


			// AST REWRITE
			// elements: v
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: v
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"token v",list_v);
			root_0 = (Object)adaptor.nil();
			// 253:5: -> ( $v)+
			{
				if ( !(stream_v.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_v.hasNext() ) {
					adaptor.addChild(root_0, stream_v.nextTree());
				}
				stream_v.reset();

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "condition_name_values"


	public static class condition_name_value_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "condition_name_value"
	// com\\legstar\\cobol\\CobolStructureParser.g:256:1: condition_name_value : v= literal ( THROUGH_KEYWORD w= literal -> ^( RANGE $v $w) | -> ^( LITERAL $v) ) ;
	public final CobolStructureParser.condition_name_value_return condition_name_value() throws RecognitionException {
		CobolStructureParser.condition_name_value_return retval = new CobolStructureParser.condition_name_value_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token THROUGH_KEYWORD26=null;
		ParserRuleReturnScope v =null;
		ParserRuleReturnScope w =null;

		Object THROUGH_KEYWORD26_tree=null;
		RewriteRuleTokenStream stream_THROUGH_KEYWORD=new RewriteRuleTokenStream(adaptor,"token THROUGH_KEYWORD");
		RewriteRuleSubtreeStream stream_literal=new RewriteRuleSubtreeStream(adaptor,"rule literal");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:257:5: (v= literal ( THROUGH_KEYWORD w= literal -> ^( RANGE $v $w) | -> ^( LITERAL $v) ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:257:9: v= literal ( THROUGH_KEYWORD w= literal -> ^( RANGE $v $w) | -> ^( LITERAL $v) )
			{
			pushFollow(FOLLOW_literal_in_condition_name_value865);
			v=literal();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_literal.add(v.getTree());
			// com\\legstar\\cobol\\CobolStructureParser.g:258:8: ( THROUGH_KEYWORD w= literal -> ^( RANGE $v $w) | -> ^( LITERAL $v) )
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==THROUGH_KEYWORD) ) {
				alt7=1;
			}
			else if ( (LA7_0==ALL_CONSTANT||LA7_0==ALPHANUM_LITERAL_STRING||LA7_0==DBCS_LITERAL_STRING||(LA7_0 >= HEX_LITERAL_STRING && LA7_0 <= HIGH_VALUE_CONSTANT)||LA7_0==INT||(LA7_0 >= LOW_VALUE_CONSTANT && LA7_0 <= NATIONAL_HEX_LITERAL_STRING)||LA7_0==NATIONAL_LITERAL_STRING||LA7_0==NULL_CONSTANT||LA7_0==PERIOD||LA7_0==QUOTE_CONSTANT||LA7_0==SIGNED_INT||LA7_0==SPACE_CONSTANT||(LA7_0 >= ZERO_CONSTANT && LA7_0 <= ZERO_LITERAL_STRING)) ) {
				alt7=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 7, 0, input);
				throw nvae;
			}

			switch (alt7) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:259:12: THROUGH_KEYWORD w= literal
					{
					THROUGH_KEYWORD26=(Token)match(input,THROUGH_KEYWORD,FOLLOW_THROUGH_KEYWORD_in_condition_name_value887); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_THROUGH_KEYWORD.add(THROUGH_KEYWORD26);

					pushFollow(FOLLOW_literal_in_condition_name_value891);
					w=literal();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_literal.add(w.getTree());

					// AST REWRITE
					// elements: v, w
					// token labels: 
					// rule labels: v, w, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"rule v",v!=null?v.getTree():null);
					RewriteRuleSubtreeStream stream_w=new RewriteRuleSubtreeStream(adaptor,"rule w",w!=null?w.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 259:38: -> ^( RANGE $v $w)
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:259:40: ^( RANGE $v $w)
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(RANGE, "RANGE"), root_1);
						adaptor.addChild(root_1, stream_v.nextTree());
						adaptor.addChild(root_1, stream_w.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:260:38: 
					{

					// AST REWRITE
					// elements: v
					// token labels: 
					// rule labels: v, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"rule v",v!=null?v.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 260:38: -> ^( LITERAL $v)
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:260:40: ^( LITERAL $v)
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(LITERAL, "LITERAL"), root_1);
						adaptor.addChild(root_1, stream_v.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "condition_name_value"


	public static class clauses_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "clauses"
	// com\\legstar\\cobol\\CobolStructureParser.g:267:1: clauses : ( redefines_clause | blank_when_zero_clause | external_clause | global_clause | group_usage_clause | justified_clause | occurs_clause | picture_clause | sign_clause | synchronized_clause | usage_clause | value_clause | date_format_clause );
	public final CobolStructureParser.clauses_return clauses() throws RecognitionException {
		CobolStructureParser.clauses_return retval = new CobolStructureParser.clauses_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope redefines_clause27 =null;
		ParserRuleReturnScope blank_when_zero_clause28 =null;
		ParserRuleReturnScope external_clause29 =null;
		ParserRuleReturnScope global_clause30 =null;
		ParserRuleReturnScope group_usage_clause31 =null;
		ParserRuleReturnScope justified_clause32 =null;
		ParserRuleReturnScope occurs_clause33 =null;
		ParserRuleReturnScope picture_clause34 =null;
		ParserRuleReturnScope sign_clause35 =null;
		ParserRuleReturnScope synchronized_clause36 =null;
		ParserRuleReturnScope usage_clause37 =null;
		ParserRuleReturnScope value_clause38 =null;
		ParserRuleReturnScope date_format_clause39 =null;


		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:268:5: ( redefines_clause | blank_when_zero_clause | external_clause | global_clause | group_usage_clause | justified_clause | occurs_clause | picture_clause | sign_clause | synchronized_clause | usage_clause | value_clause | date_format_clause )
			int alt8=13;
			switch ( input.LA(1) ) {
			case REDEFINES_KEYWORD:
				{
				alt8=1;
				}
				break;
			case BLANK_KEYWORD:
				{
				alt8=2;
				}
				break;
			case EXTERNAL_KEYWORD:
				{
				alt8=3;
				}
				break;
			case GLOBAL_KEYWORD:
				{
				alt8=4;
				}
				break;
			case GROUP_USAGE_KEYWORD:
				{
				alt8=5;
				}
				break;
			case JUSTIFIED_KEYWORD:
				{
				alt8=6;
				}
				break;
			case OCCURS_KEYWORD:
				{
				alt8=7;
				}
				break;
			case PICTURE_KEYWORD:
				{
				alt8=8;
				}
				break;
			case SIGN_LEADING_KEYWORD:
			case SIGN_TRAILING_KEYWORD:
				{
				alt8=9;
				}
				break;
			case SYNCHRONIZED_KEYWORD:
				{
				alt8=10;
				}
				break;
			case BINARY_KEYWORD:
			case DISPLAY_1_KEYWORD:
			case DISPLAY_KEYWORD:
			case DOUBLE_FLOAT_KEYWORD:
			case FUNCTION_POINTER_KEYWORD:
			case INDEX_KEYWORD:
			case NATIONAL_KEYWORD:
			case NATIVE_BINARY_KEYWORD:
			case PACKED_DECIMAL_KEYWORD:
			case POINTER_KEYWORD:
			case PROCEDURE_POINTER_KEYWORD:
			case SINGLE_FLOAT_KEYWORD:
			case USAGE_KEYWORD:
				{
				alt8=11;
				}
				break;
			case VALUE_KEYWORD:
				{
				alt8=12;
				}
				break;
			case DATE_FORMAT_KEYWORD:
				{
				alt8=13;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 8, 0, input);
				throw nvae;
			}
			switch (alt8) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:268:9: redefines_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_redefines_clause_in_clauses979);
					redefines_clause27=redefines_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, redefines_clause27.getTree());

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:269:9: blank_when_zero_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_blank_when_zero_clause_in_clauses989);
					blank_when_zero_clause28=blank_when_zero_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, blank_when_zero_clause28.getTree());

					}
					break;
				case 3 :
					// com\\legstar\\cobol\\CobolStructureParser.g:270:9: external_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_external_clause_in_clauses999);
					external_clause29=external_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, external_clause29.getTree());

					}
					break;
				case 4 :
					// com\\legstar\\cobol\\CobolStructureParser.g:271:9: global_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_global_clause_in_clauses1009);
					global_clause30=global_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, global_clause30.getTree());

					}
					break;
				case 5 :
					// com\\legstar\\cobol\\CobolStructureParser.g:272:9: group_usage_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_group_usage_clause_in_clauses1019);
					group_usage_clause31=group_usage_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, group_usage_clause31.getTree());

					}
					break;
				case 6 :
					// com\\legstar\\cobol\\CobolStructureParser.g:273:9: justified_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_justified_clause_in_clauses1029);
					justified_clause32=justified_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, justified_clause32.getTree());

					}
					break;
				case 7 :
					// com\\legstar\\cobol\\CobolStructureParser.g:274:9: occurs_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_occurs_clause_in_clauses1039);
					occurs_clause33=occurs_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, occurs_clause33.getTree());

					}
					break;
				case 8 :
					// com\\legstar\\cobol\\CobolStructureParser.g:275:9: picture_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_picture_clause_in_clauses1049);
					picture_clause34=picture_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, picture_clause34.getTree());

					}
					break;
				case 9 :
					// com\\legstar\\cobol\\CobolStructureParser.g:276:9: sign_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_sign_clause_in_clauses1059);
					sign_clause35=sign_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, sign_clause35.getTree());

					}
					break;
				case 10 :
					// com\\legstar\\cobol\\CobolStructureParser.g:277:9: synchronized_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_synchronized_clause_in_clauses1069);
					synchronized_clause36=synchronized_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, synchronized_clause36.getTree());

					}
					break;
				case 11 :
					// com\\legstar\\cobol\\CobolStructureParser.g:278:9: usage_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_usage_clause_in_clauses1079);
					usage_clause37=usage_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, usage_clause37.getTree());

					}
					break;
				case 12 :
					// com\\legstar\\cobol\\CobolStructureParser.g:279:9: value_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_value_clause_in_clauses1089);
					value_clause38=value_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, value_clause38.getTree());

					}
					break;
				case 13 :
					// com\\legstar\\cobol\\CobolStructureParser.g:280:9: date_format_clause
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_date_format_clause_in_clauses1099);
					date_format_clause39=date_format_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, date_format_clause39.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "clauses"


	public static class redefines_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "redefines_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:283:1: redefines_clause : REDEFINES_KEYWORD DATA_NAME -> ^( REDEFINES DATA_NAME ) ;
	public final CobolStructureParser.redefines_clause_return redefines_clause() throws RecognitionException {
		CobolStructureParser.redefines_clause_return retval = new CobolStructureParser.redefines_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token REDEFINES_KEYWORD40=null;
		Token DATA_NAME41=null;

		Object REDEFINES_KEYWORD40_tree=null;
		Object DATA_NAME41_tree=null;
		RewriteRuleTokenStream stream_REDEFINES_KEYWORD=new RewriteRuleTokenStream(adaptor,"token REDEFINES_KEYWORD");
		RewriteRuleTokenStream stream_DATA_NAME=new RewriteRuleTokenStream(adaptor,"token DATA_NAME");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:284:5: ( REDEFINES_KEYWORD DATA_NAME -> ^( REDEFINES DATA_NAME ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:284:9: REDEFINES_KEYWORD DATA_NAME
			{
			REDEFINES_KEYWORD40=(Token)match(input,REDEFINES_KEYWORD,FOLLOW_REDEFINES_KEYWORD_in_redefines_clause1119); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_REDEFINES_KEYWORD.add(REDEFINES_KEYWORD40);

			DATA_NAME41=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_redefines_clause1121); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_DATA_NAME.add(DATA_NAME41);


			// AST REWRITE
			// elements: DATA_NAME
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 285:5: -> ^( REDEFINES DATA_NAME )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:285:7: ^( REDEFINES DATA_NAME )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(REDEFINES, "REDEFINES"), root_1);
				adaptor.addChild(root_1, stream_DATA_NAME.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "redefines_clause"


	public static class blank_when_zero_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "blank_when_zero_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:288:1: blank_when_zero_clause : BLANK_KEYWORD ZERO_CONSTANT -> ^( BLANKWHENZERO ) ;
	public final CobolStructureParser.blank_when_zero_clause_return blank_when_zero_clause() throws RecognitionException {
		CobolStructureParser.blank_when_zero_clause_return retval = new CobolStructureParser.blank_when_zero_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token BLANK_KEYWORD42=null;
		Token ZERO_CONSTANT43=null;

		Object BLANK_KEYWORD42_tree=null;
		Object ZERO_CONSTANT43_tree=null;
		RewriteRuleTokenStream stream_ZERO_CONSTANT=new RewriteRuleTokenStream(adaptor,"token ZERO_CONSTANT");
		RewriteRuleTokenStream stream_BLANK_KEYWORD=new RewriteRuleTokenStream(adaptor,"token BLANK_KEYWORD");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:289:5: ( BLANK_KEYWORD ZERO_CONSTANT -> ^( BLANKWHENZERO ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:289:9: BLANK_KEYWORD ZERO_CONSTANT
			{
			BLANK_KEYWORD42=(Token)match(input,BLANK_KEYWORD,FOLLOW_BLANK_KEYWORD_in_blank_when_zero_clause1151); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_BLANK_KEYWORD.add(BLANK_KEYWORD42);

			ZERO_CONSTANT43=(Token)match(input,ZERO_CONSTANT,FOLLOW_ZERO_CONSTANT_in_blank_when_zero_clause1153); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_ZERO_CONSTANT.add(ZERO_CONSTANT43);


			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 290:5: -> ^( BLANKWHENZERO )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:290:7: ^( BLANKWHENZERO )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(BLANKWHENZERO, "BLANKWHENZERO"), root_1);
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "blank_when_zero_clause"


	public static class external_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "external_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:293:1: external_clause : EXTERNAL_KEYWORD -> ^( EXTERNAL ) ;
	public final CobolStructureParser.external_clause_return external_clause() throws RecognitionException {
		CobolStructureParser.external_clause_return retval = new CobolStructureParser.external_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token EXTERNAL_KEYWORD44=null;

		Object EXTERNAL_KEYWORD44_tree=null;
		RewriteRuleTokenStream stream_EXTERNAL_KEYWORD=new RewriteRuleTokenStream(adaptor,"token EXTERNAL_KEYWORD");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:294:5: ( EXTERNAL_KEYWORD -> ^( EXTERNAL ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:294:9: EXTERNAL_KEYWORD
			{
			EXTERNAL_KEYWORD44=(Token)match(input,EXTERNAL_KEYWORD,FOLLOW_EXTERNAL_KEYWORD_in_external_clause1181); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_EXTERNAL_KEYWORD.add(EXTERNAL_KEYWORD44);


			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 295:5: -> ^( EXTERNAL )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:295:7: ^( EXTERNAL )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(EXTERNAL, "EXTERNAL"), root_1);
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "external_clause"


	public static class global_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "global_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:298:1: global_clause : GLOBAL_KEYWORD -> ^( GLOBAL ) ;
	public final CobolStructureParser.global_clause_return global_clause() throws RecognitionException {
		CobolStructureParser.global_clause_return retval = new CobolStructureParser.global_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token GLOBAL_KEYWORD45=null;

		Object GLOBAL_KEYWORD45_tree=null;
		RewriteRuleTokenStream stream_GLOBAL_KEYWORD=new RewriteRuleTokenStream(adaptor,"token GLOBAL_KEYWORD");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:299:5: ( GLOBAL_KEYWORD -> ^( GLOBAL ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:299:9: GLOBAL_KEYWORD
			{
			GLOBAL_KEYWORD45=(Token)match(input,GLOBAL_KEYWORD,FOLLOW_GLOBAL_KEYWORD_in_global_clause1209); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_GLOBAL_KEYWORD.add(GLOBAL_KEYWORD45);


			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 300:5: -> ^( GLOBAL )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:300:7: ^( GLOBAL )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(GLOBAL, "GLOBAL"), root_1);
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "global_clause"


	public static class group_usage_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "group_usage_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:303:1: group_usage_clause : GROUP_USAGE_KEYWORD NATIONAL_KEYWORD -> ^( GROUPUSAGENATIONAL ) ;
	public final CobolStructureParser.group_usage_clause_return group_usage_clause() throws RecognitionException {
		CobolStructureParser.group_usage_clause_return retval = new CobolStructureParser.group_usage_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token GROUP_USAGE_KEYWORD46=null;
		Token NATIONAL_KEYWORD47=null;

		Object GROUP_USAGE_KEYWORD46_tree=null;
		Object NATIONAL_KEYWORD47_tree=null;
		RewriteRuleTokenStream stream_GROUP_USAGE_KEYWORD=new RewriteRuleTokenStream(adaptor,"token GROUP_USAGE_KEYWORD");
		RewriteRuleTokenStream stream_NATIONAL_KEYWORD=new RewriteRuleTokenStream(adaptor,"token NATIONAL_KEYWORD");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:304:5: ( GROUP_USAGE_KEYWORD NATIONAL_KEYWORD -> ^( GROUPUSAGENATIONAL ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:304:9: GROUP_USAGE_KEYWORD NATIONAL_KEYWORD
			{
			GROUP_USAGE_KEYWORD46=(Token)match(input,GROUP_USAGE_KEYWORD,FOLLOW_GROUP_USAGE_KEYWORD_in_group_usage_clause1237); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_GROUP_USAGE_KEYWORD.add(GROUP_USAGE_KEYWORD46);

			NATIONAL_KEYWORD47=(Token)match(input,NATIONAL_KEYWORD,FOLLOW_NATIONAL_KEYWORD_in_group_usage_clause1239); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_NATIONAL_KEYWORD.add(NATIONAL_KEYWORD47);


			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 305:5: -> ^( GROUPUSAGENATIONAL )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:305:7: ^( GROUPUSAGENATIONAL )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(GROUPUSAGENATIONAL, "GROUPUSAGENATIONAL"), root_1);
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "group_usage_clause"


	public static class justified_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "justified_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:308:1: justified_clause : JUSTIFIED_KEYWORD ( RIGHT_KEYWORD )? -> ^( JUSTIFIEDRIGHT ) ;
	public final CobolStructureParser.justified_clause_return justified_clause() throws RecognitionException {
		CobolStructureParser.justified_clause_return retval = new CobolStructureParser.justified_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token JUSTIFIED_KEYWORD48=null;
		Token RIGHT_KEYWORD49=null;

		Object JUSTIFIED_KEYWORD48_tree=null;
		Object RIGHT_KEYWORD49_tree=null;
		RewriteRuleTokenStream stream_JUSTIFIED_KEYWORD=new RewriteRuleTokenStream(adaptor,"token JUSTIFIED_KEYWORD");
		RewriteRuleTokenStream stream_RIGHT_KEYWORD=new RewriteRuleTokenStream(adaptor,"token RIGHT_KEYWORD");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:309:5: ( JUSTIFIED_KEYWORD ( RIGHT_KEYWORD )? -> ^( JUSTIFIEDRIGHT ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:309:9: JUSTIFIED_KEYWORD ( RIGHT_KEYWORD )?
			{
			JUSTIFIED_KEYWORD48=(Token)match(input,JUSTIFIED_KEYWORD,FOLLOW_JUSTIFIED_KEYWORD_in_justified_clause1267); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_JUSTIFIED_KEYWORD.add(JUSTIFIED_KEYWORD48);

			// com\\legstar\\cobol\\CobolStructureParser.g:309:27: ( RIGHT_KEYWORD )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==RIGHT_KEYWORD) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:309:27: RIGHT_KEYWORD
					{
					RIGHT_KEYWORD49=(Token)match(input,RIGHT_KEYWORD,FOLLOW_RIGHT_KEYWORD_in_justified_clause1269); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_RIGHT_KEYWORD.add(RIGHT_KEYWORD49);

					}
					break;

			}


			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 310:5: -> ^( JUSTIFIEDRIGHT )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:310:7: ^( JUSTIFIEDRIGHT )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(JUSTIFIEDRIGHT, "JUSTIFIEDRIGHT"), root_1);
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "justified_clause"


	public static class occurs_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "occurs_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:313:1: occurs_clause : ( fixed_length_table | variable_length_table );
	public final CobolStructureParser.occurs_clause_return occurs_clause() throws RecognitionException {
		CobolStructureParser.occurs_clause_return retval = new CobolStructureParser.occurs_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope fixed_length_table50 =null;
		ParserRuleReturnScope variable_length_table51 =null;


		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:314:5: ( fixed_length_table | variable_length_table )
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==OCCURS_KEYWORD) ) {
				int LA10_1 = input.LA(2);
				if ( (LA10_1==INT) ) {
					int LA10_2 = input.LA(3);
					if ( (LA10_2==DEPENDING_KEYWORD||LA10_2==TO_KEYWORD) ) {
						alt10=2;
					}
					else if ( ((LA10_2 >= ASCENDING_KEYWORD && LA10_2 <= BLANK_KEYWORD)||LA10_2==DATE_FORMAT_KEYWORD||(LA10_2 >= DESCENDING_KEYWORD && LA10_2 <= EXTERNAL_KEYWORD)||(LA10_2 >= FUNCTION_POINTER_KEYWORD && LA10_2 <= GROUP_USAGE_KEYWORD)||(LA10_2 >= INDEXED_KEYWORD && LA10_2 <= INDEX_KEYWORD)||LA10_2==JUSTIFIED_KEYWORD||LA10_2==NATIONAL_KEYWORD||LA10_2==NATIVE_BINARY_KEYWORD||LA10_2==OCCURS_KEYWORD||(LA10_2 >= PACKED_DECIMAL_KEYWORD && LA10_2 <= PERIOD)||LA10_2==PICTURE_KEYWORD||(LA10_2 >= POINTER_KEYWORD && LA10_2 <= PROCEDURE_POINTER_KEYWORD)||LA10_2==REDEFINES_KEYWORD||(LA10_2 >= SIGN_LEADING_KEYWORD && LA10_2 <= SINGLE_FLOAT_KEYWORD)||LA10_2==SYNCHRONIZED_KEYWORD||(LA10_2 >= USAGE_KEYWORD && LA10_2 <= VALUE_KEYWORD)) ) {
						alt10=1;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 10, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 10, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 10, 0, input);
				throw nvae;
			}

			switch (alt10) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:314:9: fixed_length_table
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_fixed_length_table_in_occurs_clause1298);
					fixed_length_table50=fixed_length_table();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, fixed_length_table50.getTree());

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:315:9: variable_length_table
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_variable_length_table_in_occurs_clause1308);
					variable_length_table51=variable_length_table();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, variable_length_table51.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "occurs_clause"


	public static class picture_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "picture_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:318:1: picture_clause : PICTURE_KEYWORD picture_string -> ^( PICTURE picture_string ) ;
	public final CobolStructureParser.picture_clause_return picture_clause() throws RecognitionException {
		CobolStructureParser.picture_clause_return retval = new CobolStructureParser.picture_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token PICTURE_KEYWORD52=null;
		ParserRuleReturnScope picture_string53 =null;

		Object PICTURE_KEYWORD52_tree=null;
		RewriteRuleTokenStream stream_PICTURE_KEYWORD=new RewriteRuleTokenStream(adaptor,"token PICTURE_KEYWORD");
		RewriteRuleSubtreeStream stream_picture_string=new RewriteRuleSubtreeStream(adaptor,"rule picture_string");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:319:5: ( PICTURE_KEYWORD picture_string -> ^( PICTURE picture_string ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:319:9: PICTURE_KEYWORD picture_string
			{
			PICTURE_KEYWORD52=(Token)match(input,PICTURE_KEYWORD,FOLLOW_PICTURE_KEYWORD_in_picture_clause1327); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_PICTURE_KEYWORD.add(PICTURE_KEYWORD52);

			pushFollow(FOLLOW_picture_string_in_picture_clause1329);
			picture_string53=picture_string();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_picture_string.add(picture_string53.getTree());

			// AST REWRITE
			// elements: picture_string
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 320:5: -> ^( PICTURE picture_string )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:320:7: ^( PICTURE picture_string )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(PICTURE, "PICTURE"), root_1);
				adaptor.addChild(root_1, stream_picture_string.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "picture_clause"


	public static class sign_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "sign_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:323:1: sign_clause : ( sign_leading_clause | sign_trailing_clause ) -> ^( SIGN ( sign_leading_clause )? ( sign_trailing_clause )? ) ;
	public final CobolStructureParser.sign_clause_return sign_clause() throws RecognitionException {
		CobolStructureParser.sign_clause_return retval = new CobolStructureParser.sign_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope sign_leading_clause54 =null;
		ParserRuleReturnScope sign_trailing_clause55 =null;

		RewriteRuleSubtreeStream stream_sign_leading_clause=new RewriteRuleSubtreeStream(adaptor,"rule sign_leading_clause");
		RewriteRuleSubtreeStream stream_sign_trailing_clause=new RewriteRuleSubtreeStream(adaptor,"rule sign_trailing_clause");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:324:5: ( ( sign_leading_clause | sign_trailing_clause ) -> ^( SIGN ( sign_leading_clause )? ( sign_trailing_clause )? ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:324:9: ( sign_leading_clause | sign_trailing_clause )
			{
			// com\\legstar\\cobol\\CobolStructureParser.g:324:9: ( sign_leading_clause | sign_trailing_clause )
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==SIGN_LEADING_KEYWORD) ) {
				alt11=1;
			}
			else if ( (LA11_0==SIGN_TRAILING_KEYWORD) ) {
				alt11=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 11, 0, input);
				throw nvae;
			}

			switch (alt11) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:324:10: sign_leading_clause
					{
					pushFollow(FOLLOW_sign_leading_clause_in_sign_clause1360);
					sign_leading_clause54=sign_leading_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_sign_leading_clause.add(sign_leading_clause54.getTree());
					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:324:32: sign_trailing_clause
					{
					pushFollow(FOLLOW_sign_trailing_clause_in_sign_clause1364);
					sign_trailing_clause55=sign_trailing_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_sign_trailing_clause.add(sign_trailing_clause55.getTree());
					}
					break;

			}


			// AST REWRITE
			// elements: sign_leading_clause, sign_trailing_clause
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 325:5: -> ^( SIGN ( sign_leading_clause )? ( sign_trailing_clause )? )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:325:7: ^( SIGN ( sign_leading_clause )? ( sign_trailing_clause )? )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(SIGN, "SIGN"), root_1);
				// com\\legstar\\cobol\\CobolStructureParser.g:325:14: ( sign_leading_clause )?
				if ( stream_sign_leading_clause.hasNext() ) {
					adaptor.addChild(root_1, stream_sign_leading_clause.nextTree());
				}
				stream_sign_leading_clause.reset();

				// com\\legstar\\cobol\\CobolStructureParser.g:325:35: ( sign_trailing_clause )?
				if ( stream_sign_trailing_clause.hasNext() ) {
					adaptor.addChild(root_1, stream_sign_trailing_clause.nextTree());
				}
				stream_sign_trailing_clause.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sign_clause"


	public static class sign_leading_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "sign_leading_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:328:1: sign_leading_clause : SIGN_LEADING_KEYWORD ( separate_clause )? -> ^( LEADING ( separate_clause )? ) ;
	public final CobolStructureParser.sign_leading_clause_return sign_leading_clause() throws RecognitionException {
		CobolStructureParser.sign_leading_clause_return retval = new CobolStructureParser.sign_leading_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token SIGN_LEADING_KEYWORD56=null;
		ParserRuleReturnScope separate_clause57 =null;

		Object SIGN_LEADING_KEYWORD56_tree=null;
		RewriteRuleTokenStream stream_SIGN_LEADING_KEYWORD=new RewriteRuleTokenStream(adaptor,"token SIGN_LEADING_KEYWORD");
		RewriteRuleSubtreeStream stream_separate_clause=new RewriteRuleSubtreeStream(adaptor,"rule separate_clause");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:329:5: ( SIGN_LEADING_KEYWORD ( separate_clause )? -> ^( LEADING ( separate_clause )? ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:329:9: SIGN_LEADING_KEYWORD ( separate_clause )?
			{
			SIGN_LEADING_KEYWORD56=(Token)match(input,SIGN_LEADING_KEYWORD,FOLLOW_SIGN_LEADING_KEYWORD_in_sign_leading_clause1403); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_SIGN_LEADING_KEYWORD.add(SIGN_LEADING_KEYWORD56);

			// com\\legstar\\cobol\\CobolStructureParser.g:329:30: ( separate_clause )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==SEPARATE_KEYWORD) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:329:30: separate_clause
					{
					pushFollow(FOLLOW_separate_clause_in_sign_leading_clause1405);
					separate_clause57=separate_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_separate_clause.add(separate_clause57.getTree());
					}
					break;

			}


			// AST REWRITE
			// elements: separate_clause
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 330:5: -> ^( LEADING ( separate_clause )? )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:330:7: ^( LEADING ( separate_clause )? )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(LEADING, "LEADING"), root_1);
				// com\\legstar\\cobol\\CobolStructureParser.g:330:17: ( separate_clause )?
				if ( stream_separate_clause.hasNext() ) {
					adaptor.addChild(root_1, stream_separate_clause.nextTree());
				}
				stream_separate_clause.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sign_leading_clause"


	public static class sign_trailing_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "sign_trailing_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:333:1: sign_trailing_clause : SIGN_TRAILING_KEYWORD ( separate_clause )? -> ^( TRAILING ( separate_clause )? ) ;
	public final CobolStructureParser.sign_trailing_clause_return sign_trailing_clause() throws RecognitionException {
		CobolStructureParser.sign_trailing_clause_return retval = new CobolStructureParser.sign_trailing_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token SIGN_TRAILING_KEYWORD58=null;
		ParserRuleReturnScope separate_clause59 =null;

		Object SIGN_TRAILING_KEYWORD58_tree=null;
		RewriteRuleTokenStream stream_SIGN_TRAILING_KEYWORD=new RewriteRuleTokenStream(adaptor,"token SIGN_TRAILING_KEYWORD");
		RewriteRuleSubtreeStream stream_separate_clause=new RewriteRuleSubtreeStream(adaptor,"rule separate_clause");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:334:5: ( SIGN_TRAILING_KEYWORD ( separate_clause )? -> ^( TRAILING ( separate_clause )? ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:334:9: SIGN_TRAILING_KEYWORD ( separate_clause )?
			{
			SIGN_TRAILING_KEYWORD58=(Token)match(input,SIGN_TRAILING_KEYWORD,FOLLOW_SIGN_TRAILING_KEYWORD_in_sign_trailing_clause1441); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_SIGN_TRAILING_KEYWORD.add(SIGN_TRAILING_KEYWORD58);

			// com\\legstar\\cobol\\CobolStructureParser.g:334:31: ( separate_clause )?
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==SEPARATE_KEYWORD) ) {
				alt13=1;
			}
			switch (alt13) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:334:31: separate_clause
					{
					pushFollow(FOLLOW_separate_clause_in_sign_trailing_clause1443);
					separate_clause59=separate_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_separate_clause.add(separate_clause59.getTree());
					}
					break;

			}


			// AST REWRITE
			// elements: separate_clause
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 335:5: -> ^( TRAILING ( separate_clause )? )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:335:7: ^( TRAILING ( separate_clause )? )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(TRAILING, "TRAILING"), root_1);
				// com\\legstar\\cobol\\CobolStructureParser.g:335:18: ( separate_clause )?
				if ( stream_separate_clause.hasNext() ) {
					adaptor.addChild(root_1, stream_separate_clause.nextTree());
				}
				stream_separate_clause.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sign_trailing_clause"


	public static class separate_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "separate_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:338:1: separate_clause : SEPARATE_KEYWORD -> ^( SEPARATE ) ;
	public final CobolStructureParser.separate_clause_return separate_clause() throws RecognitionException {
		CobolStructureParser.separate_clause_return retval = new CobolStructureParser.separate_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token SEPARATE_KEYWORD60=null;

		Object SEPARATE_KEYWORD60_tree=null;
		RewriteRuleTokenStream stream_SEPARATE_KEYWORD=new RewriteRuleTokenStream(adaptor,"token SEPARATE_KEYWORD");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:339:5: ( SEPARATE_KEYWORD -> ^( SEPARATE ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:339:9: SEPARATE_KEYWORD
			{
			SEPARATE_KEYWORD60=(Token)match(input,SEPARATE_KEYWORD,FOLLOW_SEPARATE_KEYWORD_in_separate_clause1479); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_SEPARATE_KEYWORD.add(SEPARATE_KEYWORD60);


			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 340:5: -> ^( SEPARATE )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:340:7: ^( SEPARATE )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(SEPARATE, "SEPARATE"), root_1);
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "separate_clause"


	public static class synchronized_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "synchronized_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:343:1: synchronized_clause : SYNCHRONIZED_KEYWORD ( LEFT_KEYWORD -> ^( SYNCHRONIZED LEFT ) | RIGHT_KEYWORD -> ^( SYNCHRONIZED RIGHT ) | -> ^( SYNCHRONIZED ) ) ;
	public final CobolStructureParser.synchronized_clause_return synchronized_clause() throws RecognitionException {
		CobolStructureParser.synchronized_clause_return retval = new CobolStructureParser.synchronized_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token SYNCHRONIZED_KEYWORD61=null;
		Token LEFT_KEYWORD62=null;
		Token RIGHT_KEYWORD63=null;

		Object SYNCHRONIZED_KEYWORD61_tree=null;
		Object LEFT_KEYWORD62_tree=null;
		Object RIGHT_KEYWORD63_tree=null;
		RewriteRuleTokenStream stream_LEFT_KEYWORD=new RewriteRuleTokenStream(adaptor,"token LEFT_KEYWORD");
		RewriteRuleTokenStream stream_RIGHT_KEYWORD=new RewriteRuleTokenStream(adaptor,"token RIGHT_KEYWORD");
		RewriteRuleTokenStream stream_SYNCHRONIZED_KEYWORD=new RewriteRuleTokenStream(adaptor,"token SYNCHRONIZED_KEYWORD");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:344:5: ( SYNCHRONIZED_KEYWORD ( LEFT_KEYWORD -> ^( SYNCHRONIZED LEFT ) | RIGHT_KEYWORD -> ^( SYNCHRONIZED RIGHT ) | -> ^( SYNCHRONIZED ) ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:344:9: SYNCHRONIZED_KEYWORD ( LEFT_KEYWORD -> ^( SYNCHRONIZED LEFT ) | RIGHT_KEYWORD -> ^( SYNCHRONIZED RIGHT ) | -> ^( SYNCHRONIZED ) )
			{
			SYNCHRONIZED_KEYWORD61=(Token)match(input,SYNCHRONIZED_KEYWORD,FOLLOW_SYNCHRONIZED_KEYWORD_in_synchronized_clause1507); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_SYNCHRONIZED_KEYWORD.add(SYNCHRONIZED_KEYWORD61);

			// com\\legstar\\cobol\\CobolStructureParser.g:345:9: ( LEFT_KEYWORD -> ^( SYNCHRONIZED LEFT ) | RIGHT_KEYWORD -> ^( SYNCHRONIZED RIGHT ) | -> ^( SYNCHRONIZED ) )
			int alt14=3;
			switch ( input.LA(1) ) {
			case LEFT_KEYWORD:
				{
				alt14=1;
				}
				break;
			case RIGHT_KEYWORD:
				{
				alt14=2;
				}
				break;
			case BINARY_KEYWORD:
			case BLANK_KEYWORD:
			case DATE_FORMAT_KEYWORD:
			case DISPLAY_1_KEYWORD:
			case DISPLAY_KEYWORD:
			case DOUBLE_FLOAT_KEYWORD:
			case EXTERNAL_KEYWORD:
			case FUNCTION_POINTER_KEYWORD:
			case GLOBAL_KEYWORD:
			case GROUP_USAGE_KEYWORD:
			case INDEX_KEYWORD:
			case JUSTIFIED_KEYWORD:
			case NATIONAL_KEYWORD:
			case NATIVE_BINARY_KEYWORD:
			case OCCURS_KEYWORD:
			case PACKED_DECIMAL_KEYWORD:
			case PERIOD:
			case PICTURE_KEYWORD:
			case POINTER_KEYWORD:
			case PROCEDURE_POINTER_KEYWORD:
			case REDEFINES_KEYWORD:
			case SIGN_LEADING_KEYWORD:
			case SIGN_TRAILING_KEYWORD:
			case SINGLE_FLOAT_KEYWORD:
			case SYNCHRONIZED_KEYWORD:
			case USAGE_KEYWORD:
			case VALUE_KEYWORD:
				{
				alt14=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 14, 0, input);
				throw nvae;
			}
			switch (alt14) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:345:10: LEFT_KEYWORD
					{
					LEFT_KEYWORD62=(Token)match(input,LEFT_KEYWORD,FOLLOW_LEFT_KEYWORD_in_synchronized_clause1518); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_LEFT_KEYWORD.add(LEFT_KEYWORD62);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 345:23: -> ^( SYNCHRONIZED LEFT )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:345:25: ^( SYNCHRONIZED LEFT )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(SYNCHRONIZED, "SYNCHRONIZED"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(LEFT, "LEFT"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:346:12: RIGHT_KEYWORD
					{
					RIGHT_KEYWORD63=(Token)match(input,RIGHT_KEYWORD,FOLLOW_RIGHT_KEYWORD_in_synchronized_clause1538); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_RIGHT_KEYWORD.add(RIGHT_KEYWORD63);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 346:26: -> ^( SYNCHRONIZED RIGHT )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:346:28: ^( SYNCHRONIZED RIGHT )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(SYNCHRONIZED, "SYNCHRONIZED"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(RIGHT, "RIGHT"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 3 :
					// com\\legstar\\cobol\\CobolStructureParser.g:347:26: 
					{

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 347:26: -> ^( SYNCHRONIZED )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:347:28: ^( SYNCHRONIZED )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(SYNCHRONIZED, "SYNCHRONIZED"), root_1);
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "synchronized_clause"


	public static class usage_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "usage_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:351:1: usage_clause : ( USAGE_KEYWORD )? ( BINARY_KEYWORD -> ^( USAGE BINARY ) | SINGLE_FLOAT_KEYWORD -> ^( USAGE SINGLEFLOAT ) | DOUBLE_FLOAT_KEYWORD -> ^( USAGE DOUBLEFLOAT ) | PACKED_DECIMAL_KEYWORD -> ^( USAGE PACKEDDECIMAL ) | NATIVE_BINARY_KEYWORD -> ^( USAGE NATIVEBINARY ) | DISPLAY_KEYWORD -> ^( USAGE DISPLAY ) | DISPLAY_1_KEYWORD -> ^( USAGE DISPLAY1 ) | INDEX_KEYWORD -> ^( USAGE INDEX ) | NATIONAL_KEYWORD -> ^( USAGE NATIONAL ) | POINTER_KEYWORD -> ^( USAGE POINTER ) | PROCEDURE_POINTER_KEYWORD -> ^( USAGE PROCEDUREPOINTER ) | FUNCTION_POINTER_KEYWORD -> ^( USAGE FUNCTIONPOINTER ) ) ;
	public final CobolStructureParser.usage_clause_return usage_clause() throws RecognitionException {
		CobolStructureParser.usage_clause_return retval = new CobolStructureParser.usage_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token USAGE_KEYWORD64=null;
		Token BINARY_KEYWORD65=null;
		Token SINGLE_FLOAT_KEYWORD66=null;
		Token DOUBLE_FLOAT_KEYWORD67=null;
		Token PACKED_DECIMAL_KEYWORD68=null;
		Token NATIVE_BINARY_KEYWORD69=null;
		Token DISPLAY_KEYWORD70=null;
		Token DISPLAY_1_KEYWORD71=null;
		Token INDEX_KEYWORD72=null;
		Token NATIONAL_KEYWORD73=null;
		Token POINTER_KEYWORD74=null;
		Token PROCEDURE_POINTER_KEYWORD75=null;
		Token FUNCTION_POINTER_KEYWORD76=null;

		Object USAGE_KEYWORD64_tree=null;
		Object BINARY_KEYWORD65_tree=null;
		Object SINGLE_FLOAT_KEYWORD66_tree=null;
		Object DOUBLE_FLOAT_KEYWORD67_tree=null;
		Object PACKED_DECIMAL_KEYWORD68_tree=null;
		Object NATIVE_BINARY_KEYWORD69_tree=null;
		Object DISPLAY_KEYWORD70_tree=null;
		Object DISPLAY_1_KEYWORD71_tree=null;
		Object INDEX_KEYWORD72_tree=null;
		Object NATIONAL_KEYWORD73_tree=null;
		Object POINTER_KEYWORD74_tree=null;
		Object PROCEDURE_POINTER_KEYWORD75_tree=null;
		Object FUNCTION_POINTER_KEYWORD76_tree=null;
		RewriteRuleTokenStream stream_USAGE_KEYWORD=new RewriteRuleTokenStream(adaptor,"token USAGE_KEYWORD");
		RewriteRuleTokenStream stream_DOUBLE_FLOAT_KEYWORD=new RewriteRuleTokenStream(adaptor,"token DOUBLE_FLOAT_KEYWORD");
		RewriteRuleTokenStream stream_INDEX_KEYWORD=new RewriteRuleTokenStream(adaptor,"token INDEX_KEYWORD");
		RewriteRuleTokenStream stream_SINGLE_FLOAT_KEYWORD=new RewriteRuleTokenStream(adaptor,"token SINGLE_FLOAT_KEYWORD");
		RewriteRuleTokenStream stream_DISPLAY_KEYWORD=new RewriteRuleTokenStream(adaptor,"token DISPLAY_KEYWORD");
		RewriteRuleTokenStream stream_DISPLAY_1_KEYWORD=new RewriteRuleTokenStream(adaptor,"token DISPLAY_1_KEYWORD");
		RewriteRuleTokenStream stream_NATIVE_BINARY_KEYWORD=new RewriteRuleTokenStream(adaptor,"token NATIVE_BINARY_KEYWORD");
		RewriteRuleTokenStream stream_NATIONAL_KEYWORD=new RewriteRuleTokenStream(adaptor,"token NATIONAL_KEYWORD");
		RewriteRuleTokenStream stream_FUNCTION_POINTER_KEYWORD=new RewriteRuleTokenStream(adaptor,"token FUNCTION_POINTER_KEYWORD");
		RewriteRuleTokenStream stream_BINARY_KEYWORD=new RewriteRuleTokenStream(adaptor,"token BINARY_KEYWORD");
		RewriteRuleTokenStream stream_POINTER_KEYWORD=new RewriteRuleTokenStream(adaptor,"token POINTER_KEYWORD");
		RewriteRuleTokenStream stream_PROCEDURE_POINTER_KEYWORD=new RewriteRuleTokenStream(adaptor,"token PROCEDURE_POINTER_KEYWORD");
		RewriteRuleTokenStream stream_PACKED_DECIMAL_KEYWORD=new RewriteRuleTokenStream(adaptor,"token PACKED_DECIMAL_KEYWORD");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:352:5: ( ( USAGE_KEYWORD )? ( BINARY_KEYWORD -> ^( USAGE BINARY ) | SINGLE_FLOAT_KEYWORD -> ^( USAGE SINGLEFLOAT ) | DOUBLE_FLOAT_KEYWORD -> ^( USAGE DOUBLEFLOAT ) | PACKED_DECIMAL_KEYWORD -> ^( USAGE PACKEDDECIMAL ) | NATIVE_BINARY_KEYWORD -> ^( USAGE NATIVEBINARY ) | DISPLAY_KEYWORD -> ^( USAGE DISPLAY ) | DISPLAY_1_KEYWORD -> ^( USAGE DISPLAY1 ) | INDEX_KEYWORD -> ^( USAGE INDEX ) | NATIONAL_KEYWORD -> ^( USAGE NATIONAL ) | POINTER_KEYWORD -> ^( USAGE POINTER ) | PROCEDURE_POINTER_KEYWORD -> ^( USAGE PROCEDUREPOINTER ) | FUNCTION_POINTER_KEYWORD -> ^( USAGE FUNCTIONPOINTER ) ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:352:9: ( USAGE_KEYWORD )? ( BINARY_KEYWORD -> ^( USAGE BINARY ) | SINGLE_FLOAT_KEYWORD -> ^( USAGE SINGLEFLOAT ) | DOUBLE_FLOAT_KEYWORD -> ^( USAGE DOUBLEFLOAT ) | PACKED_DECIMAL_KEYWORD -> ^( USAGE PACKEDDECIMAL ) | NATIVE_BINARY_KEYWORD -> ^( USAGE NATIVEBINARY ) | DISPLAY_KEYWORD -> ^( USAGE DISPLAY ) | DISPLAY_1_KEYWORD -> ^( USAGE DISPLAY1 ) | INDEX_KEYWORD -> ^( USAGE INDEX ) | NATIONAL_KEYWORD -> ^( USAGE NATIONAL ) | POINTER_KEYWORD -> ^( USAGE POINTER ) | PROCEDURE_POINTER_KEYWORD -> ^( USAGE PROCEDUREPOINTER ) | FUNCTION_POINTER_KEYWORD -> ^( USAGE FUNCTIONPOINTER ) )
			{
			// com\\legstar\\cobol\\CobolStructureParser.g:352:9: ( USAGE_KEYWORD )?
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( (LA15_0==USAGE_KEYWORD) ) {
				alt15=1;
			}
			switch (alt15) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:352:10: USAGE_KEYWORD
					{
					USAGE_KEYWORD64=(Token)match(input,USAGE_KEYWORD,FOLLOW_USAGE_KEYWORD_in_usage_clause1605); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_USAGE_KEYWORD.add(USAGE_KEYWORD64);

					}
					break;

			}

			// com\\legstar\\cobol\\CobolStructureParser.g:353:9: ( BINARY_KEYWORD -> ^( USAGE BINARY ) | SINGLE_FLOAT_KEYWORD -> ^( USAGE SINGLEFLOAT ) | DOUBLE_FLOAT_KEYWORD -> ^( USAGE DOUBLEFLOAT ) | PACKED_DECIMAL_KEYWORD -> ^( USAGE PACKEDDECIMAL ) | NATIVE_BINARY_KEYWORD -> ^( USAGE NATIVEBINARY ) | DISPLAY_KEYWORD -> ^( USAGE DISPLAY ) | DISPLAY_1_KEYWORD -> ^( USAGE DISPLAY1 ) | INDEX_KEYWORD -> ^( USAGE INDEX ) | NATIONAL_KEYWORD -> ^( USAGE NATIONAL ) | POINTER_KEYWORD -> ^( USAGE POINTER ) | PROCEDURE_POINTER_KEYWORD -> ^( USAGE PROCEDUREPOINTER ) | FUNCTION_POINTER_KEYWORD -> ^( USAGE FUNCTIONPOINTER ) )
			int alt16=12;
			switch ( input.LA(1) ) {
			case BINARY_KEYWORD:
				{
				alt16=1;
				}
				break;
			case SINGLE_FLOAT_KEYWORD:
				{
				alt16=2;
				}
				break;
			case DOUBLE_FLOAT_KEYWORD:
				{
				alt16=3;
				}
				break;
			case PACKED_DECIMAL_KEYWORD:
				{
				alt16=4;
				}
				break;
			case NATIVE_BINARY_KEYWORD:
				{
				alt16=5;
				}
				break;
			case DISPLAY_KEYWORD:
				{
				alt16=6;
				}
				break;
			case DISPLAY_1_KEYWORD:
				{
				alt16=7;
				}
				break;
			case INDEX_KEYWORD:
				{
				alt16=8;
				}
				break;
			case NATIONAL_KEYWORD:
				{
				alt16=9;
				}
				break;
			case POINTER_KEYWORD:
				{
				alt16=10;
				}
				break;
			case PROCEDURE_POINTER_KEYWORD:
				{
				alt16=11;
				}
				break;
			case FUNCTION_POINTER_KEYWORD:
				{
				alt16=12;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 16, 0, input);
				throw nvae;
			}
			switch (alt16) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:354:11: BINARY_KEYWORD
					{
					BINARY_KEYWORD65=(Token)match(input,BINARY_KEYWORD,FOLLOW_BINARY_KEYWORD_in_usage_clause1629); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_BINARY_KEYWORD.add(BINARY_KEYWORD65);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 354:37: -> ^( USAGE BINARY )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:354:39: ^( USAGE BINARY )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(BINARY, "BINARY"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:355:11: SINGLE_FLOAT_KEYWORD
					{
					SINGLE_FLOAT_KEYWORD66=(Token)match(input,SINGLE_FLOAT_KEYWORD,FOLLOW_SINGLE_FLOAT_KEYWORD_in_usage_clause1659); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_SINGLE_FLOAT_KEYWORD.add(SINGLE_FLOAT_KEYWORD66);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 355:37: -> ^( USAGE SINGLEFLOAT )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:355:39: ^( USAGE SINGLEFLOAT )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(SINGLEFLOAT, "SINGLEFLOAT"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 3 :
					// com\\legstar\\cobol\\CobolStructureParser.g:356:11: DOUBLE_FLOAT_KEYWORD
					{
					DOUBLE_FLOAT_KEYWORD67=(Token)match(input,DOUBLE_FLOAT_KEYWORD,FOLLOW_DOUBLE_FLOAT_KEYWORD_in_usage_clause1683); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DOUBLE_FLOAT_KEYWORD.add(DOUBLE_FLOAT_KEYWORD67);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 356:37: -> ^( USAGE DOUBLEFLOAT )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:356:39: ^( USAGE DOUBLEFLOAT )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(DOUBLEFLOAT, "DOUBLEFLOAT"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 4 :
					// com\\legstar\\cobol\\CobolStructureParser.g:357:11: PACKED_DECIMAL_KEYWORD
					{
					PACKED_DECIMAL_KEYWORD68=(Token)match(input,PACKED_DECIMAL_KEYWORD,FOLLOW_PACKED_DECIMAL_KEYWORD_in_usage_clause1707); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_PACKED_DECIMAL_KEYWORD.add(PACKED_DECIMAL_KEYWORD68);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 357:37: -> ^( USAGE PACKEDDECIMAL )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:357:39: ^( USAGE PACKEDDECIMAL )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(PACKEDDECIMAL, "PACKEDDECIMAL"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 5 :
					// com\\legstar\\cobol\\CobolStructureParser.g:358:11: NATIVE_BINARY_KEYWORD
					{
					NATIVE_BINARY_KEYWORD69=(Token)match(input,NATIVE_BINARY_KEYWORD,FOLLOW_NATIVE_BINARY_KEYWORD_in_usage_clause1729); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_NATIVE_BINARY_KEYWORD.add(NATIVE_BINARY_KEYWORD69);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 358:37: -> ^( USAGE NATIVEBINARY )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:358:39: ^( USAGE NATIVEBINARY )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(NATIVEBINARY, "NATIVEBINARY"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 6 :
					// com\\legstar\\cobol\\CobolStructureParser.g:359:11: DISPLAY_KEYWORD
					{
					DISPLAY_KEYWORD70=(Token)match(input,DISPLAY_KEYWORD,FOLLOW_DISPLAY_KEYWORD_in_usage_clause1752); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DISPLAY_KEYWORD.add(DISPLAY_KEYWORD70);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 359:37: -> ^( USAGE DISPLAY )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:359:39: ^( USAGE DISPLAY )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(DISPLAY, "DISPLAY"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 7 :
					// com\\legstar\\cobol\\CobolStructureParser.g:360:11: DISPLAY_1_KEYWORD
					{
					DISPLAY_1_KEYWORD71=(Token)match(input,DISPLAY_1_KEYWORD,FOLLOW_DISPLAY_1_KEYWORD_in_usage_clause1781); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DISPLAY_1_KEYWORD.add(DISPLAY_1_KEYWORD71);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 360:37: -> ^( USAGE DISPLAY1 )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:360:39: ^( USAGE DISPLAY1 )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(DISPLAY1, "DISPLAY1"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 8 :
					// com\\legstar\\cobol\\CobolStructureParser.g:361:11: INDEX_KEYWORD
					{
					INDEX_KEYWORD72=(Token)match(input,INDEX_KEYWORD,FOLLOW_INDEX_KEYWORD_in_usage_clause1808); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_INDEX_KEYWORD.add(INDEX_KEYWORD72);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 361:37: -> ^( USAGE INDEX )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:361:39: ^( USAGE INDEX )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(INDEX, "INDEX"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 9 :
					// com\\legstar\\cobol\\CobolStructureParser.g:362:11: NATIONAL_KEYWORD
					{
					NATIONAL_KEYWORD73=(Token)match(input,NATIONAL_KEYWORD,FOLLOW_NATIONAL_KEYWORD_in_usage_clause1839); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_NATIONAL_KEYWORD.add(NATIONAL_KEYWORD73);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 362:37: -> ^( USAGE NATIONAL )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:362:39: ^( USAGE NATIONAL )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(NATIONAL, "NATIONAL"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 10 :
					// com\\legstar\\cobol\\CobolStructureParser.g:363:11: POINTER_KEYWORD
					{
					POINTER_KEYWORD74=(Token)match(input,POINTER_KEYWORD,FOLLOW_POINTER_KEYWORD_in_usage_clause1867); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_POINTER_KEYWORD.add(POINTER_KEYWORD74);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 363:37: -> ^( USAGE POINTER )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:363:39: ^( USAGE POINTER )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(POINTER, "POINTER"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 11 :
					// com\\legstar\\cobol\\CobolStructureParser.g:364:11: PROCEDURE_POINTER_KEYWORD
					{
					PROCEDURE_POINTER_KEYWORD75=(Token)match(input,PROCEDURE_POINTER_KEYWORD,FOLLOW_PROCEDURE_POINTER_KEYWORD_in_usage_clause1896); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_PROCEDURE_POINTER_KEYWORD.add(PROCEDURE_POINTER_KEYWORD75);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 364:37: -> ^( USAGE PROCEDUREPOINTER )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:364:39: ^( USAGE PROCEDUREPOINTER )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(PROCEDUREPOINTER, "PROCEDUREPOINTER"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 12 :
					// com\\legstar\\cobol\\CobolStructureParser.g:365:11: FUNCTION_POINTER_KEYWORD
					{
					FUNCTION_POINTER_KEYWORD76=(Token)match(input,FUNCTION_POINTER_KEYWORD,FOLLOW_FUNCTION_POINTER_KEYWORD_in_usage_clause1915); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_FUNCTION_POINTER_KEYWORD.add(FUNCTION_POINTER_KEYWORD76);


					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 365:37: -> ^( USAGE FUNCTIONPOINTER )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:365:39: ^( USAGE FUNCTIONPOINTER )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(USAGE, "USAGE"), root_1);
						adaptor.addChild(root_1, (Object)adaptor.create(FUNCTIONPOINTER, "FUNCTIONPOINTER"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "usage_clause"


	public static class value_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "value_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:369:1: value_clause : VALUE_KEYWORD literal -> ^( VALUE literal ) ;
	public final CobolStructureParser.value_clause_return value_clause() throws RecognitionException {
		CobolStructureParser.value_clause_return retval = new CobolStructureParser.value_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token VALUE_KEYWORD77=null;
		ParserRuleReturnScope literal78 =null;

		Object VALUE_KEYWORD77_tree=null;
		RewriteRuleTokenStream stream_VALUE_KEYWORD=new RewriteRuleTokenStream(adaptor,"token VALUE_KEYWORD");
		RewriteRuleSubtreeStream stream_literal=new RewriteRuleSubtreeStream(adaptor,"rule literal");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:370:5: ( VALUE_KEYWORD literal -> ^( VALUE literal ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:370:9: VALUE_KEYWORD literal
			{
			VALUE_KEYWORD77=(Token)match(input,VALUE_KEYWORD,FOLLOW_VALUE_KEYWORD_in_value_clause1952); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_VALUE_KEYWORD.add(VALUE_KEYWORD77);

			pushFollow(FOLLOW_literal_in_value_clause1954);
			literal78=literal();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_literal.add(literal78.getTree());

			// AST REWRITE
			// elements: literal
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 371:5: -> ^( VALUE literal )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:371:7: ^( VALUE literal )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(VALUE, "VALUE"), root_1);
				adaptor.addChild(root_1, stream_literal.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "value_clause"


	public static class literal_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "literal"
	// com\\legstar\\cobol\\CobolStructureParser.g:374:1: literal : ( ( float_literal )=> float_literal | ( decimal_literal )=> decimal_literal | INT | SIGNED_INT | ALPHANUM_LITERAL_STRING | HEX_LITERAL_STRING | ZERO_LITERAL_STRING | DBCS_LITERAL_STRING | NATIONAL_LITERAL_STRING | NATIONAL_HEX_LITERAL_STRING | ZERO_CONSTANT | SPACE_CONSTANT | HIGH_VALUE_CONSTANT | LOW_VALUE_CONSTANT | QUOTE_CONSTANT | ALL_CONSTANT ( ALPHANUM_LITERAL_STRING | ZERO_CONSTANT | SPACE_CONSTANT | HIGH_VALUE_CONSTANT | LOW_VALUE_CONSTANT | QUOTE_CONSTANT | NULL_CONSTANT ) | NULL_CONSTANT );
	public final CobolStructureParser.literal_return literal() throws RecognitionException {
		CobolStructureParser.literal_return retval = new CobolStructureParser.literal_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token INT81=null;
		Token SIGNED_INT82=null;
		Token ALPHANUM_LITERAL_STRING83=null;
		Token HEX_LITERAL_STRING84=null;
		Token ZERO_LITERAL_STRING85=null;
		Token DBCS_LITERAL_STRING86=null;
		Token NATIONAL_LITERAL_STRING87=null;
		Token NATIONAL_HEX_LITERAL_STRING88=null;
		Token ZERO_CONSTANT89=null;
		Token SPACE_CONSTANT90=null;
		Token HIGH_VALUE_CONSTANT91=null;
		Token LOW_VALUE_CONSTANT92=null;
		Token QUOTE_CONSTANT93=null;
		Token ALL_CONSTANT94=null;
		Token set95=null;
		Token NULL_CONSTANT96=null;
		ParserRuleReturnScope float_literal79 =null;
		ParserRuleReturnScope decimal_literal80 =null;

		Object INT81_tree=null;
		Object SIGNED_INT82_tree=null;
		Object ALPHANUM_LITERAL_STRING83_tree=null;
		Object HEX_LITERAL_STRING84_tree=null;
		Object ZERO_LITERAL_STRING85_tree=null;
		Object DBCS_LITERAL_STRING86_tree=null;
		Object NATIONAL_LITERAL_STRING87_tree=null;
		Object NATIONAL_HEX_LITERAL_STRING88_tree=null;
		Object ZERO_CONSTANT89_tree=null;
		Object SPACE_CONSTANT90_tree=null;
		Object HIGH_VALUE_CONSTANT91_tree=null;
		Object LOW_VALUE_CONSTANT92_tree=null;
		Object QUOTE_CONSTANT93_tree=null;
		Object ALL_CONSTANT94_tree=null;
		Object set95_tree=null;
		Object NULL_CONSTANT96_tree=null;

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:375:5: ( ( float_literal )=> float_literal | ( decimal_literal )=> decimal_literal | INT | SIGNED_INT | ALPHANUM_LITERAL_STRING | HEX_LITERAL_STRING | ZERO_LITERAL_STRING | DBCS_LITERAL_STRING | NATIONAL_LITERAL_STRING | NATIONAL_HEX_LITERAL_STRING | ZERO_CONSTANT | SPACE_CONSTANT | HIGH_VALUE_CONSTANT | LOW_VALUE_CONSTANT | QUOTE_CONSTANT | ALL_CONSTANT ( ALPHANUM_LITERAL_STRING | ZERO_CONSTANT | SPACE_CONSTANT | HIGH_VALUE_CONSTANT | LOW_VALUE_CONSTANT | QUOTE_CONSTANT | NULL_CONSTANT ) | NULL_CONSTANT )
			int alt17=17;
			switch ( input.LA(1) ) {
			case SIGNED_INT:
				{
				int LA17_1 = input.LA(2);
				if ( (LA17_1==DECIMAL_POINT) ) {
					int LA17_16 = input.LA(3);
					if ( (LA17_16==FLOAT_PART2) && (synpred1_CobolStructureParser())) {
						alt17=1;
					}
					else if ( (LA17_16==INT) && (synpred2_CobolStructureParser())) {
						alt17=2;
					}

				}
				else if ( (LA17_1==ALL_CONSTANT||LA17_1==ALPHANUM_LITERAL_STRING||(LA17_1 >= BINARY_KEYWORD && LA17_1 <= BLANK_KEYWORD)||LA17_1==DATE_FORMAT_KEYWORD||LA17_1==DBCS_LITERAL_STRING||(LA17_1 >= DISPLAY_1_KEYWORD && LA17_1 <= EXTERNAL_KEYWORD)||(LA17_1 >= FUNCTION_POINTER_KEYWORD && LA17_1 <= HIGH_VALUE_CONSTANT)||(LA17_1 >= INDEX_KEYWORD && LA17_1 <= INT)||LA17_1==JUSTIFIED_KEYWORD||(LA17_1 >= LOW_VALUE_CONSTANT && LA17_1 <= NATIVE_BINARY_KEYWORD)||(LA17_1 >= NULL_CONSTANT && LA17_1 <= OCCURS_KEYWORD)||(LA17_1 >= PACKED_DECIMAL_KEYWORD && LA17_1 <= PERIOD)||LA17_1==PICTURE_KEYWORD||(LA17_1 >= POINTER_KEYWORD && LA17_1 <= PROCEDURE_POINTER_KEYWORD)||(LA17_1 >= QUOTE_CONSTANT && LA17_1 <= REDEFINES_KEYWORD)||LA17_1==SIGNED_INT||(LA17_1 >= SIGN_LEADING_KEYWORD && LA17_1 <= SINGLE_FLOAT_KEYWORD)||(LA17_1 >= SPACE_CONSTANT && LA17_1 <= THROUGH_KEYWORD)||(LA17_1 >= USAGE_KEYWORD && LA17_1 <= VALUE_KEYWORD)||(LA17_1 >= ZERO_CONSTANT && LA17_1 <= ZERO_LITERAL_STRING)) ) {
					alt17=4;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 17, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case INT:
				{
				int LA17_2 = input.LA(2);
				if ( (LA17_2==DECIMAL_POINT) ) {
					int LA17_16 = input.LA(3);
					if ( (LA17_16==FLOAT_PART2) && (synpred1_CobolStructureParser())) {
						alt17=1;
					}
					else if ( (LA17_16==INT) && (synpred2_CobolStructureParser())) {
						alt17=2;
					}

				}
				else if ( (LA17_2==ALL_CONSTANT||LA17_2==ALPHANUM_LITERAL_STRING||(LA17_2 >= BINARY_KEYWORD && LA17_2 <= BLANK_KEYWORD)||LA17_2==DATE_FORMAT_KEYWORD||LA17_2==DBCS_LITERAL_STRING||(LA17_2 >= DISPLAY_1_KEYWORD && LA17_2 <= EXTERNAL_KEYWORD)||(LA17_2 >= FUNCTION_POINTER_KEYWORD && LA17_2 <= HIGH_VALUE_CONSTANT)||(LA17_2 >= INDEX_KEYWORD && LA17_2 <= INT)||LA17_2==JUSTIFIED_KEYWORD||(LA17_2 >= LOW_VALUE_CONSTANT && LA17_2 <= NATIVE_BINARY_KEYWORD)||(LA17_2 >= NULL_CONSTANT && LA17_2 <= OCCURS_KEYWORD)||(LA17_2 >= PACKED_DECIMAL_KEYWORD && LA17_2 <= PERIOD)||LA17_2==PICTURE_KEYWORD||(LA17_2 >= POINTER_KEYWORD && LA17_2 <= PROCEDURE_POINTER_KEYWORD)||(LA17_2 >= QUOTE_CONSTANT && LA17_2 <= REDEFINES_KEYWORD)||LA17_2==SIGNED_INT||(LA17_2 >= SIGN_LEADING_KEYWORD && LA17_2 <= SINGLE_FLOAT_KEYWORD)||(LA17_2 >= SPACE_CONSTANT && LA17_2 <= THROUGH_KEYWORD)||(LA17_2 >= USAGE_KEYWORD && LA17_2 <= VALUE_KEYWORD)||(LA17_2 >= ZERO_CONSTANT && LA17_2 <= ZERO_LITERAL_STRING)) ) {
					alt17=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 17, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case ALPHANUM_LITERAL_STRING:
				{
				alt17=5;
				}
				break;
			case HEX_LITERAL_STRING:
				{
				alt17=6;
				}
				break;
			case ZERO_LITERAL_STRING:
				{
				alt17=7;
				}
				break;
			case DBCS_LITERAL_STRING:
				{
				alt17=8;
				}
				break;
			case NATIONAL_LITERAL_STRING:
				{
				alt17=9;
				}
				break;
			case NATIONAL_HEX_LITERAL_STRING:
				{
				alt17=10;
				}
				break;
			case ZERO_CONSTANT:
				{
				alt17=11;
				}
				break;
			case SPACE_CONSTANT:
				{
				alt17=12;
				}
				break;
			case HIGH_VALUE_CONSTANT:
				{
				alt17=13;
				}
				break;
			case LOW_VALUE_CONSTANT:
				{
				alt17=14;
				}
				break;
			case QUOTE_CONSTANT:
				{
				alt17=15;
				}
				break;
			case ALL_CONSTANT:
				{
				alt17=16;
				}
				break;
			case NULL_CONSTANT:
				{
				alt17=17;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 17, 0, input);
				throw nvae;
			}
			switch (alt17) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:375:9: ( float_literal )=> float_literal
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_float_literal_in_literal1993);
					float_literal79=float_literal();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, float_literal79.getTree());

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:376:9: ( decimal_literal )=> decimal_literal
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_decimal_literal_in_literal2008);
					decimal_literal80=decimal_literal();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, decimal_literal80.getTree());

					}
					break;
				case 3 :
					// com\\legstar\\cobol\\CobolStructureParser.g:377:9: INT
					{
					root_0 = (Object)adaptor.nil();


					INT81=(Token)match(input,INT,FOLLOW_INT_in_literal2018); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					INT81_tree = (Object)adaptor.create(INT81);
					adaptor.addChild(root_0, INT81_tree);
					}

					}
					break;
				case 4 :
					// com\\legstar\\cobol\\CobolStructureParser.g:378:9: SIGNED_INT
					{
					root_0 = (Object)adaptor.nil();


					SIGNED_INT82=(Token)match(input,SIGNED_INT,FOLLOW_SIGNED_INT_in_literal2028); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					SIGNED_INT82_tree = (Object)adaptor.create(SIGNED_INT82);
					adaptor.addChild(root_0, SIGNED_INT82_tree);
					}

					}
					break;
				case 5 :
					// com\\legstar\\cobol\\CobolStructureParser.g:379:9: ALPHANUM_LITERAL_STRING
					{
					root_0 = (Object)adaptor.nil();


					ALPHANUM_LITERAL_STRING83=(Token)match(input,ALPHANUM_LITERAL_STRING,FOLLOW_ALPHANUM_LITERAL_STRING_in_literal2038); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					ALPHANUM_LITERAL_STRING83_tree = (Object)adaptor.create(ALPHANUM_LITERAL_STRING83);
					adaptor.addChild(root_0, ALPHANUM_LITERAL_STRING83_tree);
					}

					}
					break;
				case 6 :
					// com\\legstar\\cobol\\CobolStructureParser.g:380:9: HEX_LITERAL_STRING
					{
					root_0 = (Object)adaptor.nil();


					HEX_LITERAL_STRING84=(Token)match(input,HEX_LITERAL_STRING,FOLLOW_HEX_LITERAL_STRING_in_literal2048); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					HEX_LITERAL_STRING84_tree = (Object)adaptor.create(HEX_LITERAL_STRING84);
					adaptor.addChild(root_0, HEX_LITERAL_STRING84_tree);
					}

					}
					break;
				case 7 :
					// com\\legstar\\cobol\\CobolStructureParser.g:381:9: ZERO_LITERAL_STRING
					{
					root_0 = (Object)adaptor.nil();


					ZERO_LITERAL_STRING85=(Token)match(input,ZERO_LITERAL_STRING,FOLLOW_ZERO_LITERAL_STRING_in_literal2058); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					ZERO_LITERAL_STRING85_tree = (Object)adaptor.create(ZERO_LITERAL_STRING85);
					adaptor.addChild(root_0, ZERO_LITERAL_STRING85_tree);
					}

					}
					break;
				case 8 :
					// com\\legstar\\cobol\\CobolStructureParser.g:382:9: DBCS_LITERAL_STRING
					{
					root_0 = (Object)adaptor.nil();


					DBCS_LITERAL_STRING86=(Token)match(input,DBCS_LITERAL_STRING,FOLLOW_DBCS_LITERAL_STRING_in_literal2068); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					DBCS_LITERAL_STRING86_tree = (Object)adaptor.create(DBCS_LITERAL_STRING86);
					adaptor.addChild(root_0, DBCS_LITERAL_STRING86_tree);
					}

					}
					break;
				case 9 :
					// com\\legstar\\cobol\\CobolStructureParser.g:383:9: NATIONAL_LITERAL_STRING
					{
					root_0 = (Object)adaptor.nil();


					NATIONAL_LITERAL_STRING87=(Token)match(input,NATIONAL_LITERAL_STRING,FOLLOW_NATIONAL_LITERAL_STRING_in_literal2078); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NATIONAL_LITERAL_STRING87_tree = (Object)adaptor.create(NATIONAL_LITERAL_STRING87);
					adaptor.addChild(root_0, NATIONAL_LITERAL_STRING87_tree);
					}

					}
					break;
				case 10 :
					// com\\legstar\\cobol\\CobolStructureParser.g:384:9: NATIONAL_HEX_LITERAL_STRING
					{
					root_0 = (Object)adaptor.nil();


					NATIONAL_HEX_LITERAL_STRING88=(Token)match(input,NATIONAL_HEX_LITERAL_STRING,FOLLOW_NATIONAL_HEX_LITERAL_STRING_in_literal2088); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NATIONAL_HEX_LITERAL_STRING88_tree = (Object)adaptor.create(NATIONAL_HEX_LITERAL_STRING88);
					adaptor.addChild(root_0, NATIONAL_HEX_LITERAL_STRING88_tree);
					}

					}
					break;
				case 11 :
					// com\\legstar\\cobol\\CobolStructureParser.g:385:9: ZERO_CONSTANT
					{
					root_0 = (Object)adaptor.nil();


					ZERO_CONSTANT89=(Token)match(input,ZERO_CONSTANT,FOLLOW_ZERO_CONSTANT_in_literal2098); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					ZERO_CONSTANT89_tree = (Object)adaptor.create(ZERO_CONSTANT89);
					adaptor.addChild(root_0, ZERO_CONSTANT89_tree);
					}

					}
					break;
				case 12 :
					// com\\legstar\\cobol\\CobolStructureParser.g:386:9: SPACE_CONSTANT
					{
					root_0 = (Object)adaptor.nil();


					SPACE_CONSTANT90=(Token)match(input,SPACE_CONSTANT,FOLLOW_SPACE_CONSTANT_in_literal2108); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					SPACE_CONSTANT90_tree = (Object)adaptor.create(SPACE_CONSTANT90);
					adaptor.addChild(root_0, SPACE_CONSTANT90_tree);
					}

					}
					break;
				case 13 :
					// com\\legstar\\cobol\\CobolStructureParser.g:387:9: HIGH_VALUE_CONSTANT
					{
					root_0 = (Object)adaptor.nil();


					HIGH_VALUE_CONSTANT91=(Token)match(input,HIGH_VALUE_CONSTANT,FOLLOW_HIGH_VALUE_CONSTANT_in_literal2118); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					HIGH_VALUE_CONSTANT91_tree = (Object)adaptor.create(HIGH_VALUE_CONSTANT91);
					adaptor.addChild(root_0, HIGH_VALUE_CONSTANT91_tree);
					}

					}
					break;
				case 14 :
					// com\\legstar\\cobol\\CobolStructureParser.g:388:9: LOW_VALUE_CONSTANT
					{
					root_0 = (Object)adaptor.nil();


					LOW_VALUE_CONSTANT92=(Token)match(input,LOW_VALUE_CONSTANT,FOLLOW_LOW_VALUE_CONSTANT_in_literal2128); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LOW_VALUE_CONSTANT92_tree = (Object)adaptor.create(LOW_VALUE_CONSTANT92);
					adaptor.addChild(root_0, LOW_VALUE_CONSTANT92_tree);
					}

					}
					break;
				case 15 :
					// com\\legstar\\cobol\\CobolStructureParser.g:389:9: QUOTE_CONSTANT
					{
					root_0 = (Object)adaptor.nil();


					QUOTE_CONSTANT93=(Token)match(input,QUOTE_CONSTANT,FOLLOW_QUOTE_CONSTANT_in_literal2138); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					QUOTE_CONSTANT93_tree = (Object)adaptor.create(QUOTE_CONSTANT93);
					adaptor.addChild(root_0, QUOTE_CONSTANT93_tree);
					}

					}
					break;
				case 16 :
					// com\\legstar\\cobol\\CobolStructureParser.g:390:9: ALL_CONSTANT ( ALPHANUM_LITERAL_STRING | ZERO_CONSTANT | SPACE_CONSTANT | HIGH_VALUE_CONSTANT | LOW_VALUE_CONSTANT | QUOTE_CONSTANT | NULL_CONSTANT )
					{
					root_0 = (Object)adaptor.nil();


					ALL_CONSTANT94=(Token)match(input,ALL_CONSTANT,FOLLOW_ALL_CONSTANT_in_literal2148); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					ALL_CONSTANT94_tree = (Object)adaptor.create(ALL_CONSTANT94);
					adaptor.addChild(root_0, ALL_CONSTANT94_tree);
					}

					set95=input.LT(1);
					if ( input.LA(1)==ALPHANUM_LITERAL_STRING||input.LA(1)==HIGH_VALUE_CONSTANT||input.LA(1)==LOW_VALUE_CONSTANT||input.LA(1)==NULL_CONSTANT||input.LA(1)==QUOTE_CONSTANT||input.LA(1)==SPACE_CONSTANT||input.LA(1)==ZERO_CONSTANT ) {
						input.consume();
						if ( state.backtracking==0 ) adaptor.addChild(root_0, (Object)adaptor.create(set95));
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					}
					break;
				case 17 :
					// com\\legstar\\cobol\\CobolStructureParser.g:391:9: NULL_CONSTANT
					{
					root_0 = (Object)adaptor.nil();


					NULL_CONSTANT96=(Token)match(input,NULL_CONSTANT,FOLLOW_NULL_CONSTANT_in_literal2186); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NULL_CONSTANT96_tree = (Object)adaptor.create(NULL_CONSTANT96);
					adaptor.addChild(root_0, NULL_CONSTANT96_tree);
					}

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "literal"


	public static class date_format_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "date_format_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:394:1: date_format_clause : DATE_FORMAT_KEYWORD DATE_PATTERN -> ^( DATEFORMAT DATE_PATTERN ) ;
	public final CobolStructureParser.date_format_clause_return date_format_clause() throws RecognitionException {
		CobolStructureParser.date_format_clause_return retval = new CobolStructureParser.date_format_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token DATE_FORMAT_KEYWORD97=null;
		Token DATE_PATTERN98=null;

		Object DATE_FORMAT_KEYWORD97_tree=null;
		Object DATE_PATTERN98_tree=null;
		RewriteRuleTokenStream stream_DATE_FORMAT_KEYWORD=new RewriteRuleTokenStream(adaptor,"token DATE_FORMAT_KEYWORD");
		RewriteRuleTokenStream stream_DATE_PATTERN=new RewriteRuleTokenStream(adaptor,"token DATE_PATTERN");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:395:5: ( DATE_FORMAT_KEYWORD DATE_PATTERN -> ^( DATEFORMAT DATE_PATTERN ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:395:9: DATE_FORMAT_KEYWORD DATE_PATTERN
			{
			DATE_FORMAT_KEYWORD97=(Token)match(input,DATE_FORMAT_KEYWORD,FOLLOW_DATE_FORMAT_KEYWORD_in_date_format_clause2205); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_DATE_FORMAT_KEYWORD.add(DATE_FORMAT_KEYWORD97);

			DATE_PATTERN98=(Token)match(input,DATE_PATTERN,FOLLOW_DATE_PATTERN_in_date_format_clause2207); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_DATE_PATTERN.add(DATE_PATTERN98);


			// AST REWRITE
			// elements: DATE_PATTERN
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 396:5: -> ^( DATEFORMAT DATE_PATTERN )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:396:7: ^( DATEFORMAT DATE_PATTERN )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(DATEFORMAT, "DATEFORMAT"), root_1);
				adaptor.addChild(root_1, stream_DATE_PATTERN.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "date_format_clause"


	public static class fixed_length_table_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "fixed_length_table"
	// com\\legstar\\cobol\\CobolStructureParser.g:402:1: fixed_length_table : OCCURS_KEYWORD INT ( key_clause )* ( index_clause )* -> ^( FIXEDARRAY ^( HBOUND INT ) ( key_clause )* ( index_clause )* ) ;
	public final CobolStructureParser.fixed_length_table_return fixed_length_table() throws RecognitionException {
		CobolStructureParser.fixed_length_table_return retval = new CobolStructureParser.fixed_length_table_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token OCCURS_KEYWORD99=null;
		Token INT100=null;
		ParserRuleReturnScope key_clause101 =null;
		ParserRuleReturnScope index_clause102 =null;

		Object OCCURS_KEYWORD99_tree=null;
		Object INT100_tree=null;
		RewriteRuleTokenStream stream_OCCURS_KEYWORD=new RewriteRuleTokenStream(adaptor,"token OCCURS_KEYWORD");
		RewriteRuleTokenStream stream_INT=new RewriteRuleTokenStream(adaptor,"token INT");
		RewriteRuleSubtreeStream stream_key_clause=new RewriteRuleSubtreeStream(adaptor,"rule key_clause");
		RewriteRuleSubtreeStream stream_index_clause=new RewriteRuleSubtreeStream(adaptor,"rule index_clause");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:403:5: ( OCCURS_KEYWORD INT ( key_clause )* ( index_clause )* -> ^( FIXEDARRAY ^( HBOUND INT ) ( key_clause )* ( index_clause )* ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:403:9: OCCURS_KEYWORD INT ( key_clause )* ( index_clause )*
			{
			OCCURS_KEYWORD99=(Token)match(input,OCCURS_KEYWORD,FOLLOW_OCCURS_KEYWORD_in_fixed_length_table2241); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_OCCURS_KEYWORD.add(OCCURS_KEYWORD99);

			INT100=(Token)match(input,INT,FOLLOW_INT_in_fixed_length_table2243); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_INT.add(INT100);

			// com\\legstar\\cobol\\CobolStructureParser.g:403:28: ( key_clause )*
			loop18:
			while (true) {
				int alt18=2;
				int LA18_0 = input.LA(1);
				if ( (LA18_0==ASCENDING_KEYWORD||LA18_0==DESCENDING_KEYWORD) ) {
					alt18=1;
				}

				switch (alt18) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:403:29: key_clause
					{
					pushFollow(FOLLOW_key_clause_in_fixed_length_table2246);
					key_clause101=key_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_key_clause.add(key_clause101.getTree());
					}
					break;

				default :
					break loop18;
				}
			}

			// com\\legstar\\cobol\\CobolStructureParser.g:403:42: ( index_clause )*
			loop19:
			while (true) {
				int alt19=2;
				int LA19_0 = input.LA(1);
				if ( (LA19_0==INDEXED_KEYWORD) ) {
					alt19=1;
				}

				switch (alt19) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:403:43: index_clause
					{
					pushFollow(FOLLOW_index_clause_in_fixed_length_table2251);
					index_clause102=index_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_index_clause.add(index_clause102.getTree());
					}
					break;

				default :
					break loop19;
				}
			}


			// AST REWRITE
			// elements: index_clause, INT, key_clause
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 404:5: -> ^( FIXEDARRAY ^( HBOUND INT ) ( key_clause )* ( index_clause )* )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:404:7: ^( FIXEDARRAY ^( HBOUND INT ) ( key_clause )* ( index_clause )* )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(FIXEDARRAY, "FIXEDARRAY"), root_1);
				// com\\legstar\\cobol\\CobolStructureParser.g:404:20: ^( HBOUND INT )
				{
				Object root_2 = (Object)adaptor.nil();
				root_2 = (Object)adaptor.becomeRoot((Object)adaptor.create(HBOUND, "HBOUND"), root_2);
				adaptor.addChild(root_2, stream_INT.nextNode());
				adaptor.addChild(root_1, root_2);
				}

				// com\\legstar\\cobol\\CobolStructureParser.g:404:34: ( key_clause )*
				while ( stream_key_clause.hasNext() ) {
					adaptor.addChild(root_1, stream_key_clause.nextTree());
				}
				stream_key_clause.reset();

				// com\\legstar\\cobol\\CobolStructureParser.g:404:46: ( index_clause )*
				while ( stream_index_clause.hasNext() ) {
					adaptor.addChild(root_1, stream_index_clause.nextTree());
				}
				stream_index_clause.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "fixed_length_table"


	public static class variable_length_table_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "variable_length_table"
	// com\\legstar\\cobol\\CobolStructureParser.g:407:1: variable_length_table : ( ( OCCURS_KEYWORD low_bound )=> OCCURS_KEYWORD low_bound hb= INT DEPENDING_KEYWORD DATA_NAME ( key_clause )* ( index_clause )* -> ^( VARARRAY low_bound ^( HBOUND $hb ^( DEPENDINGON DATA_NAME ) ) ( key_clause )* ( index_clause )* ) | OCCURS_KEYWORD INT DEPENDING_KEYWORD DATA_NAME ( key_clause )* ( index_clause )* -> ^( VARARRAY ^( HBOUND INT ^( DEPENDINGON DATA_NAME ) ) ( key_clause )* ( index_clause )* ) );
	public final CobolStructureParser.variable_length_table_return variable_length_table() throws RecognitionException {
		CobolStructureParser.variable_length_table_return retval = new CobolStructureParser.variable_length_table_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token hb=null;
		Token OCCURS_KEYWORD103=null;
		Token DEPENDING_KEYWORD105=null;
		Token DATA_NAME106=null;
		Token OCCURS_KEYWORD109=null;
		Token INT110=null;
		Token DEPENDING_KEYWORD111=null;
		Token DATA_NAME112=null;
		ParserRuleReturnScope low_bound104 =null;
		ParserRuleReturnScope key_clause107 =null;
		ParserRuleReturnScope index_clause108 =null;
		ParserRuleReturnScope key_clause113 =null;
		ParserRuleReturnScope index_clause114 =null;

		Object hb_tree=null;
		Object OCCURS_KEYWORD103_tree=null;
		Object DEPENDING_KEYWORD105_tree=null;
		Object DATA_NAME106_tree=null;
		Object OCCURS_KEYWORD109_tree=null;
		Object INT110_tree=null;
		Object DEPENDING_KEYWORD111_tree=null;
		Object DATA_NAME112_tree=null;
		RewriteRuleTokenStream stream_OCCURS_KEYWORD=new RewriteRuleTokenStream(adaptor,"token OCCURS_KEYWORD");
		RewriteRuleTokenStream stream_DEPENDING_KEYWORD=new RewriteRuleTokenStream(adaptor,"token DEPENDING_KEYWORD");
		RewriteRuleTokenStream stream_INT=new RewriteRuleTokenStream(adaptor,"token INT");
		RewriteRuleTokenStream stream_DATA_NAME=new RewriteRuleTokenStream(adaptor,"token DATA_NAME");
		RewriteRuleSubtreeStream stream_key_clause=new RewriteRuleSubtreeStream(adaptor,"rule key_clause");
		RewriteRuleSubtreeStream stream_index_clause=new RewriteRuleSubtreeStream(adaptor,"rule index_clause");
		RewriteRuleSubtreeStream stream_low_bound=new RewriteRuleSubtreeStream(adaptor,"rule low_bound");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:408:5: ( ( OCCURS_KEYWORD low_bound )=> OCCURS_KEYWORD low_bound hb= INT DEPENDING_KEYWORD DATA_NAME ( key_clause )* ( index_clause )* -> ^( VARARRAY low_bound ^( HBOUND $hb ^( DEPENDINGON DATA_NAME ) ) ( key_clause )* ( index_clause )* ) | OCCURS_KEYWORD INT DEPENDING_KEYWORD DATA_NAME ( key_clause )* ( index_clause )* -> ^( VARARRAY ^( HBOUND INT ^( DEPENDINGON DATA_NAME ) ) ( key_clause )* ( index_clause )* ) )
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==OCCURS_KEYWORD) ) {
				int LA24_1 = input.LA(2);
				if ( (LA24_1==INT) ) {
					int LA24_2 = input.LA(3);
					if ( (LA24_2==DEPENDING_KEYWORD) ) {
						alt24=2;
					}
					else if ( (LA24_2==TO_KEYWORD) && (synpred3_CobolStructureParser())) {
						alt24=1;
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 24, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 24, 0, input);
				throw nvae;
			}

			switch (alt24) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:408:9: ( OCCURS_KEYWORD low_bound )=> OCCURS_KEYWORD low_bound hb= INT DEPENDING_KEYWORD DATA_NAME ( key_clause )* ( index_clause )*
					{
					OCCURS_KEYWORD103=(Token)match(input,OCCURS_KEYWORD,FOLLOW_OCCURS_KEYWORD_in_variable_length_table2314); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_OCCURS_KEYWORD.add(OCCURS_KEYWORD103);

					pushFollow(FOLLOW_low_bound_in_variable_length_table2316);
					low_bound104=low_bound();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_low_bound.add(low_bound104.getTree());
					hb=(Token)match(input,INT,FOLLOW_INT_in_variable_length_table2320); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_INT.add(hb);

					DEPENDING_KEYWORD105=(Token)match(input,DEPENDING_KEYWORD,FOLLOW_DEPENDING_KEYWORD_in_variable_length_table2322); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DEPENDING_KEYWORD.add(DEPENDING_KEYWORD105);

					DATA_NAME106=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_variable_length_table2324); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DATA_NAME.add(DATA_NAME106);

					// com\\legstar\\cobol\\CobolStructureParser.g:408:97: ( key_clause )*
					loop20:
					while (true) {
						int alt20=2;
						int LA20_0 = input.LA(1);
						if ( (LA20_0==ASCENDING_KEYWORD||LA20_0==DESCENDING_KEYWORD) ) {
							alt20=1;
						}

						switch (alt20) {
						case 1 :
							// com\\legstar\\cobol\\CobolStructureParser.g:408:98: key_clause
							{
							pushFollow(FOLLOW_key_clause_in_variable_length_table2327);
							key_clause107=key_clause();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_key_clause.add(key_clause107.getTree());
							}
							break;

						default :
							break loop20;
						}
					}

					// com\\legstar\\cobol\\CobolStructureParser.g:408:111: ( index_clause )*
					loop21:
					while (true) {
						int alt21=2;
						int LA21_0 = input.LA(1);
						if ( (LA21_0==INDEXED_KEYWORD) ) {
							alt21=1;
						}

						switch (alt21) {
						case 1 :
							// com\\legstar\\cobol\\CobolStructureParser.g:408:112: index_clause
							{
							pushFollow(FOLLOW_index_clause_in_variable_length_table2332);
							index_clause108=index_clause();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_index_clause.add(index_clause108.getTree());
							}
							break;

						default :
							break loop21;
						}
					}


					// AST REWRITE
					// elements: key_clause, index_clause, low_bound, DATA_NAME, hb
					// token labels: hb
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleTokenStream stream_hb=new RewriteRuleTokenStream(adaptor,"token hb",hb);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 409:5: -> ^( VARARRAY low_bound ^( HBOUND $hb ^( DEPENDINGON DATA_NAME ) ) ( key_clause )* ( index_clause )* )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:409:7: ^( VARARRAY low_bound ^( HBOUND $hb ^( DEPENDINGON DATA_NAME ) ) ( key_clause )* ( index_clause )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(VARARRAY, "VARARRAY"), root_1);
						adaptor.addChild(root_1, stream_low_bound.nextTree());
						// com\\legstar\\cobol\\CobolStructureParser.g:409:28: ^( HBOUND $hb ^( DEPENDINGON DATA_NAME ) )
						{
						Object root_2 = (Object)adaptor.nil();
						root_2 = (Object)adaptor.becomeRoot((Object)adaptor.create(HBOUND, "HBOUND"), root_2);
						adaptor.addChild(root_2, stream_hb.nextNode());
						// com\\legstar\\cobol\\CobolStructureParser.g:409:41: ^( DEPENDINGON DATA_NAME )
						{
						Object root_3 = (Object)adaptor.nil();
						root_3 = (Object)adaptor.becomeRoot((Object)adaptor.create(DEPENDINGON, "DEPENDINGON"), root_3);
						adaptor.addChild(root_3, stream_DATA_NAME.nextNode());
						adaptor.addChild(root_2, root_3);
						}

						adaptor.addChild(root_1, root_2);
						}

						// com\\legstar\\cobol\\CobolStructureParser.g:409:67: ( key_clause )*
						while ( stream_key_clause.hasNext() ) {
							adaptor.addChild(root_1, stream_key_clause.nextTree());
						}
						stream_key_clause.reset();

						// com\\legstar\\cobol\\CobolStructureParser.g:409:79: ( index_clause )*
						while ( stream_index_clause.hasNext() ) {
							adaptor.addChild(root_1, stream_index_clause.nextTree());
						}
						stream_index_clause.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:410:9: OCCURS_KEYWORD INT DEPENDING_KEYWORD DATA_NAME ( key_clause )* ( index_clause )*
					{
					OCCURS_KEYWORD109=(Token)match(input,OCCURS_KEYWORD,FOLLOW_OCCURS_KEYWORD_in_variable_length_table2374); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_OCCURS_KEYWORD.add(OCCURS_KEYWORD109);

					INT110=(Token)match(input,INT,FOLLOW_INT_in_variable_length_table2376); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_INT.add(INT110);

					DEPENDING_KEYWORD111=(Token)match(input,DEPENDING_KEYWORD,FOLLOW_DEPENDING_KEYWORD_in_variable_length_table2378); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DEPENDING_KEYWORD.add(DEPENDING_KEYWORD111);

					DATA_NAME112=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_variable_length_table2380); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DATA_NAME.add(DATA_NAME112);

					// com\\legstar\\cobol\\CobolStructureParser.g:410:56: ( key_clause )*
					loop22:
					while (true) {
						int alt22=2;
						int LA22_0 = input.LA(1);
						if ( (LA22_0==ASCENDING_KEYWORD||LA22_0==DESCENDING_KEYWORD) ) {
							alt22=1;
						}

						switch (alt22) {
						case 1 :
							// com\\legstar\\cobol\\CobolStructureParser.g:410:57: key_clause
							{
							pushFollow(FOLLOW_key_clause_in_variable_length_table2383);
							key_clause113=key_clause();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_key_clause.add(key_clause113.getTree());
							}
							break;

						default :
							break loop22;
						}
					}

					// com\\legstar\\cobol\\CobolStructureParser.g:410:70: ( index_clause )*
					loop23:
					while (true) {
						int alt23=2;
						int LA23_0 = input.LA(1);
						if ( (LA23_0==INDEXED_KEYWORD) ) {
							alt23=1;
						}

						switch (alt23) {
						case 1 :
							// com\\legstar\\cobol\\CobolStructureParser.g:410:71: index_clause
							{
							pushFollow(FOLLOW_index_clause_in_variable_length_table2388);
							index_clause114=index_clause();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_index_clause.add(index_clause114.getTree());
							}
							break;

						default :
							break loop23;
						}
					}


					// AST REWRITE
					// elements: index_clause, INT, DATA_NAME, key_clause
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 411:5: -> ^( VARARRAY ^( HBOUND INT ^( DEPENDINGON DATA_NAME ) ) ( key_clause )* ( index_clause )* )
					{
						// com\\legstar\\cobol\\CobolStructureParser.g:411:7: ^( VARARRAY ^( HBOUND INT ^( DEPENDINGON DATA_NAME ) ) ( key_clause )* ( index_clause )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(VARARRAY, "VARARRAY"), root_1);
						// com\\legstar\\cobol\\CobolStructureParser.g:411:18: ^( HBOUND INT ^( DEPENDINGON DATA_NAME ) )
						{
						Object root_2 = (Object)adaptor.nil();
						root_2 = (Object)adaptor.becomeRoot((Object)adaptor.create(HBOUND, "HBOUND"), root_2);
						adaptor.addChild(root_2, stream_INT.nextNode());
						// com\\legstar\\cobol\\CobolStructureParser.g:411:31: ^( DEPENDINGON DATA_NAME )
						{
						Object root_3 = (Object)adaptor.nil();
						root_3 = (Object)adaptor.becomeRoot((Object)adaptor.create(DEPENDINGON, "DEPENDINGON"), root_3);
						adaptor.addChild(root_3, stream_DATA_NAME.nextNode());
						adaptor.addChild(root_2, root_3);
						}

						adaptor.addChild(root_1, root_2);
						}

						// com\\legstar\\cobol\\CobolStructureParser.g:411:57: ( key_clause )*
						while ( stream_key_clause.hasNext() ) {
							adaptor.addChild(root_1, stream_key_clause.nextTree());
						}
						stream_key_clause.reset();

						// com\\legstar\\cobol\\CobolStructureParser.g:411:69: ( index_clause )*
						while ( stream_index_clause.hasNext() ) {
							adaptor.addChild(root_1, stream_index_clause.nextTree());
						}
						stream_index_clause.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;
					}

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "variable_length_table"


	public static class low_bound_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "low_bound"
	// com\\legstar\\cobol\\CobolStructureParser.g:414:1: low_bound : INT TO_KEYWORD -> ^( LBOUND INT ) ;
	public final CobolStructureParser.low_bound_return low_bound() throws RecognitionException {
		CobolStructureParser.low_bound_return retval = new CobolStructureParser.low_bound_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token INT115=null;
		Token TO_KEYWORD116=null;

		Object INT115_tree=null;
		Object TO_KEYWORD116_tree=null;
		RewriteRuleTokenStream stream_TO_KEYWORD=new RewriteRuleTokenStream(adaptor,"token TO_KEYWORD");
		RewriteRuleTokenStream stream_INT=new RewriteRuleTokenStream(adaptor,"token INT");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:415:5: ( INT TO_KEYWORD -> ^( LBOUND INT ) )
			// com\\legstar\\cobol\\CobolStructureParser.g:415:9: INT TO_KEYWORD
			{
			INT115=(Token)match(input,INT,FOLLOW_INT_in_low_bound2440); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_INT.add(INT115);

			TO_KEYWORD116=(Token)match(input,TO_KEYWORD,FOLLOW_TO_KEYWORD_in_low_bound2442); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_TO_KEYWORD.add(TO_KEYWORD116);


			// AST REWRITE
			// elements: INT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 416:5: -> ^( LBOUND INT )
			{
				// com\\legstar\\cobol\\CobolStructureParser.g:416:7: ^( LBOUND INT )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(LBOUND, "LBOUND"), root_1);
				adaptor.addChild(root_1, stream_INT.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "low_bound"


	public static class key_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "key_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:419:1: key_clause : (v= ASCENDING_KEYWORD |v= DESCENDING_KEYWORD ) ( KEY_KEYWORD )? ( DATA_NAME )+ -> ( ^( KEY $v DATA_NAME ) )+ ;
	public final CobolStructureParser.key_clause_return key_clause() throws RecognitionException {
		CobolStructureParser.key_clause_return retval = new CobolStructureParser.key_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token v=null;
		Token KEY_KEYWORD117=null;
		Token DATA_NAME118=null;

		Object v_tree=null;
		Object KEY_KEYWORD117_tree=null;
		Object DATA_NAME118_tree=null;
		RewriteRuleTokenStream stream_DESCENDING_KEYWORD=new RewriteRuleTokenStream(adaptor,"token DESCENDING_KEYWORD");
		RewriteRuleTokenStream stream_ASCENDING_KEYWORD=new RewriteRuleTokenStream(adaptor,"token ASCENDING_KEYWORD");
		RewriteRuleTokenStream stream_KEY_KEYWORD=new RewriteRuleTokenStream(adaptor,"token KEY_KEYWORD");
		RewriteRuleTokenStream stream_DATA_NAME=new RewriteRuleTokenStream(adaptor,"token DATA_NAME");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:420:5: ( (v= ASCENDING_KEYWORD |v= DESCENDING_KEYWORD ) ( KEY_KEYWORD )? ( DATA_NAME )+ -> ( ^( KEY $v DATA_NAME ) )+ )
			// com\\legstar\\cobol\\CobolStructureParser.g:420:9: (v= ASCENDING_KEYWORD |v= DESCENDING_KEYWORD ) ( KEY_KEYWORD )? ( DATA_NAME )+
			{
			// com\\legstar\\cobol\\CobolStructureParser.g:420:9: (v= ASCENDING_KEYWORD |v= DESCENDING_KEYWORD )
			int alt25=2;
			int LA25_0 = input.LA(1);
			if ( (LA25_0==ASCENDING_KEYWORD) ) {
				alt25=1;
			}
			else if ( (LA25_0==DESCENDING_KEYWORD) ) {
				alt25=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 25, 0, input);
				throw nvae;
			}

			switch (alt25) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:420:10: v= ASCENDING_KEYWORD
					{
					v=(Token)match(input,ASCENDING_KEYWORD,FOLLOW_ASCENDING_KEYWORD_in_key_clause2485); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_ASCENDING_KEYWORD.add(v);

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:420:32: v= DESCENDING_KEYWORD
					{
					v=(Token)match(input,DESCENDING_KEYWORD,FOLLOW_DESCENDING_KEYWORD_in_key_clause2491); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DESCENDING_KEYWORD.add(v);

					}
					break;

			}

			// com\\legstar\\cobol\\CobolStructureParser.g:420:54: ( KEY_KEYWORD )?
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==KEY_KEYWORD) ) {
				alt26=1;
			}
			switch (alt26) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:420:54: KEY_KEYWORD
					{
					KEY_KEYWORD117=(Token)match(input,KEY_KEYWORD,FOLLOW_KEY_KEYWORD_in_key_clause2494); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_KEY_KEYWORD.add(KEY_KEYWORD117);

					}
					break;

			}

			// com\\legstar\\cobol\\CobolStructureParser.g:420:67: ( DATA_NAME )+
			int cnt27=0;
			loop27:
			while (true) {
				int alt27=2;
				int LA27_0 = input.LA(1);
				if ( (LA27_0==DATA_NAME) ) {
					alt27=1;
				}

				switch (alt27) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:420:67: DATA_NAME
					{
					DATA_NAME118=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_key_clause2497); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DATA_NAME.add(DATA_NAME118);

					}
					break;

				default :
					if ( cnt27 >= 1 ) break loop27;
					if (state.backtracking>0) {state.failed=true; return retval;}
					EarlyExitException eee = new EarlyExitException(27, input);
					throw eee;
				}
				cnt27++;
			}


			// AST REWRITE
			// elements: v, DATA_NAME
			// token labels: v
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleTokenStream stream_v=new RewriteRuleTokenStream(adaptor,"token v",v);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 421:5: -> ( ^( KEY $v DATA_NAME ) )+
			{
				if ( !(stream_v.hasNext()||stream_DATA_NAME.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_v.hasNext()||stream_DATA_NAME.hasNext() ) {
					// com\\legstar\\cobol\\CobolStructureParser.g:421:7: ^( KEY $v DATA_NAME )
					{
					Object root_1 = (Object)adaptor.nil();
					root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(KEY, "KEY"), root_1);
					adaptor.addChild(root_1, stream_v.nextNode());
					adaptor.addChild(root_1, stream_DATA_NAME.nextNode());
					adaptor.addChild(root_0, root_1);
					}

				}
				stream_v.reset();
				stream_DATA_NAME.reset();

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "key_clause"


	public static class index_clause_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "index_clause"
	// com\\legstar\\cobol\\CobolStructureParser.g:424:1: index_clause : INDEXED_KEYWORD ( DATA_NAME )+ -> ( ^( INDEX DATA_NAME ) )+ ;
	public final CobolStructureParser.index_clause_return index_clause() throws RecognitionException {
		CobolStructureParser.index_clause_return retval = new CobolStructureParser.index_clause_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token INDEXED_KEYWORD119=null;
		Token DATA_NAME120=null;

		Object INDEXED_KEYWORD119_tree=null;
		Object DATA_NAME120_tree=null;
		RewriteRuleTokenStream stream_INDEXED_KEYWORD=new RewriteRuleTokenStream(adaptor,"token INDEXED_KEYWORD");
		RewriteRuleTokenStream stream_DATA_NAME=new RewriteRuleTokenStream(adaptor,"token DATA_NAME");

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:425:5: ( INDEXED_KEYWORD ( DATA_NAME )+ -> ( ^( INDEX DATA_NAME ) )+ )
			// com\\legstar\\cobol\\CobolStructureParser.g:425:9: INDEXED_KEYWORD ( DATA_NAME )+
			{
			INDEXED_KEYWORD119=(Token)match(input,INDEXED_KEYWORD,FOLLOW_INDEXED_KEYWORD_in_index_clause2534); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_INDEXED_KEYWORD.add(INDEXED_KEYWORD119);

			// com\\legstar\\cobol\\CobolStructureParser.g:425:25: ( DATA_NAME )+
			int cnt28=0;
			loop28:
			while (true) {
				int alt28=2;
				int LA28_0 = input.LA(1);
				if ( (LA28_0==DATA_NAME) ) {
					alt28=1;
				}

				switch (alt28) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:425:25: DATA_NAME
					{
					DATA_NAME120=(Token)match(input,DATA_NAME,FOLLOW_DATA_NAME_in_index_clause2536); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DATA_NAME.add(DATA_NAME120);

					}
					break;

				default :
					if ( cnt28 >= 1 ) break loop28;
					if (state.backtracking>0) {state.failed=true; return retval;}
					EarlyExitException eee = new EarlyExitException(28, input);
					throw eee;
				}
				cnt28++;
			}


			// AST REWRITE
			// elements: DATA_NAME
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 426:5: -> ( ^( INDEX DATA_NAME ) )+
			{
				if ( !(stream_DATA_NAME.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_DATA_NAME.hasNext() ) {
					// com\\legstar\\cobol\\CobolStructureParser.g:426:7: ^( INDEX DATA_NAME )
					{
					Object root_1 = (Object)adaptor.nil();
					root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(INDEX, "INDEX"), root_1);
					adaptor.addChild(root_1, stream_DATA_NAME.nextNode());
					adaptor.addChild(root_0, root_1);
					}

				}
				stream_DATA_NAME.reset();

			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "index_clause"


	public static class picture_string_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "picture_string"
	// com\\legstar\\cobol\\CobolStructureParser.g:442:1: picture_string : (v+= PICTURE_PART |v+= DECIMAL_POINT )+ ->;
	public final CobolStructureParser.picture_string_return picture_string() throws RecognitionException {
		CobolStructureParser.picture_string_return retval = new CobolStructureParser.picture_string_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token v=null;
		List<Object> list_v=null;

		Object v_tree=null;
		RewriteRuleTokenStream stream_PICTURE_PART=new RewriteRuleTokenStream(adaptor,"token PICTURE_PART");
		RewriteRuleTokenStream stream_DECIMAL_POINT=new RewriteRuleTokenStream(adaptor,"token DECIMAL_POINT");


		    StringBuilder sb = new StringBuilder();

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:446:5: ( (v+= PICTURE_PART |v+= DECIMAL_POINT )+ ->)
			// com\\legstar\\cobol\\CobolStructureParser.g:446:9: (v+= PICTURE_PART |v+= DECIMAL_POINT )+
			{
			// com\\legstar\\cobol\\CobolStructureParser.g:446:9: (v+= PICTURE_PART |v+= DECIMAL_POINT )+
			int cnt29=0;
			loop29:
			while (true) {
				int alt29=3;
				int LA29_0 = input.LA(1);
				if ( (LA29_0==PICTURE_PART) ) {
					alt29=1;
				}
				else if ( (LA29_0==DECIMAL_POINT) ) {
					alt29=2;
				}

				switch (alt29) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:446:10: v+= PICTURE_PART
					{
					v=(Token)match(input,PICTURE_PART,FOLLOW_PICTURE_PART_in_picture_string2581); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_PICTURE_PART.add(v);

					if (list_v==null) list_v=new ArrayList<Object>();
					list_v.add(v);
					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:446:28: v+= DECIMAL_POINT
					{
					v=(Token)match(input,DECIMAL_POINT,FOLLOW_DECIMAL_POINT_in_picture_string2587); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_DECIMAL_POINT.add(v);

					if (list_v==null) list_v=new ArrayList<Object>();
					list_v.add(v);
					}
					break;

				default :
					if ( cnt29 >= 1 ) break loop29;
					if (state.backtracking>0) {state.failed=true; return retval;}
					EarlyExitException eee = new EarlyExitException(29, input);
					throw eee;
				}
				cnt29++;
			}

			if ( state.backtracking==0 ) {
			            for (Object o : list_v) {
			                sb.append(((Token) o).getText());
			            }
			            String picture = sb.toString();
			            if (picture.length() == 0) {
			                throw new FailedPredicateException(
			                    input, "picture_string", "Picture empty");
			            }
			            if (unbalancedParentheses(picture)) {
			                throw new FailedPredicateException(
			                    input, "picture_string", "Unbalanced parentheses");
			            }
			    }

			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 461:5: ->
			{
				adaptor.addChild(root_0, getTreeAdaptor().create(PICTURESTRING,sb.toString()));
			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "picture_string"


	public static class decimal_literal_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "decimal_literal"
	// com\\legstar\\cobol\\CobolStructureParser.g:468:1: decimal_literal : (v= SIGNED_INT |v= INT ) DECIMAL_POINT w= INT ->;
	public final CobolStructureParser.decimal_literal_return decimal_literal() throws RecognitionException {
		CobolStructureParser.decimal_literal_return retval = new CobolStructureParser.decimal_literal_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token v=null;
		Token w=null;
		Token DECIMAL_POINT121=null;

		Object v_tree=null;
		Object w_tree=null;
		Object DECIMAL_POINT121_tree=null;
		RewriteRuleTokenStream stream_SIGNED_INT=new RewriteRuleTokenStream(adaptor,"token SIGNED_INT");
		RewriteRuleTokenStream stream_DECIMAL_POINT=new RewriteRuleTokenStream(adaptor,"token DECIMAL_POINT");
		RewriteRuleTokenStream stream_INT=new RewriteRuleTokenStream(adaptor,"token INT");


		    StringBuilder sb = new StringBuilder();

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:472:5: ( (v= SIGNED_INT |v= INT ) DECIMAL_POINT w= INT ->)
			// com\\legstar\\cobol\\CobolStructureParser.g:472:7: (v= SIGNED_INT |v= INT ) DECIMAL_POINT w= INT
			{
			// com\\legstar\\cobol\\CobolStructureParser.g:472:7: (v= SIGNED_INT |v= INT )
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==SIGNED_INT) ) {
				alt30=1;
			}
			else if ( (LA30_0==INT) ) {
				alt30=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 30, 0, input);
				throw nvae;
			}

			switch (alt30) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:472:8: v= SIGNED_INT
					{
					v=(Token)match(input,SIGNED_INT,FOLLOW_SIGNED_INT_in_decimal_literal2633); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_SIGNED_INT.add(v);

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:472:23: v= INT
					{
					v=(Token)match(input,INT,FOLLOW_INT_in_decimal_literal2639); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_INT.add(v);

					}
					break;

			}

			DECIMAL_POINT121=(Token)match(input,DECIMAL_POINT,FOLLOW_DECIMAL_POINT_in_decimal_literal2642); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_DECIMAL_POINT.add(DECIMAL_POINT121);

			w=(Token)match(input,INT,FOLLOW_INT_in_decimal_literal2646); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_INT.add(w);

			if ( state.backtracking==0 ) {
			        if (v != null) {
			            sb.append(v.getText());
			        }
			        sb.append('.');
			        sb.append(w.getText());
			    }

			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 480:5: ->
			{
				adaptor.addChild(root_0, getTreeAdaptor().create(DECIMAL_LITERAL,sb.toString()));
			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "decimal_literal"


	public static class float_literal_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "float_literal"
	// com\\legstar\\cobol\\CobolStructureParser.g:487:1: float_literal : (v= SIGNED_INT |v= INT ) DECIMAL_POINT w= FLOAT_PART2 ->;
	public final CobolStructureParser.float_literal_return float_literal() throws RecognitionException {
		CobolStructureParser.float_literal_return retval = new CobolStructureParser.float_literal_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token v=null;
		Token w=null;
		Token DECIMAL_POINT122=null;

		Object v_tree=null;
		Object w_tree=null;
		Object DECIMAL_POINT122_tree=null;
		RewriteRuleTokenStream stream_FLOAT_PART2=new RewriteRuleTokenStream(adaptor,"token FLOAT_PART2");
		RewriteRuleTokenStream stream_SIGNED_INT=new RewriteRuleTokenStream(adaptor,"token SIGNED_INT");
		RewriteRuleTokenStream stream_DECIMAL_POINT=new RewriteRuleTokenStream(adaptor,"token DECIMAL_POINT");
		RewriteRuleTokenStream stream_INT=new RewriteRuleTokenStream(adaptor,"token INT");


		    StringBuilder sb = new StringBuilder();

		try {
			// com\\legstar\\cobol\\CobolStructureParser.g:491:5: ( (v= SIGNED_INT |v= INT ) DECIMAL_POINT w= FLOAT_PART2 ->)
			// com\\legstar\\cobol\\CobolStructureParser.g:491:7: (v= SIGNED_INT |v= INT ) DECIMAL_POINT w= FLOAT_PART2
			{
			// com\\legstar\\cobol\\CobolStructureParser.g:491:7: (v= SIGNED_INT |v= INT )
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==SIGNED_INT) ) {
				alt31=1;
			}
			else if ( (LA31_0==INT) ) {
				alt31=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 31, 0, input);
				throw nvae;
			}

			switch (alt31) {
				case 1 :
					// com\\legstar\\cobol\\CobolStructureParser.g:491:8: v= SIGNED_INT
					{
					v=(Token)match(input,SIGNED_INT,FOLLOW_SIGNED_INT_in_float_literal2686); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_SIGNED_INT.add(v);

					}
					break;
				case 2 :
					// com\\legstar\\cobol\\CobolStructureParser.g:491:23: v= INT
					{
					v=(Token)match(input,INT,FOLLOW_INT_in_float_literal2692); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_INT.add(v);

					}
					break;

			}

			DECIMAL_POINT122=(Token)match(input,DECIMAL_POINT,FOLLOW_DECIMAL_POINT_in_float_literal2695); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_DECIMAL_POINT.add(DECIMAL_POINT122);

			w=(Token)match(input,FLOAT_PART2,FOLLOW_FLOAT_PART2_in_float_literal2699); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_FLOAT_PART2.add(w);

			if ( state.backtracking==0 ) {
			        if (v != null) {
			            sb.append(v.getText());
			        }
			        sb.append('.');
			        sb.append(w.getText());
			    }

			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			if ( state.backtracking==0 ) {
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 499:5: ->
			{
				adaptor.addChild(root_0, getTreeAdaptor().create(FLOAT_LITERAL,sb.toString()));
			}


			retval.tree = root_0;
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "float_literal"

	// $ANTLR start synpred1_CobolStructureParser
	public final void synpred1_CobolStructureParser_fragment() throws RecognitionException {
		// com\\legstar\\cobol\\CobolStructureParser.g:375:9: ( float_literal )
		// com\\legstar\\cobol\\CobolStructureParser.g:375:10: float_literal
		{
		pushFollow(FOLLOW_float_literal_in_synpred1_CobolStructureParser1989);
		float_literal();
		state._fsp--;
		if (state.failed) return;

		}

	}
	// $ANTLR end synpred1_CobolStructureParser

	// $ANTLR start synpred2_CobolStructureParser
	public final void synpred2_CobolStructureParser_fragment() throws RecognitionException {
		// com\\legstar\\cobol\\CobolStructureParser.g:376:9: ( decimal_literal )
		// com\\legstar\\cobol\\CobolStructureParser.g:376:10: decimal_literal
		{
		pushFollow(FOLLOW_decimal_literal_in_synpred2_CobolStructureParser2004);
		decimal_literal();
		state._fsp--;
		if (state.failed) return;

		}

	}
	// $ANTLR end synpred2_CobolStructureParser

	// $ANTLR start synpred3_CobolStructureParser
	public final void synpred3_CobolStructureParser_fragment() throws RecognitionException {
		// com\\legstar\\cobol\\CobolStructureParser.g:408:9: ( OCCURS_KEYWORD low_bound )
		// com\\legstar\\cobol\\CobolStructureParser.g:408:10: OCCURS_KEYWORD low_bound
		{
		match(input,OCCURS_KEYWORD,FOLLOW_OCCURS_KEYWORD_in_synpred3_CobolStructureParser2309); if (state.failed) return;

		pushFollow(FOLLOW_low_bound_in_synpred3_CobolStructureParser2311);
		low_bound();
		state._fsp--;
		if (state.failed) return;

		}

	}
	// $ANTLR end synpred3_CobolStructureParser

	// Delegated rules

	public final boolean synpred2_CobolStructureParser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred2_CobolStructureParser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred1_CobolStructureParser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_CobolStructureParser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred3_CobolStructureParser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred3_CobolStructureParser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}



	public static final BitSet FOLLOW_data_items_in_cobdata401 = new BitSet(new long[]{0x0000000000024000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EOF_in_cobdata405 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_data_entry_in_data_items439 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_data_description_entry_in_data_entry478 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rename_description_entry_in_data_entry488 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_condition_description_entry_in_data_entry498 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_data_item_level_in_data_description_entry520 = new BitSet(new long[]{0x4D694123BC0C0C00L,0x000000000000C4E0L});
	public static final BitSet FOLLOW_DATA_NAME_in_data_description_entry522 = new BitSet(new long[]{0x4D694123BC080C00L,0x000000000000C4E0L});
	public static final BitSet FOLLOW_clauses_in_data_description_entry525 = new BitSet(new long[]{0x4D694123BC080C00L,0x000000000000C4E0L});
	public static final BitSet FOLLOW_PERIOD_in_data_description_entry528 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DATA_ITEM_LEVEL_in_data_item_level569 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rename_level_in_rename_description_entry601 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_DATA_NAME_in_rename_description_entry605 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_RENAMES_KEYWORD_in_rename_description_entry607 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_DATA_NAME_in_rename_description_entry611 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_THROUGH_KEYWORD_in_rename_description_entry613 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_DATA_NAME_in_rename_description_entry617 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_PERIOD_in_rename_description_entry619 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rename_level_in_rename_description_entry657 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_DATA_NAME_in_rename_description_entry661 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_RENAMES_KEYWORD_in_rename_description_entry663 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_DATA_NAME_in_rename_description_entry667 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_PERIOD_in_rename_description_entry669 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RENAMES_LEVEL_in_rename_level714 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_condition_level_in_condition_description_entry746 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_DATA_NAME_in_condition_description_entry748 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_condition_name_values_in_condition_description_entry750 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_PERIOD_in_condition_description_entry752 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONDITION_LEVEL_in_condition_level791 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VALUE_KEYWORD_in_condition_name_values821 = new BitSet(new long[]{0x2004B04C00400050L,0x00000000000C0208L});
	public static final BitSet FOLLOW_condition_name_value_in_condition_name_values826 = new BitSet(new long[]{0x2004B04C00400052L,0x00000000000C0208L});
	public static final BitSet FOLLOW_literal_in_condition_name_value865 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
	public static final BitSet FOLLOW_THROUGH_KEYWORD_in_condition_name_value887 = new BitSet(new long[]{0x2004B04C00400050L,0x00000000000C0208L});
	public static final BitSet FOLLOW_literal_in_condition_name_value891 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_redefines_clause_in_clauses979 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_blank_when_zero_clause_in_clauses989 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_external_clause_in_clauses999 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_global_clause_in_clauses1009 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_group_usage_clause_in_clauses1019 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_justified_clause_in_clauses1029 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_occurs_clause_in_clauses1039 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_picture_clause_in_clauses1049 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_sign_clause_in_clauses1059 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_synchronized_clause_in_clauses1069 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_usage_clause_in_clauses1079 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_value_clause_in_clauses1089 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_date_format_clause_in_clauses1099 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REDEFINES_KEYWORD_in_redefines_clause1119 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_DATA_NAME_in_redefines_clause1121 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BLANK_KEYWORD_in_blank_when_zero_clause1151 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_ZERO_CONSTANT_in_blank_when_zero_clause1153 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXTERNAL_KEYWORD_in_external_clause1181 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GLOBAL_KEYWORD_in_global_clause1209 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GROUP_USAGE_KEYWORD_in_group_usage_clause1237 = new BitSet(new long[]{0x0000400000000000L});
	public static final BitSet FOLLOW_NATIONAL_KEYWORD_in_group_usage_clause1239 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_JUSTIFIED_KEYWORD_in_justified_clause1267 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHT_KEYWORD_in_justified_clause1269 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fixed_length_table_in_occurs_clause1298 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_variable_length_table_in_occurs_clause1308 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PICTURE_KEYWORD_in_picture_clause1327 = new BitSet(new long[]{0x0200000000800000L});
	public static final BitSet FOLLOW_picture_string_in_picture_clause1329 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_sign_leading_clause_in_sign_clause1360 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_sign_trailing_clause_in_sign_clause1364 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SIGN_LEADING_KEYWORD_in_sign_leading_clause1403 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000004L});
	public static final BitSet FOLLOW_separate_clause_in_sign_leading_clause1405 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SIGN_TRAILING_KEYWORD_in_sign_trailing_clause1441 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000004L});
	public static final BitSet FOLLOW_separate_clause_in_sign_trailing_clause1443 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SEPARATE_KEYWORD_in_separate_clause1479 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SYNCHRONIZED_KEYWORD_in_synchronized_clause1507 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000002L});
	public static final BitSet FOLLOW_LEFT_KEYWORD_in_synchronized_clause1518 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHT_KEYWORD_in_synchronized_clause1538 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_USAGE_KEYWORD_in_usage_clause1605 = new BitSet(new long[]{0x0C2140209C000400L,0x0000000000000080L});
	public static final BitSet FOLLOW_BINARY_KEYWORD_in_usage_clause1629 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SINGLE_FLOAT_KEYWORD_in_usage_clause1659 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_FLOAT_KEYWORD_in_usage_clause1683 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PACKED_DECIMAL_KEYWORD_in_usage_clause1707 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NATIVE_BINARY_KEYWORD_in_usage_clause1729 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DISPLAY_KEYWORD_in_usage_clause1752 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DISPLAY_1_KEYWORD_in_usage_clause1781 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INDEX_KEYWORD_in_usage_clause1808 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NATIONAL_KEYWORD_in_usage_clause1839 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_POINTER_KEYWORD_in_usage_clause1867 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PROCEDURE_POINTER_KEYWORD_in_usage_clause1896 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_POINTER_KEYWORD_in_usage_clause1915 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VALUE_KEYWORD_in_value_clause1952 = new BitSet(new long[]{0x2004B04C00400050L,0x00000000000C0208L});
	public static final BitSet FOLLOW_literal_in_value_clause1954 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_float_literal_in_literal1993 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_decimal_literal_in_literal2008 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INT_in_literal2018 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SIGNED_INT_in_literal2028 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALPHANUM_LITERAL_STRING_in_literal2038 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HEX_LITERAL_STRING_in_literal2048 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ZERO_LITERAL_STRING_in_literal2058 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DBCS_LITERAL_STRING_in_literal2068 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NATIONAL_LITERAL_STRING_in_literal2078 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NATIONAL_HEX_LITERAL_STRING_in_literal2088 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ZERO_CONSTANT_in_literal2098 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SPACE_CONSTANT_in_literal2108 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HIGH_VALUE_CONSTANT_in_literal2118 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LOW_VALUE_CONSTANT_in_literal2128 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTE_CONSTANT_in_literal2138 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_CONSTANT_in_literal2148 = new BitSet(new long[]{0x2004100800000040L,0x0000000000040200L});
	public static final BitSet FOLLOW_set_in_literal2150 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NULL_CONSTANT_in_literal2186 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DATE_FORMAT_KEYWORD_in_date_format_clause2205 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_DATE_PATTERN_in_date_format_clause2207 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OCCURS_KEYWORD_in_fixed_length_table2241 = new BitSet(new long[]{0x0000004000000000L});
	public static final BitSet FOLLOW_INT_in_fixed_length_table2243 = new BitSet(new long[]{0x0000001002000202L});
	public static final BitSet FOLLOW_key_clause_in_fixed_length_table2246 = new BitSet(new long[]{0x0000001002000202L});
	public static final BitSet FOLLOW_index_clause_in_fixed_length_table2251 = new BitSet(new long[]{0x0000001000000002L});
	public static final BitSet FOLLOW_OCCURS_KEYWORD_in_variable_length_table2314 = new BitSet(new long[]{0x0000004000000000L});
	public static final BitSet FOLLOW_low_bound_in_variable_length_table2316 = new BitSet(new long[]{0x0000004000000000L});
	public static final BitSet FOLLOW_INT_in_variable_length_table2320 = new BitSet(new long[]{0x0000000001000000L});
	public static final BitSet FOLLOW_DEPENDING_KEYWORD_in_variable_length_table2322 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_DATA_NAME_in_variable_length_table2324 = new BitSet(new long[]{0x0000001002000202L});
	public static final BitSet FOLLOW_key_clause_in_variable_length_table2327 = new BitSet(new long[]{0x0000001002000202L});
	public static final BitSet FOLLOW_index_clause_in_variable_length_table2332 = new BitSet(new long[]{0x0000001000000002L});
	public static final BitSet FOLLOW_OCCURS_KEYWORD_in_variable_length_table2374 = new BitSet(new long[]{0x0000004000000000L});
	public static final BitSet FOLLOW_INT_in_variable_length_table2376 = new BitSet(new long[]{0x0000000001000000L});
	public static final BitSet FOLLOW_DEPENDING_KEYWORD_in_variable_length_table2378 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_DATA_NAME_in_variable_length_table2380 = new BitSet(new long[]{0x0000001002000202L});
	public static final BitSet FOLLOW_key_clause_in_variable_length_table2383 = new BitSet(new long[]{0x0000001002000202L});
	public static final BitSet FOLLOW_index_clause_in_variable_length_table2388 = new BitSet(new long[]{0x0000001000000002L});
	public static final BitSet FOLLOW_INT_in_low_bound2440 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_TO_KEYWORD_in_low_bound2442 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASCENDING_KEYWORD_in_key_clause2485 = new BitSet(new long[]{0x0000020000040000L});
	public static final BitSet FOLLOW_DESCENDING_KEYWORD_in_key_clause2491 = new BitSet(new long[]{0x0000020000040000L});
	public static final BitSet FOLLOW_KEY_KEYWORD_in_key_clause2494 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_DATA_NAME_in_key_clause2497 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_INDEXED_KEYWORD_in_index_clause2534 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_DATA_NAME_in_index_clause2536 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_PICTURE_PART_in_picture_string2581 = new BitSet(new long[]{0x0200000000800002L});
	public static final BitSet FOLLOW_DECIMAL_POINT_in_picture_string2587 = new BitSet(new long[]{0x0200000000800002L});
	public static final BitSet FOLLOW_SIGNED_INT_in_decimal_literal2633 = new BitSet(new long[]{0x0000000000800000L});
	public static final BitSet FOLLOW_INT_in_decimal_literal2639 = new BitSet(new long[]{0x0000000000800000L});
	public static final BitSet FOLLOW_DECIMAL_POINT_in_decimal_literal2642 = new BitSet(new long[]{0x0000004000000000L});
	public static final BitSet FOLLOW_INT_in_decimal_literal2646 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SIGNED_INT_in_float_literal2686 = new BitSet(new long[]{0x0000000000800000L});
	public static final BitSet FOLLOW_INT_in_float_literal2692 = new BitSet(new long[]{0x0000000000800000L});
	public static final BitSet FOLLOW_DECIMAL_POINT_in_float_literal2695 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_FLOAT_PART2_in_float_literal2699 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_float_literal_in_synpred1_CobolStructureParser1989 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_decimal_literal_in_synpred2_CobolStructureParser2004 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OCCURS_KEYWORD_in_synpred3_CobolStructureParser2309 = new BitSet(new long[]{0x0000004000000000L});
	public static final BitSet FOLLOW_low_bound_in_synpred3_CobolStructureParser2311 = new BitSet(new long[]{0x0000000000000002L});
}
