/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.jdbc.snapshot.dao;

import akka.dispatch.ExecutionContexts$;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotMetadata$;
import akka.persistence.jdbc.AkkaSerialization$;
import akka.persistence.jdbc.config.SnapshotConfig;
import akka.persistence.jdbc.snapshot.dao.SnapshotDao;
import akka.persistence.jdbc.snapshot.dao.SnapshotQueries;
import akka.persistence.jdbc.snapshot.dao.SnapshotTables;
import akka.serialization.Serialization;
import akka.stream.Materializer;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Success;
import scala.util.Try;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.RunnableCompiled;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\r\u001a\u0001\u0011B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!Y\u0005A!A!\u0002\u0017a\u0005\u0002\u0003*\u0001\u0005\u000b\u0007I1A*\t\u0011i\u0003!\u0011!Q\u0001\nQCQa\u0017\u0001\u0005\u0002qCq!\u001a\u0001C\u0002\u0013\u0005a\r\u0003\u0004k\u0001\u0001\u0006Ia\u001a\u0005\u0006W\u0002!I\u0001\u001c\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002^\u0001!\t%a\u0018\t\u000f\u00055\u0004\u0001\"\u0011\u0002p!9\u0011q\u000f\u0001\u0005B\u0005e\u0004bBAA\u0001\u0011\u0005\u00131\u0011\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\ti\n\u0001C!\u0003?Cq!a)\u0001\t\u0003\n)\u000bC\u0004\u0002,\u0002!\t%!,\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\n\u0011B)\u001a4bk2$8K\\1qg\"|G\u000fR1p\u0015\tQ2$A\u0002eC>T!\u0001H\u000f\u0002\u0011Mt\u0017\r]:i_RT!AH\u0010\u0002\t)$'m\u0019\u0006\u0003A\u0005\n1\u0002]3sg&\u001cH/\u001a8dK*\t!%\u0001\u0003bW.\f7\u0001A\n\u0004\u0001\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-[5\t\u0011$\u0003\u0002/3\tY1K\\1qg\"|G\u000fR1p\u0003\t!'\r\u0005\u00022qA\u0011!GN\u0007\u0002g)\u0011a\u0004\u000e\u0006\u0002k\u0005)1\u000f\\5dW&\u0011qg\r\u0002\f\u0015\u0012\u00147MQ1dW\u0016tG-\u0003\u0002:m\tYA)\u0019;bE\u0006\u001cX\rR3g\u0003\u001d\u0001(o\u001c4jY\u0016\u0004\"A\r\u001f\n\u0005u\u001a$a\u0003&eE\u000e\u0004&o\u001c4jY\u0016\fab\u001d8baNDw\u000e^\"p]\u001aLw\r\u0005\u0002A\u00076\t\u0011I\u0003\u0002C;\u000511m\u001c8gS\u001eL!\u0001R!\u0003\u001dMs\u0017\r]:i_R\u001cuN\u001c4jO\u0006i1/\u001a:jC2L'0\u0019;j_:\u0004\"aR%\u000e\u0003!S!!R\u0011\n\u0005)C%!D*fe&\fG.\u001b>bi&|g.\u0001\u0002fGB\u0011Q\nU\u0007\u0002\u001d*\u0011qjJ\u0001\u000bG>t7-\u001e:sK:$\u0018BA)O\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002nCR,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\u0006\naa\u001d;sK\u0006l\u0017BA-W\u00051i\u0015\r^3sS\u0006d\u0017N_3s\u0003\u0011i\u0017\r\u001e\u0011\u0002\rqJg.\u001b;?)\u0015i\u0016MY2e)\rqv\f\u0019\t\u0003Y\u0001AQa\u0013\u0005A\u00041CQA\u0015\u0005A\u0004QCQa\f\u0005A\u0002ABQA\u000f\u0005A\u0002mBQA\u0010\u0005A\u0002}BQ!\u0012\u0005A\u0002\u0019\u000bq!];fe&,7/F\u0001h!\ta\u0003.\u0003\u0002j3\ty1K\\1qg\"|G/U;fe&,7/\u0001\u0005rk\u0016\u0014\u0018.Z:!\u00039!xn\u00158baNDw\u000e\u001e#bi\u0006$\"!\\?\u0011\u00079\f8/D\u0001p\u0015\t\u0001x%\u0001\u0003vi&d\u0017B\u0001:p\u0005\r!&/\u001f\t\u0005MQ4(0\u0003\u0002vO\t1A+\u001e9mKJ\u0002\"a\u001e=\u000e\u0003}I!!_\u0010\u0003!Ms\u0017\r]:i_RlU\r^1eCR\f\u0007C\u0001\u0014|\u0013\taxEA\u0002B]fDQA`\u0006A\u0002}\f1A]8x!\u0011\t\t!a\u0002\u000f\u00071\n\u0019!C\u0002\u0002\u0006e\tab\u00158baNDw\u000e\u001e+bE2,7/\u0003\u0003\u0002\n\u0005-!aC*oCB\u001c\bn\u001c;S_^T1!!\u0002\u001a\u0003E\u0019XM]5bY&TXm\u00158baNDw\u000e\u001e\u000b\u0007\u0003#\t\u0019\"a\u0006\u0011\u00079\fx\u0010\u0003\u0004\u0002\u00161\u0001\rA^\u0001\u0005[\u0016$\u0018\rC\u0003\u001d\u0019\u0001\u0007!0A\t{KJ|wJ](oKNs\u0017\r]:i_R$B!!\b\u0002$A!a%a\bt\u0013\r\t\tc\n\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\u0015R\u00021\u0001\u0002(\u0005!!o\\<t!\u0015\tI#!\u000f\u0000\u001d\u0011\tY#!\u000e\u000f\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r$\u0003\u0019a$o\\8u}%\t\u0001&C\u0002\u00028\u001d\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002<\u0005u\"aA*fc*\u0019\u0011qG\u0014\u0002\u001d1\fG/Z:u':\f\u0007o\u001d5piR!\u00111IA%!\u0015i\u0015QIA\u000f\u0013\r\t9E\u0014\u0002\u0007\rV$XO]3\t\u000f\u0005-c\u00021\u0001\u0002N\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012\u0004B!a\u0014\u0002X9!\u0011\u0011KA*!\r\ticJ\u0005\u0004\u0003+:\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002Z\u0005m#AB*ue&twMC\u0002\u0002V\u001d\nqc\u001d8baNDw\u000e\u001e$pe6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\r\u0005\r\u0013\u0011MA2\u0011\u001d\tYe\u0004a\u0001\u0003\u001bBq!!\u001a\u0010\u0001\u0004\t9'\u0001\u0007nCb$\u0016.\\3ti\u0006l\u0007\u000fE\u0002'\u0003SJ1!a\u001b(\u0005\u0011auN\\4\u00021Mt\u0017\r]:i_R4uN]'bqN+\u0017/^3oG\u0016t%\u000f\u0006\u0004\u0002D\u0005E\u00141\u000f\u0005\b\u0003\u0017\u0002\u0002\u0019AA'\u0011\u001d\t)\b\u0005a\u0001\u0003O\nQ\"\\1y'\u0016\fX/\u001a8dK:\u0013\u0018aJ:oCB\u001c\bn\u001c;G_Jl\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"a\u0011\u0002|\u0005u\u0014q\u0010\u0005\b\u0003\u0017\n\u0002\u0019AA'\u0011\u001d\t)(\u0005a\u0001\u0003OBq!!\u001a\u0012\u0001\u0004\t9'\u0001\u0003tCZ,GCBAC\u0003\u001b\u000b\t\nE\u0003N\u0003\u000b\n9\tE\u0002'\u0003\u0013K1!a#(\u0005\u0011)f.\u001b;\t\r\u0005=%\u00031\u0001w\u0003A\u0019h.\u00199tQ>$X*\u001a;bI\u0006$\u0018\rC\u0003\u001d%\u0001\u0007!0\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003\u000b\u000b9*!'\t\u000f\u0005-3\u00031\u0001\u0002N!9\u00111T\nA\u0002\u0005\u001d\u0014AC:fcV,gnY3Oe\u0006\u0011B-\u001a7fi\u0016\fE\u000e\\*oCB\u001c\bn\u001c;t)\u0011\t))!)\t\u000f\u0005-C\u00031\u0001\u0002N\u00059B-\u001a7fi\u0016,\u0006\u000fV8NCb\u001cV-];f]\u000e,gJ\u001d\u000b\u0007\u0003\u000b\u000b9+!+\t\u000f\u0005-S\u00031\u0001\u0002N!9\u0011QO\u000bA\u0002\u0005\u001d\u0014A\u00063fY\u0016$X-\u00169U_6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\r\u0005\u0015\u0015qVAY\u0011\u001d\tYE\u0006a\u0001\u0003\u001bBq!!\u001a\u0017\u0001\u0004\t9'\u0001\u0014eK2,G/Z+q)>l\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"!\"\u00028\u0006e\u00161\u0018\u0005\b\u0003\u0017:\u0002\u0019AA'\u0011\u001d\t)h\u0006a\u0001\u0003OBq!!\u001a\u0018\u0001\u0004\t9\u0007")
public class DefaultSnapshotDao
implements SnapshotDao {
    private final JdbcBackend.DatabaseDef db;
    private final JdbcProfile profile;
    private final Serialization serialization;
    private final ExecutionContext ec;
    private final Materializer mat;
    private final SnapshotQueries queries;

    public Materializer mat() {
        return this.mat;
    }

    public SnapshotQueries queries() {
        return this.queries;
    }

    private Try<Tuple2<SnapshotMetadata, Object>> toSnapshotData(SnapshotTables.SnapshotRow row) {
        Try snapshot2 = this.serialization.deserialize(row.snapshotPayload(), row.snapshotSerId(), row.snapshotSerManifest());
        return snapshot2.flatMap((Function1 & Serializable)snapshot -> {
            Some some;
            Tuple2 tuple2;
            Option metadata = row.metaPayload().flatMap((Function1 & Serializable)mPayload -> row.metaSerId().map((Function1 & Serializable)mSerId -> DefaultSnapshotDao.$anonfun$toSnapshotData$3(mPayload, BoxesRunTime.unboxToInt((Object)mSerId))));
            Option option = metadata;
            if (None$.MODULE$.equals(option)) {
                return new Success((Object)new Tuple2((Object)SnapshotMetadata$.MODULE$.apply(row.persistenceId(), row.sequenceNumber(), row.created()), snapshot));
            }
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                byte[] payload = (byte[])tuple2._1();
                int id = tuple2._2$mcI$sp();
                return $this.serialization.deserialize(payload, id, (String)row.metaSerManifest().getOrElse((Function0 & Serializable)() -> "")).map((Function1 & Serializable)meta -> new Tuple2((Object)SnapshotMetadata$.MODULE$.apply(row.persistenceId(), row.sequenceNumber(), row.created(), (Option)new Some(meta)), snapshot));
            }
            throw new MatchError((Object)option);
        });
    }

    private Try<SnapshotTables.SnapshotRow> serializeSnapshot(SnapshotMetadata meta, Object snapshot) {
        Option serializedMetadata = meta.metadata().flatMap((Function1 & Serializable)m -> AkkaSerialization$.MODULE$.serialize($this.serialization, m).toOption());
        return AkkaSerialization$.MODULE$.serialize(this.serialization, snapshot).map((Function1 & Serializable)serializedSnapshot -> new SnapshotTables.SnapshotRow(meta.persistenceId(), meta.sequenceNr(), meta.timestamp(), serializedSnapshot.serId(), serializedSnapshot.serManifest(), serializedSnapshot.payload(), (Option<Object>)serializedMetadata.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.serId())), (Option<String>)serializedMetadata.map((Function1 & Serializable)x$2 -> x$2.serManifest()), (Option<byte[]>)serializedMetadata.map((Function1 & Serializable)x$3 -> x$3.payload())));
    }

    private Option<Tuple2<SnapshotMetadata, Object>> zeroOrOneSnapshot(Seq<SnapshotTables.SnapshotRow> rows) {
        return rows.headOption().map((Function1 & Serializable)row -> (Tuple2)this.toSnapshotData((SnapshotTables.SnapshotRow)row).get());
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> latestSnapshot(String persistenceId) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectLatestByPersistenceId().apply((Object)persistenceId))).result()).flatMap((Function1 & Serializable)rows -> {
            Option option = rows.headOption();
            if (option instanceof Some) {
                Some some = (Some)option;
                SnapshotTables.SnapshotRow row = (SnapshotTables.SnapshotRow)some.value();
                return Future$.MODULE$.fromTry(this.toSnapshotData(row)).map((Function1 & Serializable)x$4 -> Option$.MODULE$.apply(x$4), $this.ec);
            }
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        }, this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable)rows -> this.zeroOrOneSnapshot((Seq<SnapshotTables.SnapshotRow>)rows), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))))).result()).map((Function1 & Serializable)rows -> this.zeroOrOneSnapshot((Seq<SnapshotTables.SnapshotRow>)rows), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable)x$5 -> this.zeroOrOneSnapshot((Seq<SnapshotTables.SnapshotRow>)x$5), this.ec);
    }

    @Override
    public Future<BoxedUnit> save(SnapshotMetadata snapshotMetadata, Object snapshot) {
        Future eventualSnapshotRow = Future$.MODULE$.fromTry(this.serializeSnapshot(snapshotMetadata, snapshot));
        return eventualSnapshotRow.map((Function1 & Serializable)snapshotRow -> this.queries().insertOrUpdate((SnapshotTables.SnapshotRow)snapshotRow), this.ec).flatMap((Function1 & Serializable)a -> $this.db.run(a), this.ec).map((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> delete(String persistenceId, long sequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdAndSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteAllSnapshots(String persistenceId) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectAll().apply((Object)persistenceId)).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    public static final /* synthetic */ Tuple2 $anonfun$toSnapshotData$3(byte[] mPayload$1, int mSerId) {
        return new Tuple2((Object)mPayload$1, (Object)BoxesRunTime.boxToInteger((int)mSerId));
    }

    public DefaultSnapshotDao(JdbcBackend.DatabaseDef db, JdbcProfile profile, SnapshotConfig snapshotConfig, Serialization serialization, ExecutionContext ec, Materializer mat) {
        this.db = db;
        this.profile = profile;
        this.serialization = serialization;
        this.ec = ec;
        this.mat = mat;
        this.queries = new SnapshotQueries(profile, snapshotConfig.snapshotTableConfiguration());
    }
}

