/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.jdbc.testkit.internal;

import akka.Done;
import akka.Done$;
import akka.actor.ClassicActorSystemProvider;
import akka.annotation.InternalApi;
import akka.dispatch.Dispatchers$;
import akka.dispatch.MessageDispatcher;
import akka.persistence.jdbc.db.SlickDatabase;
import akka.persistence.jdbc.db.SlickExtension$;
import akka.persistence.jdbc.db.SlickExtensionImpl;
import akka.persistence.jdbc.testkit.internal.H2$;
import akka.persistence.jdbc.testkit.internal.MySQL$;
import akka.persistence.jdbc.testkit.internal.Oracle$;
import akka.persistence.jdbc.testkit.internal.Postgres$;
import akka.persistence.jdbc.testkit.internal.SchemaType;
import akka.persistence.jdbc.testkit.internal.SqlServer$;
import com.typesafe.config.Config;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import slick.jdbc.H2Profile$;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.jdbc.MySQLProfile$;
import slick.jdbc.OracleProfile$;
import slick.jdbc.PostgresProfile$;
import slick.jdbc.SQLServerProfile$;

@InternalApi
public final class SchemaUtilsImpl$ {
    public static final SchemaUtilsImpl$ MODULE$ = new SchemaUtilsImpl$();

    public boolean legacy(String configKey, Config config) {
        String string = config.getConfig(configKey).getString("dao");
        String string2 = "akka.persistence.jdbc.journal.dao.DefaultJournalDao";
        return string == null ? string2 != null : !string.equals(string2);
    }

    @InternalApi
    public Future<Done> dropIfExists(String configKey, Logger logger, ClassicActorSystemProvider actorSystem) {
        SlickDatabase slickDb = this.loadSlickDatabase(configKey, actorSystem);
        Tuple2<String, String> tuple2 = this.dropScriptFor(this.slickProfileToSchemaType(slickDb.profile()), this.legacy(configKey, actorSystem.classicSystem().settings().config()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String fileToLoad = (String)tuple2._1();
        String separator = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fileToLoad, (Object)separator);
        String fileToLoad2 = (String)tuple22._1();
        String separator2 = (String)tuple22._2();
        MessageDispatcher blockingEC = actorSystem.classicSystem().dispatchers().lookup(Dispatchers$.MODULE$.DefaultBlockingDispatcherId());
        return Future$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.applyScriptWithSlick(MODULE$.fromClasspathAsString(fileToLoad2), separator2, logger, slickDb.database()), (ExecutionContext)blockingEC);
    }

    @InternalApi
    public Future<Done> createIfNotExists(String configKey, Logger logger, ClassicActorSystemProvider actorSystem) {
        SlickDatabase slickDb = this.loadSlickDatabase(configKey, actorSystem);
        Tuple2<String, String> tuple2 = this.createScriptFor(this.slickProfileToSchemaType(slickDb.profile()), this.legacy(configKey, actorSystem.classicSystem().settings().config()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String fileToLoad = (String)tuple2._1();
        String separator = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fileToLoad, (Object)separator);
        String fileToLoad2 = (String)tuple22._1();
        String separator2 = (String)tuple22._2();
        MessageDispatcher blockingEC = actorSystem.classicSystem().dispatchers().lookup(Dispatchers$.MODULE$.DefaultBlockingDispatcherId());
        return Future$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.applyScriptWithSlick(MODULE$.fromClasspathAsString(fileToLoad2), separator2, logger, slickDb.database()), (ExecutionContext)blockingEC);
    }

    @InternalApi
    public Future<Done> applyScript(String script, String separator, String configKey, Logger logger, ClassicActorSystemProvider actorSystem) {
        MessageDispatcher blockingEC = actorSystem.classicSystem().dispatchers().lookup(Dispatchers$.MODULE$.DefaultBlockingDispatcherId());
        return Future$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.applyScriptWithSlick(script, separator, logger, MODULE$.loadSlickDatabase(configKey, actorSystem).database()), (ExecutionContext)blockingEC);
    }

    @InternalApi
    public Done dropWithSlick(SchemaType schemaType, Logger logger, JdbcBackend.DatabaseDef db, boolean legacy) {
        Tuple2<String, String> tuple2 = this.dropScriptFor(schemaType, legacy);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String fileToLoad = (String)tuple2._1();
        String separator = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fileToLoad, (Object)separator);
        String fileToLoad2 = (String)tuple22._1();
        String separator2 = (String)tuple22._2();
        return this.applyScriptWithSlick(this.fromClasspathAsString(fileToLoad2), separator2, logger, db);
    }

    @InternalApi
    public Done createWithSlick(SchemaType schemaType, Logger logger, JdbcBackend.DatabaseDef db, boolean legacy) {
        Tuple2<String, String> tuple2 = this.createScriptFor(schemaType, legacy);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String fileToLoad = (String)tuple2._1();
        String separator = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fileToLoad, (Object)separator);
        String fileToLoad2 = (String)tuple22._1();
        String separator2 = (String)tuple22._2();
        return this.applyScriptWithSlick(this.fromClasspathAsString(fileToLoad2), separator2, logger, db);
    }

    private Done applyScriptWithSlick(String script, String separator, Logger logger, JdbcBackend.DatabaseDef database) {
        return SchemaUtilsImpl$.withStatement$1((Function1 & Serializable)stmt -> {
            SchemaUtilsImpl$.$anonfun$applyScriptWithSlick$1(script, separator, logger, stmt);
            return BoxedUnit.UNIT;
        }, database);
    }

    private Tuple2<String, String> dropScriptFor(SchemaType schemaType, boolean legacy) {
        String suffix = legacy ? "-legacy" : "";
        SchemaType schemaType2 = schemaType;
        if (Postgres$.MODULE$.equals(schemaType2)) {
            return new Tuple2((Object)new StringBuilder(40).append("schema/postgres/postgres-drop-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (MySQL$.MODULE$.equals(schemaType2)) {
            return new Tuple2((Object)new StringBuilder(34).append("schema/mysql/mysql-drop-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (Oracle$.MODULE$.equals(schemaType2)) {
            return new Tuple2((Object)new StringBuilder(36).append("schema/oracle/oracle-drop-schema").append(suffix).append(".sql").toString(), (Object)"/");
        }
        if (SqlServer$.MODULE$.equals(schemaType2)) {
            return new Tuple2((Object)new StringBuilder(42).append("schema/sqlserver/sqlserver-drop-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (H2$.MODULE$.equals(schemaType2)) {
            return new Tuple2((Object)new StringBuilder(28).append("schema/h2/h2-drop-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        throw new MatchError((Object)schemaType2);
    }

    private Tuple2<String, String> createScriptFor(SchemaType schemaType, boolean legacy) {
        String suffix = legacy ? "-legacy" : "";
        SchemaType schemaType2 = schemaType;
        if (Postgres$.MODULE$.equals(schemaType2)) {
            return new Tuple2((Object)new StringBuilder(42).append("schema/postgres/postgres-create-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (MySQL$.MODULE$.equals(schemaType2)) {
            return new Tuple2((Object)new StringBuilder(36).append("schema/mysql/mysql-create-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (Oracle$.MODULE$.equals(schemaType2)) {
            return new Tuple2((Object)new StringBuilder(38).append("schema/oracle/oracle-create-schema").append(suffix).append(".sql").toString(), (Object)"/");
        }
        if (SqlServer$.MODULE$.equals(schemaType2)) {
            return new Tuple2((Object)new StringBuilder(44).append("schema/sqlserver/sqlserver-create-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (H2$.MODULE$.equals(schemaType2)) {
            return new Tuple2((Object)new StringBuilder(30).append("schema/h2/h2-create-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        throw new MatchError((Object)schemaType2);
    }

    private SchemaType slickProfileToSchemaType(JdbcProfile profile) {
        JdbcProfile jdbcProfile = profile;
        if (PostgresProfile$.MODULE$.equals(jdbcProfile)) {
            return Postgres$.MODULE$;
        }
        if (MySQLProfile$.MODULE$.equals(jdbcProfile)) {
            return MySQL$.MODULE$;
        }
        if (OracleProfile$.MODULE$.equals(jdbcProfile)) {
            return Oracle$.MODULE$;
        }
        if (SQLServerProfile$.MODULE$.equals(jdbcProfile)) {
            return SqlServer$.MODULE$;
        }
        if (H2Profile$.MODULE$.equals(jdbcProfile)) {
            return H2$.MODULE$;
        }
        throw new IllegalArgumentException(new StringBuilder(28).append("Invalid profile ").append(profile).append(" encountered").toString());
    }

    @InternalApi
    public String fromClasspathAsString(String fileName) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);
        return Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    private SlickDatabase loadSlickDatabase(String configKey, ClassicActorSystemProvider actorSystem) {
        Config journalConfig = actorSystem.classicSystem().settings().config().getConfig(configKey);
        return ((SlickExtensionImpl)SlickExtension$.MODULE$.apply(actorSystem)).database(journalConfig);
    }

    private static final Done withStatement$1(Function1 f, JdbcBackend.DatabaseDef database$1) {
        try (JdbcBackend.SessionDef session = database$1.createSession();){
            session.withStatement(session.withStatement$default$1(), session.withStatement$default$2(), session.withStatement$default$3(), f);
        }
        return Done$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$applyScriptWithSlick$1(String script$2, String separator$4, Logger logger$4, Statement stmt) {
        String[] lines = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])script$2.split(separator$4)), (Function1 & Serializable)x$5 -> x$5.trim(), ClassTag$.MODULE$.apply(String.class));
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])lines), (Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(line)))).map((Function1 & Serializable)line -> {
            Integer n;
            logger$4.debug(new StringBuilder(14).append("applying DDL: ").append((String)line).toString());
            try {
                n = BoxesRunTime.boxToInteger((int)stmt.executeUpdate((String)line));
            }
            catch (SQLException t) {
                logger$4.debug("Exception while applying SQL script", (Throwable)t);
                n = BoxedUnit.UNIT;
            }
            return n;
        }, ClassTag$.MODULE$.AnyVal());
    }

    private SchemaUtilsImpl$() {
    }
}

