/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.headers;

import akka.annotation.InternalApi;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.stream.alpakka.s3.headers.ServerSideEncryption;
import akka.stream.alpakka.s3.impl.CopyPart$;
import akka.stream.alpakka.s3.impl.GetObject$;
import akka.stream.alpakka.s3.impl.HeadObject$;
import akka.stream.alpakka.s3.impl.InitiateMultipartUpload$;
import akka.stream.alpakka.s3.impl.PutObject$;
import akka.stream.alpakka.s3.impl.S3Request;
import akka.stream.alpakka.s3.impl.UploadPart$;
import com.amazonaws.util.Base64;
import com.amazonaws.util.Md5Utils;
import java.io.Serializable;
import java.util.Objects;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u00055\u0011AbQ;ti>lWM]&fsNT!a\u0001\u0003\u0002\u000f!,\u0017\rZ3sg*\u0011QAB\u0001\u0003gNR!a\u0002\u0005\u0002\u000f\u0005d\u0007/Y6lC*\u0011\u0011BC\u0001\u0007gR\u0014X-Y7\u000b\u0003-\tA!Y6lC\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\u0003\u0013\t\t\"A\u0001\u000bTKJ4XM]*jI\u0016,en\u0019:zaRLwN\u001c\u0005\t'\u0001\u0011)\u0019!C\u0001)\u0005\u00191.Z=\u0016\u0003U\u0001\"AF\u0010\u000f\u0005]i\u0002C\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\r\u0003\u0019a$o\\8u})\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\u00051\u0001K]3eK\u001aL!\u0001I\u0011\u0003\rM#(/\u001b8h\u0015\tq2\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u0011YW-\u001f\u0011\t\u0011\u0015\u0002!Q1A\u0005\u0002\u0019\n1!\u001c36+\u00059\u0003c\u0001\u0015*+5\t1$\u0003\u0002+7\t1q\n\u001d;j_:D\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0005[\u0012,\u0004\u0005\u0003\u0004/\u0001\u0011\u0005!aL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007A\n$\u0007\u0005\u0002\u0010\u0001!)1#\fa\u0001+!9Q%\fI\u0001\u0002\u00049\u0003BB\u0002\u0001\t\u0003\"A'F\u00016!\r14(P\u0007\u0002o)\u0011\u0001(O\u0001\nS6lW\u000f^1cY\u0016T!AO\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002=o\t\u00191+Z9\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015!B7pI\u0016d'B\u0001\"D\u0003!\u00198-\u00197bINd'B\u0001#\u000b\u0003\u0011AG\u000f\u001e9\n\u0005\u0019{$A\u0003%uiBDU-\u00193fe\"\u00121\u0007\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017*\t!\"\u00198o_R\fG/[8o\u0013\ti%JA\u0006J]R,'O\\1m\u0003BL\u0007BB(\u0001\t\u0003\"\u0001+\u0001\u0006iK\u0006$WM]:G_J$\"!N)\t\u000bIs\u0005\u0019A*\u0002\u000fI,\u0017/^3tiB\u0011AkV\u0007\u0002+*\u0011a\u000bB\u0001\u0005S6\u0004H.\u0003\u0002Y+\nI1k\r*fcV,7\u000f\u001e\u0015\u0003\u001d\"CQa\u0017\u0001\u0005\u0002q\u000bqa^5uQ.+\u0017\u0010\u0006\u00021;\")1C\u0017a\u0001+!)q\f\u0001C\u0001A\u00069q/\u001b;i\u001b\u0012,DC\u0001\u0019b\u0011\u0015)c\f1\u0001\u0016\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0003\u0011\u0019w\u000e]=\u0015\u0007A*g\rC\u0004\u0014EB\u0005\t\u0019A\u000b\t\u000f\u0015\u0012\u0007\u0013!a\u0001O!)\u0001\u000e\u0001C!S\u0006AAo\\*ue&tw\rF\u0001k!\tY\u0007/D\u0001m\u0015\tig.\u0001\u0003mC:<'\"A8\u0002\t)\fg/Y\u0005\u0003A1DQA\u001d\u0001\u0005BM\fa!Z9vC2\u001cHC\u0001;x!\tAS/\u0003\u0002w7\t9!i\\8mK\u0006t\u0007\"\u0002=r\u0001\u0004I\u0018!B8uQ\u0016\u0014\bC\u0001\u0015{\u0013\tY8DA\u0002B]fDQ! \u0001\u0005By\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u007fB\u0019\u0001&!\u0001\n\u0007\u0005\r1DA\u0002J]RD\u0011\"a\u0002\u0001#\u0003%I!!\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0002\u0016\u0004+\u000551FAA\b!\u0011\t\t\"!\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005-[\u0012\u0002BA\u000e\u0003'\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ty\u0002AI\u0001\n\u0013\t\t#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r\"fA\u0014\u0002\u000e\u001dI\u0011q\u0005\u0002\u0002\u0002#\u0005\u0011\u0011F\u0001\r\u0007V\u001cHo\\7fe.+\u0017p\u001d\t\u0004\u001f\u0005-b\u0001C\u0001\u0003\u0003\u0003E\t!!\f\u0014\t\u0005-\u0012q\u0006\t\u0004Q\u0005E\u0012bAA\u001a7\t1\u0011I\\=SK\u001aDqALA\u0016\t\u0003\t9\u0004\u0006\u0002\u0002*!Y\u00111HA\u0016#\u0003%\tAAA\u0011\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0001")
public final class CustomerKeys
extends ServerSideEncryption {
    private final String key;
    private final Option<String> md5;

    public String key() {
        return this.key;
    }

    public Option<String> md5() {
        return this.md5;
    }

    @Override
    @InternalApi
    public Seq<HttpHeader> headers() {
        RawHeader rawHeader = new RawHeader("x-amz-server-side-encryption-customer-algorithm", "AES256");
        RawHeader rawHeader2 = new RawHeader("x-amz-server-side-encryption-customer-key", this.key());
        RawHeader rawHeader3 = new RawHeader("x-amz-server-side-encryption-customer-key-MD5", (String)this.md5().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            byte[] decodedKey = Base64.decode((String)this.key());
            String md5 = Md5Utils.md5AsBase64((byte[])decodedKey);
            return var2_2;
        }));
        return Nil$.MODULE$.$colon$colon((Object)rawHeader3).$colon$colon((Object)rawHeader2).$colon$colon((Object)rawHeader);
    }

    @Override
    @InternalApi
    public Seq<HttpHeader> headersFor(S3Request request) {
        Nil$ nil$;
        S3Request s3Request = request;
        boolean bl = GetObject$.MODULE$.equals(s3Request) ? true : (HeadObject$.MODULE$.equals(s3Request) ? true : (PutObject$.MODULE$.equals(s3Request) ? true : (InitiateMultipartUpload$.MODULE$.equals(s3Request) ? true : UploadPart$.MODULE$.equals(s3Request))));
        if (bl) {
            nil$ = this.headers();
        } else if (CopyPart$.MODULE$.equals(s3Request)) {
            RawHeader rawHeader = new RawHeader("x-amz-copy-source-server-side-encryption-customer-algorithm", "AES256");
            RawHeader rawHeader2 = new RawHeader("x-amz-copy-source-server-side-encryption-customer-key", this.key());
            RawHeader rawHeader3 = new RawHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", (String)this.md5().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                void var2_2;
                byte[] decodedKey = Base64.decode((String)this.key());
                String md5 = Md5Utils.md5AsBase64((byte[])decodedKey);
                return var2_2;
            }));
            List copyHeaders = Nil$.MODULE$.$colon$colon((Object)rawHeader3).$colon$colon((Object)rawHeader2).$colon$colon((Object)rawHeader);
            Seq<HttpHeader> seq = this.headers();
            nil$ = (Seq)copyHeaders.$plus$plus$colon(seq, List$.MODULE$.canBuildFrom());
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public CustomerKeys withKey(String key) {
        return this.copy(key, this.copy$default$2());
    }

    public CustomerKeys withMd5(String md5) {
        Some x$13 = new Some((Object)md5);
        String x$14 = this.copy$default$1();
        return this.copy(x$14, (Option<String>)x$13);
    }

    private CustomerKeys copy(String key, Option<String> md5) {
        return new CustomerKeys(key, md5);
    }

    private String copy$default$1() {
        return this.key();
    }

    private Option<String> copy$default$2() {
        return this.md5();
    }

    public String toString() {
        return new StringBuilder(35).append("ServerSideEncryption.CustomerKeys(").append(new StringBuilder(5).append("key=").append(this.key()).append(",").toString()).append(new StringBuilder(4).append("md5=").append(this.md5()).toString()).append(")").toString();
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof CustomerKeys) {
            CustomerKeys customerKeys = (CustomerKeys)object;
            bl = Objects.equals(this.key(), customerKeys.key()) && Objects.equals(this.md5(), customerKeys.md5());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Objects.hash(this.key(), this.md5());
    }

    public CustomerKeys(String key, Option<String> md5) {
        this.key = key;
        this.md5 = md5;
    }
}

