/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.javadsl;

import akka.Done;
import akka.Done$;
import akka.NotUsed;
import akka.http.javadsl.model.ContentType;
import akka.http.javadsl.model.ContentTypes;
import akka.http.javadsl.model.HttpMethods;
import akka.http.javadsl.model.HttpResponse;
import akka.http.javadsl.model.headers.ByteRange;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.japi.Pair;
import akka.japi.function.Function;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.Materializer;
import akka.stream.alpakka.s3.BucketAccess;
import akka.stream.alpakka.s3.ListBucketResultContents;
import akka.stream.alpakka.s3.MultipartUploadResult;
import akka.stream.alpakka.s3.ObjectMetadata;
import akka.stream.alpakka.s3.S3Headers;
import akka.stream.alpakka.s3.S3Headers$;
import akka.stream.alpakka.s3.headers.CannedAcl$;
import akka.stream.alpakka.s3.headers.ServerSideEncryption;
import akka.stream.alpakka.s3.impl.S3Location;
import akka.stream.alpakka.s3.impl.S3Stream$;
import akka.stream.javadsl.RunnableGraph;
import akka.stream.javadsl.RunnableGraph$;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;

public final class S3$ {
    public static S3$ MODULE$;

    static {
        new S3$();
    }

    public Source<HttpResponse, NotUsed> request(String bucket, String key, akka.http.javadsl.model.HttpMethod method, S3Headers s3Headers) {
        return this.request(bucket, key, Optional.empty(), method, s3Headers);
    }

    public Source<HttpResponse, NotUsed> request(String bucket, String key, Optional<String> versionId2, akka.http.javadsl.model.HttpMethod method, S3Headers s3Headers) {
        S3Location x$6 = new S3Location(bucket, key);
        HttpMethod x$7 = (HttpMethod)method;
        Option x$8 = Option$.MODULE$.apply(versionId2.orElse(null));
        Seq<HttpHeader> x$9 = s3Headers.headers();
        Option<akka.http.scaladsl.model.headers.ByteRange> x$10 = S3Stream$.MODULE$.request$default$3();
        return ((akka.stream.scaladsl.Source)S3Stream$.MODULE$.request(x$6, x$7, x$10, (Option<String>)x$8, x$9).map((Function1 & Serializable & scala.Serializable)v -> v)).asJava();
    }

    public akka.http.javadsl.model.HttpMethod request$default$4() {
        return HttpMethods.GET;
    }

    public S3Headers request$default$5() {
        return S3Headers$.MODULE$.apply();
    }

    public Source<Optional<ObjectMetadata>, NotUsed> getObjectMetadata(String bucket, String key) {
        return this.getObjectMetadata(bucket, key, null);
    }

    public Source<Optional<ObjectMetadata>, NotUsed> getObjectMetadata(String bucket, String key, ServerSideEncryption sse) {
        return this.getObjectMetadata(bucket, key, Optional.empty(), sse);
    }

    public Source<Optional<ObjectMetadata>, NotUsed> getObjectMetadata(String bucket, String key, Optional<String> versionId2, ServerSideEncryption sse) {
        return ((akka.stream.scaladsl.Source)S3Stream$.MODULE$.getObjectMetadata(bucket, key, (Option<String>)Option$.MODULE$.apply(versionId2.orElse(null)), (Option<ServerSideEncryption>)Option$.MODULE$.apply((Object)sse)).map((Function1 & Serializable & scala.Serializable)opt -> Optional.ofNullable(opt.orNull(Predef$.MODULE$.$conforms())))).asJava();
    }

    public Source<Done, NotUsed> deleteObject(String bucket, String key) {
        return this.deleteObject(bucket, key, Optional.empty());
    }

    public Source<Done, NotUsed> deleteObject(String bucket, String key, Optional<String> versionId2) {
        return ((akka.stream.scaladsl.Source)S3Stream$.MODULE$.deleteObject(new S3Location(bucket, key), (Option<String>)Option$.MODULE$.apply(versionId2.orElse(null))).map((Function1 & Serializable & scala.Serializable)x$1 -> Done$.MODULE$.getInstance())).asJava();
    }

    public Source<Done, NotUsed> deleteObjectsByPrefix(String bucket) {
        return this.deleteObjectsByPrefix(bucket, Optional.empty());
    }

    public Source<Done, NotUsed> deleteObjectsByPrefix(String bucket, Optional<String> prefix) {
        return ((akka.stream.scaladsl.Source)S3Stream$.MODULE$.deleteObjectsByPrefix(bucket, (Option<String>)Option$.MODULE$.apply(prefix.orElse(null))).map((Function1 & Serializable & scala.Serializable)x$2 -> Done$.MODULE$.getInstance())).asJava();
    }

    public Source<ObjectMetadata, NotUsed> putObject(String bucket, String key, Source<ByteString, ?> data, long contentLength2, ContentType contentType2, S3Headers s3Headers) {
        return S3Stream$.MODULE$.putObject(new S3Location(bucket, key), (akka.http.scaladsl.model.ContentType)contentType2, data.asScala(), contentLength2, s3Headers).asJava();
    }

    public Source<ObjectMetadata, NotUsed> putObject(String bucket, String key, Source<ByteString, ?> data, long contentLength2, ContentType contentType2) {
        return this.putObject(bucket, key, data, contentLength2, contentType2, S3Headers$.MODULE$.apply().withCannedAcl(CannedAcl$.MODULE$.Private()));
    }

    public Source<ObjectMetadata, NotUsed> putObject(String bucket, String key, Source<ByteString, ?> data, long contentLength2) {
        return this.putObject(bucket, key, data, contentLength2, (ContentType)ContentTypes.APPLICATION_OCTET_STREAM);
    }

    private <M> Source<Optional<Pair<Source<ByteString, M>, ObjectMetadata>>, NotUsed> toJava(akka.stream.scaladsl.Source<Option<Tuple2<akka.stream.scaladsl.Source<ByteString, M>, ObjectMetadata>>, NotUsed> download2) {
        return ((akka.stream.scaladsl.Source)download2.map((Function1 & Serializable & scala.Serializable)x$3 -> OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(x$3.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            akka.stream.scaladsl.Source stream = (akka.stream.scaladsl.Source)tuple2._1();
            ObjectMetadata meta = (ObjectMetadata)tuple2._2();
            Pair pair = new Pair((Object)stream.asJava(), (Object)meta);
            return pair;
        }))))).asJava();
    }

    public Source<Optional<Pair<Source<ByteString, NotUsed>, ObjectMetadata>>, NotUsed> download(String bucket, String key) {
        return this.toJava(S3Stream$.MODULE$.download(new S3Location(bucket, key), (Option<akka.http.scaladsl.model.headers.ByteRange>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ServerSideEncryption>)None$.MODULE$));
    }

    public Source<Optional<Pair<Source<ByteString, NotUsed>, ObjectMetadata>>, NotUsed> download(String bucket, String key, ServerSideEncryption sse) {
        return this.toJava(S3Stream$.MODULE$.download(new S3Location(bucket, key), (Option<akka.http.scaladsl.model.headers.ByteRange>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ServerSideEncryption>)new Some((Object)sse)));
    }

    public Source<Optional<Pair<Source<ByteString, NotUsed>, ObjectMetadata>>, NotUsed> download(String bucket, String key, ByteRange range) {
        akka.http.scaladsl.model.headers.ByteRange scalaRange = (akka.http.scaladsl.model.headers.ByteRange)range;
        return this.toJava(S3Stream$.MODULE$.download(new S3Location(bucket, key), (Option<akka.http.scaladsl.model.headers.ByteRange>)new Some((Object)scalaRange), (Option<String>)None$.MODULE$, (Option<ServerSideEncryption>)None$.MODULE$));
    }

    public Source<Optional<Pair<Source<ByteString, NotUsed>, ObjectMetadata>>, NotUsed> download(String bucket, String key, ByteRange range, ServerSideEncryption sse) {
        akka.http.scaladsl.model.headers.ByteRange scalaRange = (akka.http.scaladsl.model.headers.ByteRange)range;
        return this.toJava(S3Stream$.MODULE$.download(new S3Location(bucket, key), (Option<akka.http.scaladsl.model.headers.ByteRange>)new Some((Object)scalaRange), (Option<String>)None$.MODULE$, (Option<ServerSideEncryption>)new Some((Object)sse)));
    }

    public Source<Optional<Pair<Source<ByteString, NotUsed>, ObjectMetadata>>, NotUsed> download(String bucket, String key, ByteRange range, Optional<String> versionId2, ServerSideEncryption sse) {
        akka.http.scaladsl.model.headers.ByteRange scalaRange = (akka.http.scaladsl.model.headers.ByteRange)range;
        return this.toJava(S3Stream$.MODULE$.download(new S3Location(bucket, key), (Option<akka.http.scaladsl.model.headers.ByteRange>)Option$.MODULE$.apply((Object)scalaRange), (Option<String>)Option$.MODULE$.apply(versionId2.orElse(null)), (Option<ServerSideEncryption>)Option$.MODULE$.apply((Object)sse)));
    }

    public Source<ListBucketResultContents, NotUsed> listBucket(String bucket, Option<String> prefix) {
        return S3Stream$.MODULE$.listBucket(bucket, prefix).asJava();
    }

    public Sink<ByteString, CompletionStage<MultipartUploadResult>> multipartUpload(String bucket, String key, ContentType contentType2, S3Headers s3Headers) {
        return S3Stream$.MODULE$.multipartUpload(new S3Location(bucket, key), (akka.http.scaladsl.model.ContentType)contentType2, s3Headers, S3Stream$.MODULE$.multipartUpload$default$4(), S3Stream$.MODULE$.multipartUpload$default$5()).mapMaterializedValue((Function1 & Serializable & scala.Serializable)x$4 -> FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(x$4))).asJava();
    }

    public Sink<ByteString, CompletionStage<MultipartUploadResult>> multipartUpload(String bucket, String key, ContentType contentType2) {
        return this.multipartUpload(bucket, key, contentType2, S3Headers$.MODULE$.apply().withCannedAcl(CannedAcl$.MODULE$.Private()));
    }

    public Sink<ByteString, CompletionStage<MultipartUploadResult>> multipartUpload(String bucket, String key) {
        return this.multipartUpload(bucket, key, (ContentType)ContentTypes.APPLICATION_OCTET_STREAM);
    }

    public RunnableGraph<CompletionStage<MultipartUploadResult>> multipartCopy(String sourceBucket, String sourceKey, String targetBucket, String targetKey, Optional<String> sourceVersionId, ContentType contentType2, S3Headers s3Headers) {
        return RunnableGraph$.MODULE$.fromGraph(S3Stream$.MODULE$.multipartCopy(new S3Location(sourceBucket, sourceKey), new S3Location(targetBucket, targetKey), (Option<String>)Option$.MODULE$.apply(sourceVersionId.orElse(null)), (akka.http.scaladsl.model.ContentType)contentType2, s3Headers, S3Stream$.MODULE$.multipartCopy$default$6(), S3Stream$.MODULE$.multipartCopy$default$7())).mapMaterializedValue(this.func((Function1 & Serializable & scala.Serializable)x$5 -> FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(x$5))));
    }

    public RunnableGraph<CompletionStage<MultipartUploadResult>> multipartCopy(String sourceBucket, String sourceKey, String targetBucket, String targetKey, Optional<String> sourceVersionId, S3Headers s3Headers) {
        return this.multipartCopy(sourceBucket, sourceKey, targetBucket, targetKey, sourceVersionId, (ContentType)ContentTypes.APPLICATION_OCTET_STREAM, s3Headers);
    }

    public RunnableGraph<CompletionStage<MultipartUploadResult>> multipartCopy(String sourceBucket, String sourceKey, String targetBucket, String targetKey, ContentType contentType2, S3Headers s3Headers) {
        return this.multipartCopy(sourceBucket, sourceKey, targetBucket, targetKey, Optional.empty(), contentType2, s3Headers);
    }

    public RunnableGraph<CompletionStage<MultipartUploadResult>> multipartCopy(String sourceBucket, String sourceKey, String targetBucket, String targetKey, S3Headers s3Headers) {
        return this.multipartCopy(sourceBucket, sourceKey, targetBucket, targetKey, (ContentType)ContentTypes.APPLICATION_OCTET_STREAM, s3Headers);
    }

    public RunnableGraph<CompletionStage<MultipartUploadResult>> multipartCopy(String sourceBucket, String sourceKey, String targetBucket, String targetKey) {
        return this.multipartCopy(sourceBucket, sourceKey, targetBucket, targetKey, (ContentType)ContentTypes.APPLICATION_OCTET_STREAM, S3Headers$.MODULE$.apply());
    }

    public CompletionStage<Done> makeBucket(String bucketName, Materializer materializer, Attributes attributes) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(S3Stream$.MODULE$.makeBucket(bucketName, materializer, attributes)));
    }

    public CompletionStage<Done> makeBucket(String bucketName, Materializer materializer) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(S3Stream$.MODULE$.makeBucket(bucketName, materializer, new Attributes(Attributes$.MODULE$.apply$default$1()))));
    }

    public Source<Done, NotUsed> makeBucketSource(String bucketName) {
        return S3Stream$.MODULE$.makeBucketSource(bucketName).asJava();
    }

    public CompletionStage<Done> deleteBucket(String bucketName, Materializer materializer, Attributes attributes) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(S3Stream$.MODULE$.deleteBucket(bucketName, materializer, attributes)));
    }

    public CompletionStage<Done> deleteBucket(String bucketName, Materializer materializer) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(S3Stream$.MODULE$.deleteBucket(bucketName, materializer, new Attributes(Attributes$.MODULE$.apply$default$1()))));
    }

    public Source<Done, NotUsed> deleteBucketSource(String bucketName) {
        return S3Stream$.MODULE$.deleteBucketSource(bucketName).asJava();
    }

    public CompletionStage<BucketAccess> checkIfBucketExists(String bucketName, Materializer materializer, Attributes attributes) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(S3Stream$.MODULE$.checkIfBucketExists(bucketName, materializer, attributes)));
    }

    public CompletionStage<BucketAccess> checkIfBucketExists(String bucketName, Materializer materializer) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(S3Stream$.MODULE$.checkIfBucketExists(bucketName, materializer, new Attributes(Attributes$.MODULE$.apply$default$1()))));
    }

    public Source<BucketAccess, NotUsed> checkIfBucketExistsSource(String bucketName) {
        return S3Stream$.MODULE$.checkIfBucketExistsSource(bucketName).asJava();
    }

    private <T, R> Function<T, R> func(Function1<T, R> f) {
        return new Function<T, R>(f){
            private final Function1 f$1;

            public R apply(T param) {
                return (R)this.f$1.apply(param);
            }
            {
                this.f$1 = f$1;
            }
        };
    }

    private S3$() {
        MODULE$ = this;
    }
}

