/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3;

import akka.actor.ActorSystem;
import akka.http.scaladsl.model.Uri$;
import akka.stream.alpakka.s3.ApiVersion;
import akka.stream.alpakka.s3.ApiVersion$ListBucketVersion1$;
import akka.stream.alpakka.s3.ApiVersion$ListBucketVersion2$;
import akka.stream.alpakka.s3.BufferType;
import akka.stream.alpakka.s3.DiskBufferType$;
import akka.stream.alpakka.s3.ForwardProxy;
import akka.stream.alpakka.s3.ForwardProxy$;
import akka.stream.alpakka.s3.ForwardProxyCredentials;
import akka.stream.alpakka.s3.ForwardProxyCredentials$;
import akka.stream.alpakka.s3.MemoryBufferType$;
import akka.stream.alpakka.s3.Proxy;
import akka.stream.alpakka.s3.Proxy$;
import akka.stream.alpakka.s3.S3Settings;
import akka.stream.alpakka.s3.S3Settings$;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class S3Settings$ {
    public static S3Settings$ MODULE$;
    private final String ConfigPath;

    static {
        new S3Settings$();
    }

    public String ConfigPath() {
        return this.ConfigPath;
    }

    public S3Settings apply(Config c) {
        DefaultAWSCredentialsProviderChain defaultAWSCredentialsProviderChain;
        Object object;
        None$ none$;
        BufferType bufferType;
        String string = c.getString("buffer");
        if ("memory".equals(string)) {
            bufferType = MemoryBufferType$.MODULE$;
        } else if ("disk".equals(string)) {
            String diskBufferPath = c.getString("disk-buffer-path");
            bufferType = DiskBufferType$.MODULE$.apply(Paths.get(diskBufferPath, new String[0]));
        } else {
            throw new IllegalArgumentException(new StringBuilder(47).append("Buffer type must be 'memory' or 'disk'. Got: [").append(string).append("]").toString());
        }
        MemoryBufferType$ bufferType2 = bufferType;
        Option maybeProxy = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> c.getString("proxy.host")).toOption().withFilter((Function1 & Serializable & scala.Serializable)host -> BoxesRunTime.boxToBoolean((boolean)S3Settings$.$anonfun$apply$2(host))).map((Function1 & Serializable & scala.Serializable)host -> Proxy$.MODULE$.apply((String)host, c.getInt("proxy.port"), Uri$.MODULE$.httpScheme(c.getBoolean("proxy.secure"))));
        if (c.hasPath("forward-proxy")) {
            None$ maybeCredentials = c.hasPath("forward-proxy.credentials") ? Option$.MODULE$.apply((Object)ForwardProxyCredentials$.MODULE$.apply(c.getString("forward-proxy.credentials.username"), c.getString("forward-proxy.credentials.password"))) : None$.MODULE$;
            none$ = Option$.MODULE$.apply((Object)ForwardProxy$.MODULE$.apply(c.getString("forward-proxy.host"), c.getInt("forward-proxy.port"), (Option<ForwardProxyCredentials>)maybeCredentials));
        } else {
            none$ = None$.MODULE$;
        }
        None$ maybeForwardProxy = none$;
        boolean pathStyleAccess = c.getBoolean("path-style-access");
        Option endpointUrl = c.hasPath("endpoint-url") ? Option$.MODULE$.apply((Object)c.getString("endpoint-url")) : None$.MODULE$.orElse((Function0 & Serializable & scala.Serializable)() -> maybeProxy.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(4).append(p.scheme()).append("://").append(p.host()).append(":").append(p.port()).toString()));
        String regionProviderPath = "aws.region.provider";
        AwsRegionProvider staticRegionProvider = new AwsRegionProvider(c){
            private String getRegion;
            private volatile boolean bitmap$0;
            private final Config c$1;

            private String getRegion$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.getRegion = this.c$1.getString("aws.region.default-region");
                        this.bitmap$0 = true;
                    }
                }
                this.c$1 = null;
                return this.getRegion;
            }

            public String getRegion() {
                return !this.bitmap$0 ? this.getRegion$lzycompute() : this.getRegion;
            }
            {
                this.c$1 = c$1;
            }
        };
        if (c.hasPath(regionProviderPath)) {
            String string2 = c.getString(regionProviderPath);
            Object object2 = "static".equals(string2) ? staticRegionProvider : new DefaultAwsRegionProviderChain();
            object = object2;
        } else {
            object = new DefaultAwsRegionProviderChain();
        }
        DefaultAwsRegionProviderChain regionProvider = object;
        String credProviderPath = "aws.credentials.provider";
        if (c.hasPath(credProviderPath)) {
            Object object3;
            String string3 = c.getString(credProviderPath);
            if ("default".equals(string3)) {
                object3 = DefaultAWSCredentialsProviderChain.getInstance();
            } else if ("static".equals(string3)) {
                String aki = c.getString("aws.credentials.access-key-id");
                String sak = c.getString("aws.credentials.secret-access-key");
                String tokenPath = "aws.credentials.token";
                BasicSessionCredentials creds = c.hasPath(tokenPath) ? new BasicSessionCredentials(aki, sak, c.getString(tokenPath)) : new BasicAWSCredentials(aki, sak);
                object3 = new AWSStaticCredentialsProvider((AWSCredentials)creds);
            } else {
                object3 = "anon".equals(string3) ? new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()) : DefaultAWSCredentialsProviderChain.getInstance();
            }
            defaultAWSCredentialsProviderChain = object3;
        } else {
            defaultAWSCredentialsProviderChain = DefaultAWSCredentialsProviderChain.getInstance();
        }
        DefaultAWSCredentialsProviderChain credentialsProvider = defaultAWSCredentialsProviderChain;
        ApiVersion apiVersion = (ApiVersion)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ApiVersion apiVersion;
            int n = c.getInt("list-bucket-api-version");
            switch (n) {
                case 1: {
                    apiVersion = ApiVersion$ListBucketVersion1$.MODULE$;
                    break;
                }
                case 2: {
                    apiVersion = ApiVersion$ListBucketVersion2$.MODULE$;
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            return apiVersion;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> ApiVersion$ListBucketVersion2$.MODULE$);
        return new S3Settings(bufferType2, (AWSCredentialsProvider)credentialsProvider, (AwsRegionProvider)regionProvider, pathStyleAccess, (Option<String>)endpointUrl, apiVersion, (Option<ForwardProxy>)maybeForwardProxy);
    }

    public S3Settings create(Config c) {
        return this.apply(c);
    }

    public S3Settings apply(BufferType bufferType, Option<Proxy> proxy, AWSCredentialsProvider credentialsProvider, AwsRegionProvider s3RegionProvider, boolean pathStyleAccess, Option<String> endpointUrl, ApiVersion listBucketApiVersion) {
        return new S3Settings(bufferType, credentialsProvider, s3RegionProvider, pathStyleAccess, endpointUrl, listBucketApiVersion, (Option<ForwardProxy>)None$.MODULE$);
    }

    public S3Settings apply(BufferType bufferType, AWSCredentialsProvider credentialsProvider, AwsRegionProvider s3RegionProvider, ApiVersion listBucketApiVersion) {
        return new S3Settings(bufferType, credentialsProvider, s3RegionProvider, false, (Option<String>)None$.MODULE$, listBucketApiVersion, (Option<ForwardProxy>)None$.MODULE$);
    }

    public S3Settings create(BufferType bufferType, Optional<Proxy> proxy, AWSCredentialsProvider credentialsProvider, AwsRegionProvider s3RegionProvider, boolean pathStyleAccess, Optional<String> endpointUrl, ApiVersion listBucketApiVersion) {
        return this.apply(bufferType, (Option<Proxy>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(proxy)), credentialsProvider, s3RegionProvider, pathStyleAccess, (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(endpointUrl)), listBucketApiVersion);
    }

    public S3Settings create(BufferType bufferType, AWSCredentialsProvider credentialsProvider, AwsRegionProvider s3RegionProvider, ApiVersion listBucketApiVersion) {
        return this.apply(bufferType, credentialsProvider, s3RegionProvider, listBucketApiVersion);
    }

    public S3Settings apply(ActorSystem system) {
        return this.apply(system.settings().config().getConfig(this.ConfigPath()));
    }

    public S3Settings create(ActorSystem system) {
        return this.apply(system);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(String host) {
        return new StringOps(Predef$.MODULE$.augmentString(host)).nonEmpty();
    }

    private S3Settings$() {
        MODULE$ = this;
        this.ConfigPath = "alpakka.s3";
    }
}

