/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.scaladsl;

import akka.Done;
import akka.NotUsed;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.headers.ByteRange;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.Materializer;
import akka.stream.alpakka.s3.BucketAccess;
import akka.stream.alpakka.s3.ListBucketResultContents;
import akka.stream.alpakka.s3.MetaHeaders;
import akka.stream.alpakka.s3.MetaHeaders$;
import akka.stream.alpakka.s3.MultipartUploadResult;
import akka.stream.alpakka.s3.ObjectMetadata;
import akka.stream.alpakka.s3.S3Headers;
import akka.stream.alpakka.s3.S3Headers$;
import akka.stream.alpakka.s3.headers.CannedAcl;
import akka.stream.alpakka.s3.headers.CannedAcl$;
import akka.stream.alpakka.s3.headers.ServerSideEncryption;
import akka.stream.alpakka.s3.impl.S3Location;
import akka.stream.alpakka.s3.impl.S3Stream$;
import akka.stream.scaladsl.RunnableGraph;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;

public final class S3$ {
    public static S3$ MODULE$;
    private final int MinChunkSize;

    static {
        new S3$();
    }

    public int MinChunkSize() {
        return this.MinChunkSize;
    }

    public Source<HttpResponse, NotUsed> request(String bucket, String key, HttpMethod method, Option<String> versionId2, S3Headers s3Headers) {
        S3Location x$1 = new S3Location(bucket, key);
        HttpMethod x$2 = method;
        Option<String> x$3 = versionId2;
        scala.collection.immutable.Seq<HttpHeader> x$4 = s3Headers.headers();
        Option<ByteRange> x$5 = S3Stream$.MODULE$.request$default$3();
        return S3Stream$.MODULE$.request(x$1, x$2, x$5, x$3, x$4);
    }

    public HttpMethod request$default$3() {
        return HttpMethods$.MODULE$.GET();
    }

    public Option<String> request$default$4() {
        return None$.MODULE$;
    }

    public S3Headers request$default$5() {
        return S3Headers$.MODULE$.apply();
    }

    public Source<Option<ObjectMetadata>, NotUsed> getObjectMetadata(String bucket, String key, Option<String> versionId2, Option<ServerSideEncryption> sse) {
        return S3Stream$.MODULE$.getObjectMetadata(bucket, key, versionId2, sse);
    }

    public Option<String> getObjectMetadata$default$3() {
        return None$.MODULE$;
    }

    public Option<ServerSideEncryption> getObjectMetadata$default$4() {
        return None$.MODULE$;
    }

    public Source<Done, NotUsed> deleteObject(String bucket, String key, Option<String> versionId2) {
        return S3Stream$.MODULE$.deleteObject(new S3Location(bucket, key), versionId2);
    }

    public Option<String> deleteObject$default$3() {
        return None$.MODULE$;
    }

    public Source<Done, NotUsed> deleteObjectsByPrefix(String bucket, Option<String> prefix) {
        return S3Stream$.MODULE$.deleteObjectsByPrefix(bucket, prefix);
    }

    public Source<ObjectMetadata, NotUsed> putObject(String bucket, String key, Source<ByteString, ?> data, long contentLength2, ContentType contentType2, S3Headers s3Headers) {
        return S3Stream$.MODULE$.putObject(new S3Location(bucket, key), contentType2, data, contentLength2, s3Headers);
    }

    public ContentType putObject$default$5() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public Source<Option<Tuple2<Source<ByteString, NotUsed>, ObjectMetadata>>, NotUsed> download(String bucket, String key, Option<ByteRange> range, Option<String> versionId2, Option<ServerSideEncryption> sse) {
        return S3Stream$.MODULE$.download(new S3Location(bucket, key), range, versionId2, sse);
    }

    public Option<ByteRange> download$default$3() {
        return None$.MODULE$;
    }

    public Option<String> download$default$4() {
        return None$.MODULE$;
    }

    public Option<ServerSideEncryption> download$default$5() {
        return None$.MODULE$;
    }

    public Source<ListBucketResultContents, NotUsed> listBucket(String bucket, Option<String> prefix) {
        return S3Stream$.MODULE$.listBucket(bucket, prefix);
    }

    public Sink<ByteString, Future<MultipartUploadResult>> multipartUpload(String bucket, String key, ContentType contentType2, MetaHeaders metaHeaders, CannedAcl cannedAcl, int chunkSize, int chunkingParallelism, Option<ServerSideEncryption> sse) {
        S3Headers s3Headers = S3Headers$.MODULE$.apply().withCannedAcl(cannedAcl).withMetaHeaders(metaHeaders);
        return S3Stream$.MODULE$.multipartUpload(new S3Location(bucket, key), contentType2, (S3Headers)sse.map((Function1 & Serializable & scala.Serializable)serverSideEncryption -> s3Headers.withServerSideEncryption((ServerSideEncryption)serverSideEncryption)).getOrElse((Function0 & Serializable & scala.Serializable)() -> s3Headers), chunkSize, chunkingParallelism);
    }

    public ContentType multipartUpload$default$3() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public MetaHeaders multipartUpload$default$4() {
        return MetaHeaders$.MODULE$.apply((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    public CannedAcl multipartUpload$default$5() {
        return CannedAcl$.MODULE$.Private();
    }

    public int multipartUpload$default$6() {
        return this.MinChunkSize();
    }

    public int multipartUpload$default$7() {
        return 4;
    }

    public Option<ServerSideEncryption> multipartUpload$default$8() {
        return None$.MODULE$;
    }

    public Sink<ByteString, Future<MultipartUploadResult>> multipartUploadWithHeaders(String bucket, String key, ContentType contentType2, int chunkSize, int chunkingParallelism, S3Headers s3Headers) {
        return S3Stream$.MODULE$.multipartUpload(new S3Location(bucket, key), contentType2, s3Headers, chunkSize, chunkingParallelism);
    }

    public ContentType multipartUploadWithHeaders$default$3() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public int multipartUploadWithHeaders$default$4() {
        return this.MinChunkSize();
    }

    public int multipartUploadWithHeaders$default$5() {
        return 4;
    }

    public S3Headers multipartUploadWithHeaders$default$6() {
        return S3Headers$.MODULE$.apply();
    }

    public RunnableGraph<Future<MultipartUploadResult>> multipartCopy(String sourceBucket, String sourceKey, String targetBucket, String targetKey, Option<String> sourceVersionId, ContentType contentType2, S3Headers s3Headers, int chunkSize, int chunkingParallelism) {
        return S3Stream$.MODULE$.multipartCopy(new S3Location(sourceBucket, sourceKey), new S3Location(targetBucket, targetKey), sourceVersionId, contentType2, s3Headers, chunkSize, chunkingParallelism);
    }

    public Option<String> multipartCopy$default$5() {
        return None$.MODULE$;
    }

    public ContentType multipartCopy$default$6() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public S3Headers multipartCopy$default$7() {
        return S3Headers$.MODULE$.apply();
    }

    public int multipartCopy$default$8() {
        return this.MinChunkSize();
    }

    public int multipartCopy$default$9() {
        return 4;
    }

    public Future<Done> makeBucket(String bucketName, Materializer mat, Attributes attr) {
        return S3Stream$.MODULE$.makeBucket(bucketName, mat, attr);
    }

    public Attributes makeBucket$default$3(String bucketName) {
        return new Attributes(Attributes$.MODULE$.apply$default$1());
    }

    public Source<Done, NotUsed> makeBucketSource(String bucketName) {
        return S3Stream$.MODULE$.makeBucketSource(bucketName);
    }

    public Future<Done> deleteBucket(String bucketName, Materializer mat, Attributes attributes) {
        return S3Stream$.MODULE$.deleteBucket(bucketName, mat, attributes);
    }

    public Attributes deleteBucket$default$3(String bucketName) {
        return new Attributes(Attributes$.MODULE$.apply$default$1());
    }

    public Source<Done, NotUsed> deleteBucketSource(String bucketName) {
        return S3Stream$.MODULE$.deleteBucketSource(bucketName);
    }

    public Future<BucketAccess> checkIfBucketExists(String bucketName, Materializer mat, Attributes attributes) {
        return S3Stream$.MODULE$.checkIfBucketExists(bucketName, mat, attributes);
    }

    public Attributes checkIfBucketExists$default$3(String bucketName) {
        return new Attributes(Attributes$.MODULE$.apply$default$1());
    }

    public Source<BucketAccess, NotUsed> checkIfBucketExistsSource(String bucketName) {
        return S3Stream$.MODULE$.checkIfBucketExistsSource(bucketName);
    }

    private S3$() {
        MODULE$ = this;
        this.MinChunkSize = 0x500000;
    }
}

