/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.headers;

import akka.annotation.InternalApi;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.stream.alpakka.s3.headers.ServerSideEncryption;
import akka.stream.alpakka.s3.impl.CopyPart$;
import akka.stream.alpakka.s3.impl.GetObject$;
import akka.stream.alpakka.s3.impl.HeadObject$;
import akka.stream.alpakka.s3.impl.InitiateMultipartUpload$;
import akka.stream.alpakka.s3.impl.PutObject$;
import akka.stream.alpakka.s3.impl.S3Request;
import akka.stream.alpakka.s3.impl.UploadPart$;
import java.io.Serializable;
import java.util.Objects;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.Md5Utils;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001\u0002\u000b\u0016\u0005\u0001B\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\ti\u0001\u0011\t\u0011)A\u0005O!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00038\u0011\u0019a\u0004\u0001\"\u0001\u0016{!1a\u0003\u0001C!/\u0005Caa\u0017\u0001\u0005B]a\u0006\"\u00024\u0001\t\u00039\u0007\"B5\u0001\t\u0003Q\u0007\"\u00027\u0001\t\u0013i\u0007b\u00029\u0001#\u0003%I!\u001d\u0005\bw\u0002\t\n\u0011\"\u0003}\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!a\t\u0001\t\u0003\n)cB\u0005\u0002.U\t\t\u0011#\u0001\u00020\u0019AA#FA\u0001\u0012\u0003\t\t\u0004\u0003\u0004=#\u0011\u0005\u0011\u0011\b\u0005\n\u0003w\t\u0012\u0013!C\u0001+q\u0014AbQ;ti>lWM]&fsNT!AF\f\u0002\u000f!,\u0017\rZ3sg*\u0011\u0001$G\u0001\u0003gNR!AG\u000e\u0002\u000f\u0005d\u0007/Y6lC*\u0011A$H\u0001\u0007gR\u0014X-Y7\u000b\u0003y\tA!Y6lC\u000e\u00011C\u0001\u0001\"!\t\u00113%D\u0001\u0016\u0013\t!SC\u0001\u000bTKJ4XM]*jI\u0016,en\u0019:zaRLwN\\\u0001\u0004W\u0016LX#A\u0014\u0011\u0005!\ndBA\u00150!\tQS&D\u0001,\u0015\tas$\u0001\u0004=e>|GO\u0010\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'L\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021[\u0005!1.Z=!\u0003\riG-N\u000b\u0002oA\u0019\u0001(O\u0014\u000e\u00035J!AO\u0017\u0003\r=\u0003H/[8o\u0003\u0011iG-\u000e\u0011\u0002\rqJg.\u001b;?)\rqt\b\u0011\t\u0003E\u0001AQ!J\u0003A\u0002\u001dBq!N\u0003\u0011\u0002\u0003\u0007q'F\u0001C!\r\u0019\u0005JS\u0007\u0002\t*\u0011QIR\u0001\nS6lW\u000f^1cY\u0016T!aR\u0017\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002J\t\n\u00191+Z9\u0011\u0005-\u0013V\"\u0001'\u000b\u00055s\u0015!B7pI\u0016d'BA(Q\u0003!\u00198-\u00197bINd'BA)\u001e\u0003\u0011AG\u000f\u001e9\n\u0005Mc%A\u0003%uiBDU-\u00193fe\"\u0012a!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031v\t!\"\u00198o_R\fG/[8o\u0013\tQvKA\u0006J]R,'O\\1m\u0003BL\u0017A\u00035fC\u0012,'o\u001d$peR\u0011!)\u0018\u0005\u0006=\u001e\u0001\raX\u0001\be\u0016\fX/Z:u!\t\u00017-D\u0001b\u0015\t\u0011w#\u0001\u0003j[Bd\u0017B\u00013b\u0005%\u00196GU3rk\u0016\u001cH\u000f\u000b\u0002\b+\u00069q/\u001b;i\u0017\u0016LHC\u0001 i\u0011\u0015)\u0003\u00021\u0001(\u0003\u001d9\u0018\u000e\u001e5NIV\"\"AP6\t\u000bUJ\u0001\u0019A\u0014\u0002\t\r|\u0007/\u001f\u000b\u0004}9|\u0007bB\u0013\u000b!\u0003\u0005\ra\n\u0005\bk)\u0001\n\u00111\u00018\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A\u001d\u0016\u0003OM\\\u0013\u0001\u001e\t\u0003kfl\u0011A\u001e\u0006\u0003ob\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005ak\u0013B\u0001>w\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0005i(FA\u001ct\u0003!!xn\u0015;sS:<GCAA\u0001!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tA\u0001\\1oO*\u0011\u00111B\u0001\u0005U\u00064\u0018-C\u00023\u0003\u000b\ta!Z9vC2\u001cH\u0003BA\n\u00033\u00012\u0001OA\u000b\u0013\r\t9\"\f\u0002\b\u0005>|G.Z1o\u0011\u001d\tYB\u0004a\u0001\u0003;\tQa\u001c;iKJ\u00042\u0001OA\u0010\u0013\r\t\t#\f\u0002\u0004\u0003:L\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u001d\u0002c\u0001\u001d\u0002*%\u0019\u00111F\u0017\u0003\u0007%sG/\u0001\u0007DkN$x.\\3s\u0017\u0016L8\u000f\u0005\u0002##M\u0019\u0011#a\r\u0011\u0007a\n)$C\u0002\u000285\u0012a!\u00118z%\u00164GCAA\u0018\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0001")
public final class CustomerKeys
extends ServerSideEncryption {
    private final String key;
    private final Option<String> md5;

    public String key() {
        return this.key;
    }

    public Option<String> md5() {
        return this.md5;
    }

    @Override
    @InternalApi
    public Seq<HttpHeader> headers() {
        RawHeader rawHeader = new RawHeader("x-amz-server-side-encryption-customer-algorithm", "AES256");
        RawHeader rawHeader2 = new RawHeader("x-amz-server-side-encryption-customer-key", this.key());
        RawHeader rawHeader3 = new RawHeader("x-amz-server-side-encryption-customer-key-MD5", (String)this.md5().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            byte[] decodedKey = BinaryUtils.fromBase64((String)this.key());
            String md5 = Md5Utils.md5AsBase64((byte[])decodedKey);
            return var2_2;
        }));
        return Nil$.MODULE$.$colon$colon((Object)rawHeader3).$colon$colon((Object)rawHeader2).$colon$colon((Object)rawHeader);
    }

    @Override
    @InternalApi
    public Seq<HttpHeader> headersFor(S3Request request) {
        Nil$ nil$;
        S3Request s3Request = request;
        boolean bl = GetObject$.MODULE$.equals(s3Request) ? true : (HeadObject$.MODULE$.equals(s3Request) ? true : (PutObject$.MODULE$.equals(s3Request) ? true : (InitiateMultipartUpload$.MODULE$.equals(s3Request) ? true : UploadPart$.MODULE$.equals(s3Request))));
        if (bl) {
            nil$ = this.headers();
        } else if (CopyPart$.MODULE$.equals(s3Request)) {
            RawHeader rawHeader = new RawHeader("x-amz-copy-source-server-side-encryption-customer-algorithm", "AES256");
            RawHeader rawHeader2 = new RawHeader("x-amz-copy-source-server-side-encryption-customer-key", this.key());
            RawHeader rawHeader3 = new RawHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", (String)this.md5().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                void var2_2;
                byte[] decodedKey = BinaryUtils.fromBase64((String)this.key());
                String md5 = Md5Utils.md5AsBase64((byte[])decodedKey);
                return var2_2;
            }));
            List copyHeaders = Nil$.MODULE$.$colon$colon((Object)rawHeader3).$colon$colon((Object)rawHeader2).$colon$colon((Object)rawHeader);
            Seq<HttpHeader> seq = this.headers();
            nil$ = (Seq)copyHeaders.$plus$plus$colon(seq, List$.MODULE$.canBuildFrom());
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public CustomerKeys withKey(String key) {
        return this.copy(key, this.copy$default$2());
    }

    public CustomerKeys withMd5(String md5) {
        Some x$1 = new Some((Object)md5);
        String x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<String>)x$1);
    }

    private CustomerKeys copy(String key, Option<String> md5) {
        return new CustomerKeys(key, md5);
    }

    private String copy$default$1() {
        return this.key();
    }

    private Option<String> copy$default$2() {
        return this.md5();
    }

    public String toString() {
        return new StringBuilder(44).append("ServerSideEncryption.CustomerKeys(").append("key=").append(this.key()).append(",").append("md5=").append(this.md5()).append(")").toString();
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof CustomerKeys) {
            CustomerKeys customerKeys = (CustomerKeys)object;
            bl = Objects.equals(this.key(), customerKeys.key()) && Objects.equals(this.md5(), customerKeys.md5());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Objects.hash(this.key(), this.md5());
    }

    public CustomerKeys(String key, Option<String> md5) {
        this.key = key;
        this.md5 = md5;
    }
}

