/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.scaladsl;

import akka.Done;
import akka.NotUsed;
import akka.actor.ClassicActorSystemProvider;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.headers.ByteRange;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.Materializer$;
import akka.stream.alpakka.s3.BucketAccess;
import akka.stream.alpakka.s3.CommonPrefixes;
import akka.stream.alpakka.s3.DeleteMarkers;
import akka.stream.alpakka.s3.ListBucketResultCommonPrefixes;
import akka.stream.alpakka.s3.ListBucketResultContents;
import akka.stream.alpakka.s3.ListBucketsResultContents;
import akka.stream.alpakka.s3.ListMultipartUploadResultUploads;
import akka.stream.alpakka.s3.ListObjectVersionsResultVersions;
import akka.stream.alpakka.s3.ListPartsResultParts;
import akka.stream.alpakka.s3.MetaHeaders;
import akka.stream.alpakka.s3.MetaHeaders$;
import akka.stream.alpakka.s3.MultipartUploadResult;
import akka.stream.alpakka.s3.ObjectMetadata;
import akka.stream.alpakka.s3.Part;
import akka.stream.alpakka.s3.S3Headers;
import akka.stream.alpakka.s3.S3Headers$;
import akka.stream.alpakka.s3.UploadPartResponse;
import akka.stream.alpakka.s3.headers.CannedAcl;
import akka.stream.alpakka.s3.headers.CannedAcl$;
import akka.stream.alpakka.s3.headers.ServerSideEncryption;
import akka.stream.alpakka.s3.impl.S3Location;
import akka.stream.alpakka.s3.impl.S3Stream$;
import akka.stream.scaladsl.RunnableGraph;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;

public final class S3$ {
    public static S3$ MODULE$;
    private final int MinChunkSize;

    static {
        new S3$();
    }

    public int MinChunkSize() {
        return this.MinChunkSize;
    }

    public Source<HttpResponse, NotUsed> request(String bucket, String key, HttpMethod method, Option<String> versionId2, S3Headers s3Headers) {
        S3Location x$1 = new S3Location(bucket, key);
        HttpMethod x$2 = method;
        Option<String> x$3 = versionId2;
        scala.collection.immutable.Seq<HttpHeader> x$4 = s3Headers.headers();
        Option<ByteRange> x$5 = S3Stream$.MODULE$.request$default$3();
        return S3Stream$.MODULE$.request(x$1, x$2, x$5, x$3, x$4);
    }

    public HttpMethod request$default$3() {
        return HttpMethods$.MODULE$.GET();
    }

    public Option<String> request$default$4() {
        return None$.MODULE$;
    }

    public S3Headers request$default$5() {
        return S3Headers$.MODULE$.empty();
    }

    public Source<Option<ObjectMetadata>, NotUsed> getObjectMetadata(String bucket, String key, Option<String> versionId2, Option<ServerSideEncryption> sse) {
        return this.getObjectMetadata(bucket, key, versionId2, S3Headers$.MODULE$.empty().withOptionalServerSideEncryption(sse));
    }

    public Source<Option<ObjectMetadata>, NotUsed> getObjectMetadata(String bucket, String key, Option<String> versionId2, S3Headers s3Headers) {
        return S3Stream$.MODULE$.getObjectMetadata(bucket, key, versionId2, s3Headers);
    }

    public Source<Done, NotUsed> deleteObject(String bucket, String key, Option<String> versionId2) {
        return this.deleteObject(bucket, key, versionId2, S3Headers$.MODULE$.empty());
    }

    public Source<Done, NotUsed> deleteObject(String bucket, String key, Option<String> versionId2, S3Headers s3Headers) {
        return S3Stream$.MODULE$.deleteObject(new S3Location(bucket, key), versionId2, s3Headers);
    }

    public Option<String> deleteObject$default$3() {
        return None$.MODULE$;
    }

    public Source<Done, NotUsed> deleteObjectsByPrefix(String bucket, Option<String> prefix) {
        return this.deleteObjectsByPrefix(bucket, prefix, S3Headers$.MODULE$.empty());
    }

    public Source<Done, NotUsed> deleteObjectsByPrefix(String bucket, Option<String> prefix, boolean deleteAllVersions) {
        return this.deleteObjectsByPrefix(bucket, prefix, deleteAllVersions, S3Headers$.MODULE$.empty());
    }

    public Source<Done, NotUsed> deleteObjectsByPrefix(String bucket, Option<String> prefix, S3Headers s3Headers) {
        return this.deleteObjectsByPrefix(bucket, prefix, false, s3Headers);
    }

    public Source<Done, NotUsed> deleteObjectsByPrefix(String bucket, Option<String> prefix, boolean deleteAllVersions, S3Headers s3Headers) {
        return S3Stream$.MODULE$.deleteObjectsByPrefix(bucket, prefix, deleteAllVersions, s3Headers);
    }

    public Source<Done, NotUsed> deleteBucketContents(String bucket) {
        return this.deleteObjectsByPrefix(bucket, (Option<String>)None$.MODULE$, S3Headers$.MODULE$.empty());
    }

    public Source<Done, NotUsed> deleteBucketContents(String bucket, boolean deleteAllVersions) {
        return this.deleteObjectsByPrefix(bucket, (Option<String>)None$.MODULE$, deleteAllVersions, S3Headers$.MODULE$.empty());
    }

    public Source<ObjectMetadata, NotUsed> putObject(String bucket, String key, Source<ByteString, ?> data, long contentLength2, ContentType contentType2, S3Headers s3Headers) {
        return S3Stream$.MODULE$.putObject(new S3Location(bucket, key), contentType2, data, contentLength2, s3Headers);
    }

    public ContentType putObject$default$5() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public Source<Option<Tuple2<Source<ByteString, NotUsed>, ObjectMetadata>>, NotUsed> download(String bucket, String key, Option<ByteRange> range, Option<String> versionId2, Option<ServerSideEncryption> sse) {
        return this.download(bucket, key, range, versionId2, S3Headers$.MODULE$.empty().withOptionalServerSideEncryption(sse));
    }

    public Source<Option<Tuple2<Source<ByteString, NotUsed>, ObjectMetadata>>, NotUsed> download(String bucket, String key, Option<ByteRange> range, Option<String> versionId2, S3Headers s3Headers) {
        return S3Stream$.MODULE$.download(new S3Location(bucket, key), range, versionId2, s3Headers);
    }

    public Option<ByteRange> download$default$3() {
        return None$.MODULE$;
    }

    public Option<String> download$default$4() {
        return None$.MODULE$;
    }

    public Option<ServerSideEncryption> download$default$5() {
        return None$.MODULE$;
    }

    public Source<ByteString, Future<ObjectMetadata>> getObject(String bucket, String key, Option<ByteRange> range, Option<String> versionId2, Option<ServerSideEncryption> sse) {
        return this.getObject(bucket, key, range, versionId2, S3Headers$.MODULE$.empty().withOptionalServerSideEncryption(sse));
    }

    public Source<ByteString, Future<ObjectMetadata>> getObject(String bucket, String key, Option<ByteRange> range, Option<String> versionId2, S3Headers s3Headers) {
        return S3Stream$.MODULE$.getObject(new S3Location(bucket, key), range, versionId2, s3Headers);
    }

    public Option<String> getObjectMetadata$default$3() {
        return None$.MODULE$;
    }

    public Option<ServerSideEncryption> getObjectMetadata$default$4() {
        return None$.MODULE$;
    }

    public Option<ByteRange> getObject$default$3() {
        return None$.MODULE$;
    }

    public Option<String> getObject$default$4() {
        return None$.MODULE$;
    }

    public Option<ServerSideEncryption> getObject$default$5() {
        return None$.MODULE$;
    }

    public Source<ListBucketsResultContents, NotUsed> listBuckets() {
        return this.listBuckets(S3Headers$.MODULE$.empty());
    }

    public Source<ListBucketsResultContents, NotUsed> listBuckets(S3Headers s3Headers) {
        return S3Stream$.MODULE$.listBuckets(s3Headers);
    }

    public Source<ListBucketResultContents, NotUsed> listBucket(String bucket, Option<String> prefix) {
        return this.listBucket(bucket, prefix, S3Headers$.MODULE$.empty());
    }

    public Source<ListBucketResultContents, NotUsed> listBucket(String bucket, Option<String> prefix, S3Headers s3Headers) {
        return S3Stream$.MODULE$.listBucket(bucket, prefix, s3Headers);
    }

    public Source<ListBucketResultContents, NotUsed> listBucket(String bucket, String delimiter, Option<String> prefix, S3Headers s3Headers) {
        return (Source)S3Stream$.MODULE$.listBucketAndCommonPrefixes(bucket, delimiter, prefix, s3Headers).mapConcat((Function1 & Serializable & scala.Serializable)x$1 -> (scala.collection.immutable.Seq)x$1._1());
    }

    public Option<String> listBucket$default$3() {
        return None$.MODULE$;
    }

    public S3Headers listBucket$default$4() {
        return S3Headers$.MODULE$.empty();
    }

    public Source<Tuple2<Seq<ListBucketResultContents>, Seq<ListBucketResultCommonPrefixes>>, NotUsed> listBucketAndCommonPrefixes(String bucket, String delimiter, Option<String> prefix, S3Headers s3Headers) {
        return S3Stream$.MODULE$.listBucketAndCommonPrefixes(bucket, delimiter, prefix, s3Headers);
    }

    public Option<String> listBucketAndCommonPrefixes$default$3() {
        return None$.MODULE$;
    }

    public S3Headers listBucketAndCommonPrefixes$default$4() {
        return S3Headers$.MODULE$.empty();
    }

    public Source<ListMultipartUploadResultUploads, NotUsed> listMultipartUpload(String bucket, Option<String> prefix) {
        return this.listMultipartUpload(bucket, prefix, S3Headers$.MODULE$.empty());
    }

    public Source<ListMultipartUploadResultUploads, NotUsed> listMultipartUpload(String bucket, Option<String> prefix, S3Headers s3Headers) {
        return S3Stream$.MODULE$.listMultipartUpload(bucket, prefix, s3Headers);
    }

    public Source<Tuple2<Seq<ListMultipartUploadResultUploads>, Seq<CommonPrefixes>>, NotUsed> listMultipartUploadAndCommonPrefixes(String bucket, String delimiter, Option<String> prefix, S3Headers s3Headers) {
        return S3Stream$.MODULE$.listMultipartUploadAndCommonPrefixes(bucket, delimiter, prefix, s3Headers);
    }

    public Option<String> listMultipartUploadAndCommonPrefixes$default$3() {
        return None$.MODULE$;
    }

    public S3Headers listMultipartUploadAndCommonPrefixes$default$4() {
        return S3Headers$.MODULE$.empty();
    }

    public Source<ListPartsResultParts, NotUsed> listParts(String bucket, String key, String uploadId) {
        return this.listParts(bucket, key, uploadId, S3Headers$.MODULE$.empty());
    }

    public Source<ListPartsResultParts, NotUsed> listParts(String bucket, String key, String uploadId, S3Headers s3Headers) {
        return S3Stream$.MODULE$.listParts(bucket, key, uploadId, s3Headers);
    }

    public Source<Tuple2<Seq<ListObjectVersionsResultVersions>, Seq<DeleteMarkers>>, NotUsed> listObjectVersions(String bucket, Option<String> prefix) {
        return S3Stream$.MODULE$.listObjectVersions(bucket, prefix, S3Headers$.MODULE$.empty());
    }

    public Source<Tuple2<Seq<ListObjectVersionsResultVersions>, Seq<DeleteMarkers>>, NotUsed> listObjectVersions(String bucket, Option<String> prefix, S3Headers s3Headers) {
        return S3Stream$.MODULE$.listObjectVersions(bucket, prefix, s3Headers);
    }

    public Source<Tuple2<Seq<ListObjectVersionsResultVersions>, Seq<DeleteMarkers>>, NotUsed> listObjectVersions(String bucket, String delimiter, Option<String> prefix, S3Headers s3Headers) {
        return (Source)S3Stream$.MODULE$.listObjectVersionsAndCommonPrefixes(bucket, delimiter, prefix, s3Headers).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                scala.collection.immutable.Seq versions = (scala.collection.immutable.Seq)tuple3._1();
                scala.collection.immutable.Seq markers = (scala.collection.immutable.Seq)tuple3._2();
                return new Tuple2((Object)versions, (Object)markers);
            }
            throw new MatchError((Object)tuple3);
        });
    }

    public Source<Tuple3<Seq<ListObjectVersionsResultVersions>, Seq<DeleteMarkers>, Seq<CommonPrefixes>>, NotUsed> listObjectVersionsAndCommonPrefixes(String bucket, String delimiter, Option<String> prefix, S3Headers s3Headers) {
        return S3Stream$.MODULE$.listObjectVersionsAndCommonPrefixes(bucket, delimiter, prefix, s3Headers);
    }

    public Sink<ByteString, Future<MultipartUploadResult>> multipartUpload(String bucket, String key, ContentType contentType2, MetaHeaders metaHeaders, CannedAcl cannedAcl, int chunkSize, int chunkingParallelism, Option<ServerSideEncryption> sse) {
        S3Headers headers = S3Headers$.MODULE$.empty().withCannedAcl(cannedAcl).withMetaHeaders(metaHeaders).withOptionalServerSideEncryption(sse);
        return this.multipartUploadWithHeaders(bucket, key, contentType2, chunkSize, chunkingParallelism, headers);
    }

    public ContentType multipartUpload$default$3() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public MetaHeaders multipartUpload$default$4() {
        return MetaHeaders$.MODULE$.apply((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    public CannedAcl multipartUpload$default$5() {
        return CannedAcl$.MODULE$.Private();
    }

    public int multipartUpload$default$6() {
        return this.MinChunkSize();
    }

    public int multipartUpload$default$7() {
        return 4;
    }

    public Option<ServerSideEncryption> multipartUpload$default$8() {
        return None$.MODULE$;
    }

    public Sink<ByteString, Future<MultipartUploadResult>> multipartUploadWithHeaders(String bucket, String key, ContentType contentType2, int chunkSize, int chunkingParallelism, S3Headers s3Headers) {
        return S3Stream$.MODULE$.multipartUpload(new S3Location(bucket, key), contentType2, s3Headers, chunkSize, chunkingParallelism);
    }

    public ContentType multipartUploadWithHeaders$default$3() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public int multipartUploadWithHeaders$default$4() {
        return this.MinChunkSize();
    }

    public int multipartUploadWithHeaders$default$5() {
        return 4;
    }

    public S3Headers multipartUploadWithHeaders$default$6() {
        return S3Headers$.MODULE$.empty();
    }

    public <C> Sink<Tuple2<ByteString, C>, Future<MultipartUploadResult>> multipartUploadWithContext(String bucket, String key, Sink<Tuple2<UploadPartResponse, Iterable<C>>, NotUsed> chunkUploadSink, ContentType contentType2, MetaHeaders metaHeaders, CannedAcl cannedAcl, int chunkSize, int chunkingParallelism, Option<ServerSideEncryption> sse) {
        S3Headers headers = S3Headers$.MODULE$.empty().withCannedAcl(cannedAcl).withMetaHeaders(metaHeaders).withOptionalServerSideEncryption(sse);
        return this.multipartUploadWithHeadersAndContext(bucket, key, chunkUploadSink, contentType2, chunkSize, chunkingParallelism, headers);
    }

    public <C> ContentType multipartUploadWithContext$default$4() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public <C> MetaHeaders multipartUploadWithContext$default$5() {
        return MetaHeaders$.MODULE$.apply((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    public <C> CannedAcl multipartUploadWithContext$default$6() {
        return CannedAcl$.MODULE$.Private();
    }

    public <C> int multipartUploadWithContext$default$7() {
        return this.MinChunkSize();
    }

    public <C> int multipartUploadWithContext$default$8() {
        return 4;
    }

    public <C> Option<ServerSideEncryption> multipartUploadWithContext$default$9() {
        return None$.MODULE$;
    }

    public <C> Sink<Tuple2<ByteString, C>, Future<MultipartUploadResult>> multipartUploadWithHeadersAndContext(String bucket, String key, Sink<Tuple2<UploadPartResponse, Iterable<C>>, NotUsed> chunkUploadSink, ContentType contentType2, int chunkSize, int chunkingParallelism, S3Headers s3Headers) {
        return S3Stream$.MODULE$.multipartUploadWithContext(new S3Location(bucket, key), chunkUploadSink, contentType2, s3Headers, chunkSize, chunkingParallelism);
    }

    public <C> ContentType multipartUploadWithHeadersAndContext$default$4() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public <C> int multipartUploadWithHeadersAndContext$default$5() {
        return this.MinChunkSize();
    }

    public <C> int multipartUploadWithHeadersAndContext$default$6() {
        return 4;
    }

    public <C> S3Headers multipartUploadWithHeadersAndContext$default$7() {
        return S3Headers$.MODULE$.empty();
    }

    public Sink<ByteString, Future<MultipartUploadResult>> resumeMultipartUpload(String bucket, String key, String uploadId, Iterable<Part> previousParts, ContentType contentType2, MetaHeaders metaHeaders, CannedAcl cannedAcl, int chunkSize, int chunkingParallelism, Option<ServerSideEncryption> sse) {
        S3Headers headers = S3Headers$.MODULE$.empty().withCannedAcl(cannedAcl).withMetaHeaders(metaHeaders).withOptionalServerSideEncryption(sse);
        return this.resumeMultipartUploadWithHeaders(bucket, key, uploadId, previousParts, contentType2, chunkSize, chunkingParallelism, headers);
    }

    public ContentType resumeMultipartUpload$default$5() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public MetaHeaders resumeMultipartUpload$default$6() {
        return MetaHeaders$.MODULE$.apply((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    public CannedAcl resumeMultipartUpload$default$7() {
        return CannedAcl$.MODULE$.Private();
    }

    public int resumeMultipartUpload$default$8() {
        return this.MinChunkSize();
    }

    public int resumeMultipartUpload$default$9() {
        return 4;
    }

    public Option<ServerSideEncryption> resumeMultipartUpload$default$10() {
        return None$.MODULE$;
    }

    public <C> Sink<Tuple2<ByteString, C>, Future<MultipartUploadResult>> resumeMultipartUploadWithContext(String bucket, String key, String uploadId, Iterable<Part> previousParts, Sink<Tuple2<UploadPartResponse, Iterable<C>>, NotUsed> chunkUploadSink, ContentType contentType2, MetaHeaders metaHeaders, CannedAcl cannedAcl, int chunkSize, int chunkingParallelism, Option<ServerSideEncryption> sse) {
        S3Headers headers = S3Headers$.MODULE$.empty().withCannedAcl(cannedAcl).withMetaHeaders(metaHeaders).withOptionalServerSideEncryption(sse);
        return this.resumeMultipartUploadWithHeadersAndContext(bucket, key, uploadId, previousParts, chunkUploadSink, contentType2, chunkSize, chunkingParallelism, headers);
    }

    public <C> ContentType resumeMultipartUploadWithContext$default$6() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public <C> MetaHeaders resumeMultipartUploadWithContext$default$7() {
        return MetaHeaders$.MODULE$.apply((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    public <C> CannedAcl resumeMultipartUploadWithContext$default$8() {
        return CannedAcl$.MODULE$.Private();
    }

    public <C> int resumeMultipartUploadWithContext$default$9() {
        return this.MinChunkSize();
    }

    public <C> int resumeMultipartUploadWithContext$default$10() {
        return 4;
    }

    public <C> Option<ServerSideEncryption> resumeMultipartUploadWithContext$default$11() {
        return None$.MODULE$;
    }

    public Sink<ByteString, Future<MultipartUploadResult>> resumeMultipartUploadWithHeaders(String bucket, String key, String uploadId, Iterable<Part> previousParts, ContentType contentType2, int chunkSize, int chunkingParallelism, S3Headers s3Headers) {
        return S3Stream$.MODULE$.resumeMultipartUpload(new S3Location(bucket, key), uploadId, previousParts, contentType2, s3Headers, chunkSize, chunkingParallelism);
    }

    public ContentType resumeMultipartUploadWithHeaders$default$5() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public int resumeMultipartUploadWithHeaders$default$6() {
        return this.MinChunkSize();
    }

    public int resumeMultipartUploadWithHeaders$default$7() {
        return 4;
    }

    public S3Headers resumeMultipartUploadWithHeaders$default$8() {
        return S3Headers$.MODULE$.empty();
    }

    public <C> Sink<Tuple2<ByteString, C>, Future<MultipartUploadResult>> resumeMultipartUploadWithHeadersAndContext(String bucket, String key, String uploadId, Iterable<Part> previousParts, Sink<Tuple2<UploadPartResponse, Iterable<C>>, NotUsed> chunkUploadSink, ContentType contentType2, int chunkSize, int chunkingParallelism, S3Headers s3Headers) {
        return S3Stream$.MODULE$.resumeMultipartUploadWithContext(new S3Location(bucket, key), uploadId, previousParts, chunkUploadSink, contentType2, s3Headers, chunkSize, chunkingParallelism);
    }

    public <C> ContentType resumeMultipartUploadWithHeadersAndContext$default$6() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public <C> int resumeMultipartUploadWithHeadersAndContext$default$7() {
        return this.MinChunkSize();
    }

    public <C> int resumeMultipartUploadWithHeadersAndContext$default$8() {
        return 4;
    }

    public <C> S3Headers resumeMultipartUploadWithHeadersAndContext$default$9() {
        return S3Headers$.MODULE$.empty();
    }

    public Future<MultipartUploadResult> completeMultipartUpload(String bucket, String key, String uploadId, Iterable<Part> parts, ClassicActorSystemProvider system, Attributes attributes) {
        return S3Stream$.MODULE$.completeMultipartUpload(new S3Location(bucket, key), uploadId, parts, S3Headers$.MODULE$.empty(), Materializer$.MODULE$.matFromSystem(system), attributes);
    }

    public Future<MultipartUploadResult> completeMultipartUpload(String bucket, String key, String uploadId, Iterable<Part> parts, S3Headers s3Headers, ClassicActorSystemProvider system, Attributes attributes) {
        return S3Stream$.MODULE$.completeMultipartUpload(new S3Location(bucket, key), uploadId, parts, s3Headers, Materializer$.MODULE$.matFromSystem(system), attributes);
    }

    public Attributes completeMultipartUpload$default$6(String bucket, String key, String uploadId, Iterable<Part> parts) {
        return Attributes$.MODULE$.apply();
    }

    public RunnableGraph<Future<MultipartUploadResult>> multipartCopy(String sourceBucket, String sourceKey, String targetBucket, String targetKey, Option<String> sourceVersionId, ContentType contentType2, S3Headers s3Headers, int chunkSize, int chunkingParallelism) {
        return S3Stream$.MODULE$.multipartCopy(new S3Location(sourceBucket, sourceKey), new S3Location(targetBucket, targetKey), sourceVersionId, contentType2, s3Headers, chunkSize, chunkingParallelism);
    }

    public Option<String> multipartCopy$default$5() {
        return None$.MODULE$;
    }

    public ContentType multipartCopy$default$6() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    public S3Headers multipartCopy$default$7() {
        return S3Headers$.MODULE$.empty();
    }

    public int multipartCopy$default$8() {
        return this.MinChunkSize();
    }

    public int multipartCopy$default$9() {
        return 4;
    }

    public Future<Done> makeBucket(String bucketName, ClassicActorSystemProvider system, Attributes attr) {
        return S3Stream$.MODULE$.makeBucket(bucketName, S3Headers$.MODULE$.empty(), Materializer$.MODULE$.matFromSystem(system), attr);
    }

    public Future<Done> makeBucket(String bucketName, S3Headers s3Headers, ClassicActorSystemProvider system, Attributes attr) {
        return S3Stream$.MODULE$.makeBucket(bucketName, s3Headers, Materializer$.MODULE$.matFromSystem(system), attr);
    }

    public Attributes makeBucket$default$3(String bucketName) {
        return Attributes$.MODULE$.apply();
    }

    public Source<Done, NotUsed> makeBucketSource(String bucketName) {
        return this.makeBucketSource(bucketName, S3Headers$.MODULE$.empty());
    }

    public Source<Done, NotUsed> makeBucketSource(String bucketName, S3Headers s3Headers) {
        return S3Stream$.MODULE$.makeBucketSource(bucketName, s3Headers);
    }

    public Future<Done> deleteBucket(String bucketName, ClassicActorSystemProvider system, Attributes attributes) {
        return S3Stream$.MODULE$.deleteBucket(bucketName, S3Headers$.MODULE$.empty(), Materializer$.MODULE$.matFromSystem(system), attributes);
    }

    public Future<Done> deleteBucket(String bucketName, S3Headers s3Headers, ClassicActorSystemProvider system, Attributes attributes) {
        return S3Stream$.MODULE$.deleteBucket(bucketName, s3Headers, Materializer$.MODULE$.matFromSystem(system), attributes);
    }

    public Attributes deleteBucket$default$3(String bucketName) {
        return Attributes$.MODULE$.apply();
    }

    public Source<Done, NotUsed> deleteBucketSource(String bucketName) {
        return this.deleteBucketSource(bucketName, S3Headers$.MODULE$.empty());
    }

    public Source<Done, NotUsed> deleteBucketSource(String bucketName, S3Headers s3Headers) {
        return S3Stream$.MODULE$.deleteBucketSource(bucketName, s3Headers);
    }

    public Future<BucketAccess> checkIfBucketExists(String bucketName, ClassicActorSystemProvider system, Attributes attributes) {
        return S3Stream$.MODULE$.checkIfBucketExists(bucketName, S3Headers$.MODULE$.empty(), Materializer$.MODULE$.matFromSystem(system), attributes);
    }

    public Future<BucketAccess> checkIfBucketExists(String bucketName, S3Headers s3Headers, ClassicActorSystemProvider system, Attributes attributes) {
        return S3Stream$.MODULE$.checkIfBucketExists(bucketName, s3Headers, Materializer$.MODULE$.matFromSystem(system), attributes);
    }

    public Attributes checkIfBucketExists$default$3(String bucketName) {
        return Attributes$.MODULE$.apply();
    }

    public Source<BucketAccess, NotUsed> checkIfBucketExistsSource(String bucketName) {
        return this.checkIfBucketExistsSource(bucketName, S3Headers$.MODULE$.empty());
    }

    public Source<BucketAccess, NotUsed> checkIfBucketExistsSource(String bucketName, S3Headers s3Headers) {
        return S3Stream$.MODULE$.checkIfBucketExistsSource(bucketName, s3Headers);
    }

    public Future<Done> deleteUpload(String bucketName, String key, String uploadId, ClassicActorSystemProvider system, Attributes attributes) {
        return this.deleteUpload(bucketName, key, uploadId, S3Headers$.MODULE$.empty(), system, attributes);
    }

    public Future<Done> deleteUpload(String bucketName, String key, String uploadId, S3Headers s3Headers, ClassicActorSystemProvider system, Attributes attributes) {
        return S3Stream$.MODULE$.deleteUpload(bucketName, key, uploadId, s3Headers, Materializer$.MODULE$.matFromSystem(system), attributes);
    }

    public Attributes deleteUpload$default$5(String bucketName, String key, String uploadId) {
        return Attributes$.MODULE$.apply();
    }

    public Source<Done, NotUsed> deleteUploadSource(String bucketName, String key, String uploadId) {
        return this.deleteUploadSource(bucketName, key, uploadId, S3Headers$.MODULE$.empty());
    }

    public Source<Done, NotUsed> deleteUploadSource(String bucketName, String key, String uploadId, S3Headers s3Headers) {
        return S3Stream$.MODULE$.deleteUploadSource(bucketName, key, uploadId, s3Headers);
    }

    private S3$() {
        MODULE$ = this;
        this.MinChunkSize = 0x500000;
    }
}

