/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.headers;

import akka.annotation.InternalApi;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.stream.alpakka.s3.headers.ServerSideEncryption;
import akka.stream.alpakka.s3.impl.InitiateMultipartUpload$;
import akka.stream.alpakka.s3.impl.PutObject$;
import akka.stream.alpakka.s3.impl.S3Request;
import java.io.Serializable;
import java.util.Objects;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015b\u0001\u0002\t\u0012\u0005qA\u0001\"\t\u0001\u0003\u0006\u0004%\tA\t\u0005\ta\u0001\u0011\t\u0011)A\u0005G!A\u0011\u0007\u0001BC\u0002\u0013\u0005!\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00034\u0011\u0019A\u0004\u0001\"\u0001\u0012s!1!\u0003\u0001C!'uBaa\u0016\u0001\u0005BMA\u0006\"\u00022\u0001\t\u0003\u0019\u0007\"B3\u0001\t\u00031\u0007\"\u00025\u0001\t\u0013I\u0007b\u00027\u0001#\u0003%I!\u001c\u0005\bo\u0002\t\n\u0011\"\u0003y\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\u0007\u0001\t\u0003\niBA\u0002L\u001bNS!AE\n\u0002\u000f!,\u0017\rZ3sg*\u0011A#F\u0001\u0003gNR!AF\f\u0002\u000f\u0005d\u0007/Y6lC*\u0011\u0001$G\u0001\u0007gR\u0014X-Y7\u000b\u0003i\tA!Y6lC\u000e\u00011C\u0001\u0001\u001e!\tqr$D\u0001\u0012\u0013\t\u0001\u0013C\u0001\u000bTKJ4XM]*jI\u0016,en\u0019:zaRLwN\\\u0001\u0006W\u0016L\u0018\nZ\u000b\u0002GA\u0011A%\f\b\u0003K-\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001K\u000e\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051J\u0013AB6fs&#\u0007%A\u0004d_:$X\r\u001f;\u0016\u0003M\u00022\u0001N\u001b$\u001b\u0005I\u0013B\u0001\u001c*\u0005\u0019y\u0005\u000f^5p]\u0006A1m\u001c8uKb$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004umb\u0004C\u0001\u0010\u0001\u0011\u0015\tS\u00011\u0001$\u0011\u0015\tT\u00011\u00014+\u0005q\u0004cA E\r6\t\u0001I\u0003\u0002B\u0005\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u0007&\n!bY8mY\u0016\u001cG/[8o\u0013\t)\u0005IA\u0002TKF\u0004\"a\u0012(\u000e\u0003!S!!\u0013&\u0002\u000b5|G-\u001a7\u000b\u0005-c\u0015\u0001C:dC2\fGm\u001d7\u000b\u00055K\u0012\u0001\u00025uiBL!a\u0014%\u0003\u0015!#H\u000f\u001d%fC\u0012,'\u000f\u000b\u0002\u0007#B\u0011!+V\u0007\u0002'*\u0011A+G\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001,T\u0005-Ie\u000e^3s]\u0006d\u0017\t]5\u0002\u0015!,\u0017\rZ3sg\u001a{'\u000f\u0006\u0002?3\")!l\u0002a\u00017\u00069!/Z9vKN$\bC\u0001/`\u001b\u0005i&B\u00010\u0014\u0003\u0011IW\u000e\u001d7\n\u0005\u0001l&!C*4%\u0016\fX/Z:uQ\t9\u0011+A\u0005xSRD7*Z=JIR\u0011!\b\u001a\u0005\u0006C!\u0001\raI\u0001\fo&$\bnQ8oi\u0016DH\u000f\u0006\u0002;O\")\u0011'\u0003a\u0001G\u0005!1m\u001c9z)\rQ$n\u001b\u0005\bC)\u0001\n\u00111\u0001$\u0011\u001d\t$\u0002%AA\u0002M\nabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001oU\t\u0019snK\u0001q!\t\tX/D\u0001s\u0015\t\u0019H/A\u0005v]\u000eDWmY6fI*\u0011A+K\u0005\u0003mJ\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\u0012!\u001f\u0016\u0003g=\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002yB\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0011\u0001\u00026bm\u0006L!A\f@\u0002\r\u0015\fX/\u00197t)\u0011\tY!!\u0005\u0011\u0007Q\ni!C\u0002\u0002\u0010%\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002\u00149\u0001\r!!\u0006\u0002\u000b=$\b.\u001a:\u0011\u0007Q\n9\"C\u0002\u0002\u001a%\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0010!\r!\u0014\u0011E\u0005\u0004\u0003GI#aA%oi\u0002")
public final class KMS
extends ServerSideEncryption {
    private final String keyId;
    private final Option<String> context;

    public String keyId() {
        return this.keyId;
    }

    public Option<String> context() {
        return this.context;
    }

    @Override
    @InternalApi
    public Seq<HttpHeader> headers() {
        RawHeader rawHeader = new RawHeader("x-amz-server-side-encryption", "aws:kms");
        RawHeader rawHeader2 = new RawHeader("x-amz-server-side-encryption-aws-kms-key-id", this.keyId());
        List baseHeaders = Nil$.MODULE$.$colon$colon((Object)rawHeader2).$colon$colon((Object)rawHeader);
        List headers = (List)baseHeaders.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(this.context().map((Function1 & Serializable)ctx -> new RawHeader("x-amz-server-side-encryption-context", ctx))).toSeq());
        return headers;
    }

    @Override
    @InternalApi
    public Seq<HttpHeader> headersFor(S3Request request) {
        S3Request s3Request = request;
        boolean bl = PutObject$.MODULE$.equals(s3Request) ? true : InitiateMultipartUpload$.MODULE$.equals(s3Request);
        Nil$ nil$ = bl ? this.headers() : Nil$.MODULE$;
        return nil$;
    }

    public KMS withKeyId(String keyId) {
        return this.copy(keyId, this.copy$default$2());
    }

    public KMS withContext(String context) {
        Some x$1 = new Some((Object)context);
        String x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<String>)x$1);
    }

    private KMS copy(String keyId, Option<String> context) {
        return new KMS(keyId, context);
    }

    private String copy$default$1() {
        return this.keyId();
    }

    private Option<String> copy$default$2() {
        return this.context();
    }

    public String toString() {
        return new StringBuilder(26).append("ServerSideEncryption.KMS(").append(new StringBuilder(7).append("keyId=").append(this.keyId()).append(",").toString()).append(new StringBuilder(8).append("context=").append(this.context()).toString()).append(")").toString();
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof KMS) {
            KMS kMS = (KMS)object;
            bl = Objects.equals(this.keyId(), kMS.keyId()) && Objects.equals(this.context(), kMS.context());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Objects.hash(this.keyId(), this.context());
    }

    public KMS(String keyId, Option<String> context) {
        this.keyId = keyId;
        this.context = context;
    }
}

