/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.impl;

import akka.annotation.InternalApi;
import akka.http.scaladsl.marshallers.xml.ScalaXmlSupport$;
import akka.http.scaladsl.marshalling.Marshal$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.IllegalUriException;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.ByteRange;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Host$;
import akka.http.scaladsl.model.headers.Raw;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.stream.alpakka.s3.AccessStyle;
import akka.stream.alpakka.s3.AccessStyle$PathAccessStyle$;
import akka.stream.alpakka.s3.AccessStyle$VirtualHostAccessStyle$;
import akka.stream.alpakka.s3.ApiVersion;
import akka.stream.alpakka.s3.ApiVersion$ListBucketVersion1$;
import akka.stream.alpakka.s3.ApiVersion$ListBucketVersion2$;
import akka.stream.alpakka.s3.S3Settings;
import akka.stream.alpakka.s3.impl.CopyPartition;
import akka.stream.alpakka.s3.impl.MultipartCopy;
import akka.stream.alpakka.s3.impl.MultipartUpload;
import akka.stream.alpakka.s3.impl.S3Location;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import software.amazon.awssdk.regions.Region;

@InternalApi
public final class HttpRequests$ {
    public static final HttpRequests$ MODULE$ = new HttpRequests$();

    private final String BucketPattern() {
        return "{bucket}";
    }

    public HttpRequest listBucket(String bucket, Option<String> prefix, Option<String> continuationToken, Option<String> delimiter, scala.collection.immutable.Seq<HttpHeader> headers, S3Settings conf) {
        Tuple2 tuple2;
        ApiVersion apiVersion = conf.listBucketApiVersion();
        if (ApiVersion$ListBucketVersion1$.MODULE$.equals(apiVersion)) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)"marker");
        } else if (ApiVersion$ListBucketVersion2$.MODULE$.equals(apiVersion)) {
            tuple2 = new Tuple2((Object)new Some((Object)"2"), (Object)"continuation-token");
        } else {
            throw new MatchError((Object)apiVersion);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option listType = (Option)tuple22._1();
        String continuationTokenName = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)listType, (Object)continuationTokenName);
        Tuple2 tuple24 = tuple23;
        Option listType2 = (Option)tuple24._1();
        String continuationTokenName2 = (String)tuple24._2();
        Uri.Query query = Uri.Query$.MODULE$.apply(((IterableOnceOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"list-type"), (Object)listType2), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prefix"), prefix), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delimiter"), delimiter), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)continuationTokenName2), continuationToken), (List)Nil$.MODULE$)))).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, Option<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String k = (String)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String v = (String)some.value();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, Option<String>> x1) {
                Option option;
                Tuple2<String, Option<String>> tuple2 = x1;
                boolean bl = tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
                return bl;
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Host host = Host$.MODULE$.apply(this.requestAuthority(bucket, conf.s3RegionProvider().getRegion(), conf));
        return HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), HttpRequest$.MODULE$.apply$default$2(), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()).withHeaders((scala.collection.immutable.Seq)headers.$plus$colon((Object)host)).withUri(this.requestUri(bucket, (Option<String>)None$.MODULE$, conf).withQuery(query));
    }

    public Option<String> listBucket$default$2() {
        return None$.MODULE$;
    }

    public Option<String> listBucket$default$3() {
        return None$.MODULE$;
    }

    public Option<String> listBucket$default$4() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Seq<HttpHeader> listBucket$default$5() {
        return Nil$.MODULE$;
    }

    public HttpRequest getDownloadRequest(S3Location s3Location, HttpMethod method, scala.collection.immutable.Seq<HttpHeader> s3Headers, Option<String> versionId2, S3Settings conf) {
        Uri.Query query = (Uri.Query)versionId2.map((Function1 & Serializable)vId -> Uri.Query$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"versionId"), (Object)URLDecoder.decode(vId, StandardCharsets.UTF_8.toString()))}))).getOrElse((Function0 & Serializable)() -> Uri.Query$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
        return (HttpRequest)this.s3Request(s3Location, method, (Function1<Uri, Uri>)(Function1 & Serializable)x$2 -> x$2.withQuery(query), conf).withDefaultHeaders(s3Headers);
    }

    public HttpMethod getDownloadRequest$default$2() {
        return HttpMethods$.MODULE$.GET();
    }

    public scala.collection.immutable.Seq<HttpHeader> getDownloadRequest$default$3() {
        return (scala.collection.immutable.Seq)Seq$.MODULE$.empty();
    }

    public Option<String> getDownloadRequest$default$4() {
        return None$.MODULE$;
    }

    public HttpRequest bucketManagementRequest(S3Location s3Location, HttpMethod method, scala.collection.immutable.Seq<HttpHeader> headers, S3Settings conf) {
        return (HttpRequest)this.s3Request(s3Location, method, this.s3Request$default$3(), conf).withDefaultHeaders(headers);
    }

    public scala.collection.immutable.Seq<HttpHeader> bucketManagementRequest$default$3() {
        return (scala.collection.immutable.Seq)Seq$.MODULE$.empty();
    }

    public HttpRequest uploadRequest(S3Location s3Location, Source<ByteString, ?> payload, long contentLength2, ContentType contentType2, scala.collection.immutable.Seq<HttpHeader> s3Headers, S3Settings conf) {
        return ((HttpRequest)this.s3Request(s3Location, HttpMethods$.MODULE$.PUT(), this.s3Request$default$3(), conf).withDefaultHeaders(s3Headers)).withEntity((RequestEntity)HttpEntity$.MODULE$.apply(contentType2, contentLength2, payload));
    }

    public HttpRequest initiateMultipartUploadRequest(S3Location s3Location, ContentType contentType2, scala.collection.immutable.Seq<HttpHeader> s3Headers, S3Settings conf) {
        return ((HttpRequest)this.s3Request(s3Location, HttpMethods$.MODULE$.POST(), (Function1<Uri, Uri>)(Function1 & Serializable)x$3 -> x$3.withQuery(Uri.Query$.MODULE$.apply("uploads")), conf).withDefaultHeaders(s3Headers)).withEntity((RequestEntity)HttpEntity$.MODULE$.empty(contentType2));
    }

    public HttpRequest uploadPartRequest(MultipartUpload upload, int partNumber, Source<ByteString, ?> payload, int payloadSize, scala.collection.immutable.Seq<HttpHeader> s3Headers, S3Settings conf) {
        return ((HttpRequest)this.s3Request(upload.s3Location(), HttpMethods$.MODULE$.PUT(), (Function1<Uri, Uri>)(Function1 & Serializable)x$4 -> x$4.withQuery(Uri.Query$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partNumber"), (Object)((Object)BoxesRunTime.boxToInteger((int)partNumber)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uploadId"), (Object)upload.uploadId())}))), conf).withDefaultHeaders(s3Headers)).withEntity((RequestEntity)HttpEntity$.MODULE$.apply((ContentType)ContentTypes$.MODULE$.application$divoctet$minusstream(), (long)payloadSize, payload));
    }

    public scala.collection.immutable.Seq<HttpHeader> uploadPartRequest$default$5() {
        return (scala.collection.immutable.Seq)Seq$.MODULE$.empty();
    }

    public Future<HttpRequest> completeMultipartUploadRequest(MultipartUpload upload, scala.collection.immutable.Seq<Tuple2<Object, String>> parts, scala.collection.immutable.Seq<HttpHeader> headers, ExecutionContext ec, S3Settings conf) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n                    "));
        $buf.$amp$plus(parts.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int partNumber = tuple2._1$mcI$sp();
            String etag = (String)tuple2._2();
            NodeBuffer $buf = new NodeBuffer();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)partNumber));
            $buf.$amp$plus((Object)new Elem(null, "PartNumber", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)etag);
            $buf.$amp$plus((Object)new Elem(null, "ETag", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            Elem elem = new Elem(null, "Part", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            return elem;
        }));
        $buf.$amp$plus((Object)new Text("\n                  "));
        Elem payload = new Elem(null, "CompleteMultipartUpload", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        return Marshal$.MODULE$.apply((Object)payload).to(ScalaXmlSupport$.MODULE$.defaultNodeSeqMarshaller(), ec).map((Function1 & Serializable)entity -> (HttpRequest)MODULE$.s3Request(upload.s3Location(), HttpMethods$.MODULE$.POST(), (Function1<Uri, Uri>)(Function1 & Serializable)x$5 -> x$5.withQuery(Uri.Query$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uploadId"), (Object)upload.uploadId())}))), conf).withEntity(entity).withDefaultHeaders(headers), ec);
    }

    public HttpRequest uploadCopyPartRequest(MultipartCopy multipartCopy, Option<String> sourceVersionId, scala.collection.immutable.Seq<HttpHeader> s3Headers, S3Settings conf) {
        MultipartUpload upload = multipartCopy.multipartUpload();
        CopyPartition copyPartition = multipartCopy.copyPartition();
        Option<ByteRange.Slice> range = copyPartition.range();
        S3Location source = copyPartition.sourceLocation().validate(conf);
        String encodedKey = URLEncoder.encode(source.key(), StandardCharsets.UTF_8.toString());
        String sourceHeaderValuePrefix = new StringBuilder(2).append("/").append(source.bucket()).append("/").append(encodedKey).toString();
        String sourceHeaderValue = (String)sourceVersionId.map((Function1 & Serializable)versionId2 -> new StringBuilder(11).append(sourceHeaderValuePrefix).append("?versionId=").append((String)versionId2).toString()).getOrElse((Function0 & Serializable)() -> sourceHeaderValuePrefix);
        RawHeader sourceHeader = new RawHeader("x-amz-copy-source", sourceHeaderValue);
        scala.collection.immutable.Seq copyHeaders = (scala.collection.immutable.Seq)range.map((Function1 & Serializable)br -> (scala.collection.immutable.Seq)new .colon.colon((Object)sourceHeader, (List)new .colon.colon((Object)new RawHeader("x-amz-copy-source-range", new StringBuilder(7).append("bytes=").append(br.first()).append("-").append(br.last() - 1L).toString()), (List)Nil$.MODULE$))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)new .colon.colon((Object)sourceHeader, (List)Nil$.MODULE$));
        scala.collection.immutable.Seq allHeaders = (scala.collection.immutable.Seq)s3Headers.$plus$plus((IterableOnce)copyHeaders);
        return (HttpRequest)this.s3Request(upload.s3Location(), HttpMethods$.MODULE$.PUT(), (Function1<Uri, Uri>)(Function1 & Serializable)x$6 -> x$6.withQuery(Uri.Query$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partNumber"), (Object)((Object)BoxesRunTime.boxToInteger((int)copyPartition.partNumber())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uploadId"), (Object)upload.uploadId())}))), conf).withDefaultHeaders(allHeaders);
    }

    public Option<String> uploadCopyPartRequest$default$2() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Seq<HttpHeader> uploadCopyPartRequest$default$3() {
        return (scala.collection.immutable.Seq)Seq$.MODULE$.empty();
    }

    private HttpRequest s3Request(S3Location s3Location, HttpMethod method, Function1<Uri, Uri> uriFn, S3Settings conf) {
        S3Location loc = s3Location.validate(conf);
        Uri s3RequestUri = (Uri)uriFn.apply((Object)this.requestUri(loc.bucket(), (Option<String>)new Some((Object)loc.key()), conf));
        return ((HttpRequest)HttpRequest$.MODULE$.apply(method, HttpRequest$.MODULE$.apply$default$2(), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()).withHeaders((HttpHeader)Host$.MODULE$.apply(this.requestAuthority(s3Location.bucket(), conf.s3RegionProvider().getRegion(), conf)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpHeader[]{new Raw.minusRequest.minusURI(this.rawRequestUri(s3RequestUri))}))).withUri(s3RequestUri);
    }

    private Function1<Uri, Uri> s3Request$default$3() {
        return (Function1 & Serializable)x -> (Uri)Predef$.MODULE$.identity(x);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Uri.Authority requestAuthority(String bucket, Region region, S3Settings conf) throws IllegalUriException {
        Tuple2 tuple2 = new Tuple2(conf.endpointUrl(), (Object)conf.accessStyle());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            AccessStyle accessStyle = (AccessStyle)tuple2._2();
            if (None$.MODULE$.equals(option) && AccessStyle$PathAccessStyle$.MODULE$.equals(accessStyle)) {
                return new Uri.Authority(Uri.Host$.MODULE$.apply(new StringBuilder(17).append("s3.").append(region).append(".amazonaws.com").toString(), Uri.Host$.MODULE$.apply$default$2(), Uri.Host$.MODULE$.apply$default$3()), Uri.Authority$.MODULE$.apply$default$2(), Uri.Authority$.MODULE$.apply$default$3());
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            AccessStyle accessStyle = (AccessStyle)tuple2._2();
            if (None$.MODULE$.equals(option) && AccessStyle$VirtualHostAccessStyle$.MODULE$.equals(accessStyle)) {
                return new Uri.Authority(Uri.Host$.MODULE$.apply(new StringBuilder(18).append(bucket).append(".s3.").append(region).append(".amazonaws.com").toString(), Uri.Host$.MODULE$.apply$default$2(), Uri.Host$.MODULE$.apply$default$3()), Uri.Authority$.MODULE$.apply$default$2(), Uri.Authority$.MODULE$.apply$default$3());
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            AccessStyle accessStyle = (AccessStyle)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String endpointUrl = (String)some.value();
                if (AccessStyle$PathAccessStyle$.MODULE$.equals(accessStyle)) {
                    return Uri$.MODULE$.apply(endpointUrl).authority();
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._1();
        AccessStyle accessStyle = (AccessStyle)tuple2._2();
        if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
        Some some = (Some)option;
        String endpointUrl = (String)some.value();
        if (!AccessStyle$VirtualHostAccessStyle$.MODULE$.equals(accessStyle)) throw new MatchError((Object)tuple2);
        return Uri$.MODULE$.apply(endpointUrl.replace("{bucket}", bucket)).authority();
    }

    private Uri requestUri(String bucket, Option<String> key, S3Settings conf) {
        Uri uri;
        Uri.Path path;
        Uri.Path path2;
        AccessStyle accessStyle = conf.accessStyle();
        if (AccessStyle$PathAccessStyle$.MODULE$.equals(accessStyle)) {
            path2 = Uri.Path$.MODULE$.$div(bucket);
        } else if (AccessStyle$VirtualHostAccessStyle$.MODULE$.equals(accessStyle)) {
            path2 = Uri.Path$.Empty$.MODULE$;
        } else {
            throw new MatchError((Object)accessStyle);
        }
        Uri.Path basePath = path2;
        Uri.Path x$1 = path = (Uri.Path)key.fold((Function0 & Serializable)() -> basePath, (Function1 & Serializable)someKey -> (Uri.Path)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])someKey.split("/", -1)), (Object)basePath, (Function2 & Serializable)(acc, p) -> acc.$div(p)));
        Uri.Authority x$2 = this.requestAuthority(bucket, conf.s3RegionProvider().getRegion(), conf);
        String x$3 = Uri$.MODULE$.apply$default$1();
        Option x$4 = Uri$.MODULE$.apply$default$4();
        Option x$5 = Uri$.MODULE$.apply$default$5();
        Uri uri2 = Uri$.MODULE$.apply(x$3, x$2, x$1, x$4, x$5);
        Option<String> option = conf.endpointUrl();
        if (None$.MODULE$.equals(option)) {
            uri = uri2.withScheme("https");
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String endpointUri = (String)some.value();
            uri = uri2.withScheme(Uri$.MODULE$.apply(endpointUri.replace("{bucket}", "b")).scheme());
        } else {
            throw new MatchError(option);
        }
        return uri;
    }

    /*
     * WARNING - void declaration
     */
    private String rawRequestUri(Uri uri) {
        String string;
        String rawUri = uri.toHttpRequestTargetOriginForm().toString();
        String rawPath = uri.path().toString();
        if (rawPath.contains("+")) {
            String fixedPath = rawPath.replaceAll("\\+", "%2B");
            Predef$.MODULE$.require(rawUri.startsWith(rawPath));
            string = new StringBuilder(0).append(fixedPath).append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(rawUri), rawPath.length())).toString();
        } else {
            void var2_2;
            string = var2_2;
        }
        return string;
    }

    private HttpRequests$() {
    }
}

