/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.impl.auth;

import akka.annotation.InternalApi;
import akka.stream.alpakka.s3.impl.auth.CredentialScope;
import akka.stream.alpakka.s3.impl.auth.SigningKey$;
import akka.stream.alpakka.s3.impl.auth.package$;
import java.io.Serializable;
import java.time.ZonedDateTime;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

@ScalaSignature(bytes="\u0006\u0005\tUc!\u0002\u00192\u0005Nj\u0004\u0002\u0003+\u0001\u0005+\u0007I\u0011A+\t\u0011y\u0003!\u0011#Q\u0001\nYC\u0001b\u0018\u0001\u0003\u0016\u0004%\t\u0001\u0019\u0005\t]\u0002\u0011\t\u0012)A\u0005C\"Aq\u000e\u0001BK\u0002\u0013\u0005\u0001\u000f\u0003\u0005v\u0001\tE\t\u0015!\u0003r\u0011!1\bA!f\u0001\n\u00039\b\"CA\u0001\u0001\tE\t\u0015!\u0003y\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bA\u0001\u0002\u001a\u0001C\u0002\u0013%\u0011\u0011\u0003\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u0014!I\u00111\u0004\u0001C\u0002\u0013\u0005\u0011Q\u0004\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002 !I\u0011Q\u0007\u0001C\u0002\u0013\u0005\u0011q\u0007\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u0002:!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\u0007\u00037\u0002A\u0011A<\t\u0015\u0005u\u0003\u0001#b\u0001\n\u0003\ti\u0002\u0003\u0006\u0002`\u0001A)\u0019!C\u0001\u0003;A!\"!\u0019\u0001\u0011\u000b\u0007I\u0011AA\u000f\u0011)\t\u0019\u0007\u0001EC\u0002\u0013\u0005\u0011Q\u0004\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\ti\u0007\u0001C\u0005\u0003_B\u0011\"!\u001e\u0001\u0003\u0003%\t!a\u001e\t\u0013\u0005\u0005\u0005!%A\u0005\u0002\u0005\r\u0005\"CAM\u0001E\u0005I\u0011AAN\u0011%\ty\nAI\u0001\n\u0003\t\t\u000bC\u0005\u0002&\u0002\t\n\u0011\"\u0001\u0002(\"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\n\u0003s\u0003\u0011\u0011!C\u0001\u0003wC\u0011\"a1\u0001\u0003\u0003%\t!!2\t\u0013\u0005E\u0007!!A\u0005B\u0005M\u0007\"CAq\u0001\u0005\u0005I\u0011AAr\u0011%\ti\u000fAA\u0001\n\u0003\ny\u000fC\u0005\u0002t\u0002\t\t\u0011\"\u0011\u0002v\"I\u0011q\u001f\u0001\u0002\u0002\u0013\u0005\u0013\u0011 \u0005\n\u0003w\u0004\u0011\u0011!C!\u0003{<!B!\u00042\u0003\u0003E\ta\rB\b\r%\u0001\u0014'!A\t\u0002M\u0012\t\u0002C\u0004\u0002\u0004!\"\tA!\u000b\t\u0013\u0005]\b&!A\u0005F\u0005e\b\"\u0003B\u0016Q\u0005\u0005I\u0011\u0011B\u0017\u0011%\u00119\u0004KI\u0001\n\u0003\t9\u000bC\u0005\u0003:!\n\t\u0011\"!\u0003<!I!\u0011\n\u0015\u0012\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0005\u0017B\u0013\u0011!C\u0005\u0005\u001b\u0012!bU5h]&twmS3z\u0015\t\u00114'\u0001\u0003bkRD'B\u0001\u001b6\u0003\u0011IW\u000e\u001d7\u000b\u0005Y:\u0014AA:4\u0015\tA\u0014(A\u0004bYB\f7n[1\u000b\u0005iZ\u0014AB:ue\u0016\fWNC\u0001=\u0003\u0011\t7n[1\u0014\t\u0001qDi\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}*\u0015B\u0001$A\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001S)\u000f\u0005%{eB\u0001&O\u001b\u0005Y%B\u0001'N\u0003\u0019a$o\\8u}\r\u0001\u0011\"A!\n\u0005A\u0003\u0015a\u00029bG.\fw-Z\u0005\u0003%N\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0015!\u0002\u0017I,\u0017/^3ti\u0012\u000bG/Z\u000b\u0002-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0005i&lWMC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&!\u0004.p]\u0016$G)\u0019;f)&lW-\u0001\u0007sKF,Xm\u001d;ECR,\u0007%\u0001\u0007de\u0016$\u0007K]8wS\u0012,'/F\u0001b!\t\u0011G.D\u0001d\u0015\t!W-A\u0006de\u0016$WM\u001c;jC2\u001c(B\u0001\u001ag\u0015\t9\u0007.\u0001\u0004boN\u001cHm\u001b\u0006\u0003S*\fa!Y7bu>t'\"A6\u0002\u0011M|g\r^<be\u0016L!!\\2\u0003-\u0005;8o\u0011:fI\u0016tG/[1mgB\u0013xN^5eKJ\fQb\u0019:fIB\u0013xN^5eKJ\u0004\u0013!B:d_B,W#A9\u0011\u0005I\u001cX\"A\u0019\n\u0005Q\f$aD\"sK\u0012,g\u000e^5bYN\u001bw\u000e]3\u0002\rM\u001cw\u000e]3!\u0003%\tGnZ8sSRDW.F\u0001y!\tIXP\u0004\u0002{wB\u0011!\nQ\u0005\u0003y\u0002\u000ba\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011A\u0010Q\u0001\u000bC2<wN]5uQ6\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0006\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\u0001\"A\u001d\u0001\t\u000bQK\u0001\u0019\u0001,\t\u000b}K\u0001\u0019A1\t\u000b=L\u0001\u0019A9\t\u000fYL\u0001\u0013!a\u0001qV\u0011\u00111\u0003\t\u0004E\u0006U\u0011bAA\fG\nq\u0011i^:De\u0016$WM\u001c;jC2\u001c\u0018\u0001D2sK\u0012,g\u000e^5bYN\u0004\u0013A\u0002:bo.+\u00170\u0006\u0002\u0002 A!\u0011\u0011EA\u0018\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012\u0001B:qK\u000eTA!!\u000b\u0002,\u000511M]=qi>T!!!\f\u0002\u000b)\fg/\u0019=\n\t\u0005E\u00121\u0005\u0002\u000e'\u0016\u001c'/\u001a;LKf\u001c\u0006/Z2\u0002\u000fI\fwoS3zA\u0005a1/Z:tS>tGk\\6f]V\u0011\u0011\u0011\b\t\u0005\u007f\u0005m\u00020C\u0002\u0002>\u0001\u0013aa\u00149uS>t\u0017!D:fgNLwN\u001c+pW\u0016t\u0007%A\u0005tS\u001et\u0017\r^;sKR!\u0011QIA)!\u0015y\u0014qIA&\u0013\r\tI\u0005\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u007f\u00055\u0013bAA(\u0001\n!!)\u001f;f\u0011\u001d\t\u0019\u0006\u0005a\u0001\u0003\u000b\nq!\\3tg\u0006<W-A\niKb,enY8eK\u0012\u001c\u0016n\u001a8biV\u0014X\rF\u0002y\u00033Bq!a\u0015\u0012\u0001\u0004\t)%\u0001\tde\u0016$WM\u001c;jC2\u001cFO]5oO\u0006\u00191.Z=\u0002)\u0011\fG/\u001a*fO&|gnU3sm&\u001cWmS3z\u00035!\u0017\r^3SK\u001eLwN\\&fs\u00069A-\u0019;f\u0017\u0016L\u0018!D<sCB\u001c\u0016n\u001a8biV\u0014X\r\u0006\u0004\u0002 \u0005%\u00141\u000e\u0005\b\u0003\u0003:\u0002\u0019AA\u0010\u0011\u001d\t\u0019f\u0006a\u0001\u0003\u000b\n1b]5h]^KG\u000f[&fsR1\u0011QIA9\u0003gBq!!\u0018\u0019\u0001\u0004\ty\u0002C\u0004\u0002Ta\u0001\r!!\u0012\u0002\t\r|\u0007/\u001f\u000b\u000b\u0003\u000f\tI(a\u001f\u0002~\u0005}\u0004b\u0002+\u001a!\u0003\u0005\rA\u0016\u0005\b?f\u0001\n\u00111\u0001b\u0011\u001dy\u0017\u0004%AA\u0002EDqA^\r\u0011\u0002\u0003\u0007\u00010\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015%f\u0001,\u0002\b.\u0012\u0011\u0011\u0012\t\u0005\u0003\u0017\u000b)*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0014\u0002\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9*!$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u%fA1\u0002\b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAARU\r\t\u0018qQ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tIKK\u0002y\u0003\u000f\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAX!\u0011\t\t,a.\u000e\u0005\u0005M&bAA[5\u0006!A.\u00198h\u0013\rq\u00181W\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003{\u00032aPA`\u0013\r\t\t\r\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000f\fi\rE\u0002@\u0003\u0013L1!a3A\u0005\r\te.\u001f\u0005\n\u0003\u001f\u0004\u0013\u0011!a\u0001\u0003{\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAk!\u0019\t9.!8\u0002H6\u0011\u0011\u0011\u001c\u0006\u0004\u00037\u0004\u0015AC2pY2,7\r^5p]&!\u0011q\\Am\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0015\u00181\u001e\t\u0004\u007f\u0005\u001d\u0018bAAu\u0001\n9!i\\8mK\u0006t\u0007\"CAhE\u0005\u0005\t\u0019AAd\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005=\u0016\u0011\u001f\u0005\n\u0003\u001f\u001c\u0013\u0011!a\u0001\u0003{\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003{\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003_\u000ba!Z9vC2\u001cH\u0003BAs\u0003\u007fD\u0011\"a4'\u0003\u0003\u0005\r!a2)\u0007\u0001\u0011\u0019\u0001\u0005\u0003\u0003\u0006\t%QB\u0001B\u0004\u0015\r\t\u0019jO\u0005\u0005\u0005\u0017\u00119AA\u0006J]R,'O\\1m\u0003BL\u0017AC*jO:LgnZ&fsB\u0011!\u000fK\n\u0006Q\tM!q\u0004\t\u000b\u0005+\u0011YBV1rq\u0006\u001dQB\u0001B\f\u0015\r\u0011I\u0002Q\u0001\beVtG/[7f\u0013\u0011\u0011iBa\u0006\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0005\u0003\u0003\"\t\u001dRB\u0001B\u0012\u0015\r\u0011)CW\u0001\u0003S>L1A\u0015B\u0012)\t\u0011y!A\u0003baBd\u0017\u0010\u0006\u0006\u0002\b\t=\"\u0011\u0007B\u001a\u0005kAQ\u0001V\u0016A\u0002YCQaX\u0016A\u0002\u0005DQa\\\u0016A\u0002EDqA^\u0016\u0011\u0002\u0003\u0007\u00010A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BA!\u0010\u0003FA)q(a\u000f\u0003@A9qH!\u0011WCFD\u0018b\u0001B\"\u0001\n1A+\u001e9mKRB\u0011Ba\u0012.\u0003\u0003\u0005\r!a\u0002\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u001f\u0002B!!-\u0003R%!!1KAZ\u0005\u0019y%M[3di\u0002")
@InternalApi
public final class SigningKey
implements Product,
Serializable {
    private SecretKeySpec key;
    private SecretKeySpec dateRegionServiceKey;
    private SecretKeySpec dateRegionKey;
    private SecretKeySpec dateKey;
    private final ZonedDateTime requestDate;
    private final AwsCredentialsProvider credProvider;
    private final CredentialScope scope;
    private final String algorithm;
    private final AwsCredentials credentials;
    private final SecretKeySpec rawKey;
    private final Option<String> sessionToken;
    private volatile byte bitmap$0;

    public static String $lessinit$greater$default$4() {
        return SigningKey$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<ZonedDateTime, AwsCredentialsProvider, CredentialScope, String>> unapply(SigningKey signingKey) {
        return SigningKey$.MODULE$.unapply(signingKey);
    }

    public static String apply$default$4() {
        return SigningKey$.MODULE$.apply$default$4();
    }

    public static SigningKey apply(ZonedDateTime zonedDateTime, AwsCredentialsProvider awsCredentialsProvider, CredentialScope credentialScope, String string) {
        return SigningKey$.MODULE$.apply(zonedDateTime, awsCredentialsProvider, credentialScope, string);
    }

    public static Function1<Tuple4<ZonedDateTime, AwsCredentialsProvider, CredentialScope, String>, SigningKey> tupled() {
        return SigningKey$.MODULE$.tupled();
    }

    public static Function1<ZonedDateTime, Function1<AwsCredentialsProvider, Function1<CredentialScope, Function1<String, SigningKey>>>> curried() {
        return SigningKey$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public ZonedDateTime requestDate() {
        return this.requestDate;
    }

    public AwsCredentialsProvider credProvider() {
        return this.credProvider;
    }

    public CredentialScope scope() {
        return this.scope;
    }

    public String algorithm() {
        return this.algorithm;
    }

    private AwsCredentials credentials() {
        return this.credentials;
    }

    public SecretKeySpec rawKey() {
        return this.rawKey;
    }

    public Option<String> sessionToken() {
        return this.sessionToken;
    }

    public byte[] signature(byte[] message) {
        return this.signWithKey(this.key(), message);
    }

    public String hexEncodedSignature(byte[] message) {
        return package$.MODULE$.encodeHex(this.signature(message));
    }

    public String credentialString() {
        return new StringBuilder(1).append(this.credentials().accessKeyId()).append("/").append(this.scope().scopeString()).toString();
    }

    private SecretKeySpec key$lzycompute() {
        SigningKey signingKey = this;
        synchronized (signingKey) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.key = this.wrapSignature(this.dateRegionServiceKey(), "aws4_request".getBytes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.key;
    }

    public SecretKeySpec key() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.key$lzycompute() : this.key;
    }

    private SecretKeySpec dateRegionServiceKey$lzycompute() {
        SigningKey signingKey = this;
        synchronized (signingKey) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dateRegionServiceKey = this.wrapSignature(this.dateRegionKey(), this.scope().awsService().getBytes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dateRegionServiceKey;
    }

    public SecretKeySpec dateRegionServiceKey() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dateRegionServiceKey$lzycompute() : this.dateRegionServiceKey;
    }

    private SecretKeySpec dateRegionKey$lzycompute() {
        SigningKey signingKey = this;
        synchronized (signingKey) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dateRegionKey = this.wrapSignature(this.dateKey(), this.scope().awsRegion().id().getBytes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dateRegionKey;
    }

    public SecretKeySpec dateRegionKey() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.dateRegionKey$lzycompute() : this.dateRegionKey;
    }

    private SecretKeySpec dateKey$lzycompute() {
        SigningKey signingKey = this;
        synchronized (signingKey) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.dateKey = this.wrapSignature(this.rawKey(), this.scope().formattedDate().getBytes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.dateKey;
    }

    public SecretKeySpec dateKey() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.dateKey$lzycompute() : this.dateKey;
    }

    private SecretKeySpec wrapSignature(SecretKeySpec signature, byte[] message) {
        return new SecretKeySpec(this.signWithKey(signature, message), this.algorithm());
    }

    private byte[] signWithKey(SecretKeySpec key, byte[] message) {
        Mac mac = Mac.getInstance(this.algorithm());
        mac.init(key);
        return mac.doFinal(message);
    }

    public SigningKey copy(ZonedDateTime requestDate, AwsCredentialsProvider credProvider, CredentialScope scope, String algorithm) {
        return new SigningKey(requestDate, credProvider, scope, algorithm);
    }

    public ZonedDateTime copy$default$1() {
        return this.requestDate();
    }

    public AwsCredentialsProvider copy$default$2() {
        return this.credProvider();
    }

    public CredentialScope copy$default$3() {
        return this.scope();
    }

    public String copy$default$4() {
        return this.algorithm();
    }

    public String productPrefix() {
        return "SigningKey";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.requestDate();
                break;
            }
            case 1: {
                object = this.credProvider();
                break;
            }
            case 2: {
                object = this.scope();
                break;
            }
            case 3: {
                object = this.algorithm();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SigningKey;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "requestDate";
                break;
            }
            case 1: {
                string = "credProvider";
                break;
            }
            case 2: {
                string = "scope";
                break;
            }
            case 3: {
                string = "algorithm";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SigningKey)) return false;
        boolean bl = true;
        if (!bl) return false;
        SigningKey signingKey = (SigningKey)x$1;
        ZonedDateTime zonedDateTime = this.requestDate();
        ZonedDateTime zonedDateTime2 = signingKey.requestDate();
        if (zonedDateTime == null) {
            if (zonedDateTime2 != null) {
                return false;
            }
        } else if (!((Object)zonedDateTime).equals(zonedDateTime2)) return false;
        AwsCredentialsProvider awsCredentialsProvider = this.credProvider();
        AwsCredentialsProvider awsCredentialsProvider2 = signingKey.credProvider();
        if (awsCredentialsProvider == null) {
            if (awsCredentialsProvider2 != null) {
                return false;
            }
        } else if (!awsCredentialsProvider.equals(awsCredentialsProvider2)) return false;
        CredentialScope credentialScope = this.scope();
        CredentialScope credentialScope2 = signingKey.scope();
        if (credentialScope == null) {
            if (credentialScope2 != null) {
                return false;
            }
        } else if (!((Object)credentialScope).equals(credentialScope2)) return false;
        String string = this.algorithm();
        String string2 = signingKey.algorithm();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public SigningKey(ZonedDateTime requestDate, AwsCredentialsProvider credProvider, CredentialScope scope, String algorithm) {
        None$ none$;
        this.requestDate = requestDate;
        this.credProvider = credProvider;
        this.scope = scope;
        this.algorithm = algorithm;
        Product.$init$((Product)this);
        this.credentials = credProvider.resolveCredentials();
        this.rawKey = new SecretKeySpec(new StringBuilder(4).append("AWS4").append(this.credentials().secretAccessKey()).toString().getBytes(), algorithm);
        AwsCredentials awsCredentials = this.credentials();
        if (awsCredentials instanceof AwsSessionCredentials) {
            AwsSessionCredentials awsSessionCredentials = (AwsSessionCredentials)awsCredentials;
            none$ = new Some((Object)awsSessionCredentials.sessionToken());
        } else {
            none$ = None$.MODULE$;
        }
        this.sessionToken = none$;
    }
}

