/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.impl.auth;

import akka.annotation.InternalApi;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.headers.Raw$minusRequest$minusURI$;
import akka.http.scaladsl.model.headers.Timeout$minusAccess$;
import akka.http.scaladsl.model.headers.Tls$minusSession$minusInfo$;
import akka.http.scaladsl.model.headers.X$minusForwarded$minusFor$;
import akka.stream.alpakka.s3.impl.auth.CanonicalRequest;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;

@InternalApi
public final class CanonicalRequest$
implements Serializable {
    public static final CanonicalRequest$ MODULE$ = new CanonicalRequest$();
    private static final List<String> akkaSyntheticHeaderNames = new .colon.colon((Object)Raw$minusRequest$minusURI$.MODULE$.lowercaseName(), (List)new .colon.colon((Object)X$minusForwarded$minusFor$.MODULE$.lowercaseName(), (List)new .colon.colon((Object)Timeout$minusAccess$.MODULE$.lowercaseName(), (List)new .colon.colon((Object)Tls$minusSession$minusInfo$.MODULE$.lowercaseName(), (List)Nil$.MODULE$))));
    private static final String reservedCharacters = ":?#[]@!$&'()*+,;=";

    private List<String> akkaSyntheticHeaderNames() {
        return akkaSyntheticHeaderNames;
    }

    public CanonicalRequest from(HttpRequest request) {
        String hashedBody = (String)request.headers().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends HttpHeader, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.is("x-amz-content-sha256")) {
                    return (B1)A1.value();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(HttpHeader x1) {
                HttpHeader httpHeader = x1;
                return httpHeader.is("x-amz-content-sha256");
            }
        }).getOrElse((Function0 & Serializable)() -> "");
        Seq signedHeaders = (Seq)request.headers().filterNot((Function1 & Serializable)header -> BoxesRunTime.boxToBoolean((boolean)CanonicalRequest$.$anonfun$from$2(header)));
        return new CanonicalRequest(request.method().value(), this.pathEncode(request.uri().path()), this.canonicalQueryString(request.uri().query(request.uri().query$default$1(), request.uri().query$default$2())), this.canonicalHeaderString((Seq<HttpHeader>)signedHeaders), this.signedHeadersString((Seq<HttpHeader>)signedHeaders), hashedBody);
    }

    public boolean isUnreservedCharacter(char c) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '-' || c == '.' || c == '_' || c == '~';
    }

    public String reservedCharacters() {
        return reservedCharacters;
    }

    public boolean isReservedCharacter(char c) {
        return StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(this.reservedCharacters()), c);
    }

    public String canonicalQueryString(Uri.Query query) {
        return ((IterableOnceOps)((StrictOptimizedIterableOps)query.sortBy((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                return name;
            }
            throw new MatchError((Object)tuple2);
        }, (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                return new StringBuilder(1).append(CanonicalRequest$.uriEncode$1(name)).append("=").append(CanonicalRequest$.uriEncode$1(value)).toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString("&");
    }

    public String canonicalHeaderString(Seq<HttpHeader> headers) {
        return ((List)headers.groupBy((Function1 & Serializable)x$1 -> x$1.lowercaseName()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq headers = (Seq)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)((IterableOnceOps)headers.map((Function1 & Serializable)header -> header.value().replaceAll("\\s+", " ").trim())).mkString(","));
            }
            throw new MatchError((Object)tuple2);
        }).toList().sortBy((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                return name;
            }
            throw new MatchError((Object)tuple2);
        }, (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                return new StringBuilder(1).append(name).append(":").append(value).toString();
            }
            throw new MatchError((Object)tuple2);
        }).mkString("\n");
    }

    public String signedHeadersString(Seq<HttpHeader> headers) {
        return ((IterableOnceOps)((SeqOps)((SeqOps)headers.map((Function1 & Serializable)x$2 -> x$2.lowercaseName())).distinct()).sorted((Ordering)Ordering.String$.MODULE$)).mkString(";");
    }

    public String pathEncode(Uri.Path path) {
        if (path.isEmpty()) {
            return "/";
        }
        return StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(path.toString()), (Function1 & Serializable)x0$1 -> CanonicalRequest$.$anonfun$pathEncode$1(BoxesRunTime.unboxToChar((Object)x0$1)));
    }

    public CanonicalRequest apply(String method, String uri, String queryString, String headerString, String signedHeaders, String hashedPayload) {
        return new CanonicalRequest(method, uri, queryString, headerString, signedHeaders, hashedPayload);
    }

    public Option<Tuple6<String, String, String, String, String, String>> unapply(CanonicalRequest x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.method(), (Object)x$0.uri(), (Object)x$0.queryString(), (Object)x$0.headerString(), (Object)x$0.signedHeaders(), (Object)x$0.hashedPayload()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CanonicalRequest$.class);
    }

    public static final /* synthetic */ boolean $anonfun$from$2(HttpHeader header) {
        return MODULE$.akkaSyntheticHeaderNames().contains((Object)header.lowercaseName());
    }

    public static final /* synthetic */ String $anonfun$canonicalQueryString$1(char x0$1) {
        char c = x0$1;
        switch (c) {
            default: 
        }
        if (MODULE$.isUnreservedCharacter(c)) {
            return Character.toString(c);
        }
        return new StringBuilder(1).append("%").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper((int)c)).toUpperCase()).toString();
    }

    private static final String uriEncode$1(String s) {
        return StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x0$1 -> CanonicalRequest$.$anonfun$canonicalQueryString$1(BoxesRunTime.unboxToChar((Object)x0$1)));
    }

    public static final /* synthetic */ String $anonfun$pathEncode$1(char x0$1) {
        char c = x0$1;
        switch (c) {
            default: 
        }
        if (MODULE$.isReservedCharacter(c)) {
            return new StringBuilder(1).append("%").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper((int)c)).toUpperCase()).toString();
        }
        return Character.toString(c);
    }

    private CanonicalRequest$() {
    }
}

