/*
 * Decompiled with CFR 0.152.
 */
package akka.discovery.kubernetes;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.discovery.kubernetes.Settings$;
import com.typesafe.config.Config;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0003\u0013\tA1+\u001a;uS:<7O\u0003\u0002\u0004\t\u0005Q1.\u001e2fe:,G/Z:\u000b\u0005\u00151\u0011!\u00033jg\u000e|g/\u001a:z\u0015\u00059\u0011\u0001B1lW\u0006\u001c\u0001aE\u0002\u0001\u0015A\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0015\u001b\u0005\u0011\"BA\n\u0007\u0003\u0015\t7\r^8s\u0013\t)\"CA\u0005FqR,gn]5p]\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0004tsN$X-\u001c\t\u0003#eI!A\u0007\n\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\t\u000bq\u0001A\u0011A\u000f\u0002\rqJg.\u001b;?)\tq\u0002\u0005\u0005\u0002 \u00015\t!\u0001C\u0003\u00187\u0001\u0007\u0001\u0004C\u0004#\u0001\t\u0007I\u0011B\u0012\u0002\u001b-,(-\u001a:oKR,7/\u00119j+\u0005!\u0003CA\u0013-\u001b\u00051#BA\u0014)\u0003\u0019\u0019wN\u001c4jO*\u0011\u0011FK\u0001\tif\u0004Xm]1gK*\t1&A\u0002d_6L!!\f\u0014\u0003\r\r{gNZ5h\u0011\u0019y\u0003\u0001)A\u0005I\u0005q1.\u001e2fe:,G/Z:Ba&\u0004\u0003bB\u0019\u0001\u0005\u0004%\tAM\u0001\nCBL7)\u0019)bi\",\u0012a\r\t\u0003i]r!aC\u001b\n\u0005Yb\u0011A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!A\u000e\u0007\t\rm\u0002\u0001\u0015!\u00034\u0003)\t\u0007/[\"b!\u0006$\b\u000e\t\u0005\b{\u0001\u0011\r\u0011\"\u00013\u00031\t\u0007/\u001b+pW\u0016t\u0007+\u0019;i\u0011\u0019y\u0004\u0001)A\u0005g\u0005i\u0011\r]5U_.,g\u000eU1uQ\u0002Bq!\u0011\u0001C\u0002\u0013\u0005!'A\u000bba&\u001cVM\u001d<jG\u0016Dun\u001d;F]Zt\u0015-\\3\t\r\r\u0003\u0001\u0015!\u00034\u0003Y\t\u0007/[*feZL7-\u001a%pgR,eN\u001e(b[\u0016\u0004\u0003bB#\u0001\u0005\u0004%\tAM\u0001\u0016CBL7+\u001a:wS\u000e,\u0007k\u001c:u\u000b:4h*Y7f\u0011\u00199\u0005\u0001)A\u0005g\u00051\u0012\r]5TKJ4\u0018nY3Q_J$XI\u001c<OC6,\u0007\u0005C\u0004J\u0001\t\u0007I\u0011\u0001\u001a\u0002\u0019A|GMT1nKN\u0004\u0018mY3\t\r-\u0003\u0001\u0015!\u00034\u00035\u0001x\u000e\u001a(b[\u0016\u001c\b/Y2fA!)Q\n\u0001C\u0001\u001d\u0006\u0001\u0002o\u001c3MC\n,GnU3mK\u000e$xN\u001d\u000b\u0003g=CQ\u0001\u0015'A\u0002M\nAA\\1nK\"9!\u000b\u0001b\u0001\n\u0003\u0011\u0014a\u00039pIB{'\u000f\u001e(b[\u0016Da\u0001\u0016\u0001!\u0002\u0013\u0019\u0014\u0001\u00049pIB{'\u000f\u001e(b[\u0016\u0004s!\u0002,\u0003\u0011\u00039\u0016\u0001C*fiRLgnZ:\u0011\u0005}Af!B\u0001\u0003\u0011\u0003I6\u0003\u0002-\u000b5v\u00032!E.\u001f\u0013\ta&CA\u0006FqR,gn]5p]&#\u0007CA\t_\u0013\ty&CA\nFqR,gn]5p]&#\u0007K]8wS\u0012,'\u000fC\u0003\u001d1\u0012\u0005\u0011\rF\u0001X\u0011\u0015\u0019\u0007\f\"\u0011e\u0003\r9W\r\u001e\u000b\u0003=\u0015DQa\u00062A\u0002\u0019\u0004\"!E4\n\u0005!\u0014\"aC!di>\u00148+_:uK6DQA\u001b-\u0005B-\fa\u0001\\8pWV\u0004H#\u00017\u000f\u0005})\u0006\"\u00028Y\t\u0003z\u0017aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0005y\u0001\b\"B\fn\u0001\u0004A\u0002")
public final class Settings
implements Extension {
    private final Config kubernetesApi;
    private final String apiCaPath;
    private final String apiTokenPath;
    private final String apiServiceHostEnvName;
    private final String apiServicePortEnvName;
    private final String podNamespace;
    private final String podPortName;

    public static Extension apply(ActorSystem actorSystem) {
        return Settings$.MODULE$.apply(actorSystem);
    }

    public static Settings createExtension(ExtendedActorSystem extendedActorSystem) {
        return Settings$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Settings$ lookup() {
        return Settings$.MODULE$.lookup();
    }

    public static Settings get(ActorSystem actorSystem) {
        return Settings$.MODULE$.get(actorSystem);
    }

    private Config kubernetesApi() {
        return this.kubernetesApi;
    }

    public String apiCaPath() {
        return this.apiCaPath;
    }

    public String apiTokenPath() {
        return this.apiTokenPath;
    }

    public String apiServiceHostEnvName() {
        return this.apiServiceHostEnvName;
    }

    public String apiServicePortEnvName() {
        return this.apiServicePortEnvName;
    }

    public String podNamespace() {
        return this.podNamespace;
    }

    public String podLabelSelector(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(this.kubernetesApi().getString("pod-label-selector"))).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
    }

    public String podPortName() {
        return this.podPortName;
    }

    public Settings(ExtendedActorSystem system) {
        this.kubernetesApi = system.settings().config().getConfig("akka.discovery.kubernetes-api");
        this.apiCaPath = this.kubernetesApi().getString("api-ca-path");
        this.apiTokenPath = this.kubernetesApi().getString("api-token-path");
        this.apiServiceHostEnvName = this.kubernetesApi().getString("api-service-host-env-name");
        this.apiServicePortEnvName = this.kubernetesApi().getString("api-service-port-env-name");
        this.podNamespace = this.kubernetesApi().getString("pod-namespace");
        this.podPortName = this.kubernetesApi().getString("pod-port-name");
    }
}

