/*
 * Decompiled with CFR 0.152.
 */
package akka.discovery.kubernetes;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.discovery.Lookup;
import akka.discovery.ServiceDiscovery;
import akka.discovery.kubernetes.JsonFormat$;
import akka.discovery.kubernetes.KubernetesApiServiceDiscovery$;
import akka.discovery.kubernetes.PodList;
import akka.discovery.kubernetes.Settings;
import akka.discovery.kubernetes.Settings$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Authorization;
import akka.http.scaladsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.headers.OAuth2BearerToken;
import akka.http.scaladsl.unmarshalling.Unmarshal$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import com.typesafe.sslconfig.akka.AkkaSSLConfig;
import com.typesafe.sslconfig.akka.AkkaSSLConfig$;
import com.typesafe.sslconfig.ssl.TrustStoreConfig;
import com.typesafe.sslconfig.ssl.TrustStoreConfig$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t%r!\u0002\u0011\"\u0011\u0003Ac!\u0002\u0016\"\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004B\u0002\u001b\u0002\t\u0003\tSG\u0002\u0003j\u0003\u0001Q\u0007\u0002\u0003?\u0005\u0005\u0003\u0005\u000b\u0011\u0002,\t\u000bI\"A\u0011A?\u0007\u000b)\n\u0003!a\u0001\t\u0015\u00055qA!A!\u0002\u0013\ty\u0001\u0003\u00043\u000f\u0011\u0005\u00111\u0004\u0005\n\u0003C9!\u0019!C\u0005\u0003GA\u0001\"a\r\bA\u0003%\u0011Q\u0005\u0005\n\u0003k9!\u0019!C\u0005\u0003oA\u0001\"a\u0010\bA\u0003%\u0011\u0011\b\u0005\n\u0003\u0003:!\u0019!C\u0006\u0003\u0007B\u0001\"!\u0015\bA\u0003%\u0011Q\t\u0005\n\u0003':!\u0019!C\u0005\u0003+B\u0001\"a\u0019\bA\u0003%\u0011q\u000b\u0005\n\u0003K:!\u0019!C\u0005\u0003OB\u0001\"!!\bA\u0003%\u0011\u0011\u000e\u0005\n\u0003\u0007;!\u0019!C\u0005\u0003\u000bC\u0001\"!%\bA\u0003%\u0011q\u0011\u0005\n\u0003';!\u0019!C\u0005\u0003+C\u0001\"!(\bA\u0003%\u0011q\u0013\u0005\b\u0003?;A\u0011IAQ\u0011%\tym\u0002b\u0001\n\u0013\t\t\u000eC\u0004\u0002T\u001e\u0001\u000b\u0011\u0002,\t\u0011};!\u0019!C\u0005\u0003#Dq!!6\bA\u0003%a\u000bC\u0004\u0002X\u001e!I!!7\t\u000f\u0005\rx\u0001\"\u0003\u0002f\"9!1B\u0004\u0005\n\t5\u0011!H&vE\u0016\u0014h.\u001a;fg\u0006\u0003\u0018nU3sm&\u001cW\rR5tG>4XM]=\u000b\u0005\t\u001a\u0013AC6vE\u0016\u0014h.\u001a;fg*\u0011A%J\u0001\nI&\u001c8m\u001c<fefT\u0011AJ\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005%\nQ\"A\u0011\u0003;-+(-\u001a:oKR,7/\u00119j'\u0016\u0014h/[2f\t&\u001c8m\u001c<fef\u001c\"!\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001&A\u0004uCJ<W\r^:\u0015\u000bYb\u0015K\u00181\u0011\u0007]bd(D\u00019\u0015\tI$(A\u0005j[6,H/\u00192mK*\u00111HL\u0001\u000bG>dG.Z2uS>t\u0017BA\u001f9\u0005\r\u0019V-\u001d\t\u0003\u007f%s!\u0001Q$\u000f\u0005\u00053eB\u0001\"F\u001b\u0005\u0019%B\u0001#(\u0003\u0019a$o\\8u}%\ta%\u0003\u0002%K%\u0011\u0001jI\u0001\u0011'\u0016\u0014h/[2f\t&\u001c8m\u001c<fefL!AS&\u0003\u001dI+7o\u001c7wK\u0012$\u0016M]4fi*\u0011\u0001j\t\u0005\u0006\u001b\u000e\u0001\rAT\u0001\ba>$G*[:u!\tIs*\u0003\u0002QC\t9\u0001k\u001c3MSN$\b\"\u0002*\u0004\u0001\u0004\u0019\u0016\u0001\u00039peRt\u0015-\\3\u0011\u00075\"f+\u0003\u0002V]\t1q\n\u001d;j_:\u0004\"aV.\u000f\u0005aK\u0006C\u0001\"/\u0013\tQf&\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001./\u0011\u0015y6\u00011\u0001W\u00031\u0001x\u000e\u001a(b[\u0016\u001c\b/Y2f\u0011\u0015\t7\u00011\u0001W\u0003%\u0001x\u000e\u001a#p[\u0006Lg\u000e\u000b\u0002\u0004GB\u0011AmZ\u0007\u0002K*\u0011a-J\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00015f\u0005-Ie\u000e^3s]\u0006d\u0017\t]5\u0003--+(-\u001a:oKR,7/\u00119j\u000bb\u001cW\r\u001d;j_:\u001c2\u0001B6u!\ta\u0017O\u0004\u0002n_:\u0011!I\\\u0005\u0002_%\u0011\u0001OL\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00118O\u0001\tSk:$\u0018.\\3Fq\u000e,\u0007\u000f^5p]*\u0011\u0001O\f\t\u0003kjl\u0011A\u001e\u0006\u0003ob\fqaY8oiJ|GN\u0003\u0002z]\u0005!Q\u000f^5m\u0013\tYhO\u0001\u0007O_N#\u0018mY6Ue\u0006\u001cW-A\u0002ng\u001e$2A`A\u0001!\tyH!D\u0001\u0002\u0011\u0015ah\u00011\u0001W'\r9\u0011Q\u0001\t\u0005\u0003\u000f\tI!D\u0001$\u0013\r\tYa\t\u0002\u0011'\u0016\u0014h/[2f\t&\u001c8m\u001c<fef\faa]=ti\u0016l\u0007\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005UQ%A\u0003bGR|'/\u0003\u0003\u0002\u001a\u0005M!aC!di>\u00148+_:uK6$B!!\b\u0002 A\u0011\u0011f\u0002\u0005\b\u0003\u001bI\u0001\u0019AA\b\u0003\u0011AG\u000f\u001e9\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003_i!!!\u000b\u000b\t\u0005-\u0012QF\u0001\tg\u000e\fG.\u00193tY*\u0019\u0011\u0011E\u0013\n\t\u0005E\u0012\u0011\u0006\u0002\b\u0011R$\b/\u0012=u\u0003\u0015AG\u000f\u001e9!\u0003!\u0019X\r\u001e;j]\u001e\u001cXCAA\u001d!\rI\u00131H\u0005\u0004\u0003{\t#\u0001C*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013aA7biV\u0011\u0011Q\t\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J\u0013\u0002\rM$(/Z1n\u0013\u0011\ty%!\u0013\u0003#\u0005\u001bGo\u001c:NCR,'/[1mSj,'/\u0001\u0003nCR\u0004\u0013a\u00017pOV\u0011\u0011q\u000b\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL\u0013\u0002\u000b\u00154XM\u001c;\n\t\u0005\u0005\u00141\f\u0002\u000f\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\u0011awn\u001a\u0011\u0002+!$H\u000f]:UeV\u001cHo\u0015;pe\u0016\u001cuN\u001c4jOV\u0011\u0011\u0011\u000e\t\u0005\u0003W\ni(\u0004\u0002\u0002n)!\u0011qNA9\u0003\r\u00198\u000f\u001c\u0006\u0005\u0003g\n)(A\u0005tg2\u001cwN\u001c4jO*!\u0011qOA=\u0003!!\u0018\u0010]3tC\u001a,'BAA>\u0003\r\u0019w.\\\u0005\u0005\u0003\u007f\niG\u0001\tUeV\u001cHo\u0015;pe\u0016\u001cuN\u001c4jO\u00061\u0002\u000e\u001e;qgR\u0013Xo\u001d;Ti>\u0014XmQ8oM&<\u0007%A\u0006iiR\u00048oQ8oM&<WCAAD!\u0011\tI)!$\u000e\u0005\u0005-%b\u0001\u0014\u0002r%!\u0011qRAF\u00055\t5n[1T'2\u001buN\u001c4jO\u0006a\u0001\u000e\u001e;qg\u000e{gNZ5hA\u0005a\u0001\u000e\u001e;qg\u000e{g\u000e^3yiV\u0011\u0011q\u0013\t\u0005\u0003O\tI*\u0003\u0003\u0002\u001c\u0006%\"A\u0006%uiB\u001c8i\u001c8oK\u000e$\u0018n\u001c8D_:$X\r\u001f;\u0002\u001b!$H\u000f]:D_:$X\r\u001f;!\u0003\u0019awn\\6vaR1\u00111UA[\u0003\u007f\u0003b!!*\u0002,\u0006=VBAAT\u0015\r\tIKL\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAW\u0003O\u0013aAR;ukJ,\u0007cA \u00022&\u0019\u00111W&\u0003\u0011I+7o\u001c7wK\u0012Dq!a.\u0019\u0001\u0004\tI,A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0003\u0002\b\u0005m\u0016bAA_G\t1Aj\\8lkBDq!!1\u0019\u0001\u0004\t\u0019-\u0001\bsKN|GN^3US6,w.\u001e;\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fTA!!3\u0002(\u0006AA-\u001e:bi&|g.\u0003\u0003\u0002N\u0006\u001d'A\u0004$j]&$X\rR;sCRLwN\\\u0001\tCBLGk\\6f]V\ta+A\u0005ba&$vn[3oA\u0005i\u0001o\u001c3OC6,7\u000f]1dK\u0002\n1D]3bI\u000e{gNZ5h-\u0006\u0014hI]8n\r&dWm]=ti\u0016lG#B*\u0002\\\u0006}\u0007BBAo;\u0001\u0007a+\u0001\u0003qCRD\u0007BBAq;\u0001\u0007a+\u0001\u0003oC6,\u0017AD8qi&|g\u000eV8GkR,(/Z\u000b\u0005\u0003O\fy\u000f\u0006\u0004\u0002j\n\u0005!q\u0001\t\u0007\u0003K\u000bY+a;\u0011\t\u00055\u0018q\u001e\u0007\u0001\t\u001d\t\tP\bb\u0001\u0003g\u0014\u0011\u0001V\t\u0005\u0003k\fY\u0010E\u0002.\u0003oL1!!?/\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!LA\u007f\u0013\r\tyP\f\u0002\u0004\u0003:L\bb\u0002B\u0002=\u0001\u0007!QA\u0001\u0007_B$\u0018n\u001c8\u0011\t5\"\u00161\u001e\u0005\u0007\u0005\u0013q\u0002\u0019\u0001,\u0002\u000f\u0019\f\u0017\u000e\\'tO\u0006Q\u0001o\u001c3SKF,Xm\u001d;\u0015\u0011\t=!Q\u0004B\u0011\u0005K\u0001B!\f+\u0003\u0012A!!1\u0003B\r\u001b\t\u0011)B\u0003\u0003\u0003\u0018\u0005%\u0012!B7pI\u0016d\u0017\u0002\u0002B\u000e\u0005+\u00111\u0002\u0013;uaJ+\u0017/^3ti\"1!qD\u0010A\u0002Y\u000bQ\u0001^8lK:DaAa\t \u0001\u00041\u0016!\u00038b[\u0016\u001c\b/Y2f\u0011\u0019\u00119c\ba\u0001-\u0006iA.\u00192fYN+G.Z2u_J\u0004")
public class KubernetesApiServiceDiscovery
extends ServiceDiscovery {
    private final ActorSystem system;
    private final HttpExt http;
    private final Settings settings;
    private final ActorMaterializer mat;
    private final LoggingAdapter log;
    private final TrustStoreConfig httpsTrustStoreConfig;
    private final AkkaSSLConfig httpsConfig;
    private final HttpsConnectionContext httpsContext;
    private final String apiToken;
    private final String podNamespace;

    private HttpExt http() {
        return this.http;
    }

    private Settings settings() {
        return this.settings;
    }

    private ActorMaterializer mat() {
        return this.mat;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private TrustStoreConfig httpsTrustStoreConfig() {
        return this.httpsTrustStoreConfig;
    }

    private AkkaSSLConfig httpsConfig() {
        return this.httpsConfig;
    }

    private HttpsConnectionContext httpsContext() {
        return this.httpsContext;
    }

    public Future<ServiceDiscovery.Resolved> lookup(Lookup query, FiniteDuration resolveTimeout) {
        String labelSelector = this.settings().podLabelSelector(query.serviceName());
        this.log().info("Querying for pods with label selector: [{}]. Namespace: [{}]. Port: [{}]", (Object)labelSelector, (Object)this.podNamespace(), (Object)query.portName());
        return this.optionToFuture(this.podRequest(this.apiToken(), this.podNamespace(), labelSelector), new StringBuilder(76).append("Unable to form request; check Kubernetes environment (expecting env vars ").append(this.settings().apiServiceHostEnvName()).append(", ").append(this.settings().apiServicePortEnvName()).append(")").toString()).flatMap((Function1 & Serializable & scala.Serializable)request -> this.http().singleRequest(request, this.httpsContext(), this.http().singleRequest$default$3(), this.http().singleRequest$default$4()).flatMap((Function1 & Serializable & scala.Serializable)response -> response.entity().toStrict(resolveTimeout, (Materializer)this.mat()).flatMap((Function1 & Serializable & scala.Serializable)entity -> {
            Future future;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            StatusCode statusCode2 = statusCode;
            if (!(success != null ? !success.equals(statusCode2) : statusCode2 != null)) {
                this.log().debug("Kubernetes API entity: [{}]", (Object)entity.data().utf8String());
                Future unmarshalled = Unmarshal$.MODULE$.apply(entity).to(JsonFormat$.MODULE$.sprayJsonUnmarshaller(JsonFormat$.MODULE$.podListFormat()), (ExecutionContext)$this.system.dispatcher(), (Materializer)this.mat());
                unmarshalled.failed().foreach((Function1 & Serializable & scala.Serializable)t -> {
                    KubernetesApiServiceDiscovery.$anonfun$lookup$4(this, response, entity, t);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)$this.system.dispatcher());
                future = unmarshalled;
            } else {
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Forbidden();
                StatusCode statusCode3 = statusCode;
                if (!(clientError != null ? !clientError.equals(statusCode3) : statusCode3 != null)) {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), (Materializer)this.mat()).foreach((Function1 & Serializable & scala.Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$5(this, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException("Forbidden when communicating with the Kubernetes API. Check RBAC settings."));
                } else {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), (Materializer)this.mat()).foreach((Function1 & Serializable & scala.Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$6(this, statusCode, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException(new StringBuilder(36).append("Non-200 from Kubernetes API server: ").append(statusCode).toString()));
                }
            }
            return future.map((Function1 & Serializable & scala.Serializable)podList -> {
                scala.collection.immutable.Seq<ServiceDiscovery.ResolvedTarget> addresses;
                block0: {
                    addresses = KubernetesApiServiceDiscovery$.MODULE$.targets((PodList)podList, (Option<String>)query.portName(), this.podNamespace(), this.settings().podDomain());
                    if (!addresses.isEmpty() || !podList.items().nonEmpty() || !this.log().isInfoEnabled()) break block0;
                    Set containerPortNames = ((TraversableOnce)((GenericTraversableTemplate)((TraversableLike)((TraversableLike)podList.items().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(x$2.spec()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.containers(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(x$4.ports()), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toSet();
                    this.log().info("No targets found from pod list. Is the correct port name configured? Current configuration: [{}]. Ports on pods: [{}]", (Object)query.portName(), (Object)containerPortNames);
                }
                return ServiceDiscovery.Resolved$.MODULE$.apply(query.serviceName(), addresses);
            }, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    private String apiToken() {
        return this.apiToken;
    }

    private String podNamespace() {
        return this.podNamespace;
    }

    private Option<String> readConfigVarFromFilesystem(String path, String name) {
        Some some;
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                some = new Some((Object)new String(Files.readAllBytes(file), "utf-8"));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.log().error(e, "Error reading {} from {}", (Object)name, (Object)path);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
        } else {
            this.log().warning("Unable to read {} from {} because it doesn't exist.", (Object)name, (Object)path);
            some = None$.MODULE$;
        }
        return some;
    }

    private <T> Future<T> optionToFuture(Option<T> option, String failMsg) {
        return (Future)option.fold((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.failed((Throwable)new NoSuchElementException(failMsg)), (Function1 & Serializable & scala.Serializable)result -> Future$.MODULE$.successful(result));
    }

    private Option<HttpRequest> podRequest(String token, String namespace, String labelSelector) {
        return package$.MODULE$.env().get((Object)this.settings().apiServiceHostEnvName()).flatMap((Function1 & Serializable & scala.Serializable)host -> package$.MODULE$.env().get((Object)this.settings().apiServicePortEnvName()).flatMap((Function1 & Serializable & scala.Serializable)portStr -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(portStr)).toInt()).toOption().map((Function1 & Serializable & scala.Serializable)port -> KubernetesApiServiceDiscovery.$anonfun$podRequest$4(namespace, labelSelector, host, token, BoxesRunTime.unboxToInt((Object)port)))));
    }

    public static final /* synthetic */ void $anonfun$lookup$4(KubernetesApiServiceDiscovery $this, HttpResponse response$1, HttpEntity.Strict entity$1, Throwable t) {
        $this.log().warning("Failed to unmarshal Kubernetes API response.  Status code: [{}]; Response body: [{}]. Ex: [{}]", (Object)response$1.status().value(), (Object)entity$1, (Object)t.getMessage());
    }

    public static final /* synthetic */ void $anonfun$lookup$5(KubernetesApiServiceDiscovery $this, String body) {
        $this.log().warning("Forbidden to communicate with Kubernetes API server; check RBAC settings. Response: [{}]", (Object)body);
    }

    public static final /* synthetic */ void $anonfun$lookup$6(KubernetesApiServiceDiscovery $this, StatusCode x1$1, String body) {
        $this.log().warning("Non-200 when communicating with Kubernetes API server. Status code: [{}]. Response body: [{}]", (Object)x1$1, (Object)body);
    }

    public static final /* synthetic */ HttpRequest $anonfun$podRequest$4(String namespace$1, String labelSelector$1, String host$1, String token$1, int port) {
        Uri uri;
        Uri.Path path = Uri.Path$.Empty$.MODULE$.$div("api").$div("v1").$div("namespaces").$div(namespace$1).$div("pods");
        Uri.Query query = Uri.Query$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelSelector"), (Object)labelSelector$1)}));
        String x$1 = "https";
        String x$2 = host$1;
        int x$3 = port;
        String x$4 = Uri$.MODULE$.from$default$2();
        String x$5 = Uri$.MODULE$.from$default$5();
        Option x$6 = Uri$.MODULE$.from$default$6();
        Option x$7 = Uri$.MODULE$.from$default$7();
        Uri.ParsingMode x$8 = Uri$.MODULE$.from$default$8();
        Uri x$9 = uri = Uri$.MODULE$.from(x$1, x$4, x$2, x$3, x$5, x$6, x$7, x$8).withPath(path).withQuery(query);
        scala.collection.immutable.Seq x$10 = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Authorization[]{new Authorization((HttpCredentials)new OAuth2BearerToken(token$1))}));
        HttpMethod x$11 = HttpRequest$.MODULE$.apply$default$1();
        RequestEntity x$12 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$13 = HttpRequest$.MODULE$.apply$default$5();
        return HttpRequest$.MODULE$.apply(x$11, x$9, x$10, x$12, x$13);
    }

    public KubernetesApiServiceDiscovery(ActorSystem system) {
        this.system = system;
        this.http = Http$.MODULE$.apply(system);
        this.settings = (Settings)Settings$.MODULE$.apply(system);
        this.mat = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)system);
        this.log = Logging$.MODULE$.apply(system, (Object)this.getClass(), LogSource$.MODULE$.fromAnyClass());
        this.httpsTrustStoreConfig = TrustStoreConfig$.MODULE$.apply((Option)None$.MODULE$, (Option)new Some((Object)this.settings().apiCaPath())).withStoreType("PEM");
        this.httpsConfig = AkkaSSLConfig$.MODULE$.apply(system).mapSettings((Function1 & Serializable & scala.Serializable)s -> s.withTrustManagerConfig(s.trustManagerConfig().withTrustStoreConfigs((scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrustStoreConfig[]{this.httpsTrustStoreConfig()})))));
        this.httpsContext = this.http().createClientHttpsContext(this.httpsConfig());
        this.log().debug("Settings {}", (Object)this.settings());
        this.apiToken = (String)this.readConfigVarFromFilesystem(this.settings().apiTokenPath(), "api-token").getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.podNamespace = (String)this.settings().podNamespace().orElse((Function0 & Serializable & scala.Serializable)() -> this.readConfigVarFromFilesystem(this.settings().podNamespacePath(), "pod-namespace")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "default");
    }

    public static class KubernetesApiException
    extends RuntimeException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public KubernetesApiException(String msg) {
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }
}

