/*
 * Decompiled with CFR 0.152.
 */
package akka.discovery.kubernetes;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.discovery.Lookup;
import akka.discovery.ServiceDiscovery;
import akka.discovery.kubernetes.JsonFormat$;
import akka.discovery.kubernetes.KubernetesApiServiceDiscovery$;
import akka.discovery.kubernetes.PodList;
import akka.discovery.kubernetes.Settings;
import akka.discovery.kubernetes.Settings$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Authorization;
import akka.http.scaladsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.headers.OAuth2BearerToken;
import akka.http.scaladsl.unmarshalling.Unmarshal$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import com.typesafe.sslconfig.akka.AkkaSSLConfig;
import com.typesafe.sslconfig.akka.AkkaSSLConfig$;
import com.typesafe.sslconfig.ssl.TrustStoreConfig;
import com.typesafe.sslconfig.ssl.TrustStoreConfig$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMr!\u0002\u0011\"\u0011\u0003Ac!\u0002\u0016\"\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004B\u0002\u001b\u0002\t\u0003\tSG\u0002\u0003o\u0003\u0001y\u0007\"CA\u0002\t\t\u0005\t\u0015!\u0003W\u0011\u0019\u0011D\u0001\"\u0001\u0002\u0006\u0019)!&\t\u0001\u0002\u000e!Q\u0011qC\u0004\u0003\u0002\u0003\u0006I!!\u0007\t\rI:A\u0011AA\u0013\u0011%\tYc\u0002b\u0001\n\u0013\ti\u0003\u0003\u0005\u0002>\u001d\u0001\u000b\u0011BA\u0018\u0011%\tyd\u0002b\u0001\n\u0013\t\t\u0005\u0003\u0005\u0002J\u001d\u0001\u000b\u0011BA\"\u0011%\tYe\u0002b\u0001\n\u0017\ti\u0005\u0003\u0005\u0002\\\u001d\u0001\u000b\u0011BA(\u0011%\tif\u0002b\u0001\n\u0013\ty\u0006\u0003\u0005\u0002n\u001d\u0001\u000b\u0011BA1\u0011%\tyg\u0002b\u0001\n\u0013\t\t\b\u0003\u0005\u0002\f\u001e\u0001\u000b\u0011BA:\u0011%\tii\u0002b\u0001\n\u0013\ty\t\u0003\u0005\u0002\u001c\u001e\u0001\u000b\u0011BAI\u0011%\tij\u0002b\u0001\n\u0013\ty\n\u0003\u0005\u0002(\u001e\u0001\u000b\u0011BAQ\u0011\u001d\tIk\u0002C!\u0003WC\u0011\"!7\b\u0005\u0004%I!a7\t\u000f\u0005uw\u0001)A\u0005-\"Aql\u0002b\u0001\n\u0013\tY\u000eC\u0004\u0002`\u001e\u0001\u000b\u0011\u0002,\t\u000f\u0005\u0005x\u0001\"\u0003\u0002d\"9\u0011Q^\u0004\u0005\n\u0005=\bb\u0002B\u000b\u000f\u0011%!qC\u0001\u001e\u0017V\u0014WM\u001d8fi\u0016\u001c\u0018\t]5TKJ4\u0018nY3ESN\u001cwN^3ss*\u0011!eI\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u0001\u0013&\u0003%!\u0017n]2pm\u0016\u0014\u0018PC\u0001'\u0003\u0011\t7n[1\u0004\u0001A\u0011\u0011&A\u0007\u0002C\ti2*\u001e2fe:,G/Z:Ba&\u001cVM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u0018p\u0005\u0002\u0002YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0015\u0002\u000fQ\f'oZ3ugR1a\u0007T)_A\n\u00042a\u000e\u001f?\u001b\u0005A$BA\u001d;\u0003%IW.\\;uC\ndWM\u0003\u0002<]\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uB$aA*fcB\u0011q(\u0013\b\u0003\u0001\u001es!!\u0011$\u000f\u0005\t+U\"A\"\u000b\u0005\u0011;\u0013A\u0002\u001fs_>$h(C\u0001'\u0013\t!S%\u0003\u0002IG\u0005\u00012+\u001a:wS\u000e,G)[:d_Z,'/_\u0005\u0003\u0015.\u0013aBU3t_24X\r\u001a+be\u001e,GO\u0003\u0002IG!)Qj\u0001a\u0001\u001d\u00069\u0001o\u001c3MSN$\bCA\u0015P\u0013\t\u0001\u0016EA\u0004Q_\u0012d\u0015n\u001d;\t\u000bI\u001b\u0001\u0019A*\u0002\u0011A|'\u000f\u001e(b[\u0016\u00042!\f+W\u0013\t)fF\u0001\u0004PaRLwN\u001c\t\u0003/ns!\u0001W-\u0011\u0005\ts\u0013B\u0001./\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005is\u0003\"B0\u0004\u0001\u00041\u0016\u0001\u00049pI:\u000bW.Z:qC\u000e,\u0007\"B1\u0004\u0001\u00041\u0016!\u00039pI\u0012{W.Y5o\u0011\u0015\u00197\u00011\u0001e\u0003\u0015\u0011\u0018m^%q!\tiS-\u0003\u0002g]\t9!i\\8mK\u0006t\u0007FA\u0002i!\tIG.D\u0001k\u0015\tYW%\u0001\u0006b]:|G/\u0019;j_:L!!\u001c6\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0002\u0017\u0017V\u0014WM\u001d8fi\u0016\u001c\u0018\t]5Fq\u000e,\u0007\u000f^5p]N\u0019A\u0001]=\u0011\u0005E4hB\u0001:u\u001d\t\u00115/C\u00010\u0013\t)h&A\u0004qC\u000e\\\u0017mZ3\n\u0005]D(\u0001\u0005*v]RLW.Z#yG\u0016\u0004H/[8o\u0015\t)h\u0006\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u000691m\u001c8ue>d'B\u0001@/\u0003\u0011)H/\u001b7\n\u0007\u0005\u00051P\u0001\u0007O_N#\u0018mY6Ue\u0006\u001cW-A\u0002ng\u001e$B!a\u0002\u0002\fA\u0019\u0011\u0011\u0002\u0003\u000e\u0003\u0005Aa!a\u0001\u0007\u0001\u000416cA\u0004\u0002\u0010A!\u0011\u0011CA\n\u001b\u0005\u0019\u0013bAA\u000bG\t\u00012+\u001a:wS\u000e,G)[:d_Z,'/_\u0001\u0007gf\u001cH/Z7\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b&\u0003\u0015\t7\r^8s\u0013\u0011\t\u0019#!\b\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u000b\u0005\u0003O\tI\u0003\u0005\u0002*\u000f!9\u0011qC\u0005A\u0002\u0005e\u0011\u0001\u00025uiB,\"!a\f\u0011\t\u0005E\u0012\u0011H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005A1oY1mC\u0012\u001cHNC\u0002\u0002,\u0015JA!a\u000f\u00024\t9\u0001\n\u001e;q\u000bb$\u0018!\u00025uiB\u0004\u0013\u0001C:fiRLgnZ:\u0016\u0005\u0005\r\u0003cA\u0015\u0002F%\u0019\u0011qI\u0011\u0003\u0011M+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\u00075\fG/\u0006\u0002\u0002PA!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V\u0015\naa\u001d;sK\u0006l\u0017\u0002BA-\u0003'\u0012\u0011#Q2u_Jl\u0015\r^3sS\u0006d\u0017N_3s\u0003\u0011i\u0017\r\u001e\u0011\u0002\u00071|w-\u0006\u0002\u0002bA!\u00111MA5\u001b\t\t)GC\u0002\u0002h\u0015\nQ!\u001a<f]RLA!a\u001b\u0002f\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\nQ\u0003\u001b;uaN$&/^:u'R|'/Z\"p]\u001aLw-\u0006\u0002\u0002tA!\u0011QOAD\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014aA:tY*!\u0011QPA@\u0003%\u00198\u000f\\2p]\u001aLwM\u0003\u0003\u0002\u0002\u0006\r\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005\u0015\u0015aA2p[&!\u0011\u0011RA<\u0005A!&/^:u'R|'/Z\"p]\u001aLw-\u0001\fiiR\u00048\u000f\u0016:vgR\u001cFo\u001c:f\u0007>tg-[4!\u0003-AG\u000f\u001e9t\u0007>tg-[4\u0016\u0005\u0005E\u0005\u0003BAJ\u0003/k!!!&\u000b\u0007\u0019\nY(\u0003\u0003\u0002\u001a\u0006U%!D!lW\u0006\u001c6\u000bT\"p]\u001aLw-\u0001\u0007iiR\u00048oQ8oM&<\u0007%\u0001\u0007iiR\u00048oQ8oi\u0016DH/\u0006\u0002\u0002\"B!\u0011\u0011GAR\u0013\u0011\t)+a\r\u0003-!#H\u000f]:D_:tWm\u0019;j_:\u001cuN\u001c;fqR\fQ\u0002\u001b;uaN\u001cuN\u001c;fqR\u0004\u0013A\u00027p_.,\b\u000f\u0006\u0004\u0002.\u0006}\u0016\u0011\u001a\t\u0007\u0003_\u000b),!/\u000e\u0005\u0005E&bAAZ]\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005]\u0016\u0011\u0017\u0002\u0007\rV$XO]3\u0011\u0007}\nY,C\u0002\u0002>.\u0013\u0001BU3t_24X\r\u001a\u0005\b\u0003\u0003D\u0002\u0019AAb\u0003\u0015\tX/\u001a:z!\u0011\t\t\"!2\n\u0007\u0005\u001d7E\u0001\u0004M_>\\W\u000f\u001d\u0005\b\u0003\u0017D\u0002\u0019AAg\u00039\u0011Xm]8mm\u0016$\u0016.\\3pkR\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f\t,\u0001\u0005ekJ\fG/[8o\u0013\u0011\t9.!5\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006A\u0011\r]5U_.,g.F\u0001W\u0003%\t\u0007/\u001b+pW\u0016t\u0007%A\u0007q_\u0012t\u0015-\\3ta\u0006\u001cW\rI\u0001\u001ce\u0016\fGmQ8oM&<g+\u0019:Ge>lg)\u001b7fgf\u001cH/Z7\u0015\u000bM\u000b)/!;\t\r\u0005\u001dX\u00041\u0001W\u0003\u0011\u0001\u0018\r\u001e5\t\r\u0005-X\u00041\u0001W\u0003\u0011q\u0017-\\3\u0002\u001d=\u0004H/[8o)>4U\u000f^;sKV!\u0011\u0011_A})\u0019\t\u0019Pa\u0003\u0003\u0012A1\u0011qVA[\u0003k\u0004B!a>\u0002z2\u0001AaBA~=\t\u0007\u0011Q \u0002\u0002)F!\u0011q B\u0003!\ri#\u0011A\u0005\u0004\u0005\u0007q#a\u0002(pi\"Lgn\u001a\t\u0004[\t\u001d\u0011b\u0001B\u0005]\t\u0019\u0011I\\=\t\u000f\t5a\u00041\u0001\u0003\u0010\u00051q\u000e\u001d;j_:\u0004B!\f+\u0002v\"1!1\u0003\u0010A\u0002Y\u000bqAZ1jY6\u001bx-\u0001\u0006q_\u0012\u0014V-];fgR$\u0002B!\u0007\u0003(\t-\"q\u0006\t\u0005[Q\u0013Y\u0002\u0005\u0003\u0003\u001e\t\rRB\u0001B\u0010\u0015\u0011\u0011\t#a\r\u0002\u000b5|G-\u001a7\n\t\t\u0015\"q\u0004\u0002\f\u0011R$\bOU3rk\u0016\u001cH\u000f\u0003\u0004\u0003*}\u0001\rAV\u0001\u0006i>\\WM\u001c\u0005\u0007\u0005[y\u0002\u0019\u0001,\u0002\u00139\fW.Z:qC\u000e,\u0007B\u0002B\u0019?\u0001\u0007a+A\u0007mC\n,GnU3mK\u000e$xN\u001d")
public class KubernetesApiServiceDiscovery
extends ServiceDiscovery {
    private final ActorSystem system;
    private final HttpExt http;
    private final Settings settings;
    private final ActorMaterializer mat;
    private final LoggingAdapter log;
    private final TrustStoreConfig httpsTrustStoreConfig;
    private final AkkaSSLConfig httpsConfig;
    private final HttpsConnectionContext httpsContext;
    private final String apiToken;
    private final String podNamespace;

    private HttpExt http() {
        return this.http;
    }

    private Settings settings() {
        return this.settings;
    }

    private ActorMaterializer mat() {
        return this.mat;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private TrustStoreConfig httpsTrustStoreConfig() {
        return this.httpsTrustStoreConfig;
    }

    private AkkaSSLConfig httpsConfig() {
        return this.httpsConfig;
    }

    private HttpsConnectionContext httpsContext() {
        return this.httpsContext;
    }

    public Future<ServiceDiscovery.Resolved> lookup(Lookup query, FiniteDuration resolveTimeout) {
        String labelSelector = this.settings().podLabelSelector(query.serviceName());
        this.log().info("Querying for pods with label selector: [{}]. Namespace: [{}]. Port: [{}]", (Object)labelSelector, (Object)this.podNamespace(), (Object)query.portName());
        return this.optionToFuture(this.podRequest(this.apiToken(), this.podNamespace(), labelSelector), new StringBuilder(76).append("Unable to form request; check Kubernetes environment (expecting env vars ").append(this.settings().apiServiceHostEnvName()).append(", ").append(this.settings().apiServicePortEnvName()).append(")").toString()).flatMap((Function1 & Serializable & scala.Serializable)request -> this.http().singleRequest(request, this.httpsContext(), this.http().singleRequest$default$3(), this.http().singleRequest$default$4()).flatMap((Function1 & Serializable & scala.Serializable)response -> response.entity().toStrict(resolveTimeout, (Materializer)this.mat()).flatMap((Function1 & Serializable & scala.Serializable)entity -> {
            Future future;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            StatusCode statusCode2 = statusCode;
            if (!(success != null ? !success.equals(statusCode2) : statusCode2 != null)) {
                this.log().debug("Kubernetes API entity: [{}]", (Object)entity.data().utf8String());
                Future unmarshalled = Unmarshal$.MODULE$.apply(entity).to(JsonFormat$.MODULE$.sprayJsonUnmarshaller(JsonFormat$.MODULE$.podListFormat()), (ExecutionContext)$this.system.dispatcher(), (Materializer)this.mat());
                unmarshalled.failed().foreach((Function1 & Serializable & scala.Serializable)t -> {
                    KubernetesApiServiceDiscovery.$anonfun$lookup$4(this, response, entity, t);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)$this.system.dispatcher());
                future = unmarshalled;
            } else {
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Forbidden();
                StatusCode statusCode3 = statusCode;
                if (!(clientError != null ? !clientError.equals(statusCode3) : statusCode3 != null)) {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), (Materializer)this.mat()).foreach((Function1 & Serializable & scala.Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$5(this, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException("Forbidden when communicating with the Kubernetes API. Check RBAC settings."));
                } else {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), (Materializer)this.mat()).foreach((Function1 & Serializable & scala.Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$6(this, statusCode, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException(new StringBuilder(36).append("Non-200 from Kubernetes API server: ").append(statusCode).toString()));
                }
            }
            return future.map((Function1 & Serializable & scala.Serializable)podList -> {
                scala.collection.immutable.Seq<ServiceDiscovery.ResolvedTarget> addresses;
                block0: {
                    addresses = KubernetesApiServiceDiscovery$.MODULE$.targets((PodList)podList, (Option<String>)query.portName(), this.podNamespace(), this.settings().podDomain(), this.settings().rawIp());
                    if (!addresses.isEmpty() || !podList.items().nonEmpty() || !this.log().isInfoEnabled()) break block0;
                    Set containerPortNames = ((TraversableOnce)((GenericTraversableTemplate)((TraversableLike)((TraversableLike)podList.items().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(x$2.spec()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.containers(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(x$4.ports()), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toSet();
                    this.log().info("No targets found from pod list. Is the correct port name configured? Current configuration: [{}]. Ports on pods: [{}]", (Object)query.portName(), (Object)containerPortNames);
                }
                return ServiceDiscovery.Resolved$.MODULE$.apply(query.serviceName(), addresses);
            }, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    private String apiToken() {
        return this.apiToken;
    }

    private String podNamespace() {
        return this.podNamespace;
    }

    private Option<String> readConfigVarFromFilesystem(String path, String name) {
        Some some;
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                some = new Some((Object)new String(Files.readAllBytes(file), "utf-8"));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.log().error(e, "Error reading {} from {}", (Object)name, (Object)path);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
        } else {
            this.log().warning("Unable to read {} from {} because it doesn't exist.", (Object)name, (Object)path);
            some = None$.MODULE$;
        }
        return some;
    }

    private <T> Future<T> optionToFuture(Option<T> option, String failMsg) {
        return (Future)option.fold((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.failed((Throwable)new NoSuchElementException(failMsg)), (Function1 & Serializable & scala.Serializable)result -> Future$.MODULE$.successful(result));
    }

    private Option<HttpRequest> podRequest(String token, String namespace, String labelSelector) {
        return package$.MODULE$.env().get((Object)this.settings().apiServiceHostEnvName()).flatMap((Function1 & Serializable & scala.Serializable)host -> package$.MODULE$.env().get((Object)this.settings().apiServicePortEnvName()).flatMap((Function1 & Serializable & scala.Serializable)portStr -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(portStr)).toInt()).toOption().map((Function1 & Serializable & scala.Serializable)port -> KubernetesApiServiceDiscovery.$anonfun$podRequest$4(namespace, labelSelector, host, token, BoxesRunTime.unboxToInt((Object)port)))));
    }

    public static final /* synthetic */ void $anonfun$lookup$4(KubernetesApiServiceDiscovery $this, HttpResponse response$1, HttpEntity.Strict entity$1, Throwable t) {
        $this.log().warning("Failed to unmarshal Kubernetes API response.  Status code: [{}]; Response body: [{}]. Ex: [{}]", (Object)response$1.status().value(), (Object)entity$1, (Object)t.getMessage());
    }

    public static final /* synthetic */ void $anonfun$lookup$5(KubernetesApiServiceDiscovery $this, String body) {
        $this.log().warning("Forbidden to communicate with Kubernetes API server; check RBAC settings. Response: [{}]", (Object)body);
    }

    public static final /* synthetic */ void $anonfun$lookup$6(KubernetesApiServiceDiscovery $this, StatusCode x1$1, String body) {
        $this.log().warning("Non-200 when communicating with Kubernetes API server. Status code: [{}]. Response body: [{}]", (Object)x1$1, (Object)body);
    }

    public static final /* synthetic */ HttpRequest $anonfun$podRequest$4(String namespace$1, String labelSelector$1, String host$1, String token$1, int port) {
        Uri uri;
        Uri.Path path = Uri.Path$.Empty$.MODULE$.$div("api").$div("v1").$div("namespaces").$div(namespace$1).$div("pods");
        Uri.Query query = Uri.Query$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelSelector"), (Object)labelSelector$1)}));
        String x$1 = "https";
        String x$2 = host$1;
        int x$3 = port;
        String x$4 = Uri$.MODULE$.from$default$2();
        String x$5 = Uri$.MODULE$.from$default$5();
        Option x$6 = Uri$.MODULE$.from$default$6();
        Option x$7 = Uri$.MODULE$.from$default$7();
        Uri.ParsingMode x$8 = Uri$.MODULE$.from$default$8();
        Uri x$9 = uri = Uri$.MODULE$.from(x$1, x$4, x$2, x$3, x$5, x$6, x$7, x$8).withPath(path).withQuery(query);
        scala.collection.immutable.Seq x$10 = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Authorization[]{new Authorization((HttpCredentials)new OAuth2BearerToken(token$1))}));
        HttpMethod x$11 = HttpRequest$.MODULE$.apply$default$1();
        RequestEntity x$12 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$13 = HttpRequest$.MODULE$.apply$default$5();
        return HttpRequest$.MODULE$.apply(x$11, x$9, x$10, x$12, x$13);
    }

    public KubernetesApiServiceDiscovery(ActorSystem system) {
        this.system = system;
        this.http = Http$.MODULE$.apply(system);
        this.settings = (Settings)Settings$.MODULE$.apply(system);
        this.mat = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)system);
        this.log = Logging$.MODULE$.apply(system, (Object)this.getClass(), LogSource$.MODULE$.fromAnyClass());
        this.httpsTrustStoreConfig = TrustStoreConfig$.MODULE$.apply((Option)None$.MODULE$, (Option)new Some((Object)this.settings().apiCaPath())).withStoreType("PEM");
        this.httpsConfig = AkkaSSLConfig$.MODULE$.apply(system).mapSettings((Function1 & Serializable & scala.Serializable)s -> s.withTrustManagerConfig(s.trustManagerConfig().withTrustStoreConfigs((scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrustStoreConfig[]{this.httpsTrustStoreConfig()})))));
        this.httpsContext = this.http().createClientHttpsContext(this.httpsConfig());
        this.log().debug("Settings {}", (Object)this.settings());
        this.apiToken = (String)this.readConfigVarFromFilesystem(this.settings().apiTokenPath(), "api-token").getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.podNamespace = (String)this.settings().podNamespace().orElse((Function0 & Serializable & scala.Serializable)() -> this.readConfigVarFromFilesystem(this.settings().podNamespacePath(), "pod-namespace")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "default");
    }

    public static class KubernetesApiException
    extends RuntimeException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public KubernetesApiException(String msg) {
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }
}

