/*
 * Decompiled with CFR 0.152.
 */
package akka.discovery.kubernetes;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.discovery.Lookup;
import akka.discovery.ServiceDiscovery;
import akka.discovery.kubernetes.JsonFormat$;
import akka.discovery.kubernetes.KubernetesApiServiceDiscovery$;
import akka.discovery.kubernetes.PodList;
import akka.discovery.kubernetes.Settings;
import akka.discovery.kubernetes.Settings$;
import akka.dispatch.Dispatchers$;
import akka.dispatch.MessageDispatcher;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.ConnectionContext$;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Authorization;
import akka.http.scaladsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.headers.OAuth2BearerToken;
import akka.http.scaladsl.unmarshalling.Unmarshal$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.pki.kubernetes.PemManagersProvider$;
import akka.stream.Materializer$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t%x!\u0002\u001a4\u0011\u0003Qd!\u0002\u001f4\u0011\u0003i\u0004\"\u0002#\u0002\t\u0003)\u0005B\u0002$\u0002\t\u0003\u0019tI\u0002\u0004\u0002\u0006\u0005\u0001\u0011q\u0001\u0005\n\u0003W!!\u0011!Q\u0001\n!Da\u0001\u0012\u0003\u0005\u0002\u00055bABA\u001b\u0003\u0019\u000b9\u0004C\u0005r\u000f\tU\r\u0011\"\u0001\u0002F!I\u0011qI\u0004\u0003\u0012\u0003\u0006I\u0001\u001b\u0005\u000b\u0003\u0013:!Q3A\u0005\u0002\u0005\u0015\u0003\"CA&\u000f\tE\t\u0015!\u0003i\u0011)\tie\u0002BK\u0002\u0013\u0005\u0011q\n\u0005\u000b\u0003C:!\u0011#Q\u0001\n\u0005E\u0003B\u0002#\b\t\u0003\t\u0019\u0007C\u0005\u0002n\u001d\t\t\u0011\"\u0001\u0002p!I\u0011qO\u0004\u0012\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003\u001b;\u0011\u0013!C\u0001\u0003sB\u0011\"a$\b#\u0003%\t!!%\t\u0013\u0005Uu!!A\u0005B\u0005]\u0005\"CAT\u000f\u0005\u0005I\u0011AAU\u0011%\t\tlBA\u0001\n\u0003\t\u0019\fC\u0005\u0002@\u001e\t\t\u0011\"\u0011\u0002B\"I\u00111Z\u0004\u0002\u0002\u0013\u0005\u0011Q\u001a\u0005\n\u0003#<\u0011\u0011!C!\u0003'D\u0011\"!6\b\u0003\u0003%\t%a6\t\u0013\u0005ew!!A\u0005B\u0005mw!CAp\u0003\u0005\u0005\t\u0012BAq\r%\t)$AA\u0001\u0012\u0013\t\u0019\u000f\u0003\u0004E9\u0011\u0005\u0011\u0011\u001f\u0005\n\u0003+d\u0012\u0011!C#\u0003/D\u0011\"a=\u001d\u0003\u0003%\t)!>\t\u0013\u0005uH$!A\u0005\u0002\u0006}\b\"\u0003B\u00079\u0005\u0005I\u0011\u0002B\b\r\u0015a4\u0007\u0001B\f\u0011)\u0011\tC\tB\u0001B\u0003-!1\u0005\u0005\u0007\t\n\"\tAa\f\t\u0013\u0005m#E1A\u0005\n\t]\u0002\u0002\u0003B E\u0001\u0006IA!\u000f\t\u0013\t\u0005#E1A\u0005\n\t\r\u0003\u0002\u0003B&E\u0001\u0006IA!\u0012\t\u0013\t5#E1A\u0005\n\t=\u0003\u0002\u0003B/E\u0001\u0006IA!\u0015\t\u0013\t}#E1A\u0005\n\t\u0005\u0004\u0002\u0003B:E\u0001\u0006IAa\u0019\t\u000f\tU$\u0005\"\u0011\u0003x!9!1\u0014\u0012\u0005\n\tu\u0005b\u0002B_E\u0011%!q\u0018\u0005\b\u0003\u001b\u0012C\u0011\u0002Bn\u0011\u001d\u0011iN\tC\u0005\u0005?\fQdS;cKJtW\r^3t\u0003BL7+\u001a:wS\u000e,G)[:d_Z,'/\u001f\u0006\u0003iU\n!b[;cKJtW\r^3t\u0015\t1t'A\u0005eSN\u001cwN^3ss*\t\u0001(\u0001\u0003bW.\f7\u0001\u0001\t\u0003w\u0005i\u0011a\r\u0002\u001e\u0017V\u0014WM\u001d8fi\u0016\u001c\u0018\t]5TKJ4\u0018nY3ESN\u001cwN^3ssN\u0011\u0011A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0014a\u0002;be\u001e,Go\u001d\u000b\b\u0011z\u001b\u0007O\u001d;z!\rIe\nU\u0007\u0002\u0015*\u00111\nT\u0001\nS6lW\u000f^1cY\u0016T!!\u0014!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002P\u0015\n\u00191+Z9\u0011\u0005E[fB\u0001*Z\u001d\t\u0019\u0006L\u0004\u0002U/6\tQK\u0003\u0002Ws\u00051AH]8pizJ\u0011\u0001O\u0005\u0003m]J!AW\u001b\u0002!M+'O^5dK\u0012K7oY8wKJL\u0018B\u0001/^\u00059\u0011Vm]8mm\u0016$G+\u0019:hKRT!AW\u001b\t\u000b}\u001b\u0001\u0019\u00011\u0002\u000fA|G\rT5tiB\u00111(Y\u0005\u0003EN\u0012q\u0001U8e\u0019&\u001cH\u000fC\u0003e\u0007\u0001\u0007Q-\u0001\u0005q_J$h*Y7f!\ryd\r[\u0005\u0003O\u0002\u0013aa\u00149uS>t\u0007CA5n\u001d\tQ7\u000e\u0005\u0002U\u0001&\u0011A\u000eQ\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002m\u0001\")\u0011o\u0001a\u0001Q\u0006a\u0001o\u001c3OC6,7\u000f]1dK\")1o\u0001a\u0001Q\u0006I\u0001o\u001c3E_6\f\u0017N\u001c\u0005\u0006k\u000e\u0001\rA^\u0001\u0006e\u0006<\u0018\n\u001d\t\u0003\u007f]L!\u0001\u001f!\u0003\u000f\t{w\u000e\\3b]\")!p\u0001a\u0001K\u0006i1m\u001c8uC&tWM\u001d(b[\u0016D#a\u0001?\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyx'\u0001\u0006b]:|G/\u0019;j_:L1!a\u0001\u007f\u0005-Ie\u000e^3s]\u0006d\u0017\t]5\u0003--+(-\u001a:oKR,7/\u00119j\u000bb\u001cW\r\u001d;j_:\u001cR\u0001BA\u0005\u00037\u0001B!a\u0003\u0002\u00169!\u0011QBA\t\u001d\r!\u0016qB\u0005\u0002\u0003&\u0019\u00111\u0003!\u0002\u000fA\f7m[1hK&!\u0011qCA\r\u0005A\u0011VO\u001c;j[\u0016,\u0005pY3qi&|gNC\u0002\u0002\u0014\u0001\u0003B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0004d_:$(o\u001c7\u000b\u0007\u0005\u0015\u0002)\u0001\u0003vi&d\u0017\u0002BA\u0015\u0003?\u0011ABT8Ti\u0006\u001c7\u000e\u0016:bG\u0016\f1!\\:h)\u0011\ty#a\r\u0011\u0007\u0005EB!D\u0001\u0002\u0011\u0019\tYC\u0002a\u0001Q\ny1*\u001e2fe:,G/Z:TKR,\bo\u0005\u0004\b}\u0005e\u0012q\b\t\u0004\u007f\u0005m\u0012bAA\u001f\u0001\n9\u0001K]8ek\u000e$\bcA \u0002B%\u0019\u00111\t!\u0003\u0019M+'/[1mSj\f'\r\\3\u0016\u0003!\fQ\u0002]8e\u001d\u0006lWm\u001d9bG\u0016\u0004\u0013\u0001C1qSR{7.\u001a8\u0002\u0013\u0005\u0004\u0018\u000eV8lK:\u0004\u0013\u0001H2mS\u0016tG\u000f\u0013;uaN\u001cuN\u001c8fGRLwN\\\"p]R,\u0007\u0010^\u000b\u0003\u0003#\u0002B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\r\tYfN\u0001\u0005QR$\b/\u0003\u0003\u0002`\u0005U#A\u0006%uiB\u001c8i\u001c8oK\u000e$\u0018n\u001c8D_:$X\r\u001f;\u0002;\rd\u0017.\u001a8u\u0011R$\bo]\"p]:,7\r^5p]\u000e{g\u000e^3yi\u0002\"\u0002\"!\u001a\u0002h\u0005%\u00141\u000e\t\u0004\u0003c9\u0001\"B9\u000f\u0001\u0004A\u0007BBA%\u001d\u0001\u0007\u0001\u000eC\u0004\u0002N9\u0001\r!!\u0015\u0002\t\r|\u0007/\u001f\u000b\t\u0003K\n\t(a\u001d\u0002v!9\u0011o\u0004I\u0001\u0002\u0004A\u0007\u0002CA%\u001fA\u0005\t\u0019\u00015\t\u0013\u00055s\u0002%AA\u0002\u0005E\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003wR3\u0001[A?W\t\ty\b\u0005\u0003\u0002\u0002\u0006%UBAAB\u0015\u0011\t))a\"\u0002\u0013Ut7\r[3dW\u0016$'BA@A\u0013\u0011\tY)a!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0013\u0016\u0005\u0003#\ni(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0003B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+\u0001\u0003mC:<'BAAR\u0003\u0011Q\u0017M^1\n\u00079\fi*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002,B\u0019q(!,\n\u0007\u0005=\u0006IA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00026\u0006m\u0006cA \u00028&\u0019\u0011\u0011\u0018!\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002>V\t\t\u00111\u0001\u0002,\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a1\u0011\r\u0005\u0015\u0017qYA[\u001b\u0005a\u0015bAAe\u0019\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r1\u0018q\u001a\u0005\n\u0003{;\u0012\u0011!a\u0001\u0003k\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003W\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\u000ba!Z9vC2\u001cHc\u0001<\u0002^\"I\u0011Q\u0018\u000e\u0002\u0002\u0003\u0007\u0011QW\u0001\u0010\u0017V\u0014WM\u001d8fi\u0016\u001c8+\u001a;vaB\u0019\u0011\u0011\u0007\u000f\u0014\u000bq\t)/a\u0010\u0011\u0015\u0005\u001d\u0018Q\u001e5i\u0003#\n)'\u0004\u0002\u0002j*\u0019\u00111\u001e!\u0002\u000fI,h\u000e^5nK&!\u0011q^Au\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003C\fQ!\u00199qYf$\u0002\"!\u001a\u0002x\u0006e\u00181 \u0005\u0006c~\u0001\r\u0001\u001b\u0005\u0007\u0003\u0013z\u0002\u0019\u00015\t\u000f\u00055s\u00041\u0001\u0002R\u00059QO\\1qa2LH\u0003\u0002B\u0001\u0005\u0013\u0001Ba\u00104\u0003\u0004A9qH!\u0002iQ\u0006E\u0013b\u0001B\u0004\u0001\n1A+\u001e9mKNB\u0011Ba\u0003!\u0003\u0003\u0005\r!!\u001a\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\t!\u0011\tYJa\u0005\n\t\tU\u0011Q\u0014\u0002\u0007\u001f\nTWm\u0019;\u0014\u0007\t\u0012I\u0002\u0005\u0003\u0003\u001c\tuQ\"A\u001b\n\u0007\t}QG\u0001\tTKJ4\u0018nY3ESN\u001cwN^3ss\u000611/_:uK6\u0004BA!\n\u0003,5\u0011!q\u0005\u0006\u0004\u0005S9\u0014!B1di>\u0014\u0018\u0002\u0002B\u0017\u0005O\u00111\"Q2u_J\u001c\u0016p\u001d;f[R\u0011!\u0011\u0007\u000b\u0005\u0005g\u0011)\u0004\u0005\u0002<E!9!\u0011\u0005\u0013A\u0004\t\rRC\u0001B\u001d!\u0011\t\u0019Fa\u000f\n\t\tu\u0012Q\u000b\u0002\b\u0011R$\b/\u0012=u\u0003\u0015AG\u000f\u001e9!\u0003!\u0019X\r\u001e;j]\u001e\u001cXC\u0001B#!\rY$qI\u0005\u0004\u0005\u0013\u001a$\u0001C*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013a\u00017pOV\u0011!\u0011\u000b\t\u0005\u0005'\u0012I&\u0004\u0002\u0003V)\u0019!qK\u001c\u0002\u000b\u00154XM\u001c;\n\t\tm#Q\u000b\u0002\u000f\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\u0011awn\u001a\u0011\u0002\u001f-,(-\u001a:oKR,7oU3ukB,\"Aa\u0019\u0011\r\t\u0015$1\u000eB8\u001b\t\u00119GC\u0002\u0003j\u0001\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\u0011iGa\u001a\u0003\r\u0019+H/\u001e:f!\r\u0011\th\u0002\b\u0003w\u0001\t\u0001c[;cKJtW\r^3t'\u0016$X\u000f\u001d\u0011\u0002\r1|wn[;q)\u0019\u0011IH!!\u0003\fB1!Q\rB6\u0005w\u00022!\u0015B?\u0013\r\u0011y(\u0018\u0002\t%\u0016\u001cx\u000e\u001c<fI\"9!1Q\u0017A\u0002\t\u0015\u0015!B9vKJL\b\u0003\u0002B\u000e\u0005\u000fK1A!#6\u0005\u0019aun\\6va\"9!QR\u0017A\u0002\t=\u0015A\u0004:fg>dg/\u001a+j[\u0016|W\u000f\u001e\t\u0005\u0005#\u00139*\u0004\u0002\u0003\u0014*!!Q\u0013B4\u0003!!WO]1uS>t\u0017\u0002\u0002BM\u0005'\u0013aBR5oSR,G)\u001e:bi&|g.\u0001\bpaRLwN\u001c+p\rV$XO]3\u0016\t\t}%q\u0015\u000b\u0007\u0005C\u0013\u0019L!/\u0011\r\t\u0015$1\u000eBR!\u0011\u0011)Ka*\r\u0001\u00119!\u0011\u0016\u0018C\u0002\t-&!\u0001+\u0012\t\t5\u0016Q\u0017\t\u0004\u007f\t=\u0016b\u0001BY\u0001\n9aj\u001c;iS:<\u0007b\u0002B[]\u0001\u0007!qW\u0001\u0007_B$\u0018n\u001c8\u0011\t}2'1\u0015\u0005\u0007\u0005ws\u0003\u0019\u00015\u0002\u000f\u0019\f\u0017\u000e\\'tO\u0006Q\u0001o\u001c3SKF,Xm\u001d;\u0015\u0011\t\u0005'q\u001aBj\u0005/\u0004Ba\u00104\u0003DB!!Q\u0019Bf\u001b\t\u00119M\u0003\u0003\u0003J\u0006U\u0013!B7pI\u0016d\u0017\u0002\u0002Bg\u0005\u000f\u00141\u0002\u0013;uaJ+\u0017/^3ti\"1!\u0011[\u0018A\u0002!\fQ\u0001^8lK:DaA!60\u0001\u0004A\u0017!\u00038b[\u0016\u001c\b/Y2f\u0011\u0019\u0011In\fa\u0001Q\u0006iA.\u00192fYN+G.Z2u_J$\"!!\u0015\u00027I,\u0017\rZ\"p]\u001aLwMV1s\rJ|WNR5mKNL8\u000f^3n)\u0015)'\u0011\u001dBs\u0011\u0019\u0011\u0019/\ra\u0001Q\u0006!\u0001/\u0019;i\u0011\u0019\u00119/\ra\u0001Q\u0006!a.Y7f\u0001")
public class KubernetesApiServiceDiscovery
extends ServiceDiscovery {
    private final ActorSystem system;
    private final HttpExt http;
    private final Settings settings;
    private final LoggingAdapter log;
    private final Future<KubernetesSetup> kubernetesSetup;

    private HttpExt http() {
        return this.http;
    }

    private Settings settings() {
        return this.settings;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private Future<KubernetesSetup> kubernetesSetup() {
        return this.kubernetesSetup;
    }

    public Future<ServiceDiscovery.Resolved> lookup(Lookup query, FiniteDuration resolveTimeout) {
        String labelSelector = this.settings().podLabelSelector(query.serviceName());
        return this.kubernetesSetup().flatMap((Function1 & Serializable & scala.Serializable)setup -> {
            this.log().info("Querying for pods with label selector: [{}]. Namespace: [{}]. Port: [{}]", (Object)labelSelector, (Object)setup.podNamespace(), (Object)query.portName());
            return this.optionToFuture(this.podRequest(setup.apiToken(), setup.podNamespace(), labelSelector), new StringBuilder(76).append("Unable to form request; check Kubernetes environment (expecting env vars ").append(this.settings().apiServiceHostEnvName()).append(", ").append(this.settings().apiServicePortEnvName()).append(")").toString()).flatMap((Function1 & Serializable & scala.Serializable)request -> this.http().singleRequest(request, setup.clientHttpsConnectionContext(), this.http().singleRequest$default$3(), this.http().singleRequest$default$4()).flatMap((Function1 & Serializable & scala.Serializable)response -> response.entity().toStrict(resolveTimeout, Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).flatMap((Function1 & Serializable & scala.Serializable)entity -> {
                Future future;
                StatusCode statusCode = response.status();
                StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                StatusCode statusCode2 = statusCode;
                if (!(success != null ? !success.equals(statusCode2) : statusCode2 != null)) {
                    this.log().debug("Kubernetes API entity: [{}]", (Object)entity.data().utf8String());
                    Future unmarshalled = Unmarshal$.MODULE$.apply(entity).to(JsonFormat$.MODULE$.sprayJsonUnmarshaller(JsonFormat$.MODULE$.podListFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system));
                    unmarshalled.failed().foreach((Function1 & Serializable & scala.Serializable)t -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$5(this, response, entity, t);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = unmarshalled;
                } else {
                    StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Forbidden();
                    StatusCode statusCode3 = statusCode;
                    if (!(clientError != null ? !clientError.equals(statusCode3) : statusCode3 != null)) {
                        Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable & scala.Serializable)body -> {
                            KubernetesApiServiceDiscovery.$anonfun$lookup$6(this, body);
                            return BoxedUnit.UNIT;
                        }, (ExecutionContext)$this.system.dispatcher());
                        future = Future$.MODULE$.failed((Throwable)new KubernetesApiException("Forbidden when communicating with the Kubernetes API. Check RBAC settings."));
                    } else {
                        Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable & scala.Serializable)body -> {
                            KubernetesApiServiceDiscovery.$anonfun$lookup$7(this, statusCode, body);
                            return BoxedUnit.UNIT;
                        }, (ExecutionContext)$this.system.dispatcher());
                        future = Future$.MODULE$.failed((Throwable)new KubernetesApiException(new StringBuilder(36).append("Non-200 from Kubernetes API server: ").append(statusCode).toString()));
                    }
                }
                return future.map((Function1 & Serializable & scala.Serializable)podList -> {
                    scala.collection.immutable.Seq<ServiceDiscovery.ResolvedTarget> addresses;
                    block0: {
                        addresses = KubernetesApiServiceDiscovery$.MODULE$.targets((PodList)podList, (Option<String>)query.portName(), setup.podNamespace(), this.settings().podDomain(), this.settings().rawIp(), this.settings().containerName());
                        if (!addresses.isEmpty() || !podList.items().nonEmpty() || !this.log().isInfoEnabled()) break block0;
                        Set containerPortNames = ((TraversableOnce)((GenericTraversableTemplate)((TraversableLike)((TraversableLike)podList.items().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(x$4.spec()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.containers(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> Option$.MODULE$.option2Iterable(x$6.ports()), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toSet();
                        this.log().info("No targets found from pod list. Is the correct port name configured? Current configuration: [{}]. Ports on pods: [{}]", (Object)query.portName(), (Object)containerPortNames);
                    }
                    return ServiceDiscovery.Resolved$.MODULE$.apply(query.serviceName(), addresses);
                }, (ExecutionContext)$this.system.dispatcher());
            }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)this.system.dispatcher());
    }

    private <T> Future<T> optionToFuture(Option<T> option, String failMsg) {
        return (Future)option.fold((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.failed((Throwable)new NoSuchElementException(failMsg)), (Function1 & Serializable & scala.Serializable)result -> Future$.MODULE$.successful(result));
    }

    private Option<HttpRequest> podRequest(String token, String namespace, String labelSelector) {
        return package$.MODULE$.env().get((Object)this.settings().apiServiceHostEnvName()).flatMap((Function1 & Serializable & scala.Serializable)host -> package$.MODULE$.env().get((Object)this.settings().apiServicePortEnvName()).flatMap((Function1 & Serializable & scala.Serializable)portStr -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(portStr)).toInt()).toOption().map((Function1 & Serializable & scala.Serializable)port -> KubernetesApiServiceDiscovery.$anonfun$podRequest$4(namespace, labelSelector, host, token, BoxesRunTime.unboxToInt((Object)port)))));
    }

    private HttpsConnectionContext clientHttpsConnectionContext() {
        Iterable certificates = PemManagersProvider$.MODULE$.loadCertificates(this.settings().apiCaPath());
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null);
        factory.init(keyStore, (char[])Array$.MODULE$.empty(ClassTag$.MODULE$.Char()));
        KeyManager[] km = factory.getKeyManagers();
        TrustManager[] tm = PemManagersProvider$.MODULE$.buildTrustManagers(certificates);
        SecureRandom random = new SecureRandom();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(km, tm, random);
        return ConnectionContext$.MODULE$.httpsClient(sslContext);
    }

    private Option<String> readConfigVarFromFilesystem(String path, String name) {
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            Some some;
            try {
                some = new Some((Object)new String(Files.readAllBytes(file), "utf-8"));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.log().error(e, "Error reading {} from {}", (Object)name, (Object)path);
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        }
        this.log().warning("Unable to read {} from {} because it doesn't exist.", (Object)name, (Object)path);
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$kubernetesSetup$3(String check$ifrefutable$1) {
        String string = check$ifrefutable$1;
        return string != null;
    }

    public static final /* synthetic */ boolean $anonfun$kubernetesSetup$8(String check$ifrefutable$2) {
        String string = check$ifrefutable$2;
        return string != null;
    }

    public static final /* synthetic */ Future $anonfun$kubernetesSetup$4(KubernetesApiServiceDiscovery $this, ExecutionContext blockingDispatcher$1, String apiToken) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)$this.settings().podNamespace().orElse((Function0 & Serializable & scala.Serializable)() -> $this.readConfigVarFromFilesystem($this.settings().podNamespacePath(), "pod-namespace")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "default"), blockingDispatcher$1).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)KubernetesApiServiceDiscovery.$anonfun$kubernetesSetup$8(check$ifrefutable$2)), blockingDispatcher$1).flatMap((Function1 & Serializable & scala.Serializable)namespace -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.clientHttpsConnectionContext(), blockingDispatcher$1).map((Function1 & Serializable & scala.Serializable)httpsContext -> new KubernetesSetup((String)namespace, apiToken, (HttpsConnectionContext)httpsContext), blockingDispatcher$1), blockingDispatcher$1);
    }

    public static final /* synthetic */ void $anonfun$lookup$5(KubernetesApiServiceDiscovery $this, HttpResponse response$1, HttpEntity.Strict entity$1, Throwable t) {
        $this.log().warning("Failed to unmarshal Kubernetes API response.  Status code: [{}]; Response body: [{}]. Ex: [{}]", (Object)response$1.status().value(), (Object)entity$1, (Object)t.getMessage());
    }

    public static final /* synthetic */ void $anonfun$lookup$6(KubernetesApiServiceDiscovery $this, String body) {
        $this.log().warning("Forbidden to communicate with Kubernetes API server; check RBAC settings. Response: [{}]", (Object)body);
    }

    public static final /* synthetic */ void $anonfun$lookup$7(KubernetesApiServiceDiscovery $this, StatusCode x1$1, String body) {
        $this.log().warning("Non-200 when communicating with Kubernetes API server. Status code: [{}]. Response body: [{}]", (Object)x1$1, (Object)body);
    }

    public static final /* synthetic */ HttpRequest $anonfun$podRequest$4(String namespace$2, String labelSelector$2, String host$1, String token$1, int port) {
        Uri uri;
        Uri.Path path = Uri.Path$.Empty$.MODULE$.$div("api").$div("v1").$div("namespaces").$div(namespace$2).$div("pods");
        Uri.Query query = Uri.Query$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelSelector"), (Object)labelSelector$2)}));
        String x$1 = "https";
        String x$2 = host$1;
        int x$3 = port;
        String x$4 = Uri$.MODULE$.from$default$2();
        String x$5 = Uri$.MODULE$.from$default$5();
        Option x$6 = Uri$.MODULE$.from$default$6();
        Option x$7 = Uri$.MODULE$.from$default$7();
        Uri.ParsingMode x$8 = Uri$.MODULE$.from$default$8();
        Uri x$9 = uri = Uri$.MODULE$.from(x$1, x$4, x$2, x$3, x$5, x$6, x$7, x$8).withPath(path).withQuery(query);
        .colon.colon x$10 = new .colon.colon((Object)new Authorization((HttpCredentials)new OAuth2BearerToken(token$1)), (List)Nil$.MODULE$);
        HttpMethod x$11 = HttpRequest$.MODULE$.apply$default$1();
        RequestEntity x$12 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$13 = HttpRequest$.MODULE$.apply$default$5();
        return HttpRequest$.MODULE$.apply(x$11, x$9, (scala.collection.immutable.Seq)x$10, x$12, x$13);
    }

    public KubernetesApiServiceDiscovery(ActorSystem system) {
        this.system = system;
        this.http = Http$.MODULE$.apply((ClassicActorSystemProvider)system);
        this.settings = (Settings)Settings$.MODULE$.apply(system);
        this.log = Logging$.MODULE$.apply(system, KubernetesApiServiceDiscovery.class, LogSource$.MODULE$.fromAnyClass());
        this.log().debug("Settings {}", (Object)this.settings());
        MessageDispatcher blockingDispatcher = system.dispatchers().lookup(Dispatchers$.MODULE$.DefaultBlockingDispatcherId());
        this.kubernetesSetup = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)this.readConfigVarFromFilesystem(this.settings().apiTokenPath(), "api-token").getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (ExecutionContext)blockingDispatcher).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KubernetesApiServiceDiscovery.$anonfun$kubernetesSetup$3(check$ifrefutable$1)), (ExecutionContext)blockingDispatcher).flatMap(arg_0 -> KubernetesApiServiceDiscovery.$anonfun$kubernetesSetup$4(this, (ExecutionContext)blockingDispatcher, arg_0), (ExecutionContext)blockingDispatcher);
    }

    public static class KubernetesApiException
    extends RuntimeException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public KubernetesApiException(String msg) {
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }

    private static final class KubernetesSetup
    implements Product,
    scala.Serializable {
        private final String podNamespace;
        private final String apiToken;
        private final HttpsConnectionContext clientHttpsConnectionContext;

        public String podNamespace() {
            return this.podNamespace;
        }

        public String apiToken() {
            return this.apiToken;
        }

        public HttpsConnectionContext clientHttpsConnectionContext() {
            return this.clientHttpsConnectionContext;
        }

        public KubernetesSetup copy(String podNamespace, String apiToken, HttpsConnectionContext clientHttpsConnectionContext) {
            return new KubernetesSetup(podNamespace, apiToken, clientHttpsConnectionContext);
        }

        public String copy$default$1() {
            return this.podNamespace();
        }

        public String copy$default$2() {
            return this.apiToken();
        }

        public HttpsConnectionContext copy$default$3() {
            return this.clientHttpsConnectionContext();
        }

        public String productPrefix() {
            return "KubernetesSetup";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.podNamespace();
                }
                case 1: {
                    return this.apiToken();
                }
                case 2: {
                    return this.clientHttpsConnectionContext();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KubernetesSetup;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof KubernetesSetup)) return false;
            boolean bl = true;
            if (!bl) return false;
            KubernetesSetup kubernetesSetup = (KubernetesSetup)x$1;
            String string = this.podNamespace();
            String string2 = kubernetesSetup.podNamespace();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.apiToken();
            String string4 = kubernetesSetup.apiToken();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            HttpsConnectionContext httpsConnectionContext = this.clientHttpsConnectionContext();
            HttpsConnectionContext httpsConnectionContext2 = kubernetesSetup.clientHttpsConnectionContext();
            if (httpsConnectionContext == null) {
                if (httpsConnectionContext2 == null) return true;
                return false;
            } else {
                if (!httpsConnectionContext.equals(httpsConnectionContext2)) return false;
                return true;
            }
        }

        public KubernetesSetup(String podNamespace, String apiToken, HttpsConnectionContext clientHttpsConnectionContext) {
            this.podNamespace = podNamespace;
            this.apiToken = apiToken;
            this.clientHttpsConnectionContext = clientHttpsConnectionContext;
            Product.$init$((Product)this);
        }
    }
}

