/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.discovery.ServiceDiscovery$;
import akka.discovery.SimpleServiceDiscovery;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Initializing$;
import akka.management.cluster.bootstrap.ClusterBootstrap$NotRunning$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings$;
import akka.management.cluster.bootstrap.JoinDecider;
import akka.management.cluster.bootstrap.contactpoint.HttpClusterBootstrapRoutes;
import akka.management.cluster.bootstrap.dns.HeadlessServiceDnsBootstrap;
import akka.management.cluster.bootstrap.dns.HeadlessServiceDnsBootstrap$;
import akka.management.cluster.bootstrap.dns.HeadlessServiceDnsBootstrap$Protocol$InitiateBootstrapping$;
import akka.management.http.ManagementRouteProvider;
import akka.management.http.ManagementRouteProviderSettings;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0001\u0003\u0005-\u0011\u0001c\u00117vgR,'OQ8piN$(/\u00199\u000b\u0005\r!\u0011!\u00032p_R\u001cHO]1q\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u001dA\u0011AC7b]\u0006<W-\\3oi*\t\u0011\"\u0001\u0003bW.\f7\u0001A\n\u0005\u00011\u0011\u0002\u0004\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+!\tQ!Y2u_JL!a\u0006\u000b\u0003\u0013\u0015CH/\u001a8tS>t\u0007CA\r\u001d\u001b\u0005Q\"BA\u000e\u0007\u0003\u0011AG\u000f\u001e9\n\u0005uQ\"aF'b]\u0006<W-\\3oiJ{W\u000f^3Qe>4\u0018\u000eZ3s\u0011!y\u0002A!A!\u0002\u0017\u0001\u0013AB:zgR,W\u000e\u0005\u0002\u0014C%\u0011!\u0005\u0006\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\u0006I\u0001!\t!J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\"\"aJ\u0015\u0011\u0005!\u0002Q\"\u0001\u0002\t\u000b}\u0019\u00039\u0001\u0011\t\u000f-\u0002!\u0019!C\u0005Y\u0005\u0019An\\4\u0016\u00035\u0002\"AL\u0019\u000e\u0003=R!\u0001\r\u0005\u0002\u000b\u00154XM\u001c;\n\u0005Iz#A\u0004'pO\u001eLgnZ!eCB$XM\u001d\u0005\u0007i\u0001\u0001\u000b\u0011B\u0017\u0002\t1|w\r\t\u0005\bm\u0001\u0011\r\u0011\"\u00048\u00035\u0011wn\u001c;tiJ\f\u0007o\u0015;faV\t\u0001\bE\u0002:\u0005\u0012k\u0011A\u000f\u0006\u0003wq\na!\u0019;p[&\u001c'BA\u001f?\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u007f\u0001\u000bA!\u001e;jY*\t\u0011)\u0001\u0003kCZ\f\u0017BA\";\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CA#b\u001d\tAciB\u0003H\u0005!\u0005\u0001*\u0001\tDYV\u001cH/\u001a:C_>$8\u000f\u001e:baB\u0011\u0001&\u0013\u0004\u0006\u0003\tA\tAS\n\u0005\u00132Ye\nE\u0002\u0014\u0019\u001eJ!!\u0014\u000b\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003'=K!\u0001\u0015\u000b\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\t\u000b\u0011JE\u0011\u0001*\u0015\u0003!CQ\u0001V%\u0005BU\u000ba\u0001\\8pWV\u0004H#A#\t\u000b]KE\u0011\t-\u0002\u0007\u001d,G\u000f\u0006\u0002(3\")qD\u0016a\u00015B\u00111cW\u0005\u00039R\u00111\"Q2u_J\u001c\u0016p\u001d;f[\")a,\u0013C!?\u0006y1M]3bi\u0016,\u0005\u0010^3og&|g\u000e\u0006\u0002(A\")q$\u0018a\u0001A\u0019A!-\u0013I\u0001$C\u00111MA\u0007C_>$8\u000f\u001e:baN#X\r]\n\u0003C2Ic!Y3\u0002N\u0005EdA\u00024J\u0011\u0003\u0013qMA\u0006J]&$\u0018.\u00197ju\u0016$7#B3\rQ*l\u0007CA5b\u001b\u0005I\u0005CA\u0007l\u0013\tagBA\u0004Qe>$Wo\u0019;\u0011\u00055q\u0017BA8\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015!S\r\"\u0001r)\u0005\u0011\bCA5f\u0011\u001d!X-!A\u0005BU\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0005e\u0004\u0015\u0001\u00027b]\u001eL!a\u001f=\u0003\rM#(/\u001b8h\u0011\u001diX-!A\u0005\u0002y\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012a \t\u0004\u001b\u0005\u0005\u0011bAA\u0002\u001d\t\u0019\u0011J\u001c;\t\u0013\u0005\u001dQ-!A\u0005\u0002\u0005%\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\t\t\u0002E\u0002\u000e\u0003\u001bI1!a\u0004\u000f\u0005\r\te.\u001f\u0005\n\u0003'\t)!!AA\u0002}\f1\u0001\u001f\u00132\u0011%\t9\"ZA\u0001\n\u0003\nI\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u0002\u0005\u0004\u0002\u001e\u0005\r\u00121B\u0007\u0003\u0003?Q1!!\t\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\tyB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tI#ZA\u0001\n\u0003\tY#\u0001\u0005dC:,\u0015/^1m)\u0011\ti#a\r\u0011\u00075\ty#C\u0002\u000229\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002\u0014\u0005\u001d\u0012\u0011!a\u0001\u0003\u0017A\u0011\"a\u000ef\u0003\u0003%\t%!\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a \u0005\n\u0003{)\u0017\u0011!C!\u0003\u007f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002m\"I\u00111I3\u0002\u0002\u0013%\u0011QI\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002HA\u0019q/!\u0013\n\u0007\u0005-\u0003P\u0001\u0004PE*,7\r\u001e\u0004\t\u0003\u001fJ\u0005\u0012\u0011\u0002\u0002R\ta\u0011J\\5uS\u0006d\u0017N_5oON1\u0011Q\n\u0007iU6Dq\u0001JA'\t\u0003\t)\u0006\u0006\u0002\u0002XA\u0019\u0011.!\u0014\t\u0011Q\fi%!A\u0005BUD\u0001\"`A'\u0003\u0003%\tA \u0005\u000b\u0003\u000f\ti%!A\u0005\u0002\u0005}C\u0003BA\u0006\u0003CB\u0011\"a\u0005\u0002^\u0005\u0005\t\u0019A@\t\u0015\u0005]\u0011QJA\u0001\n\u0003\nI\u0002\u0003\u0006\u0002*\u00055\u0013\u0011!C\u0001\u0003O\"B!!\f\u0002j!Q\u00111CA3\u0003\u0003\u0005\r!a\u0003\t\u0015\u0005]\u0012QJA\u0001\n\u0003\nI\u0004\u0003\u0006\u0002>\u00055\u0013\u0011!C!\u0003\u007fA!\"a\u0011\u0002N\u0005\u0005I\u0011BA#\r!\t\u0019(\u0013EA\u0005\u0005U$A\u0003(piJ+hN\\5oON1\u0011\u0011\u000f\u0007iU6Dq\u0001JA9\t\u0003\tI\b\u0006\u0002\u0002|A\u0019\u0011.!\u001d\t\u0011Q\f\t(!A\u0005BUD\u0001\"`A9\u0003\u0003%\tA \u0005\u000b\u0003\u000f\t\t(!A\u0005\u0002\u0005\rE\u0003BA\u0006\u0003\u000bC\u0011\"a\u0005\u0002\u0002\u0006\u0005\t\u0019A@\t\u0015\u0005]\u0011\u0011OA\u0001\n\u0003\nI\u0002\u0003\u0006\u0002*\u0005E\u0014\u0011!C\u0001\u0003\u0017#B!!\f\u0002\u000e\"Q\u00111CAE\u0003\u0003\u0005\r!a\u0003\t\u0015\u0005]\u0012\u0011OA\u0001\n\u0003\nI\u0004\u0003\u0006\u0002>\u0005E\u0014\u0011!C!\u0003\u007fA!\"a\u0011\u0002r\u0005\u0005I\u0011BA#\u000f!\t9*\u0013EA\u0005\u0005m\u0014A\u0003(piJ+hN\\5oO\u001eA\u00111T%\t\u0002\n\t9&\u0001\u0007J]&$\u0018.\u00197ju&twmB\u0004\u0002 &C\tI\u0001:\u0002\u0017%s\u0017\u000e^5bY&TX\r\u001a\u0005\b\u0003G\u0003\u0001\u0015!\u00049\u00039\u0011wn\u001c;tiJ\f\u0007o\u0015;fa\u0002B\u0011\"a*\u0001\u0005\u0004%\t!!+\u0002\u0011M,G\u000f^5oON,\"!a+\u0011\u0007!\ni+C\u0002\u00020\n\u0011\u0001d\u00117vgR,'OQ8piN$(/\u00199TKR$\u0018N\\4t\u0011!\t\u0019\f\u0001Q\u0001\n\u0005-\u0016!C:fiRLgnZ:!\u0011%\t9\f\u0001b\u0001\n\u0003\tI,A\u0005eSN\u001cwN^3ssV\u0011\u00111\u0018\t\u0005\u0003{\u000b\t-\u0004\u0002\u0002@*\u0019\u0011q\u0017\u0005\n\t\u0005\r\u0017q\u0018\u0002\u0017'&l\u0007\u000f\\3TKJ4\u0018nY3ESN\u001cwN^3ss\"A\u0011q\u0019\u0001!\u0002\u0013\tY,\u0001\u0006eSN\u001cwN^3ss\u0002B\u0011\"a3\u0001\u0005\u0004%I!!4\u0002\u0017)|\u0017N\u001c#fG&$WM]\u000b\u0003\u0003\u001f\u00042\u0001KAi\u0013\r\t\u0019N\u0001\u0002\f\u0015>Lg\u000eR3dS\u0012,'\u000f\u0003\u0005\u0002X\u0002\u0001\u000b\u0011BAh\u00031Qw.\u001b8EK\u000eLG-\u001a:!\u0011!\tY\u000e\u0001Q\u0001\n\u0005u\u0017\u0001F0tK247i\u001c8uC\u000e$\bk\\5oiV\u0013\u0018\u000e\u0005\u0004\u0002`\u0006\r\u0018q]\u0007\u0003\u0003CT!!\u0010\b\n\t\u0005\u0015\u0018\u0011\u001d\u0002\b!J|W.[:f!\u0011\tI/!>\u000e\u0005\u0005-(\u0002BAw\u0003_\fQ!\\8eK2TA!!=\u0002t\u0006A1oY1mC\u0012\u001cHN\u0003\u0002\u001c\u0011%!\u0011q_Av\u0005\r)&/\u001b\u0005\b\u0003w\u0004A\u0011IA\u007f\u0003\u0019\u0011x.\u001e;fgR!\u0011q B\u0014!\u0011\u0011\tA!\t\u000f\t\t\r!1\u0004\b\u0005\u0005\u000b\u00119B\u0004\u0003\u0003\b\tUa\u0002\u0002B\u0005\u0005'qAAa\u0003\u0003\u00125\u0011!Q\u0002\u0006\u0004\u0005\u001fQ\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\tY\u0002\"\u0003\u0003\u0002r\u0006M\u0018\u0002\u0002B\r\u0003_\faa]3sm\u0016\u0014\u0018\u0002\u0002B\u000f\u0005?\tq\u0001]1dW\u0006<WM\u0003\u0003\u0003\u001a\u0005=\u0018\u0002\u0002B\u0012\u0005K\u0011QAU8vi\u0016TAA!\b\u0003 !A!\u0011FA}\u0001\u0004\u0011Y#A\u000bs_V$X\r\u0015:pm&$WM]*fiRLgnZ:\u0011\u0007e\u0011i#C\u0002\u00030i\u0011q$T1oC\u001e,W.\u001a8u%>,H/\u001a)s_ZLG-\u001a:TKR$\u0018N\\4t\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005k\tQa\u001d;beR$\"Aa\u000e\u0011\u00075\u0011I$C\u0002\u0003<9\u0011A!\u00168ji\"A!q\b\u0001\u0005\u0002!\u0011\t%A\ntKR\u001cV\r\u001c4D_:$\u0018m\u0019;Q_&tG\u000f\u0006\u0003\u00038\t\r\u0003\u0002\u0003B#\u0005{\u0001\r!a:\u0002\u000f\t\f7/Z+sS\"\"!Q\bB%!\u0011\u0011YE!\u0015\u000e\u0005\t5#b\u0001B(\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tM#Q\n\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e\u0003\u0005\u0003X\u0001!\t\u0001\u0003B-\u0003A\u0019X\r\u001c4D_:$\u0018m\u0019;Q_&tG/\u0006\u0002\u0003\\A1\u0011q\u001cB/\u0003OLAAa\u0018\u0002b\n1a)\u001e;ve\u0016DCA!\u0016\u0003J\u0001")
public final class ClusterBootstrap
implements ManagementRouteProvider {
    private final ExtendedActorSystem system;
    private final LoggingAdapter akka$management$cluster$bootstrap$ClusterBootstrap$$log;
    private final AtomicReference<BootstrapStep> bootstrapStep;
    private final ClusterBootstrapSettings settings;
    private final SimpleServiceDiscovery discovery;
    private final JoinDecider joinDecider;
    private final Promise<Uri> _selfContactPointUri;

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.apply(actorSystem);
    }

    public static ClusterBootstrap createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterBootstrap$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterBootstrap get(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.get(actorSystem);
    }

    public static ClusterBootstrap$ lookup() {
        return ClusterBootstrap$.MODULE$.lookup();
    }

    public LoggingAdapter akka$management$cluster$bootstrap$ClusterBootstrap$$log() {
        return this.akka$management$cluster$bootstrap$ClusterBootstrap$$log;
    }

    private final AtomicReference<BootstrapStep> bootstrapStep() {
        return this.bootstrapStep;
    }

    public ClusterBootstrapSettings settings() {
        return this.settings;
    }

    public SimpleServiceDiscovery discovery() {
        return this.discovery;
    }

    private JoinDecider joinDecider() {
        return this.joinDecider;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings routeProviderSettings) {
        this.akka$management$cluster$bootstrap$ClusterBootstrap$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got self contact point address: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{routeProviderSettings.selfBaseUri()})));
        this.setSelfContactPoint(routeProviderSettings.selfBaseUri());
        return new HttpClusterBootstrapRoutes(this.settings()).routes();
    }

    public void start() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().nonEmpty()) {
            this.akka$management$cluster$bootstrap$ClusterBootstrap$$log().warning("Application is configured with specific `akka.cluster.seed-nodes`: {}, bailing out of the bootstrap process! If you want to use the automatic bootstrap mechanism, make sure to NOT set explicit seed nodes in the configuration. This node will attempt to join the configured seed nodes.", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().mkString("[", ", ", "]"));
        } else if (this.bootstrapStep().compareAndSet(ClusterBootstrap$NotRunning$.MODULE$, ClusterBootstrap$Initializing$.MODULE$)) {
            this.akka$management$cluster$bootstrap$ClusterBootstrap$$log().info("Initiating bootstrap procedure using {} method...", (Object)this.settings().contactPointDiscovery().discoveryMethod());
            Props bootstrapProps = HeadlessServiceDnsBootstrap$.MODULE$.props(this.discovery(), this.joinDecider(), this.settings());
            ActorRef bootstrap = this.system.systemActorOf(bootstrapProps, "headlessServiceDnsBootstrap");
            Timeout bootTimeout = new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(1)).day());
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(bootstrap);
            HeadlessServiceDnsBootstrap$Protocol$InitiateBootstrapping$ x$2 = HeadlessServiceDnsBootstrap$Protocol$InitiateBootstrapping$.MODULE$;
            Timeout x$3 = bootTimeout;
            ActorRef x$4 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$2);
            Future bootstrapCompleted = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$2, x$3, x$4).mapTo(ClassTag$.MODULE$.apply(HeadlessServiceDnsBootstrap.Protocol.BootstrappingCompleted.class));
            bootstrapCompleted.failed().foreach((Function1)new Serializable(this, bootTimeout){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClusterBootstrap $outer;
                private final Timeout bootTimeout$1;

                public final void apply(Throwable x$1) {
                    this.$outer.akka$management$cluster$bootstrap$ClusterBootstrap$$log().warning("Failed to complete bootstrap within {}!", (Object)this.bootTimeout$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.bootTimeout$1 = bootTimeout$1;
                }
            }, (ExecutionContext)this.system.dispatcher());
        } else {
            this.akka$management$cluster$bootstrap$ClusterBootstrap$$log().warning("Bootstrap already initiated, yet start() method was called again. Ignoring.");
        }
    }

    @InternalApi
    public void setSelfContactPoint(Uri baseUri) {
        this._selfContactPointUri.success((Object)baseUri);
    }

    @InternalApi
    public Future<Uri> selfContactPoint() {
        return this._selfContactPointUri.future();
    }

    public ClusterBootstrap(ExtendedActorSystem system) {
        SimpleServiceDiscovery simpleServiceDiscovery;
        this.system = system;
        this.akka$management$cluster$bootstrap$ClusterBootstrap$$log = Logging$.MODULE$.apply((ActorSystem)system, ClusterBootstrap.class, LogSource$.MODULE$.fromAnyClass());
        this.bootstrapStep = new AtomicReference<ClusterBootstrap$NotRunning$>(ClusterBootstrap$NotRunning$.MODULE$);
        this.settings = ClusterBootstrapSettings$.MODULE$.apply(system.settings().config());
        String string = this.settings().contactPointDiscovery().discoveryMethod();
        if ("akka.discovery".equals(string)) {
            SimpleServiceDiscovery discovery = ServiceDiscovery$.MODULE$.apply((ActorSystem)system).discovery();
            this.akka$management$cluster$bootstrap$ClusterBootstrap$$log().info("Bootstrap using default `akka.discovery` mechanism: {}", (Object)Logging$.MODULE$.simpleName((Object)discovery));
            simpleServiceDiscovery = discovery;
        } else {
            String implClazz = system.settings().config().getString(new StringBuilder().append((Object)string).append((Object)".class").toString());
            this.akka$management$cluster$bootstrap$ClusterBootstrap$$log().info("Bootstrap using [{}] discovery mechanism, instantiating [{}]", (Object)string, (Object)implClazz);
            simpleServiceDiscovery = (SimpleServiceDiscovery)system.dynamicAccess().createInstanceFor(implClazz, (scala.collection.immutable.Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ActorSystem.class), (Object)system)})), ClassTag$.MODULE$.apply(SimpleServiceDiscovery.class)).get();
        }
        this.discovery = simpleServiceDiscovery;
        this.joinDecider = (JoinDecider)system.dynamicAccess().createInstanceFor(this.settings().joinDecider().implClass(), (scala.collection.immutable.Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(ActorSystem.class, (Object)system), new Tuple2(ClusterBootstrapSettings.class, (Object)this.settings())})), ClassTag$.MODULE$.apply(JoinDecider.class)).get();
        this._selfContactPointUri = Promise$.MODULE$.apply();
    }

    public static interface BootstrapStep {
    }
}

