/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.discovery.SimpleServiceDiscovery;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.Uri;
import akka.management.cluster.bootstrap.ClusterBootstrap;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.JoinDecider;
import akka.management.cluster.bootstrap.JoinDecision;
import akka.management.cluster.bootstrap.JoinOtherSeedNodes;
import akka.management.cluster.bootstrap.JoinSelf$;
import akka.management.cluster.bootstrap.KeepProbing$;
import akka.management.cluster.bootstrap.SeedNodesInformation;
import akka.management.cluster.bootstrap.SeedNodesObservation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u0017\tABj\\<fgR\fE\r\u001a:fgNTu.\u001b8EK\u000eLG-\u001a:\u000b\u0005\r!\u0011!\u00032p_R\u001cHO]1q\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u001dA\u0011AC7b]\u0006<W-\\3oi*\t\u0011\"\u0001\u0003bW.\f7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\tY!j\\5o\t\u0016\u001c\u0017\u000eZ3s\u0011!9\u0002A!A!\u0002\u0013A\u0012AB:zgR,W\u000e\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\u0011\u0005)\u0011m\u0019;pe&\u0011QD\u0007\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0003!\u0019X\r\u001e;j]\u001e\u001c\bCA\n\"\u0013\t\u0011#A\u0001\rDYV\u001cH/\u001a:C_>$8\u000f\u001e:baN+G\u000f^5oONDQ\u0001\n\u0001\u0005\u0002\u0015\na\u0001P5oSRtDc\u0001\u0014(QA\u00111\u0003\u0001\u0005\u0006/\r\u0002\r\u0001\u0007\u0005\u0006?\r\u0002\r\u0001\t\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0003\rawnZ\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\u0011q\u0006C\u0001\u0006KZ,g\u000e^\u0005\u0003c9\u0012a\u0002T8hO&tw-\u00113baR,'\u000f\u0003\u00044\u0001\u0001\u0006I\u0001L\u0001\u0005Y><\u0007\u0005C\u00036\u0001\u0011\u0005c'\u0001\u0004eK\u000eLG-\u001a\u000b\u0003o\u0001\u00032\u0001O\u001e>\u001b\u0005I$B\u0001\u001e\u000f\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003ye\u0012aAR;ukJ,\u0007CA\n?\u0013\ty$A\u0001\u0007K_&tG)Z2jg&|g\u000eC\u0003Bi\u0001\u0007!)\u0001\u0003j]\u001a|\u0007CA\nD\u0013\t!%A\u0001\u000bTK\u0016$gj\u001c3fg&sgm\u001c:nCRLwN\u001c\u0005\u0006\r\u0002!\tbR\u0001\u0013U>Lgn\u0014;iKJ\u001cV-\u001a3O_\u0012,7\u000f\u0006\u0002I%B\u0019\u0011\nT(\u000f\u00055Q\u0015BA&\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0004'\u0016$(BA&\u000f!\tI\u0002+\u0003\u0002R5\t9\u0011\t\u001a3sKN\u001c\b\"B!F\u0001\u0004\u0011\u0005\"\u0002+\u0001\t#)\u0016A\u00065bg\u0016sw.^4i\u0007>tG/Y2u!>Lg\u000e^:\u0015\u0005YK\u0006CA\u0007X\u0013\tAfBA\u0004C_>dW-\u00198\t\u000b\u0005\u001b\u0006\u0019\u0001\"\t\u000bm\u0003A\u0011\u0003/\u0002%%\u001c\b+Y:u'R\f'\r\\3NCJ<\u0017N\u001c\u000b\u0003-vCQ!\u0011.A\u0002\tCQa\u0018\u0001\u0005\u0012\u0001\fA'[:D_:4\u0017N]7fI\u000e{W.\\;oS\u000e\fG/[8o/&$\b.\u00117m\u0007>tG/Y2u!>Lg\u000e^:SKF,\u0018N]3e)\t1\u0016\rC\u0003B=\u0002\u0007!\tC\u0003d\u0001\u0011%A-A\njg\u0006cGn\\<fIR{'j\\5o'\u0016dg\r\u0006\u0002WK\")\u0011I\u0019a\u0001\u0005\")q\r\u0001C\tQ\u0006IBn\\<fgR\fE\r\u001a:fgN\u001cuN\u001c;bGR\u0004v.\u001b8u)\tIG\u0010E\u0002\u000eU2L!a\u001b\b\u0003\r=\u0003H/[8o!\ti\u0017P\u0004\u0002om:\u0011q\u000e\u001e\b\u0003aNl\u0011!\u001d\u0006\u0003e*\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005UD\u0011!\u00033jg\u000e|g/\u001a:z\u0013\t9\b0\u0001\fTS6\u0004H.Z*feZL7-\u001a#jg\u000e|g/\u001a:z\u0015\t)\b\"\u0003\u0002{w\nq!+Z:pYZ,G\rV1sO\u0016$(BA<y\u0011\u0015\te\r1\u0001C\u0001")
public class LowestAddressJoinDecider
implements JoinDecider {
    private final ActorSystem system;
    private final ClusterBootstrapSettings settings;
    private final LoggingAdapter log;

    private LoggingAdapter log() {
        return this.log;
    }

    @Override
    public Future<JoinDecision> decide(SeedNodesInformation info) {
        Future<JoinDecision> future;
        if (info.hasSeedNodes()) {
            Set<Address> seeds = this.joinOtherSeedNodes(info);
            future = seeds.isEmpty() ? KeepProbing$.MODULE$.asCompletedFuture() : new JoinOtherSeedNodes(seeds).asCompletedFuture();
        } else if (this.hasEnoughContactPoints(info)) {
            if (this.isPastStableMargin(info)) {
                Set contactPointsWithoutSeedNodesObservations;
                Set set = contactPointsWithoutSeedNodesObservations = this.isConfirmedCommunicationWithAllContactPointsRequired(info) ? (Set)info.contactPoints().$minus$minus((GenTraversableOnce)info.seedNodesObservations().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleServiceDiscovery.ResolvedTarget apply(SeedNodesObservation x$1) {
                        return x$1.contactPoint();
                    }
                }, Set$.MODULE$.canBuildFrom())) : Predef$.MODULE$.Set().empty();
                if (contactPointsWithoutSeedNodesObservations.isEmpty()) {
                    if (this.isAllowedToJoinSelf(info)) {
                        future = JoinSelf$.MODULE$.asCompletedFuture();
                    } else {
                        if (this.log().isInfoEnabled()) {
                            if (this.settings.formNewCluster()) {
                                this.log().info("Exceeded stable margins without locating seed-nodes, however this node is NOT the lowest address out of the discovered IPs in this deployment, thus NOT joining self. Expecting node [{}] (out of [{}]) to perform the self-join and initiate the cluster.", this.lowestAddressContactPoint(info).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }), (Object)info.contactPoints().mkString(", "));
                            } else {
                                this.log().warning("Exceeded stable margins without locating seed-nodes, however this node is configured with form-new-cluster=off, thus NOT joining self. Expecting existing cluster or node [{}] (out of [{}]) to perform the self-join and initiate the cluster.", this.lowestAddressContactPoint(info).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }), (Object)info.contactPoints().mkString(", "));
                            }
                        }
                        future = KeepProbing$.MODULE$.asCompletedFuture();
                    }
                } else {
                    if (this.log().isInfoEnabled()) {
                        this.log().info("Exceeded stable margins but missing seed node information from some contact points [{}] (out of [{}])", (Object)contactPointsWithoutSeedNodesObservations.mkString(", "), (Object)info.contactPoints().mkString(", "));
                    }
                    future = KeepProbing$.MODULE$.asCompletedFuture();
                }
            } else {
                this.log().debug("Contact points observations have changed more recently than the stable-margin [{}], changed at [{}], not joining myself. This process will be retried.", (Object)this.settings.contactPointDiscovery().stableMargin(), (Object)info.contactPointsChangedAt());
                future = KeepProbing$.MODULE$.asCompletedFuture();
            }
        } else {
            this.log().info("Discovered [{}] contact points, confirmed [{}], which is less than the required [{}], retrying", (Object)BoxesRunTime.boxToInteger((int)info.contactPoints().size()), (Object)BoxesRunTime.boxToInteger((int)info.seedNodesObservations().size()), (Object)BoxesRunTime.boxToInteger((int)this.settings.contactPointDiscovery().requiredContactPointsNr()));
            future = KeepProbing$.MODULE$.asCompletedFuture();
        }
        return future;
    }

    public Set<Address> joinOtherSeedNodes(SeedNodesInformation info) {
        return (Set)info.allSeedNodes().take(5);
    }

    public boolean hasEnoughContactPoints(SeedNodesInformation info) {
        return info.seedNodesObservations().size() >= this.settings.contactPointDiscovery().requiredContactPointsNr();
    }

    public boolean isPastStableMargin(SeedNodesInformation info) {
        java.time.Duration contactPointsChanged = java.time.Duration.between(info.contactPointsChangedAt(), info.currentTime());
        return contactPointsChanged.toMillis() >= this.settings.contactPointDiscovery().stableMargin().toMillis();
    }

    public boolean isConfirmedCommunicationWithAllContactPointsRequired(SeedNodesInformation info) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAllowedToJoinSelf(SeedNodesInformation info) {
        if (!this.settings.formNewCluster()) return false;
        ClusterBootstrap bootstrap = (ClusterBootstrap)ClusterBootstrap$.MODULE$.apply(this.system);
        Uri selfContactPoint = (Uri)Try$.MODULE$.apply((Function0)new Serializable(this, bootstrap){
            public static final long serialVersionUID = 0L;
            private final ClusterBootstrap bootstrap$1;

            public final Uri apply() {
                return (Uri)Await$.MODULE$.result(this.bootstrap$1.selfContactPoint(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).second());
            }
            {
                this.bootstrap$1 = bootstrap$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Bootstrap.selfContactPoint was NOT set! This is required for the bootstrap to work! If binding bootstrap routes manually and not via akka-management");
            }
        });
        Option<SimpleServiceDiscovery.ResolvedTarget> option = this.lowestAddressContactPoint(info);
        if (!(option instanceof Some)) {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            return false;
        }
        Some some = (Some)option;
        SimpleServiceDiscovery.ResolvedTarget lowest = (SimpleServiceDiscovery.ResolvedTarget)some.x();
        boolean bl = this.lowestContactPointIsSelfManagement$1(lowest, selfContactPoint);
        boolean bl2 = bl;
        return bl2;
    }

    public Option<SimpleServiceDiscovery.ResolvedTarget> lowestAddressContactPoint(SeedNodesInformation info) {
        return ((TraversableLike)((SeqLike)info.seedNodesObservations().toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleServiceDiscovery.ResolvedTarget apply(SeedNodesObservation x$2) {
                return x$2.contactPoint();
            }
        }, List$.MODULE$.canBuildFrom())).sorted(SimpleServiceDiscovery.ResolvedTarget$.MODULE$.addressOrdering())).headOption();
    }

    private final boolean lowestContactPointIsSelfManagement$1(SimpleServiceDiscovery.ResolvedTarget lowest, Uri selfContactPoint$1) {
        String string = lowest.host();
        String string2 = selfContactPoint$1.authority().host().toString();
        return !(string != null ? !string.equals(string2) : string2 != null) && BoxesRunTime.unboxToInt((Object)lowest.port().getOrElse((Function0)new Serializable(this, selfContactPoint$1){
            public static final long serialVersionUID = 0L;
            private final Uri selfContactPoint$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.selfContactPoint$1.authority().port();
            }
            {
                this.selfContactPoint$1 = selfContactPoint$1;
            }
        })) == selfContactPoint$1.authority().port();
    }

    public LowestAddressJoinDecider(ActorSystem system, ClusterBootstrapSettings settings) {
        this.system = system;
        this.settings = settings;
        this.log = Logging$.MODULE$.apply(system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
    }
}

