/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.AkkaVersion$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.discovery.Discovery$;
import akka.discovery.ServiceDiscovery;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.management.cluster.bootstrap.ClusterBootstrap;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$Initializing$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$NotRunning$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings$;
import akka.management.cluster.bootstrap.JoinDecider;
import akka.management.cluster.bootstrap.contactpoint.HttpClusterBootstrapRoutes;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator$;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator$Protocol$InitiateBootstrapping$;
import akka.management.scaladsl.ManagementRouteProvider;
import akka.management.scaladsl.ManagementRouteProviderSettings;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001B\u0001\u0003\u0005-\u0011\u0001c\u00117vgR,'OQ8piN$(/\u00199\u000b\u0005\r!\u0011!\u00032p_R\u001cHO]1q\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u001dA\u0011AC7b]\u0006<W-\\3oi*\t\u0011\"\u0001\u0003bW.\f7\u0001A\n\u0005\u00011\u0011\u0002\u0004\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+!\tQ!Y2u_JL!a\u0006\u000b\u0003\u0013\u0015CH/\u001a8tS>t\u0007CA\r\u001d\u001b\u0005Q\"BA\u000e\u0007\u0003!\u00198-\u00197bINd\u0017BA\u000f\u001b\u0005]i\u0015M\\1hK6,g\u000e\u001e*pkR,\u0007K]8wS\u0012,'\u000f\u0003\u0005 \u0001\t\u0005\t\u0015a\u0003!\u0003\u0019\u0019\u0018p\u001d;f[B\u00111#I\u0005\u0003EQ\u00111#\u0012=uK:$W\rZ!di>\u00148+_:uK6DQ\u0001\n\u0001\u0005\u0002\u0015\na\u0001P5oSRtD#\u0001\u0014\u0015\u0005\u001dJ\u0003C\u0001\u0015\u0001\u001b\u0005\u0011\u0001\"B\u0010$\u0001\b\u0001\u0003bB\u0016\u0001\u0005\u0004%I\u0001L\u0001\u0004Y><W#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005AB\u0011!B3wK:$\u0018B\u0001\u001a0\u00059aunZ4j]\u001e\fE-\u00199uKJDa\u0001\u000e\u0001!\u0002\u0013i\u0013\u0001\u00027pO\u0002BqA\u000e\u0001C\u0002\u00135q'A\u0007c_>$8\u000f\u001e:baN#X\r]\u000b\u0002qA\u0019\u0011H\u0011#\u000e\u0003iR!a\u000f\u001f\u0002\r\u0005$x.\\5d\u0015\tid(\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0010!\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0003\u0006!!.\u0019<b\u0013\t\u0019%HA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\t)5N\u0004\u0002GE:\u0011\u0001fR\u0004\u0006\u0011\nA\t!S\u0001\u0011\u00072,8\u000f^3s\u0005>|Go\u001d;sCB\u0004\"\u0001\u000b&\u0007\u000b\u0005\u0011\u0001\u0012A&\u0014\t)cAj\u0014\t\u0004'5;\u0013B\u0001(\u0015\u0005-)\u0005\u0010^3og&|g.\u00133\u0011\u0005M\u0001\u0016BA)\u0015\u0005M)\u0005\u0010^3og&|g.\u00133Qe>4\u0018\u000eZ3s\u0011\u0015!#\n\"\u0001T)\u0005I\u0005\"B+K\t\u00032\u0016A\u00027p_.,\b\u000fF\u0001G\u0011\u0015A&\n\"\u0011Z\u0003\r9W\r\u001e\u000b\u0003OiCQaH,A\u0002m\u0003\"a\u0005/\n\u0005u#\"aC!di>\u00148+_:uK6DQa\u0018&\u0005B\u0001\fqb\u0019:fCR,W\t\u001f;f]NLwN\u001c\u000b\u0003O\u0005DQa\b0A\u0002\u0001:aa\u0019&\t\u0002\t!\u0017\u0001C%oi\u0016\u0014h.\u00197\u0011\u0005\u00154W\"\u0001&\u0007\r\u001dT\u0005\u0012\u0001\u0002i\u0005!Ie\u000e^3s]\u0006d7C\u00014\r\u0011\u0015!c\r\"\u0001k)\u0005!ga\u00027g!\u0003\r\n#\u001c\u0002\u000e\u0005>|Go\u001d;sCB\u001cF/\u001a9\u0014\u0005-d\u0011\u0006B6p\u0003C2Q\u0001\u001d4\t\u0002F\u0014A\"\u00138ji&\fG.\u001b>j]\u001e\u001cRa\u001c\u0007si^\u0004\"a]6\u000e\u0003\u0019\u0004\"!D;\n\u0005Yt!a\u0002)s_\u0012,8\r\u001e\t\u0003\u001baL!!\u001f\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b\u0011zG\u0011A>\u0015\u0003q\u0004\"a]8\t\u000fy|\u0017\u0011!C!\u007f\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0001\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002A\u0003\u0011a\u0017M\\4\n\t\u0005-\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\t\u0013\u0005=q.!A\u0005\u0002\u0005E\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\n!\ri\u0011QC\u0005\u0004\u0003/q!aA%oi\"I\u00111D8\u0002\u0002\u0013\u0005\u0011QD\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty\"!\n\u0011\u00075\t\t#C\u0002\u0002$9\u00111!\u00118z\u0011)\t9#!\u0007\u0002\u0002\u0003\u0007\u00111C\u0001\u0004q\u0012\n\u0004\"CA\u0016_\u0006\u0005I\u0011IA\u0017\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0018!\u0019\t\t$a\u000e\u0002 5\u0011\u00111\u0007\u0006\u0004\u0003kq\u0011AC2pY2,7\r^5p]&!\u0011\u0011HA\u001a\u0005!IE/\u001a:bi>\u0014\b\"CA\u001f_\u0006\u0005I\u0011AA \u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA!\u0003\u000f\u00022!DA\"\u0013\r\t)E\u0004\u0002\b\u0005>|G.Z1o\u0011)\t9#a\u000f\u0002\u0002\u0003\u0007\u0011q\u0004\u0005\n\u0003\u0017z\u0017\u0011!C!\u0003\u001b\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003'A\u0011\"!\u0015p\u0003\u0003%\t%a\u0015\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0001\t\u0013\u0005]s.!A\u0005\n\u0005e\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0017\u0011\t\u0005\r\u0011QL\u0005\u0005\u0003?\n)A\u0001\u0004PE*,7\r\u001e\u0004\b\u0003G2\u0007\u0012QA3\u0005)qu\u000e\u001e*v]:LgnZ\n\u0007\u0003Cb!\u000f^<\t\u000f\u0011\n\t\u0007\"\u0001\u0002jQ\u0011\u00111\u000e\t\u0004g\u0006\u0005\u0004\u0002\u0003@\u0002b\u0005\u0005I\u0011I@\t\u0015\u0005=\u0011\u0011MA\u0001\n\u0003\t\t\u0002\u0003\u0006\u0002\u001c\u0005\u0005\u0014\u0011!C\u0001\u0003g\"B!a\b\u0002v!Q\u0011qEA9\u0003\u0003\u0005\r!a\u0005\t\u0015\u0005-\u0012\u0011MA\u0001\n\u0003\ni\u0003\u0003\u0006\u0002>\u0005\u0005\u0014\u0011!C\u0001\u0003w\"B!!\u0011\u0002~!Q\u0011qEA=\u0003\u0003\u0005\r!a\b\t\u0015\u0005-\u0013\u0011MA\u0001\n\u0003\ni\u0005\u0003\u0006\u0002R\u0005\u0005\u0014\u0011!C!\u0003'B!\"a\u0016\u0002b\u0005\u0005I\u0011BA-\u000f\u001d\t9I\u001aEA\u0003W\n!BT8u%Vtg.\u001b8h\u000f\u0019\tYI\u001aEAy\u0006a\u0011J\\5uS\u0006d\u0017N_5oO\"9\u0011q\u0012\u0001!\u0002\u001bA\u0014A\u00042p_R\u001cHO]1q'R,\u0007\u000f\t\u0005\n\u0003'\u0003!\u0019!C\u0001\u0003+\u000b\u0001b]3ui&twm]\u000b\u0003\u0003/\u00032\u0001KAM\u0013\r\tYJ\u0001\u0002\u0019\u00072,8\u000f^3s\u0005>|Go\u001d;sCB\u001cV\r\u001e;j]\u001e\u001c\b\u0002CAP\u0001\u0001\u0006I!a&\u0002\u0013M,G\u000f^5oON\u0004\u0003\"CAR\u0001\t\u0007I\u0011AAS\u0003%!\u0017n]2pm\u0016\u0014\u00180\u0006\u0002\u0002(B!\u0011\u0011VAW\u001b\t\tYKC\u0002\u0002$\"IA!a,\u0002,\n\u00012+\u001a:wS\u000e,G)[:d_Z,'/\u001f\u0005\t\u0003g\u0003\u0001\u0015!\u0003\u0002(\u0006QA-[:d_Z,'/\u001f\u0011\t\u0013\u0005]\u0006A1A\u0005\n\u0005e\u0016a\u00036pS:$UmY5eKJ,\"!a/\u0011\u0007!\ni,C\u0002\u0002@\n\u00111BS8j]\u0012+7-\u001b3fe\"A\u00111\u0019\u0001!\u0002\u0013\tY,\u0001\u0007k_&tG)Z2jI\u0016\u0014\b\u0005\u0003\u0005\u0002H\u0002\u0001\u000b\u0011BAe\u0003Qy6/\u001a7g\u0007>tG/Y2u!>Lg\u000e^+sSB1\u00111ZAh\u0003'l!!!4\u000b\u0005ur\u0011\u0002BAi\u0003\u001b\u0014q\u0001\u0015:p[&\u001cX\r\u0005\u0003\u0002V\u0006\u0005XBAAl\u0015\u0011\tI.a7\u0002\u000b5|G-\u001a7\u000b\u0007m\tiNC\u0002\u0002`\"\tA\u0001\u001b;ua&!\u00111]Al\u0005\r)&/\u001b\u0005\b\u0003O\u0004A\u0011IAu\u0003\u0019\u0011x.\u001e;fgR!\u00111\u001eB\n!\u0011\tiO!\u0004\u000f\t\u0005=(q\u0001\b\u0005\u0003c\u0014\u0019A\u0004\u0003\u0002t\n\u0005a\u0002BA{\u0003\u007ftA!a>\u0002~6\u0011\u0011\u0011 \u0006\u0004\u0003wT\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\r\ty\u000eC\u0005\u00047\u0005u\u0017\u0002\u0002B\u0003\u00037\faa]3sm\u0016\u0014\u0018\u0002\u0002B\u0005\u0005\u0017\tq\u0001]1dW\u0006<WM\u0003\u0003\u0003\u0006\u0005m\u0017\u0002\u0002B\b\u0005#\u0011QAU8vi\u0016TAA!\u0003\u0003\f!A!QCAs\u0001\u0004\u00119\"A\u000bs_V$X\r\u0015:pm&$WM]*fiRLgnZ:\u0011\u0007e\u0011I\"C\u0002\u0003\u001ci\u0011q$T1oC\u001e,W.\u001a8u%>,H/\u001a)s_ZLG-\u001a:TKR$\u0018N\\4t\u0011\u001d\u0011y\u0002\u0001C\u0001\u0005C\tQa\u001d;beR$\"Aa\t\u0011\u00075\u0011)#C\u0002\u0003(9\u0011A!\u00168ji\"A!1\u0006\u0001\u0005\u0002!\u0011i#A\ntKR\u001cV\r\u001c4D_:$\u0018m\u0019;Q_&tG\u000f\u0006\u0003\u0003$\t=\u0002\u0002\u0003B\u0019\u0005S\u0001\r!a5\u0002\u000f\t\f7/Z+sS\"\"!\u0011\u0006B\u001b!\u0011\u00119D!\u0010\u000e\u0005\te\"b\u0001B\u001e\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}\"\u0011\b\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e\u0003\u0005\u0003D\u0001!\t\u0001\u0003B#\u0003A\u0019X\r\u001c4D_:$\u0018m\u0019;Q_&tG/\u0006\u0002\u0003HA1\u00111\u001aB%\u0005\u001bJAAa\u0013\u0002N\n1a)\u001e;ve\u0016\u0004r!\u0004B(\u0005'\n\u0019\"C\u0002\u0003R9\u0011a\u0001V;qY\u0016\u0014\u0004\u0003\u0002B+\u00057r1!\u0004B,\u0013\r\u0011IFD\u0001\u0007!J,G-\u001a4\n\t\u0005-!Q\f\u0006\u0004\u00053r\u0001\u0006\u0002B!\u0005k\u0001")
public final class ClusterBootstrap
implements ManagementRouteProvider {
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final AtomicReference<Internal.BootstrapStep> bootstrapStep;
    private final ClusterBootstrapSettings settings;
    private final ServiceDiscovery discovery;
    private final JoinDecider joinDecider;
    private final Promise<Uri> _selfContactPointUri;

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.apply(actorSystem);
    }

    public static ClusterBootstrap createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterBootstrap$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterBootstrap get(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.get(actorSystem);
    }

    public static ClusterBootstrap$ lookup() {
        return ClusterBootstrap$.MODULE$.lookup();
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private final AtomicReference<Internal.BootstrapStep> bootstrapStep() {
        return this.bootstrapStep;
    }

    public ClusterBootstrapSettings settings() {
        return this.settings;
    }

    public ServiceDiscovery discovery() {
        return this.discovery;
    }

    private JoinDecider joinDecider() {
        return this.joinDecider;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings routeProviderSettings) {
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using self contact point address: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{routeProviderSettings.selfBaseUri()})));
        this.setSelfContactPoint(routeProviderSettings.selfBaseUri());
        return new HttpClusterBootstrapRoutes(this.settings()).routes();
    }

    public void start() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().nonEmpty()) {
            this.log().warning("Application is configured with specific `akka.cluster.seed-nodes`: {}, bailing out of the bootstrap process! If you want to use the automatic bootstrap mechanism, make sure to NOT set explicit seed nodes in the configuration. This node will attempt to join the configured seed nodes.", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().mkString("[", ", ", "]"));
        } else if (this.bootstrapStep().compareAndSet(ClusterBootstrap$Internal$NotRunning$.MODULE$, ClusterBootstrap$Internal$Initializing$.MODULE$)) {
            this.log().info("Initiating bootstrap procedure using {} method...", (Object)this.settings().contactPointDiscovery().discoveryMethod());
            Props bootstrapProps = BootstrapCoordinator$.MODULE$.props(this.discovery(), this.joinDecider(), this.settings());
            ActorRef bootstrap = this.system.systemActorOf(bootstrapProps, "bootstrapCoordinator");
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(bootstrap);
            BootstrapCoordinator$Protocol$InitiateBootstrapping$ x$1 = BootstrapCoordinator$Protocol$InitiateBootstrapping$.MODULE$;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        } else {
            this.log().warning("Bootstrap already initiated, yet start() method was called again. Ignoring.");
        }
    }

    @InternalApi
    public void setSelfContactPoint(Uri baseUri) {
        this._selfContactPointUri.success((Object)baseUri);
    }

    @InternalApi
    public Future<Tuple2<String, Object>> selfContactPoint() {
        return this._selfContactPointUri.future().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Uri uri) {
                return new Tuple2((Object)uri.authority().host().toString(), (Object)BoxesRunTime.boxToInteger((int)uri.authority().port()));
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    public ClusterBootstrap(ExtendedActorSystem system) {
        ServiceDiscovery serviceDiscovery;
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterBootstrap.class, LogSource$.MODULE$.fromAnyClass());
        this.bootstrapStep = new AtomicReference<ClusterBootstrap$Internal$NotRunning$>(ClusterBootstrap$Internal$NotRunning$.MODULE$);
        AkkaVersion$.MODULE$.require("cluster-bootstrap", "2.5.19");
        this.settings = ClusterBootstrapSettings$.MODULE$.apply(system.settings().config(), this.log());
        String string = this.settings().contactPointDiscovery().discoveryMethod();
        if ("akka.discovery".equals(string)) {
            ServiceDiscovery discovery = Discovery$.MODULE$.apply((ActorSystem)system).discovery();
            this.log().info("Bootstrap using default `akka.discovery` method: {}", (Object)Logging$.MODULE$.simpleName((Object)discovery));
            serviceDiscovery = discovery;
        } else {
            this.log().info("Bootstrap using `akka.discovery` method: {}", (Object)string);
            serviceDiscovery = Discovery$.MODULE$.apply((ActorSystem)system).loadServiceDiscovery(string);
        }
        this.discovery = serviceDiscovery;
        this.joinDecider = (JoinDecider)system.dynamicAccess().createInstanceFor(this.settings().joinDecider().implClass(), (scala.collection.immutable.Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(ActorSystem.class, (Object)system), new Tuple2(ClusterBootstrapSettings.class, (Object)this.settings())})), ClassTag$.MODULE$.apply(JoinDecider.class)).get();
        this._selfContactPointUri = Promise$.MODULE$.apply();
    }
}

